'use strict';

/**
 * @ngdoc overview
 * @name modules.authentication
 * @description
 * authentication module
 */
define([
  'angular',
  'modules/licence/services/LicenceFactory',
  'modules/licence/controllers/LicenceCtrl',
], function(angular, LicenceFactory, LicenceCtrl) {
  // Module
  var mod = angular.module('licence', ['ngRoute']);

  // Services
  mod.factory('licenceFactory', LicenceFactory);

  // Controllers
  mod.controller('LicenceCtrl', LicenceCtrl);

  mod.config([
    '$routeProvider',
    function($routeProvider) {
      $routeProvider.when('/licence/', {
        templateUrl: 'js/XG/modules/licence/views/licence.html',
        controller: LicenceCtrl,
      });
    },
  ]);

  return mod;
});
