'use strict';
define(function () {
  var HomeCtrl = function (
      $rootScope,
      $scope,
      $location,
      homeFactory,
      gaDomUtils,
      $filter,
      gaJsUtils,
      PortalsFactory
  ) {
    $scope.allowConfig = $location.search().mode === 'config';
    $scope.portalId = $location.search().portal;
    if (!angular.isDefined($scope.portalId)) {
      $scope.portalId = PortalsFactory.getPortalId();
    }
    gaDomUtils.showGlobalLoader();
    // récupère le nom de la page d'accueil
    homeFactory.getPortalHomepageName($scope.portalId).then(
        res => {
          $scope.portalHomepageName = res;
        },
        () => {
          // charge l'ancienne page d'accueil kis
          $scope.portalHomepageName = 'default';
        }
    ).finally(
        () => {
          if (!$scope.portalHomepageName || $scope.portalHomepageName === 'default') {
            // si la page d'accueil est 'default' ou null
            // on ne charge pas la page d'accueil v2 (ou autre)
            $scope.homepage = null;
            console.log('HomeCtrl - Aucune page d\'accueil');
            gaDomUtils.hideGlobalLoader();
          } else {
            homeFactory.getByNameAndHeader($scope.portalHomepageName).then(
                result => {
                  const userCanConfigureHomepage = homeFactory.isUserAllowedToConfigureHomepage($rootScope.xgos.user);

                  if (result && result !== '' && result.homepage) {
                    if (result.homepage.published || userCanConfigureHomepage) {
                      // homepage publiée => charge la page d'accueil v2 (ou autre)
                      // utilisateur ayant droit => charge la page d'accueil v2 (ou autre)
                      $scope.homepage = result.homepage;
                      if (result.header) {
                        // charge l'éventuel header html personnalisé de la page d'accueil
                        $scope.header = result.header;
                      }
                    } else {
                      // page d'accueil en cours de préparation ou utilisateur non autorisé
                      // => aucune page d'accueil
                      $scope.portalHomepageName = 'default';
                    }
                  } else {
                    // si le portail a une page d'accueil active mais celle-ci est null
                    // => charge une page d'accueil minimale
                    $scope.homepage = homeFactory.getDefaultHomepage($scope.portalId);
                  }
                  gaDomUtils.hideGlobalLoader();
                },
                (err) => {
                  // si erreur serveur pour récupérer la page d'accueil
                  // => charge une page d'accueil minimale
                  $scope.homepage = homeFactory.getDefaultHomepage($scope.portalId);
                  gaDomUtils.hideGlobalLoader();
                  require('toastr').error(
                      $filter('translate')('portals.homepage.getHomepageError'));
                  console.error(err.data.hasOwnProperty('message') ? err.data.message : '');
                }
            );
          }
        }
    )
  };

  HomeCtrl.$inject = [
    '$rootScope',
    '$scope',
    '$location',
    'homeFactory',
    'gaDomUtils',
    '$filter',
    'gaJsUtils',
    'PortalsFactory'
  ];
  return HomeCtrl;
});
