'use strict';
define(function() {
  var GraticuleFactory = function($http) {
    var GraticuleFactory = {};
    /**
     * Class : GraticuleFactory
     * Factory WebServices
     */

    /**
     * Function: add
     */
    function add(name, xmin, xmax, ymin, ymax, step, srid, gridType) {
      var promise = $http.get(
        '/services/{portalid}/graticule/add?f=json' +
          '&name=' +
          name +
          '&xmin=' +
          xmin +
          '&xmax=' +
          xmax +
          '&ymin=' +
          ymin +
          '&ymax=' +
          ymax +
          '&step=' +
          step +
          '&srid=' +
          srid +
          '&gridType=' +
          gridType
      );

      return promise;
    }
    /**
     * Function: remove
     */
    function remove(name) {
      var promise = $http.get(
        '/services/{portalid}/graticule/del?f=json' + '&name=' + name
      );

      return promise;
    }
    /**
     * Function: list
     */
    function list() {
      var promise = $http.get('/services/{portalid}/graticule/list?f=json');

      return promise;
    }
    return {
      GraticuleFactory: GraticuleFactory,
      add: add,
      remove: remove,
      list: list,
    };
  };
  GraticuleFactory.$inject = ['$http'];
  return GraticuleFactory;
});
