'use strict';
define(function() {
  let GeoTreatmentFactory = ($http, $filter, $timeout, gclayers, SelectManager)=> {
    let GeoTreatmentFactory = {};
    const CURRENT_SELECTION = 'CURRENT_SELECTION';
    const DATABASE = 'BD';
    const CURRENT_VIEW = 'View';
    const SELECT_ZONE = 'Zone';

    let handlePromiseError= () =>{
      require('toastr').error('erreur serveur');
    };

    let result = (senddata, map) => {
      const mapsrid = map
        .getView()
        .getProjection()
        .getCode();
      let promise = $http.post(
        '/services/{portalid}/geotreatment/result?f=json&mapsrid=' + mapsrid,
        senddata
      ).catch(handlePromiseError);
      return promise;
    };

    let moreResults = (senddata, mapSrid) =>{
      if (mapSrid == undefined) mapSrid = '';
      var promise = $http.post(
        '/services/{portalid}/geotreatment/moreResults?f=json&mapSrid=' +
          mapSrid,
        senddata
      ).catch(handlePromiseError);
      return promise;
    };

    let sql = () => {
      let promise = $http.get('/services/{portalid}/geotreatment/sql?f=json')
      .catch(handlePromiseError);
      return promise;
    };

    let applychange = (senddata, typeOfGeotreatment, attributesTochange,
      insertNew)=> {
      let promise = $http.post(
        '/services/{portalid}/geotreatment/applychange?f=json&typeOfGeotreatment=' +
          typeOfGeotreatment +
          '&attributesTochange=' +
          attributesTochange +
          '&insertNew=' +
          insertNew,
        senddata
      ).catch(handlePromiseError);
      return promise;
    };

    let surveytreatment = (senddata)=> {
      var promise = $http.post(
        '/services/{portalid}/geotreatment/survey?f=json',
        senddata
      ).catch(handlePromiseError);
      return promise;
    };

    let stoptreatment = (senddata)=> {
      var promise = $http.post(
        '/services/{portalid}/geotreatment/stop?f=json',
        senddata
      );
      return promise;
    };

    let treatment = (senddata, method)=> {
      let promise = $http.post(
        '/services/{portalid}/geotreatment/run?f=json' + '&method=' + method,
        senddata
      ).catch(handlePromiseError);
      return promise;
    };

    let manageInterruption = (scope)=> {
      scope.interrupt = false;
      swal({
        title: $filter('translate')('geotreat.geotreatments'),
        text: $filter('translate')('geotreat.interrupted'),
        type: 'warning',
        showCancelButton: false,
        confirmButtonColor: '#DD6B55',
        confirmButtonText: $filter('translate')('common.ok'),
        closeOnConfirm: true,
      });
    };

    let tick = (scope, attributeList, actionList)=> {
      if (scope.httpStatus === 204 ) {
        scope.inprogress = false;
        require('toastr').error(
          "Il n'y a pas de " + scope.$parent.$parent.$parent.title,
          '',
          {
            positionClass: 'toast-bottom-left',
          });
      }
      else {
        let ind,
          mess = '';
        if (!scope.interrupt) {
          surveytreatment(scope.state).then(function (data2) {
            scope.state = data2.data;
            if (scope.state.state == 'RUNNABLE') {
              $timeout(function () {
                tick(scope, attributeList, actionList);
              }, 2000);
            } else if (scope.state.state == 'TERMINATED') {
              result(scope.state, scope.map).then(function (data3) {
                scope.inprogress = false;
                if (data3.data.etat != 'erreur') {
                  scope.result = JSON.parse(data3.data.objValeur);
                  scope.attributes = attributeList;
                  gclayers
                  .getDrawLayer()
                  .getSource()
                  .clear();
                  scope.vopenResult(scope);
                  if (actionList != undefined) {
                    scope.actions = actionList;
                  }
                }
                else {
                  for (ind = 0; ind < data3.data.errorList.length; ind++) {
                    if (mess != '') mess += '\n';
                    mess += data3.data.errorList[ind].message_kis;
                  }
                  swal({
                    title: $filter('translate')('geotreat.geotreatments'),
                    text: $filter('translate')('common.error') + ': ' + mess,
                    type: 'error',
                    showCancelButton: false,
                    confirmButtonColor: '#DD6B55',
                    confirmButtonText: $filter('translate')('common.ok'),
                    closeOnConfirm: true,
                  });
                }
              });
            }
          });
        } else {
          manageInterruption(scope);
        }
      }
    };

    /**
     * 
     * @param {*} geoLimit 
     * @param {*} map 
     * @param {*} limitZoneGeometry 
     * @param {Array of String} ftisName liste des noms des couches sélectionnés
     * @param {Array} featureCollections tableau vide qui sera rempli avec les objets de
     *    la sélection courante (si nécessaire)
     * @returns 
     */
    const getSpatialClause = (geoLimit, map, limitZoneGeometry, ftisName, featureCollections) => {
      const wktObj = new ol.format.WKT();
      let spatialClause = '';
      switch (geoLimit) {
        case CURRENT_VIEW:
          const currExtent = map
            .getView()
            .calculateExtent(map.getSize());
          const polyExtent = ol.geom.Polygon.fromExtent(currExtent);
          const wktStr = wktObj.writeGeometry(polyExtent);
          spatialClause = 'INTERSECTS(geom, ' + wktStr + ')';
          break;
        case SELECT_ZONE:
          if (limitZoneGeometry != null) {
            const coords = limitZoneGeometry.coordinates;
            const polyCoords = new ol.geom.Polygon(coords, 'XY');
            const wktStr = wktObj.writeGeometry(polyCoords);
            spatialClause = 'INTERSECTS(geom, ' + wktStr + ')';
          }
          break;
        case DATABASE:
          spatialClause = 'no';
          break;
        case CURRENT_SELECTION:
          for (const ftiName of ftisName) {
            // récupère seulement les objets qui sont de type ftiName
            featureCollections.push({
              features: SelectManager.getFeaturesByftiType(ftiName).features,
              type: "FeatureCollection"
            });
          }
          break;
        default:
          console.error('geotreatment: search zone is not correct.');
          break;
      }
      return spatialClause;
    };

    return {
      GeoTreatmentFactory: GeoTreatmentFactory,
      CURRENT_SELECTION: CURRENT_SELECTION,
      DATABASE: DATABASE,
      CURRENT_VIEW: CURRENT_VIEW,
      SELECT_ZONE: SELECT_ZONE,
      result: result,
      moreResults: moreResults,
      applychange: applychange,
      sql: sql,
      surveytreatment: surveytreatment,
      stoptreatment: stoptreatment,
      treatment: treatment,
      manageInterruption: manageInterruption,
      tick: tick,
      getSpatialClause: getSpatialClause
    };
  };
  GeoTreatmentFactory.$inject = ['$http', '$filter', '$timeout', 'gclayers', 'SelectManager'];
  return GeoTreatmentFactory;
});
