'use strict';
define(function() {
  var FilesFactory = function($http) {
    var FilesFactory = {};
    /**
     * Class : FilesFactory
     * Factory WebServices
     */
    /**
     * Function: getfile
     */
    function getfile(fileName) {
      var promise = $http.get(
        '/services/{portalid}/files/getfile?f=json' + '&fileName=' + fileName
      );

      return promise;
    }
    /**
     * Function: uploadprocess
     */
    function uploadprocess(senddata) {
      var promise = $http.post(
        '/services/{portalid}/files/uploadfile?f=json',
        senddata,
        {
          transformRequest: angular.identity,
          headers: { 'Content-Type': undefined },
        }
      );

      return promise;
    }
    /**
     * Function: importcommunescsv
     */
    function importcommunescsv(senddata) {
      const promise = $http.post(
        '/services/{portalid}/files/importcommunescsv?f=json',
        senddata,
        {
          transformRequest: angular.identity,
          headers: { 'Content-Type': undefined },
        }
      );
      return promise;
    }
    /**
     * Function: downloadfile
     */
    function downloadfile(fileName) {
      var promise = $http.get(
        '/services/{portalid}/files/downloadfile?f=json' +
          '&fileName=' +
          fileName
      );

      return promise;
    }

    /**
     * Function: downloadfile
     */
    function uploadfilestatic(ftiName, fileName, sendata) {
      var promise = $http.post(
        '/services/{portalid}/files/uploadfilestatic?f=json&filename=' +
          fileName +
          '&ftiname=' +
          ftiName,
        sendata,
        {
          transformRequest: angular.identity,
          headers: { 'Content-Type': undefined },
        }
      );

      return promise;
    }

    /**
     * Function: downloadfile
     */
    function getfilesstatic(ftiName) {
      var promise = $http.get(
        '/services/{portalid}/files/getfilesstatic?f=json&ftiname=' + ftiName
      );

      return promise;
    }

    /**
     * Function: downloadfile
     */
    function getfilestatic(ftiName, filename) {
      var promise = $http.get(
        '/services/{portalid}/files/getfilestatic?f=json&ftiname=' +
          ftiName +
          '&filename=' +
          filename
      );

      return promise;
    }

    /**
     * Function: downloadfile
     */
    function getActionsGeneratedZip(sendata) {
      var promise = $http.post(
        '/services/{portalid}/files/getactionsgeneratedzip?f=json',
        sendata
      );

      return promise;
    }

    /**
     * Class : FilesFactory
     * Factory WebServices
     */
    /**
     * Function: getfile
     */
    function getfileFromPath(fileName) {
      var promise = $http.get(
        '/services/{portalid}/files/getfileFromPath?f=json' +
          '&filePath=' +
          fileName
      );

      return promise;
    }

    let getListFromCsv = (path, fileName, fichieravecentete, query) => {
      var sAvecEntete = 'non',
        sQuery = '';
      if (fichieravecentete) sAvecEntete = 'oui';
      if (query != undefined) sQuery = '&query=' + query;
      return $http.get(
        '/services/{portalid}/files/getListFromCsv?f=json' +
        '&filePath=' +
        path +
        '&filename=' +
        fileName +
        '&fichieravecentete=' +
        sAvecEntete +
        sQuery
      );
    };


    let esriUploadFile = (ds, filename) => {
      return $http.get('../esriproxy/' + ds.proxykey
        + '/FeatureServer/uploads/upload?f=json&portalid='
        + angular.module('gcMain').portalid + '&file=' + filename);
    };

    /**
     * Charge un fichier dans le dossier "UPLOAD" du repo
     * @param processId uid du processus d'import (utiliser gaJsUtils.guid par défaut)
     * @param file fichier à charger
     * @return {*} Promise au statut 200 si l'import a réussi
     */
    const uploadFile = (processId, file) => {
      if (!processId || !file) {
        return;
      }
      const fd = new FormData();
      fd.append('processId', processId);
      fd.append('file', file);
      return $http.post('/services/{portalid}/file/uploadProcess?f=json', fd,
          {
            transformRequest: angular.identity,
            headers: { 'Content-Type': undefined },
          }
      ).catch(() => {
        console.error('uploadFile : Impossible de charger le fichier ' + file.name);
        require('toastr').error($filter('translate')('featureattachment.importToUploadFailed'));
      });
    };

    /**
     * Supprime du dossier "UPLOAD" du repo le fichier portant le nom fourni en paramètre
     * @param processId nom du sous-dossier du répertoire "UPLOAD" dans lequel est stocké le fichier
     * @param fileName nom du fichier à supprimer
     * @return {Promise} status 200 si suppression réussie
     */
    const removeUploaded = (processId, fileName) => {
      return $http.get('/services/{portalid}/file/removeUploaded?f=json'
      + '&processId=' + processId
      + '&fileName=' + fileName).catch((error) => console.error('removeUploaded ', error));
    };

    /**
     * Liste les noms de fichiers/dossiers présents dans le sous-dossier "UPLOAD/processId" où processId est fourni en paramètre
     * @param {string} processId string du nom de dossier dans lequel sont contenus les fichiers à lister
     * @return {Promise} contient le tableau des noms de fichiers/dossiers présents dans le sous-dossier "UPLOAD/processId"
     */
    const listUploadFiles = (processId) => {
      return $http.get('/services/{portalid}/file/listUploadFiles?f=json'
          + '&processId=' + processId).catch((error) => console.error('listUploadFiles ', error));
    };


    return {
      FilesFactory: FilesFactory,
      getfile: getfile,
      getfileFromPath: getfileFromPath,
      getListFromCsv: getListFromCsv,
      uploadprocess: uploadprocess,
      importcommunescsv: importcommunescsv,
      downloadfile: downloadfile,
      uploadfilestatic: uploadfilestatic,
      getfilesstatic: getfilesstatic,
      getfilestatic: getfilestatic,
      getActionsGeneratedZip: getActionsGeneratedZip,
      esriUploadFile: esriUploadFile,
      uploadFile: uploadFile,
      removeUploaded: removeUploaded,
      listUploadFiles: listUploadFiles
    };
  };
  FilesFactory.$inject = ['$http'];
  return FilesFactory;
});
