"use strict";
define(function () {
  var EditRuleMoveObjectOnEnd = {

    $get: function ($q) {

      /**
       * Pythagore trop fort (c'est pas bien de réinventer la roue)
       * @param pointACoords
       * @param pointBCoords
       * @returns {number}
       */
      const distanceBetween = (pointACoords, pointBCoords) => {
        return Math.sqrt(
            Math.pow(pointACoords[0] - pointBCoords[0], 2)
            + Math.pow(pointACoords[1] - pointBCoords[1], 2));
      }


      /**
       * Le but de cette fonction est de déplacer le POINT intersectant
       * un linéaire sur son extrémité la plus proche
       * @param editdescription
       * @param ruleConf
       * @returns {*}
       */
      const moveObjectOnEnd = (editdescription, ruleConf) => {
        const defer = $q.defer();

        // Pour chaque type configuré,
        // on cherche si une feature a été trouvée par une autre règle
        for(let shareObjectsType of ruleConf.parameters.sharedObjects) {
          // Pour chaque objet partagé avec les autres règles
          for (let shareObject of editdescription.shareObjects) {
            if (shareObject.shareObject === shareObjectsType.name) {

              // Coordonnées actuelle du point
              const actualPointCoordinates = editdescription.editedfeature.getGeometry().getCoordinates();

              // Coordonnées du linéaire
              const linearCoordinates = shareObject.feature.getGeometry().getCoordinates()[0];

              // On affecte au point les coordonnées de l'extrémitée du linéaire la plus proche
              editdescription.editedfeature.getGeometry().setCoordinates(
                  distanceBetween(actualPointCoordinates, linearCoordinates[0]) <
                  distanceBetween(actualPointCoordinates, linearCoordinates[linearCoordinates.length-1]) ?
                      linearCoordinates[0]: linearCoordinates[linearCoordinates.length-1]
              );

              // Fin de la règle
              defer.resolve();
              return defer.promise;
            }
          }
        }

        // Fin de la règle
        defer.resolve();
        return defer.promise;
      }

      return {
        moveObjectOnEnd: moveObjectOnEnd
      };
    }
  };

  EditRuleMoveObjectOnEnd.$get.$inject = ['$q'];
  return EditRuleMoveObjectOnEnd;
});