'use strict';
define(function() {
  var RuleCfgFactory = function(
    $translate,
    EditTypesFactory,
    FeatureTypeFactory
  ) {
    function initEditTypeList(scope, editTypesSource) {
      if (scope.rule.editTypes == undefined) {
        scope.rule.editTypes = [];
        //Par défaut, tous les type d'édition sont activés
        angular.forEach(editTypesSource, function(editType, index) {
          scope.rule.editTypes.push(editType);
        });
      }
      scope.editTypeList = {
        leftData: editTypesSource,
        leftDisplayAttribute: 'label',
        rightData: scope.rule.editTypes,
        rightDisplayAttribute: 'label',
        leftTitle: 'Disponibles',
        rightTitle: 'A Executer',
        source: 'left',
      };
      $translate('rulecfg.common.availableEditTypes').then(function(res) {
        scope.editTypeList.leftTitle = res;
      });
      $translate('rulecfg.common.executeEditTypes').then(function(res) {
        scope.editTypeList.rightTitle = res;
      });
    }

    function removeShareObject(scope, sourceIndex, down) {
      var sourceArray;
      if (down) {
        sourceArray = scope.rule.parameters['aval']['shareObjects'];
      } else {
        sourceArray = scope.rule.parameters['shareObjects'];
      }
      var deleted = sourceArray.splice(sourceIndex, 1);

      //Suppression de l'objet partagé des sharedObjects (composant de visualisation des objets partagés par les config de règles)
      var shareObject = deleted[0];
      if (shareObject == undefined) return;

      if (shareObject.hashKey) {
        delete scope.rule.parameters.sharedObjects[shareObject.hashKey];
        //Mise à jour du composant de visualisation de tous les objets partagés par les cfg de règles.
        //element html correspondant à la directive de visualisation des objets partagés.
        var CfgRulesInfosElem = document.querySelector('#updateCfgRulesInfos');
        if (CfgRulesInfosElem) {
          CfgRulesInfosElem.dispatchEvent(new Event('updateCfgRulesInfos'));
        }
      }
    }

    function buildDirectiveObject(htmlFile, ruleName) {
      return {
        templateUrl: htmlFile,
        restrict: 'E',
        scope: {
          currentfeaturetype: '=currentfeaturetype',
          rule: '=rule',
        },
        link: function(scope) {
          scope.rule.name = ruleName;
          scope.rule.type = 'OnEnd';

          var editTypesSource = [
            EditTypesFactory.editTypes.add,
            EditTypesFactory.editTypes.update,
            EditTypesFactory.editTypes.updateattributes,
          ];

          initEditTypeList(scope, editTypesSource);

          //Si phase de creation
          if (scope.rule.parameters == undefined) {
            scope.rule.parameters = {};
          }
        },
      };
    }

    /**
     *    Code JS de la directive pour cfg.cuttingIntersectingLine et cfg.moveExtremityPoint.
     */
    function buildDirectiveObject2(
      htmlFile,
      ruleName,
      editType,
      theGeomToFilter
    ) {
      return {
        templateUrl: htmlFile,
        restrict: 'E',

        scope: {
          currentfeaturetype: '=currentfeaturetype',
          rule: '=rule',
        },
        link: function(scope) {
          //scope.result = {};
          scope.rule.name = ruleName;
          scope.rule.type = 'OnEnd';

          var editTypesSource;
          if (editType === 'onlyUpdate') {
            editTypesSource = [EditTypesFactory.editTypes.update];
          } else if (editType === 'addAndUpdate') {
            editTypesSource = [
              EditTypesFactory.editTypes.add,
              EditTypesFactory.editTypes.update,
            ];
          }

          initEditTypeList(scope, editTypesSource);

          //Si phase de creation
          if (scope.rule.parameters == undefined) {
            scope.rule.parameters = {};
          }
          if (scope.rule['parameters']['layerInfos'] == undefined) {
            scope.rule['parameters']['layerInfos'] = {};
          }
          if (scope.currentfeaturetype.typeInfo == 'LINE') {
            if (scope.rule.parameters.amont == undefined) {
              scope.rule.parameters.amont = {};
              scope.rule.parameters.amont.shareObjects = [];
            }
            if (scope.rule.parameters.aval == undefined) {
              scope.rule.parameters.aval = {};
              scope.rule.parameters.aval.shareObjects = [];
            }
          }
          if (scope.currentfeaturetype.typeInfo == 'POINT') {
            if (scope.rule.parameters.point == undefined) {
              scope.rule.parameters.point = {};
              scope.rule.parameters.point.shareObjects = [];
            }
          }

          /**
           * Cette fonction dans les sources d'origine était soit isFeaturePoint,
           * soit isFeatureLine.
           * Donc, theGeomToFilter contient 'POINT' ou 'LINE'.
           */
          function geomFilter(ft) {
            return ft.typeInfo === theGeomToFilter;
          }

          function isLayerNamePresent(shareObjects, layerName) {
            var isPresent = false;
            for (var i = 0; i < shareObjects.length; i++) {
              if (shareObjects[i].layerName == layerName) {
                isPresent = true;
              }
            }
            return isPresent;
          }

          if (FeatureTypeFactory.resources.featuretypes.length == 0) {
            FeatureTypeFactory.get().then(function() {
              scope.featureTypes = angular
                .copy(FeatureTypeFactory.resources.featuretypes)
                .filter(geomFilter);
            });
          } else {
            scope.featureTypes = angular
              .copy(FeatureTypeFactory.resources.featuretypes)
              .filter(geomFilter);
          }

          scope.onLayerChange = function(f) {
            scope.selectedlayer = f;
          };

          scope.addShareObject = function(position) {
            if (scope.selectedlayer == null) return;

            var sourceArray = undefined;
            if (position == 'amont') {
              sourceArray = scope.rule.parameters['amont']['shareObjects'];
            } else if (position == 'aval') {
              sourceArray = scope.rule.parameters['aval']['shareObjects'];
            } else if (position == 'point') {
              sourceArray = scope.rule.parameters['point']['shareObjects'];
            }

            if (!isLayerNamePresent(sourceArray, scope.selectedlayer.name)) {
              sourceArray.push({
                layerName: scope.selectedlayer.name
              });
            }
          };

          scope.removeShareObject = function(sourceIndex, position) {
            var sourceArray = undefined;
            if (position == 'amont') {
              sourceArray = scope.rule.parameters['amont']['shareObjects'];
            } else if (position == 'aval') {
              sourceArray = scope.rule.parameters['aval']['shareObjects'];
            } else if (position == 'point') {
              sourceArray = scope.rule.parameters['point']['shareObjects'];
            }

            sourceArray.splice(sourceIndex, 1);
          };

          listAllSharedObjects(scope);
        },
      };
    }

    /**
     *    Code JS de la directive pour cfg.snapon et cfg.historicize.
     */
    function buildDirectiveObject3(scopeInput, htmlFile, ruleName, moment) {
      return {
        templateUrl: htmlFile,
        restrict: 'E',
        scope: scopeInput,
        link: function(scope, element, attrs, ctrl) {
          //scope.rule = {};//objet rule créé par ng-model lors du choix de la règle ou existe déjà si en état de modification
          scope.rule.name = ruleName;
          scope.rule.type = moment;

          const editTypesSource = [
            EditTypesFactory.editTypes.update,
          ];
          if(ruleName === 'Historicize') {
            editTypesSource.push(EditTypesFactory.editTypes.delete);
          } else if (ruleName === 'SnapOn') {
            editTypesSource.push(EditTypesFactory.editTypes.add);
          }

          initEditTypeList(scope, editTypesSource);

          //Si phase de creation
          if (scope.rule.parameters == undefined) {
            scope.rule.parameters = {};
          }
          if (scope.rule.parameters['layers'] == undefined) {
            scope.rule.parameters['layers'] = [];
          }

          if (FeatureTypeFactory.resources.featuretypes.length == 0) {
            FeatureTypeFactory.get().then(function() {
              scope.featureTypes = angular.copy(
                FeatureTypeFactory.resources.featuretypes
              );
            });
          } else {
            scope.featureTypes = angular.copy(
              FeatureTypeFactory.resources.featuretypes
            );
          }

          function buildFeatureTypeNames(featureTypes) {
            var result = [];
            for (var i = 0; i < featureTypes.length; i++) {
              result.push({ name: featureTypes[i].name });
            }
            return result;
          }

          $translate('rulecfg.snapon.availablelayers').then(function(res) {
            scope.dualListData.leftTitle = res;
          });
          $translate('rulecfg.snapon.snapedlayers').then(function(res) {
            scope.dualListData.rightTitle = res;
          });

          //scope.selectedFeatureTypes = [];
          scope.dualListData = {
            leftData: buildFeatureTypeNames(scope.featureTypes),
            leftDisplayAttribute: 'name',
            rightData: scope.rule.parameters['layers'],
            rightDisplayAttribute: 'name',
            leftTitle: 'Couches 1',
            rightTitle: 'Couches 2',
            source: 'left',
          };
        },
      };
    }

    function listAllSharedObjects(scope) {
      scope.allSharedObjectsNames = [];
      angular.forEach(scope.currentfeaturetype.rules, function(rule) {
        if (rule.parameters.sharedObjects) {
          angular.forEach(rule.parameters.sharedObjects, function(shareObj) {
            scope.allSharedObjectsNames.push(shareObj.name);
          });
        }
      });
    }

    function initFormula(scope) {
      // if is new rule
      if (scope.rule.parameters === undefined) {
        scope.rule.parameters = {};
      }
      if (scope.rule.parameters.formula === undefined) {
        scope.formula = {
          numerotation: {
            auto: false,
            separator: ' ',
            parts: [
              {
                key: 'type',
                format: ' ',
              },
            ],
          },
        };
        scope.rule.parameters.formula = scope.formula;
        scope.targetField = '';
      } else {
        scope.formula = scope.rule.parameters.formula;
        scope.targetField = scope.rule.parameters.targetField;
      }
    }

    return {
      initEditTypeList: initEditTypeList,
      removeShareObject: removeShareObject,
      buildDirectiveObject: buildDirectiveObject,
      buildDirectiveObject2: buildDirectiveObject2,
      buildDirectiveObject3: buildDirectiveObject3,
      listAllSharedObjects: listAllSharedObjects,
      initFormula: initFormula,
    };
  };
  RuleCfgFactory.$inject = [
    '$translate',
    'EditTypesFactory',
    'FeatureTypeFactory',
  ];
  return RuleCfgFactory;
});
