'use strict';
/**
 * @ngdoc overview
 * @name modules.edit
 * @description
 * edit module
 */
define([
  'angular',
  'modules/edit/services/AdvancedEditionFactory',
  'modules/edit/services/EditFactory',
  'modules/edit/services/EditRulesProvider',
  'modules/edit/services/RuleCfgFactory',
  'modules/edit/services/networks/ASSEditionFactory',
  'modules/edit/services/rules/EditRuleAllowDelete',
  'modules/edit/services/rules/EditRuleMoveObjectOnEnd',
  'modules/edit/services/rules/EditRuleObjectNotAllowedAtIntersection',
  'modules/edit/services/rules/EditRuleSetDefaultValueByRole',
  'modules/edit/services/rules/EditRuleSnappedOnFeature',
  'modules/edit/services/rules/mustNotSelfIntersectRule',
  'modules/edit/services/rules/mustNotSelfOverlapRule',
  'modules/edit/services/rules/getFeaturesFromLineAssociationRule',
  'modules/edit/directives/rules/cfgRulesInfos',
  'modules/edit/services/EditRulesFeatGeomFactory',

  'modules/edit/directives/rules/cfg/cfg.snapon',

  'modules/edit/directives/rules/cfg/cfg.setAttribute',
  'modules/edit/directives/rules/cfg/cfg.setDefaultValue',
  'modules/edit/directives/rules/cfg/cfg.setDefaultValueByRole',
  'modules/edit/directives/rules/cfg/cfg.setAttributeByFormula',
  'modules/edit/directives/rules/cfg/cfg.setAttributeByConcat',
  'modules/edit/directives/rules/cfg/cfg.setUniqueIdByConcat',
  'modules/edit/directives/rules/cfg/cfg.setRemoteAttribute',
  'modules/edit/directives/rules/cfg/cfg.setXYAttributes',
  'modules/edit/directives/rules/cfg/cfg.setLengthAttribute',
  'modules/edit/directives/rules/cfg/cfg.setUserAttribute',
  'modules/edit/directives/rules/cfg/cfg.setDateAttribute',
  'modules/edit/directives/rules/cfg/cfg.setW3wAttribute',
  'modules/edit/directives/rules/cfg/cfg.setAreaAttribute',
  'modules/edit/directives/rules/cfg/cfg.rotateSymbolPoint',

  'modules/edit/directives/rules/cfg/cfg.setObjectOnExtremity',
  'modules/edit/directives/rules/cfg/cfg.getIntersectingLine',
  'modules/edit/directives/rules/cfg/cfg.startLineSnappedOnPoint',
  'modules/edit/directives/rules/cfg/cfg.endLineSnappedOnPoint',
  'modules/edit/directives/rules/cfg/cfg.startLineSnappedOnLine',
  'modules/edit/directives/rules/cfg/cfg.endLineSnappedOnLine',
  'modules/edit/directives/rules/cfg/cfg.getInitialIntersectingLine',
  'modules/edit/directives/rules/cfg/cfg.getAllIntersectingInitialLine',
  'modules/edit/directives/rules/cfg/cfg.getAllIntersectingLine',
  'modules/edit/directives/rules/cfg/cfg.moveExtremityPoint',
  'modules/edit/directives/rules/cfg/cfg.moveObjectsOnLine',
  'modules/edit/directives/rules/cfg/cfg.deleteObjectsOnLine',
  'modules/edit/directives/rules/cfg/cfg.deposeObjectsOnLine',
  'modules/edit/directives/rules/cfg/cfg.checkNbConnectionOfSnappedPoint',
  'modules/edit/directives/rules/cfg/cfg.mustNotSelfOverlap',

  'modules/edit/directives/rules/cfg/cfg.getIntersectingPolygon',
  'modules/edit/directives/rules/cfg/cfg.getIntersectingPoint',
  'modules/edit/directives/rules/cfg/cfg.mergeRemainingLines',
  'modules/edit/directives/rules/cfg/cfg.mergeIntersectingLines',
  'modules/edit/directives/rules/cfg/cfg.allowDelete',
  'modules/edit/directives/rules/cfg/cfg.moveObjectOnEnd',
  'modules/edit/directives/rules/cfg/cfg.objectNotAllowedAtIntersection',

  'modules/edit/directives/rules/cfg/cfg.cutIntersectingLine',

  'modules/edit/directives/rules/cfg/cfg.historicize',
  'modules/edit/directives/rules/cfg/cfg.verifZoneSaisie',

  'modules/edit/directives/rules/cfg/cfg.copyPasteAttribute',
  'modules/edit/directives/rules/cfg/cfg.mustNotSelfIntersect',
  'modules/edit/directives/rules/cfg/cfg.getFeaturesFromLineAssociation'
], function (
  angular,
  AdvancedEditionFactory,
  EditFactory,
  EditRulesProvider,
  RuleCfgFactory,
  ASSEditionFactory,
  EditRuleAllowDelete,
  EditRuleMoveObjectOnEnd,
  EditRuleObjectNotAllowedAtIntersection,
  EditRuleSetDefaultValueByRole,
  EditRuleSnappedOnFeature,
  mustNotSelfIntersectRule,
  mustNotSelfOverlapRule,
  getFeaturesFromLineAssociationRule,
  cfgRulesInfos,
  EditRulesFeatGeomFactory,
  cfgSnapOn,
  cfgSetAttribute,
  cfgSetDefaultValue,
  cfgSetDefaultValueByRole,
  cfgSetAttributeByFormula,
  cfgSetAttributeByConcat,
  cfgSetUniqueIdByConcat,
  cfgSetRemoteAttribute,
  cfgSetXYAttributes,
  cfgSetLengthAttribute,
  cfgSetUserAttribute,
  cfgSetDateAttribute,
  cfgSetW3wAttribute,
  cfgSetAreaAttribute,
  cfgRotateSymbolPoint,
  cfgSetObjectOnExtremity,
  cfgGetIntersectingLine,
  cfgStartLineSnappedOnPoint,
  cfgEndLineSnappedOnPoint,
  cfgStartLineSnappedOnLine,
  cfgEndLineSnappedOnLine,
  cfgGetInitialIntersectingLine,
  cfgGetAllIntersectingInitialLine,
  cfgGetAllIntersectingLine,
  cfgMoveExtremityPoint,
  cfgMoveObjectsOnLine,
  cfgDeleteObjectsOnLine,
  cfgDeposeObjectsOnLine,
  cfgCheckNbConnectionOfSnappedPoint,
  cfgMustNotSelfOverlap,
  cfgGetIntersectingPolygon,
  cfgGetIntersectingPoint,
  cfgMergeRemainingLines,
  cfgMergeIntersectingLines,
  cfgAllowDelete,
  cfgMoveObjectOnEnd,
  cfgObjectNotAllowedAtIntersection,
  cfgCutIntersectingLine,
  cfgHistoricize,
  cfgVerifZoneSaisie,
  cfgCopyPasteAttribute,
  cfgMustNotSelfIntersect,
  cfgGetFeaturesFromLineAssociation
) {
  // Module
  var mod = angular.module('edit', []);

  // Services
  mod.factory('AdvancedEditionFactory', AdvancedEditionFactory);
  mod.factory('EditFactory', EditFactory);
  mod.factory('RuleCfgFactory', RuleCfgFactory);
  mod.factory('EditRulesFeatGeomFactory', EditRulesFeatGeomFactory);
  mod.factory('ASSEditionFactory', ASSEditionFactory);
  //L'implémentation des règles
  mod.provider('EditRuleAllowDelete', EditRuleAllowDelete);
  mod.provider('EditRuleMoveObjectOnEnd', EditRuleMoveObjectOnEnd);
  mod.provider('EditRuleObjectNotAllowedAtIntersection', EditRuleObjectNotAllowedAtIntersection);
  mod.provider('EditRuleSetDefaultValueByRole', EditRuleSetDefaultValueByRole);
  mod.provider('EditRuleSnappedOnFeature', EditRuleSnappedOnFeature);
  mod.provider('MustNotSelfIntersectRule', mustNotSelfIntersectRule);
  mod.provider('MustNotSelfOverlapRule', mustNotSelfOverlapRule);
  mod.factory('GetFeaturesFromLineAssociationRule', getFeaturesFromLineAssociationRule);
  mod.provider('EditRulesProvider', EditRulesProvider);
  // Les directives de configuration de règles

  //Directive de visualisation des objets partagés par l'ensemble des configurations de règles
  mod.directive('cfgRulesInfos', cfgRulesInfos);

  //Règles d'initialisation
  mod.directive('ruleCfgSnapOn', cfgSnapOn);

  //Règles attributaires
  mod.directive('ruleCfgSetAttribute', cfgSetAttribute);
  mod.directive('ruleCfgSetDefaultValue', cfgSetDefaultValue);
  mod.directive('ruleCfgSetDefaultValueByRole', cfgSetDefaultValueByRole);
  mod.directive('ruleCfgSetAttributeByFormula', cfgSetAttributeByFormula);
  mod.directive('ruleCfgSetAttributeByConcat', cfgSetAttributeByConcat);
  mod.directive('ruleCfgSetUniqueIdByConcat', cfgSetUniqueIdByConcat);
  mod.directive('ruleCfgSetRemoteAttribute', cfgSetRemoteAttribute);
  mod.directive('ruleCfgSetXyAttributes', cfgSetXYAttributes);
  mod.directive('ruleCfgSetLengthAttribute', cfgSetLengthAttribute);
  mod.directive('ruleCfgSetUserAttribute', cfgSetUserAttribute);
  mod.directive('ruleCfgSetDateAttribute', cfgSetDateAttribute);
  mod.directive('ruleCfgSetW3wAttribute', cfgSetW3wAttribute);
  mod.directive('ruleCfgSetAreaAttribute', cfgSetAreaAttribute);
  mod.directive('ruleCfgRotateSymbolPoint', cfgRotateSymbolPoint);
  mod.directive('ruleCfgCopyPasteAttribute', cfgCopyPasteAttribute);

  //Règles géométriques pour linéaires
  mod.directive('ruleCfgSetObjectOnExtremity', cfgSetObjectOnExtremity);
  mod.directive('ruleCfgGetIntersectingLine', cfgGetIntersectingLine);
  mod.directive('ruleCfgStartLineSnappedOnPoint', cfgStartLineSnappedOnPoint);
  mod.directive('ruleCfgEndLineSnappedOnPoint', cfgEndLineSnappedOnPoint);
  mod.directive('ruleCfgStartLineSnappedOnLine', cfgStartLineSnappedOnLine);
  mod.directive('ruleCfgEndLineSnappedOnLine', cfgEndLineSnappedOnLine);
  mod.directive(
    'ruleCfgGetInitialIntersectingLine',
    cfgGetInitialIntersectingLine
  );
  mod.directive(
    'ruleCfgGetAllIntersectingInitialLine',
    cfgGetAllIntersectingInitialLine
  );
  mod.directive('ruleCfgGetAllIntersectingLine', cfgGetAllIntersectingLine);
  mod.directive('ruleCfgMoveExtremityPoint', cfgMoveExtremityPoint);
  mod.directive('ruleCfgMoveObjectsOnLine', cfgMoveObjectsOnLine);
  mod.directive('ruleCfgDeleteObjectsOnLine', cfgDeleteObjectsOnLine);
  mod.directive('ruleCfgDeposeObjectsOnLine', cfgDeposeObjectsOnLine);
  mod.directive('ruleCfgCheckNbConnectionOfSnappedPoint', cfgCheckNbConnectionOfSnappedPoint);
  // Invalide la géométrie d’un linéaire ayant des segments qui se chevauchent
  mod.directive('ruleCfgMustNotSelfOverlap', cfgMustNotSelfOverlap);

  // Règles géométriques pour polygones
  mod.directive('ruleCfgGetIntersectingPolygon', cfgGetIntersectingPolygon);

  //Règles géométriques pour ponctuels
  mod.directive('ruleCfgGetIntersectingPoint', cfgGetIntersectingPoint);
  mod.directive('ruleCfgMergeRemainingLines', cfgMergeRemainingLines);
  mod.directive('ruleCfgMergeIntersectingLines', cfgMergeIntersectingLines);
  mod.directive('ruleCfgAllowDelete', cfgAllowDelete);
  mod.directive('ruleCfgMoveObjectOnEnd', cfgMoveObjectOnEnd);
  mod.directive('ruleCfgObjectNotAllowedAtIntersection', cfgObjectNotAllowedAtIntersection);

  //Règles géométriques pour ponctuels et linéaires
  mod.directive('ruleCfgCutIntersectingLine', cfgCutIntersectingLine);

  //Règles d'historisation
  mod.directive('ruleCfgHistoricize', cfgHistoricize);
  // Règles géométriques communes
  mod.directive('ruleCfgVerifZoneSaisie', cfgVerifZoneSaisie);

  // Invalide la géométrie d’un linéaire qui s’auto-intersecte
  mod.directive('ruleCfgMustNotSelfIntersect', cfgMustNotSelfIntersect);

  // Créer et d'établir le lien entre le patrimoine réseau d’assainissement et les éléments de supports de la fibre optique
  mod.directive('ruleCfgGetFeaturesFromLineAssociation', cfgGetFeaturesFromLineAssociation);

  return mod;
});
