'use strict';
define(function() {
  var gcelement = function(
    FeatureTypeFactory,
    EditTypesFactory,
    $translate,
    RuleCfgFactory
  ) {
    return {
      templateUrl:
        'js/XG/modules/edit/views/rules/cfg/cfg.setObjectOnExtremity.html',

      restrict: 'E',
      scope: {
        currentfeaturetype: '=currentfeaturetype',
        rule: '=',
      },
      link: function(scope) {
        //scope.result = {};
        scope.rule.name = 'SetObjectOnExtremity';
        scope.rule.type = 'OnEnd';

        //Si phase de creation
        if (scope.rule.parameters === undefined) {
          scope.rule.parameters = {};
        }

        if (scope.rule.parameters.sharedObjects === undefined) {
          scope.rule.parameters.sharedObjects = [];
        }

        /* KIS-3116: A l’exécution de la règle depuis le widget d’Edition,
        il faut évaluer l’option avant l’affichage des popups amont et aval */
        if (!scope.rule.parameters.hidePopupAttribute === undefined) {
          scope.rule.parameters.hidePopupAttribute = false;
        }

        // Récupération de la liste des noms des objets partagés entre les règles
        RuleCfgFactory.listAllSharedObjects(scope);



        var editTypesSource = [EditTypesFactory.editTypes.add];
        RuleCfgFactory.initEditTypeList(scope, editTypesSource);
        var shareObjectDescAmont = '';
        var shareObjectDescAval = '';
        $translate('rulecfg.setobjectonextremity.shareObjectDescAmont').then(
          function(res) {
            shareObjectDescAmont = res;
          }
        );
        $translate('rulecfg.setobjectonextremity.shareObjectDescAval').then(
          function(res) {
            shareObjectDescAval = res;
          }
        );

        if (scope.rule.parameters == undefined) {
          scope.rule.parameters = {};
        }
        //Objets partagés destinés au partage avec les autres config de règles
        if (scope.rule.parameters.sharedObjects == undefined) {
          scope.rule.parameters.sharedObjects = {};
        }

        function filterLayerPoint(elem) {
          return elem.typeInfo == 'POINT';
        }

        if (FeatureTypeFactory.resources.featuretypes.length == 0) {
          FeatureTypeFactory.get().then(function() {
            scope.featureTypes = FeatureTypeFactory.resources.featuretypes.filter(
              filterLayerPoint
            );
          });
        } else {
          scope.featureTypes = FeatureTypeFactory.resources.featuretypes.filter(
            filterLayerPoint
          );
        }

        /**
         * Méthode appelée à chaque changement de nom de l'objet partagé, par l'utilisateur.
         * Permet d'enregistrer l'objet partagé dans un tableau utilisable par d'autres configuration de règles qui récupérent les objets partagés existants.
         * @param {type} shareObject
         * @returns {undefined}
         */
        scope.updateSharedObjects = function(shareObject) {
          //Affectation d'un hashKey à shareObject à sa creation seulement. C'est ce premier hashKey qui sera ensuite utilisé tout le cycle de vie de ce shareObject.
          //Si on remarque des problemes d'unicité, on pourra utiliser Math.random() à la place.
          if (shareObject.hashKey == undefined) {
            shareObject.hashKey = shareObject.$$hashKey;
          }
          scope.rule.parameters.sharedObjects[
              shareObject.hashKey
              ] = shareObject;

          //Mise à jour du composant de visualisation de tous les objets partagés par les cfg de règles.
          //element html correspondant à la directive de visualisation des objets partagés.
          var CfgRulesInfosElem = document.querySelector(
              '#updateCfgRulesInfos'
          );
          if (CfgRulesInfosElem) {
            CfgRulesInfosElem.dispatchEvent(new Event('updateCfgRulesInfos'));
          }
        };

        /**
         * Vérifie que le type d'objet partagé que l'on cherche à ajouter n'existe pas déjà
         * @param {Array.Object} shareObjects Liste des objets partagés
         * @param {string} layerName Nom du type d'objet
         * @returns {boolean} true si le nom de la couche est déjà présent dans la liste d'objets à partager, faux sinon
         */
        const isLayerNamePresent = (shareObjects, layerName) => {
          for (const tempShareObject of shareObjects) {
            if (tempShareObject.layerName === layerName) {
              return true;
            }
          }
          return false;
        }

        /**
         * Au changement dans le SELECT de couche selectionné
         * @param {Object} selectedLayer couche selectionnée
         */
        scope.onLayerChange = (selectedLayer) => {
          scope.selectedlayer = selectedLayer;
        };

        /**
         * Ajout d'un objet partagé entre les règles
         * @param {string} localPosition amont/aval
         */
        scope.addShareObject = (localPosition) => {
          if (!scope.selectedlayer) {
            return;
          }
          if (!scope.rule.parameters[localPosition]) {
            scope.rule.parameters[localPosition] = {};
          }
          if (!scope.rule.parameters[localPosition].shareObjects) {
            scope.rule.parameters[localPosition].shareObjects = [];
          }
          if (!isLayerNamePresent(scope.rule.parameters[localPosition].shareObjects , scope.selectedlayer.name)) {
            scope.rule.parameters[localPosition].shareObjects.push({ layer: scope.selectedlayer.name });
          }
        };

        /**
         * Suppression d'un objet partagé
         * @param {number} sourceIndex Position de l'objet à supprimer dans le tableau des objets partagés
         * @param {string} localPosition Amont/Aval
         */
        scope.removeShareObject = (sourceIndex, localPosition) => {
          scope.rule.parameters[localPosition].shareObjects.splice(sourceIndex, 1);
        };

        /**
         * La refonte de la règle lors du ticket KIS-2718 n'a pas tenu compte des composants
         * possédant déjà une règle setObjectOnExtremity configurée dans leur fichier json.<br>
         * L'objet de cette méthode est de permettre la lecture d'une configuration existante uniquement.<br>
         * Cette méthode regarde si la structure de la règle est antérieure à la refonte et adapte le json à la nouvelle structure le cas échéant.
         * Si la règle n'est pas re-enregistrée alors la structure initiale ne sera pas physiquement modifiée dans le fichier.
         * Lors de la refonte lors du ticket KIS-2718 une confusion supplémentaire de nommage a été ajoutée (entre "sharedObjects" et "shareObjects")
         */
        const reshapeJson = () => {
          const parameters = scope.rule.parameters;
          const sharedObjects = parameters.sharedObjects;

          const reshapeObjects = (direction) => {
            if (parameters[direction] && !parameters[direction].hasOwnProperty('shareObjects') && sharedObjects.hasOwnProperty(direction)) {
              const hashKey = sharedObjects[direction].hashKey  === undefined ? sharedObjects[direction].$$hashKey : sharedObjects[direction].hashKey;
              parameters[direction].shareObjects = {};
              parameters[direction].shareObjects = [{
                layer: sharedObjects[direction].layerName,
                name: sharedObjects[direction].name,
                hashKey: hashKey
              }];
            }
          };

          reshapeObjects('amont');
          reshapeObjects('aval');
        };

        reshapeJson();
      },
    };
  };

  gcelement.$inject = [
    'FeatureTypeFactory',
    'EditTypesFactory',
    '$translate',
    'RuleCfgFactory',
  ];
  return gcelement;
});
