'use strict';
define(function() {
  var gcelement = function(
    FeatureTypeFactory,
    $translate,
    EditTypesFactory,
    RuleCfgFactory
  ) {
    return {
      templateUrl:
        'js/XG/modules/edit/views/rules/cfg/cfg.rotateSymbolPoint.html',
      restrict: 'E',

      scope: {
        currentfeaturetype: '=currentfeaturetype',
        rule: '=rule',
        preventSave: '=?'
      },
      link: function(scope, element, attrs, ctrl) {
        //scope.result = {};
        scope.rule.name = 'RotateSymbolPoint';
        scope.rule.type = 'OnEnd';

        var editTypesSource = [
          EditTypesFactory.editTypes.add,
          EditTypesFactory.editTypes.update,
        ];

        RuleCfgFactory.initEditTypeList(scope, editTypesSource);

        //Si phase de creation
        if (scope.rule.parameters == undefined) {
          scope.rule.parameters = {};
        }
        if (scope.rule['parameters']['layerInfos'] == undefined) {
          scope.rule['parameters']['layerInfos'] = {};
        }
        if (
          scope.rule['parameters']['layerInfos'][
            scope.currentfeaturetype.name
          ] == undefined
        ) {
          scope.rule['parameters']['layerInfos'][
            scope.currentfeaturetype.name
          ] = {};
        }

        if (scope.rule.parameters.shareObjects == undefined) {
          scope.rule.parameters.shareObjects = [];
        }

        // désactive le bouton "Enregistrer" au départ
        // activation uniquement si un attribut et un composant partagé sont définis
        scope.preventSave = true;

        function isFeatureLine(ft) {
          return ft.typeInfo == 'LINE';
        }

        function isLayerNamePresent(shareObjects, layerName) {
          var isPresent = false;
          for (var i = 0; i < shareObjects.length; i++) {
            if (shareObjects[i].layerName == layerName) {
              isPresent = true;
            }
          }
          return isPresent;
        }

        if (FeatureTypeFactory.resources.featuretypes.length == 0) {
          FeatureTypeFactory.get().then(function() {
            scope.featureTypes = angular
              .copy(FeatureTypeFactory.resources.featuretypes)
              .filter(isFeatureLine);
          });
        } else {
          scope.featureTypes = angular
            .copy(FeatureTypeFactory.resources.featuretypes)
            .filter(isFeatureLine);
        }

        scope.onLayerChange = function(f) {
          scope.selectedlayer = f;
        };

        scope.onRotateFieldNameChange = function() {
          scope.selectedRotateFieldName =
            scope.rule['parameters']['layerInfos'][
              scope.currentfeaturetype.name
            ]['rotateFieldName'];
        };

        scope.addShareObject = function() {
          if (
            scope.selectedlayer == null ||
            scope.selectedRotateFieldName == undefined
          )
            return;

          var sourceArray = scope.rule.parameters['shareObjects'];

          if (!isLayerNamePresent(sourceArray, scope.selectedlayer.name)) {
            sourceArray.push({
              layerName: scope.selectedlayer.name
            });
          }
          scope.preventSave = false;
        };

        scope.removeShareObject = function(sourceIndex) {
          var sourceArray = scope.rule.parameters['shareObjects'];
          sourceArray.splice(sourceIndex, 1);
        };

        /**
         * Tous les objets partagés par l'ensemble des règles de la couche currentfeaturetype.
         */
        RuleCfgFactory.listAllSharedObjects(scope);
      },
    };
  };

  gcelement.$inject = [
    'FeatureTypeFactory',
    '$translate',
    'EditTypesFactory',
    'RuleCfgFactory',
  ];
  return gcelement;
});
