'use strict';
define(function() {
  var gcelement = function(
      FeatureTypeFactory,
      $translate,
      EditTypesFactory,
      RuleCfgFactory
  ) {
    return {
      templateUrl:
          'js/XG/modules/edit/views/rules/cfg/cfg.objectNotAllowedAtIntersection.html',
      restrict: 'E',

      scope: {
        currentfeaturetype: '=currentfeaturetype',
        rule: '=rule',
      },
      link: function(scope) {
        //scope.result = {};
        scope.rule.name = 'ObjectNotAllowedAtIntersection';
        scope.rule.type = 'OnEnd';

        //Si phase de creation
        if (scope.rule.parameters === undefined) {
          scope.rule.parameters = {};
        }

        if (scope.rule.parameters.sharedObjects === undefined) {
          scope.rule.parameters.sharedObjects = [];
        }

        // Récupération de la liste des noms des objets partagés entre les règles
        RuleCfgFactory.listAllSharedObjects(scope);

        const editTypesSource = [EditTypesFactory.editTypes.add,
          EditTypesFactory.editTypes.update];
        RuleCfgFactory.initEditTypeList(scope, editTypesSource);

        if (FeatureTypeFactory.resources.featuretypes.length === 0) {
          FeatureTypeFactory.get().then(() => {
            scope.linearFeatureTypes = angular.copy(
                FeatureTypeFactory.resources.featuretypes
                .filter(feature => feature.typeInfo === 'LINE')
            );
          });
        } else {
          scope.linearFeatureTypes = angular.copy(
              FeatureTypeFactory.resources.featuretypes
              .filter(feature => feature.typeInfo === 'LINE')
          );
        }

        scope.onLayerChange = f => {
          scope.selectedlayer = f;
        };

        /**
         * Vérification que la couche layerName n'est pas pas présente
         * dans les objets partagés sharedObjects
         * @param sharedObjects nom de la couche
         * @param layerName liste des objets partagés entre les règles
         * @returns {boolean}
         */
        const isLayerNamePresent = (sharedObjects, layerName) => {
          for (const shareObject of sharedObjects) {
            if (shareObject.layerName === layerName) {
              return true;
            }
          }
          return false;
        }

        /**
         * Appelée lors de l'ajout d'un objet intersecté
         */
        scope.addUpShareObject = () => {
          if (scope.selectedlayer === ''){
            return;
          }
          let sourceArray = scope.rule.parameters.sharedObjects;

          //Ajout de l'objet uniquement si le couple (layerName, name) n'est pas encore present
          if (!isLayerNamePresent(sourceArray, scope.selectedlayer.name)) {
            sourceArray.push({
              layerName: scope.selectedlayer.name
            });
          }
        };

        /**
         * Suppression d'un objet partagé
         * @param sourceIndex index dans la liste de l'objet partagé à supprimer
         */
        scope.removeUpShareObject = sourceIndex => {
          let sourceArray = scope.rule.parameters.sharedObjects;
          let deleted = sourceArray.splice(sourceIndex, 1);

          //Suppression de l'objet partagé des sharedObjects
          const shareObject = deleted[0];
          if (shareObject === undefined) {
            return;
          }
          if (shareObject.hashKey) {
            delete scope.rule.parameters.sharedObjects[shareObject.hashKey];
            //Mise à jour du composant de visualisation de tous les objets partagés par les cfg de règles.
            //element html correspondant à la directive de visualisation des objets partagés.
            let CfgRulesInfosElem = document.getElementById(
                'updateCfgRulesInfos'
            );
            if (CfgRulesInfosElem) {
              CfgRulesInfosElem.dispatchEvent(new Event('updateCfgRulesInfos'));
            }
          }
        };
      },
    };
  };

  gcelement.$inject = [
    'FeatureTypeFactory',
    '$translate',
    'EditTypesFactory',
    'RuleCfgFactory',
  ];
  return gcelement;
});
