'use strict';
define(function() {
  var gcelement = function(
    FeatureTypeFactory,
    $translate,
    EditTypesFactory,
    RuleCfgFactory
  ) {
    return {
      templateUrl:
        'js/XG/modules/edit/views/rules/cfg/cfg.mergeIntersectingLines.html',
      restrict: 'E',

      scope: {
        currentfeaturetype: '=currentfeaturetype',
        rule: '=rule',
      },
      link: function(scope) {
        //scope.result = {};
        scope.rule.name = 'MergeRemainingLines';
        scope.rule.type = 'OnStart';

        var editTypesSource = [EditTypesFactory.editTypes.update];

        RuleCfgFactory.initEditTypeList(scope, editTypesSource);

        //Si phase de creation
        if (scope.rule.parameters == undefined) {
          scope.rule.parameters = {};
        }
        if (scope.rule['parameters']['layersObjects'] == undefined) {
          scope.rule['parameters']['layersObjects'] = [];
        }

        function isFeatureLine(ft) {
          return ft.typeInfo == 'LINE';
        }

        function isLayerNamePresent(shareObjects, layerName) {
          var isPresent = false;
          for (var i = 0; i < shareObjects.length; i++) {
            if (shareObjects[i].layerName == layerName) {
              isPresent = true;
            }
          }
          return isPresent;
        }

        if (FeatureTypeFactory.resources.featuretypes.length == 0) {
          FeatureTypeFactory.get().then(function() {
            scope.featureTypes = angular
              .copy(FeatureTypeFactory.resources.featuretypes)
              .filter(isFeatureLine);
          });
        } else {
          scope.featureTypes = angular
            .copy(FeatureTypeFactory.resources.featuretypes)
            .filter(isFeatureLine);
        }

        scope.onLayerChange = function(f) {
          scope.selectedlayer = f;
        };

        scope.onMaterialfieldNameChange = function(name) {
          scope.selectedMaterialFieldName = name;
        };
        scope.onDiameterFieldNameChange = function(name) {
          scope.selectedDiameterFieldName = name;
        };
        scope.onLengthFieldNameChange = function(name) {
          scope.selectedLengthFieldName = name;
        };

        scope.addObject = function() {
          if (
            scope.selectedlayer == null ||
            scope.selectedMaterialFieldName == undefined ||
            scope.selectedDiameterFieldName == undefined
          )
            return;

          var sourceArray = scope.rule.parameters['layersObjects'];

          if (!isLayerNamePresent(sourceArray, scope.selectedlayer.name)) {
            sourceArray.push({
              layerName: scope.selectedlayer.name,
              materialFieldName: scope.selectedMaterialFieldName,
              diameterFieldName: scope.selectedDiameterFieldName,
              lengthFieldName: scope.selectedLengthFieldName
            });
          }
        };

        scope.removeObject = function(sourceIndex) {
          var sourceArray = undefined;
          sourceArray = scope.rule['parameters']['layersObjects'];
          sourceArray.splice(sourceIndex, 1);
        };
      },
    };
  };

  gcelement.$inject = [
    'FeatureTypeFactory',
    '$translate',
    'EditTypesFactory',
    'RuleCfgFactory',
  ];
  return gcelement;
});
