'use strict';
define(function() {
  var gcelement = function(
    FeatureTypeFactory,
    $filter,
    EditTypesFactory,
    RuleCfgFactory
  ) {
    return {
      templateUrl:
        'js/XG/modules/edit/views/rules/cfg/cfg.getIntersectingPolygon.html',
      restrict: 'E',

      scope: {
        currentfeaturetype: '=currentfeaturetype',
        rule: '=rule',
      },
      link: function(scope) {

        scope.rule.name = 'GetFeatureIntersectingPolygon';
        scope.rule.type = 'OnEnd';

        const editTypesSource = [
          EditTypesFactory.editTypes.add,
          EditTypesFactory.editTypes.update
        ];

        RuleCfgFactory.initEditTypeList(scope, editTypesSource);

        // Si phase de creation
        if (!scope.rule.parameters) {
          scope.rule.parameters = {};
        }

        // Objets destinés au partage avec les autres configuration de règles
        if (!scope.rule.parameters.sharedObjects) {
          scope.rule.parameters.sharedObjects = {};
        }
        if (!scope.rule.parameters.shareObjects) {
          scope.rule.parameters.shareObjects = [];
        }

        if (FeatureTypeFactory.resources.featuretypes.length === 0) {
          FeatureTypeFactory.get().then(() => {
            scope.featureTypes = angular.copy(
              FeatureTypeFactory.resources.featuretypes
            );
          });
        } else {
          scope.featureTypes = angular.copy(
            FeatureTypeFactory.resources.featuretypes
          );
        }


        scope.onLayerChange = f => {
          scope.selectedlayer = f;
        };

        /**
         * Vérifie que le type d'objet partagé que l'on cherche à ajouter n'existe pas déjà
         * @param {Array.Object} shareObjects Liste des objets partagés
         * @param {string} layerName Nom du type d'objet
         * @returns {boolean} true si le nom de la couche est déjà présent dans la liste d'objets à partager, faux sinon
         */
        const isLayerNamePresent = (shareObjects, layerName) => {
          return shareObjects.find(it => it.layerName === layerName) !== undefined;
        };

        /**
         * Ajout d'un objet partagé à avec les autres règles
         */
        scope.addShareObject = () => {
          const sourceArray = scope.rule.parameters['shareObjects'];
          if (scope.selectedlayer && !isLayerNamePresent(sourceArray, scope.selectedlayer.name)) {
            sourceArray.push({
              layerName: scope.selectedlayer.name,
              desc: $filter('translate')('rulecfg.getIntersectingPolygon.shareObjectDesc')
            });
          }
        };

        /**
         * Méthode appelée à chaque changement de nom de l'objet partagé, par l'utilisateur.
         * Permet d'enregistrer l'objet partagé dans un tableau utilisable par d'autres configuration de règles qui récupérent les objets partagés existants.
         * @param {type} shareObject
         * @returns {undefined}
         */
        scope.updateSharedObjects = (shareObject) => {
          //Affectation d'un hashKey à shareObject à sa creation seulement. C'est ce premier hashKey qui sera ensuite utilisé tout le cycle de vie de ce shareObject.
          //Si on remarque des problemes d'unicité, on pourra utiliser Math.random() à la place.
          if (shareObject.hashKey === undefined) {
            shareObject.hashKey = shareObject.$$hashKey;
          }
          scope.rule.parameters.sharedObjects[
            shareObject.hashKey
          ] = shareObject;

          //Mise à jour du composant de visualisation de tous les objets partagés par les cfg de règles.
          //element html correspondant à la directive de visualisation des objets partagés.
          let CfgRulesInfosElem = document.querySelector(
            '#updateCfgRulesInfos'
          );
          if (CfgRulesInfosElem) {
            CfgRulesInfosElem.dispatchEvent(new Event('updateCfgRulesInfos'));
          }
        };

        /**
         * Suppression d'un objet partagé
         * @param sourceIndex
         */
        scope.removeShareObject = (sourceIndex) => {
          RuleCfgFactory.removeShareObject(scope, sourceIndex, false);
        };
      },
    };
  };

  gcelement.$inject = [
    'FeatureTypeFactory',
    '$filter',
    'EditTypesFactory',
    'RuleCfgFactory',
  ];
  return gcelement;
});
