'use strict';
define(() => {
  let gcelement = (EditTypesFactory, RuleCfgFactory, $rootScope, gaJsUtils, $filter,
      AssociationFactory) => {
    return {
      templateUrl: 'js/XG/modules/edit/views/rules/cfg/cfg.getFeaturesFromLineAssociation.html',
      restrict: 'E',
      scope: {
        currentfeaturetype: '=currentfeaturetype',
        rule: '=rule',
      },
      link: function (scope) {
        scope.rule.type = 'OnEnd';

        const editTypesSource = [
          EditTypesFactory.editTypes.add,
          EditTypesFactory.editTypes.update,
        ];

        // permet de masquer la règle getFeaturesFromLine aux composants ponctuels
        // permet de masquer la règle getFeaturesFromPoint aux composant linéaires
        scope.isFeatureTypeMatchingRuleGeometry = scope.rule.name.toLowerCase().includes(
            scope.currentfeaturetype.typeInfo.toLowerCase().replace('multi', ''));

        RuleCfgFactory.initEditTypeList(scope, editTypesSource);

        //Si phase de creation
        if (!scope.rule.parameters) {
          scope.rule.parameters = {};
        }

        /**
         * Créé les données de la dualListBox permettant de sélectionner
         * les attributs du formulaire pour lesquels on copiera les valeurs entre l'objet source et l'objet créé
         * @return {Promise}
         */
          scope.dualListBoxAssociations = {
            leftData: [],
            leftDisplayAttribute: 'alias',
            rightData: [],
            rightDisplayAttribute: 'alias',
            rightTitle: 'tools.builder.intervention_simple.reusedAssociations',
            leftTitle: 'tools.builder.intervention_simple.availableAssociations',
            source: 'right'
          };
        if (gaJsUtils.notNullAndDefined($rootScope.xgos, 'portal.parameters.mainDB')) {
          AssociationFactory.getAll($rootScope.xgos.portal.parameters.mainDB).then(
            res => {
              if (Array.isArray(res.data)) {
                const allAss = res.data;

                if (!scope.rule.parameters.associationsToLoad) {
                  scope.rule.parameters.associationsToLoad = [];
                }

                // filtre les associations contenant le fti du composant 'currentfeaturetype'
                const isAssocContainingFeatureType = (assoc) => {
                  const isAssocTblNameEqualsFtiName = (assoc, side) => {
                    const sideTable = side + 'table';
                    return assoc.hasOwnProperty(sideTable)
                    && assoc[sideTable] === scope.currentfeaturetype.name;
                  };
                  return assoc.type_patrimoine && (isAssocTblNameEqualsFtiName(assoc, 'a') || isAssocTblNameEqualsFtiName(assoc, 'b'));
                };

                // les associations disponibles ne doivent pas contenir des associations déjà utilisées
                const loadedAssocNames = scope.rule.parameters.associationsToLoad.map(assoc => assoc.name);
                let availableAss = allAss.filter(isAssocContainingFeatureType).filter(assoc => !loadedAssocNames.includes(assoc.name));
                scope.dualListBoxAssociations.leftData = availableAss.slice();

                scope.dualListBoxAssociations.rightData = scope.rule.parameters.associationsToLoad;
              }
            }
          ).catch(error => {
            console.error(error.data);
          });
        } else {
          require('toastr').error($filter('translate')('model.association.noMainDB'));
        }
      }
    };
  };

  gcelement.$inject = ['EditTypesFactory', 'RuleCfgFactory', '$rootScope', 'gaJsUtils', '$filter',
    'AssociationFactory'];
  return gcelement;
});