'use strict';
define(function () {
  const gcelement = (
    EditTypesFactory,
    FeatureTypeFactory,
    RuleCfgFactory
  ) => {
    return {
      templateUrl:
        'js/XG/modules/edit/views/rules/cfg/cfg.checkNbConnectionOfSnappedPoint.html',
      restrict: 'E',
      scope: {
        currentfeaturetype: '=currentfeaturetype',
        rule: '=',
      },
      link: (scope) => {
        // Configuration de la règle
        scope.rule.name = 'CheckNbConnectionOfSnappedPoint';
        scope.rule.type = 'OnEnd';
        scope.rule.parameters = scope.rule.parameters || {amont: {}, aval: {}};
        if (!scope.rule.parameters.amont.nbMaxConnections) {
          scope.rule.parameters.amont.nbMaxConnections = 1;
        }
        if (!scope.rule.parameters.aval.nbMaxConnections) {
          scope.rule.parameters.aval.nbMaxConnections = 1;
        }

        // Configuration pour la dual-list-box
        const editTypesSource = [
          EditTypesFactory.editTypes.add,
          EditTypesFactory.editTypes.update
        ];
        RuleCfgFactory.initEditTypeList(scope, editTypesSource);

        // Récupération des featuresTypes pour
        const filterLayerPoint = (elem) => {
          return elem.typeInfo === 'POINT';
        }
        if (FeatureTypeFactory.resources.featuretypes.length === 0) {
          FeatureTypeFactory.get().then(function() {
            scope.featureTypes = FeatureTypeFactory.resources.featuretypes.filter(
                filterLayerPoint
            );
          });
        } else {
          scope.featureTypes = FeatureTypeFactory.resources.featuretypes.filter(
              filterLayerPoint
          );
        }

        // Récupération de la liste des noms des objets partagés entre les règles
        RuleCfgFactory.listAllSharedObjects(scope);



        /**
         * Vérifie que le type d'objet partagé que l'on cherche à ajouter n'existe pas déjà
         * @param {Array.Object} shareObjects Liste des objets partagés
         * @param {string} layerName Nom du type d'objet
         * @returns {boolean} true si le nom de la couche est déjà présent dans la liste d'objets à partager, faux sinon
         */
        const isLayerNamePresent = (shareObjects, layerName) => {
          return shareObjects.find(it => it.layerName === layerName) != undefined;
        };

        /**
         * Au changement dans le SELECT de couche selectionné
         * @param {Object} selectedLayer couche selectionnée
         */
        scope.onLayerChange = (selectedLayer) => {
          scope.selectedlayer = selectedLayer;
        };

        /**
         * Ajout d'un objet partagé entre les règles
         * @param {string} localPosition amont/aval
         */
        scope.addShareObject = (localPosition) => {
          if (!scope.selectedlayer) {
            return;
          }
          if (!scope.rule.parameters[localPosition]) {
            scope.rule.parameters[localPosition] = {};
          }
          if (!scope.rule.parameters[localPosition].shareObjects) {
            scope.rule.parameters[localPosition].shareObjects = [];
          }
          if (!isLayerNamePresent(scope.rule.parameters[localPosition].shareObjects , scope.selectedlayer.name)) {
            scope.rule.parameters[localPosition].shareObjects.push({ layer: scope.selectedlayer.name });
          }
        };

        /**
         * Suppression d'un objet partagé
         * @param {number} sourceIndex Position de l'objet à supprimer dans le tableau des objets partagés
         * @param {string} localPosition Amont/Aval
         */
        scope.removeShareObject = (sourceIndex, localPosition) => {
          scope.rule.parameters[localPosition].shareObjects.splice(sourceIndex, 1);
        };

      },
    };
  };

  gcelement.$inject = [
    'EditTypesFactory',
    'FeatureTypeFactory',
    'RuleCfgFactory'
  ];
  return gcelement;
});
