'use strict';
define(function() {
  var dolibarrFactory = function($http, gaDomUtils, $q) {
    /**
     * Class : dolibarrFactory
     */
    var dolibarrFactory = {};
    var cfg = {
      params: {},
      token: false,
    };

    /**
     * setDolibarrConnectionCfg
     * Setting dolibar connexion confiugration
     * @param {*} cfg
     */
    var setDolibarrConnectionCfg = function(d) {
      cfg.params = d;
    };

    /**
     * setDolibarrConnection
     * Trying to connect to dolibar server
     * @param {*} silent
     */
    var setDolibarrConnection = function(silent) {
      var def = $q.defer();

      // a deplacer dans une factory qui va bien
      if (
        angular.isDefined(cfg.params.url) &&
        angular.isDefined(cfg.params.user) &&
        angular.isDefined(cfg.params.pass) &&
        //  @INTERFACE JVS Multifac et Omega
        !cfg.params.facturationTierce.active
      ) {
        $http({
          url: cfg.params.url + 'api/index.php/login',
          method: 'GET',
          params: {
            login: cfg.params.user,
            password: cfg.params.pass,
            reset: 1,
          },
        }).then(
          function(res) {
            if (!silent)
              require('toastr').success(
                'Connexion au module de facturation établie.'
              );
            cfg.token = res.data.success.token;
            gaDomUtils.hideGlobalLoader();
            def.resolve();
          },
          function() {
            //if (!silent)
            require('toastr').error(
              'Erreur lors de la connexion au module de facturation.'
            );
            gaDomUtils.hideGlobalLoader();
            cfg.token = false;

            def.reject();
          }
        );
      } else {
        def.reject();
      }

      return def.promise;
    };

    /**
     * getservices
     */

    var getServices = function() {
      var promise = $http({
        url: cfg.params.url + 'api/index.php/products',
        method: 'GET',
        headers: {
          dolapikey: cfg.token,
        },
      });

      promise.then(
        function(res) {},
        function(err) {
          console.log('Erreur lors de la recupération des services dolibarr');
        }
      );

      return promise;
    };

    /**
     * addService
     */
    var addService = function(params) {
      // 0=produit, 1=service
      params.type = '1';

      var promise = $http({
        url: cfg.params.url + 'api/index.php/products',
        method: 'POST',
        data: params,
        headers: {
          dolapikey: cfg.token,
        },
      });
      promise.then(
        function(res) {
          console.log('service ajoute');
          console.log(res);
        },
        function(err) {
          if (err.data.error && err.data.error[0]) {
            if (err.data.error[0] == 'ErrorProductAlreadyExists')
              require('toastr').error('Ce service existe déjà.');
          }
          console.log('error');
        }
      );
      return promise;
    };
    /**
     * updateService
     */
    var updateService = function(params, id) {
      // 0=produit, 1=service
      params.type = '1';

      var promise = $http({
        url: cfg.params.url + 'api/index.php/products/' + id,
        method: 'PUT',
        data: params,
        headers: {
          dolapikey: cfg.token,
        },
      });
      promise.then(
        function(res) {
          console.log('service mis a jour');
          console.log(res);
        },
        function(err) {
          console.log('error');
        }
      );
      return promise;
    };

    /**
     * addTiers
     */
    var addTiers = function(params) {
      var promise = $http({
        url: cfg.params.url + 'api/index.php/thirdparties/fromkis',
        method: 'POST',
        data: params,
        headers: {
          dolapikey: cfg.token,
        },
      });
      promise.then(
        function(res) {
          console.log('tiers ajoutés');
          console.log(res);
        },
        function(err) {
          console.log('error');
        }
      );
      return promise;
    };

    /**
     * getTiers
     */

    var getTiers = function() {
      var promise = $http({
        url: cfg.params.url + 'api/index.php/thirdparties',
        method: 'GET',
        headers: {
          dolapikey: cfg.token,
        },
      });

      promise.then(
        function(res) {},
        function(err) {
          console.log('Erreur lors de la recupération des tiers dolibarr');
        }
      );

      return promise;
    };

    /**
     * addFacture
     */
    var addFacture = function(params) {
      var promise = $http({
        url: cfg.params.url + 'api/index.php/invoices',
        method: 'POST',
        data: params,
        headers: {
          dolapikey: cfg.token,
        },
      });

      promise.then(
        function(res) {
          console.log('facture créée');
          console.log(res);
        },
        function(err) {
          console.log('error');
        }
      );

      return promise;
    };

    /**
     * addContacts
     */
    var addContacts = function(params) {
      var promise = $http({
        url: cfg.params.url + 'api/index.php/contacts/fromkis',
        method: 'POST',
        data: params,
        headers: {
          dolapikey: cfg.token,
        },
      });
      promise.then(
        function(res) {
          console.log('added');
          console.log(res);
        },
        function(err) {
          console.log('error');
        }
      );
      return promise;
    };

    /**
     * validateFacture
     */
    var validateFacture = function(id) {
      var promise = $http({
        url: cfg.params.url + 'api/index.php/invoices/' + id + '/validate',
        method: 'POST',
        headers: {
          dolapikey: cfg.token,
        },
      });

      promise.then(
        function(res) {
          console.log('validated');
          console.log(res);
        },
        function(err) {
          console.log('error');
        }
      );

      return promise;
    };

    const exportPesv2 = (dossierIds) => {
      return $http({
        url: cfg.params.url + 'api/index.php/dossierxml',
        method: 'POST',
        data: dossierIds,
        headers: {
          dolapikey: cfg.token,
        },
      });
    }

    const downloadPesv2File = filename => {
      window.open(`${cfg.params.url}api/index.php/dossierxml?filename=${filename}&DOLAPIKEY=${cfg.token}`);
    }

    return {
      cfg: cfg,
      setDolibarrConnectionCfg: setDolibarrConnectionCfg,
      setDolibarrConnection: setDolibarrConnection,
      // services
      addService: addService,
      updateService: updateService,
      getServices: getServices,
      // tiers
      getTiers: getTiers,
      addTiers: addTiers,
      // contact
      //addContacts: addContacts,
      // factures
      addFacture: addFacture,
      validateFacture: validateFacture,
      // export PesV2
      exportPesv2: exportPesv2,
      downloadPesv2File: downloadPesv2File
    };
  };
  dolibarrFactory.$inject = ['$http', 'gaDomUtils', '$q'];
  return dolibarrFactory;
});
