'use strict';
define(function() {
  /**
   * Class : DecoupAdminFactory
   * Factory WebServices
   * https://api.gouv.fr/documentation/api-geo
   * base URL: https://
   */
  class DecoupAdminFactory {
    constructor($http) {
      /**
       * Recherche de departements
       * {nom,code,codeRegion}
       */
      function getDepartements() {
        const url = 'https://geo.api.gouv.fr/departements';
        return $http.get(url);
      }
      /**
       * Renvoi les communes d'un département
       * @param codeDepartement: code du département avec le 0 (ex. 01)
       * {nom,code,codeDepartement,codeRegion,codesPostaux,population}
       */
      function getCommunesByDepartement(codeDept) {
        const url =
          'https://geo.api.gouv.fr/departements/' + codeDept + '/communes';
        return $http.get(url);
      }
      return {
        getDepartements: getDepartements,
        getCommunesByDepartement: getCommunesByDepartement,
      };
    }
  }

  DecoupAdminFactory.$inject = ['$http'];
  return DecoupAdminFactory;
});
