'use strict';
define(function() {
  var ParametersFactory = function($http, gaUrlUtils, $q) {
    var ParametersFactory = {};

    /**
     * Class : ParametersFactory
     * Factory WebServices
     */

    /**
     * Function: add
     */
    function add(data, type, name, category, isObject, idToUpdate) {
      let sendDataObj;

      if (!isObject) {
        sendDataObj = {
          data: data || null,
          name: name || null,
          type: type || null,
          description: data && data.description ? data.description : '',
          category: category || null
        };
      } else {
        sendDataObj = data;
      }

      idToUpdate = idToUpdate ? idToUpdate : '';

      return $http.post(
        '/services/{portalid}/parameter/add?f=json&idtoupdate='+idToUpdate,
        sendDataObj
      );
    }

    /**
     * Function: remove
     */
    function remove(id, forUpdate) {
      forUpdate = forUpdate ? forUpdate : false;
      return $http.get(
        '/services/{portalid}/parameter/remove?f=json' + '&id=' + id +'&forupdate='+forUpdate
      );
    }


    /**
     * Function: get
     */
    function get() {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        return defer.promise;
      } else {
        var promise = $http.get('/services/{portalid}/parameter/get?f=json');
        return promise;
      }
    }

    /**
     * Function: update
     */
    function update(senddata, id) {
      console.log(senddata);
      var promise = $http.post(
        '/services/{portalid}/parameter/update?f=json' + '&id=' + id,
        senddata
      );

      return promise;
    }

    /**
     * Function: publish
     */
    function publish(paramid, users, roles, groups, more) {
      users = gaUrlUtils.encodeUriQuery(users || '');
      roles = gaUrlUtils.encodeUriQuery(roles || '');
      groups = gaUrlUtils.encodeUriQuery(groups || '');
      more = gaUrlUtils.encodeUriQuery(more || '');

      var promise = $http.get(
        '/services/{portalid}/parameter/publish?f=json' +
          '&paramid=' +
          paramid +
          '&users=' +
          users +
          '&roles=' +
          roles +
          '&groups=' +
          groups +
          '&more=' +
          more
      );

      return promise;
    }

    /**
     * Function: unpublish
     */
    function unPublish(paramid) {
      return $http.get(
        '/services/{portalid}/parameter/unpublish?f=json' +
          '&paramid=' +
          paramid
      );
    }

    /**
     * Function: getbyname
     */
    function getbyname(name) {
      if (typeof ancAppAndroid !== 'undefined') {
        var defer = $q.defer();
        return defer.promise;
      } else {
        var promise = $http.get(
          '/services/{portalid}/parameter/getbyname?f=json' + '&name=' + name
        );
        return promise;
      }
    }
    /**
     * Function: getbyid
     */
    function getbyid(id) {
      var promise = $http.get(
        '/services/{portalid}/parameter/getbyid?f=json' + '&id=' + id
      );

      return promise;
    }


    /**
     * Récupère tous les paramètres suivant le type
     * @param type chaine de caractères correpondant
     * au type des paramètres à récupérer
     * @param srid
     * @param bypass
     * @returns {*}
     */
    const getbytype = (type, srid, bypass) => {
      if (typeof ancAppAndroid !== 'undefined') {
        let defer = $q.defer();
        return defer.promise;
      } else {
        return $http.get(
          '/services/{portalid}/parameter/getbytype?f=json' +
            '&type=' + type + '&srid=' + srid + '&bypass=' + bypass
        );
      }
    };


    /**
     * Récupère les paramètres du repo de type 'annotation'
     * <ul>
     *   <li>créés par l'utilisateur</li>
     *   <li>partagées à l'utilisateur</li>
     *   <li>partagées à un rôle/groupe de l'utilisateur</li>
     * </ul>
     * @param username nom de l'auteur de l'annotation
     * @param srid paramètre de <code>ParametersHandler#getbytype</code> nécessaire pour les géosignets (non nécessaire pour les annotations)
     * @param bypass est <code>true</code> si la recherche de paramètres ne doit pas
     *        être filtrée par les droits de l'utilisateur cf. <code>ParametersRepository#getByTypeAsUserParam</code>
     * @param isroot est <code>true</code> si l'utilisateur connecté est "root" (<code>$rootScope.xgos.isroot</code>)
     * @returns {Promise} contenant un tableau d'annotations de type {@link UserParameter}
     */
    function getannotationsbyuser(username, srid, bypass, isroot) {
      if (typeof ancAppAndroid !== 'undefined') {
        let defer = $q.defer();
        return defer.promise;
      } else {
        return $http.get(
          '/services/{portalid}/parameter/getannotationsbyuser?f=json' +
            '&username=' +username + '&srid=' + srid +
            '&bypass=' + bypass + '&isroot=' + isroot
        );
      }
    }

    /**
     * Function: updatebyname
     */
    function updatebyname(senddata, name) {
      var promise = $http.post(
        '/services/{portalid}/parameter/updatebyname?f=json' + '&name=' + name,
        senddata
      );

      return promise;
    }


    /**
     * Function: deletebyname
     */
    const deletebyname = (name) => {
      return $http.get(
        '/services/{portalid}/parameter/deletebyname?f=json' + '&name=' + name
      );
    };


    /**
     * Function: deletebytypeandname
     */
    const deletebytypeandname = (name, type) => {
      return $http.get(
        '/services/{portalid}/parameter/deletebytypeandname?f=json' +
        '&name=' + name + '&type=' + type
      );
    };


    /**
     * Cherche un paramétre ne base d'aprés son nom et son type.
     *
     * Function: getbytypeandname
     */
    const getbytypeandname = (name, type) => {
      return $http.get(
        '/services/{portalid}/parameter/getbytypeandname?f=json' +
        '&name=' + name + '&type=' + type
      );
    };


    /**
     * Function: getpublishinfosbyid
     */
    const getpublishinfosbyid = (paramid) => {
      return $http.get(
        '/services/{portalid}/parameter/getpublishinfosbyid?f=json&paramid=' +
        paramid
      );
    };


    /**
     * Récupère un paramètre de type 'defaultfilter' ayant pour titre le paramètre
     * @param title chaine de caractères correspondant au titre du filtre
     * @returns {Promise}
     */
    function getDefaultFilterByTitle(title) {
      return $http.get(
        '/services/{portalid}/parameter/getdefaultfilterbytitle?f=json' +
          '&filterTitle=' + title
      );
    }

    /**
     * Met à jour une collection de paramètres de type 'defaultfilter'
     * @param filters tableau de filtres
     * @returns {Promise}
     */
    function updateFilters(filters) {
      return $http.post(
        '/services/{portalid}/parameter/updatefilters?f=json',
        filters
      );
    }

    /**
     * Suppression de plusieurs paramètres de type 'defaultfilter' selon le nom
     * @param filterNames liste de String des noms de filtres de données
     * @return {Promise} liste des noms de filtres de données supprimmés
     */
    function deleteFiltersByName(filterNames) {
      return $http.post(
        '/services/{portalid}/parameter/deleteFiltersByName?f=json',
        filterNames
      );
    }

    return {
      ParametersFactory: ParametersFactory,
      add: add,
      remove: remove,
      get: get,
      update: update,
      publish: publish,
      unPublish: unPublish,
      getbyname: getbyname,
      getbyid: getbyid,
      getbytype: getbytype,
      updatebyname: updatebyname,
      deletebyname: deletebyname,
      getannotationsbyuser: getannotationsbyuser,
      deletebytypeandname: deletebytypeandname,
      getpublishinfosbyid: getpublishinfosbyid,
      getDefaultFilterByTitle: getDefaultFilterByTitle,
      updateFilters: updateFilters,
      deleteFiltersByName: deleteFiltersByName,
      getbytypeandname: getbytypeandname
    };
  };
  ParametersFactory.$inject = ['$http', 'gaUrlUtils', '$q'];
  return ParametersFactory;
});
