'use strict';
/**
 * @ngdoc overview
 * @name modules.dbparameters
 * @description
 * dbparameters module
 */
define([
  'angular',
  'modules/dbparameters/services/DbParameterFactory',
  'modules/dbparameters/directives/adminParamWidget',
  'modules/dbparameters/controllers/publishController',
  'modules/dbparameters/directives/publishParamComponent',
  'modules/dbparameters/directives/rPublishParamComponent',
  'modules/dbparameters/controllers/AdminParametersCtrl',
], function(
  angular,
  ParametersFactory,
  adminParamWidget,
  publishController,
  publishParamComponent,
  rPublishParamComponent,
  AdminParametersCtrl
) {
  // Module
  var mod = angular.module('parameters', []);

  // Services
  mod.factory('ParametersFactory', ParametersFactory);

  //Widget d'administration de l'ensemble des paramètres
  mod.directive('adminparamwidget', adminParamWidget);

  //Controller de la popup de publication
  mod.controller('publishController', publishController);

  //route provider
  mod.config([
    '$routeProvider',
    function($routeProvider) {
      $routeProvider.when('/parameters/', {
        // templateUrl: "js/XG/modules/" + 'dbparameters/views/parameters.html'
        templateUrl: 'js/XG/modules/process/views/process.html',
        controller: AdminParametersCtrl,
      });
    },
  ]);

  //Composant independant de publication de paramètre
  mod.directive('publishParam', publishParamComponent);
  mod.directive('repPublishParam', rPublishParamComponent);

  return mod;
});
