'use strict';

/**
 * @ngdoc controller
 * @name modules.dbparameters.controller:publishController
 * @description
 * The publishController controller
 */
define(function() {
  var publishController = function(
    $scope,
    ParametersFactory,
    UsersFactory,
    GroupsFactory,
    RolesFactory,
    $filter,
    $rootScope,
    FunctionFactory,
    gaDomUtils,
    taOptions
  ) {
    const editedParam = $scope.ngDialogData;

    $scope.paramState = editedParam.state;
    $scope.publishedUsers = [];
    $scope.publishedRoles = [];
    $scope.publishedGroups = [];

    //$scope.tabs = [{"title": "Utilisateurs"}, {"title": "Rôles"}, {"title": "Groupes"}];
    // les variables qui definissent les titres sont recuperees dans la fonctions precedente
    $scope.tabs = [
      {
        title: $filter('translate')('adminparam.tab_users'),
      },
      {
        title: $filter('translate')('adminparam.tab_roles'),
      },
      {
        title: $filter('translate')('adminparam.tab_groups'),
      },
    ];
    $scope.tabs.activeTab = 0;

    /**
     * Handler du bouton de sauvegarde des informations de publication
     * @returns {undefined}
     */
    $scope.savePublishInfos = () => {
      editedParam.state = $scope.paramState;

      //Publication
      if ($scope.paramState === 'public') {
        publish();
      }
      //Depublication
      else if ($scope.paramState === 'private') {
        unPublish();
      }
    };

    const publish = () => {
      //Suppression d'un eventuel element chaine vide.
      if ($scope.publishedUsers.indexOf('') !== -1)
        $scope.publishedUsers.splice($scope.publishedUsers.indexOf(''), 1);
      if ($scope.publishedRoles.indexOf('') !== -1)
        $scope.publishedRoles.splice($scope.publishedRoles.indexOf(''), 1);
      if ($scope.publishedGroups.indexOf('') !== -1)
        $scope.publishedGroups.splice($scope.publishedGroups.indexOf(''), 1);

      //Construction de la chaine à partir du tableau
      const usersToPublish = $scope.publishedUsers.toString();
      const rolesToPublish = $scope.publishedRoles.toString();
      const groupsToPublish = $scope.publishedGroups.toString();

      //toastr avec message traduit
      ParametersFactory.publish(
        editedParam.id,
        usersToPublish,
        rolesToPublish,
        groupsToPublish
      ).then(
        () => {
          $rootScope.$broadcast('mapModelListUpdated', editedParam.id);
          require('toastr').info(
            $filter('translate')('model.featuretypes.publish_ok')
          );
        },
        (reason) => {
          console.log('Publish id:' + editedParam.id + ' en echec . ' + reason);
          require('toastr').error(
            'Publish parameter id:' + editedParam.id + ': en echec .' + reason);
        }
      );
    }

    const unPublish = () => {
      ParametersFactory.unPublish(editedParam.id).then(
        () => {
          $rootScope.$broadcast('mapModelListUpdated', editedParam.id);
          require('toastr').info('Depublication OK !');
        },
        (reason) => {
          console.log(
            'unPublish id:' + editedParam.id + ' en echec . ' + reason
          );
          require('toastr').error(
            'unPublish parameter id:' + editedParam.id + ': en echec .' + reason
          );
        }
      );
    }

    /**
     * Récupération des informations de publication du paramètre édité.
     * @returns {undefined}
     */
    const getPublishInfos = () => {
      ParametersFactory.getpublishinfosbyid(editedParam.id).then(
        (res) => {
          const resultObject = res.data;
          //Etat du paramètre
          $scope.paramState = resultObject.state;

          //Récupération des utilisateurs publiés
          $scope.publishedUsers.splice(0);
          const resUsers = resultObject.users;
          if (Array.isArray(resUsers)) {
            for (let i = 0; i < resUsers.length; i++) {
              const l = resUsers[i];
              if (l && l !== '') $scope.publishedUsers.push(l);
            }
          }

          //Récupération des roles publiés
          $scope.publishedRoles.splice(0);
          const resRoles = resultObject.roles;
          if (Array.isArray(resRoles)) {
            for (let i = 0; i < resRoles.length; i++) {
              const l = resRoles[i];
              if (l && l !== '') $scope.publishedRoles.push(l);
            }
          }

          //Récupération des Groupes publiés
          $scope.publishedGroups.splice(0);
          const resGroups = resultObject.groups;
          if (Array.isArray(resGroups)) {
            for (let i = 0; i < resGroups.length; i++) {
              const l = resGroups[i];
              if (l && l !== '') $scope.publishedGroups.push(l);
            }
          }
        },
        (reason) => {
          console.log('getPublishInfos id:' + editedParam.id + ' en echec . ' + reason);
          require('toastr').error('getPublishInfos parameter id:' + editedParam.id +
              ': en echec .' + reason
          );
        }
      );
    }

    getPublishInfos();

    //////////////////////////////////////////
    //
    // Gestion des Utilisateurs (1er onglet)
    //
    /////////////////////////////////////////

    $scope.users = []; //Contient la liste des utilisateurs

    /**
     * Méthode de récupération des utilisateurs stockés dans le repository du portail.
     */
    UsersFactory.getlight().then(
      (res) => {
        $scope.users.splice(0);
        $scope.users = res.data;
        $scope.users.sort();
      },
      (reason) => {
        console.log('Get Users echec : ' + reason);
        require('toastr').error('Get Users echec :' + reason);
      }
    );

    $scope.userCheckboxes = { checked: false, items: {} };

    // watch for check all checkbox
    $scope.$watch('userCheckboxes.checked', function(value) {
      angular.forEach($scope.publishedUsers, function(item) {
        if (angular.isDefined(item)) {
          $scope.userCheckboxes.items[item] = value;
        }
      });
    });

    $scope.deleteUsers = () => {
      const usersToKeep = [];
      for (const user of $scope.publishedUsers){
        if (!$scope.userCheckboxes.items[user]) {
          usersToKeep.push(user);
        }
      }
      $scope.publishedUsers = usersToKeep;

      const userkeys = Object.keys($scope.userCheckboxes.items);
      for (let i = 0; i < userkeys.length; i++) {
        if ($scope.userCheckboxes.items[userkeys[i]] === true) {
          delete $scope.userCheckboxes.items[userkeys[i]];
        }
      }
    };

    $scope.$watch('listSelectedUser', () => {
        if ($scope.listSelectedUser && $scope.listSelectedUser.login &&
          $scope.publishedUsers.findIndex(u => u === $scope.listSelectedUser.login) === -1) {
          $scope.publishedUsers.push($scope.listSelectedUser.login);
        }
      },
      1
    );

    //////////////////////////////////////////
    //
    // Gestion des Roles (2eme onglet)
    //
    /////////////////////////////////////////

    $scope.roles = []; //Contient la liste des roles

    /**
     *
     * Méthode de récupération des roles stockés dans le repository du portail.
     */
    RolesFactory.get(true).then(
      (res) => {
        $scope.roles.splice(0);
        $scope.roles = res.data;
      },
      (reason) => {
        console.log('Get Roles echec : ' + reason);
        require('toastr').error('Get Roles echec :' + reason);
      }
    );

    $scope.roleCheckboxes = { checked: false, items: {} };

    // watch for check all checkbox
    $scope.$watch('roleCheckboxes.checked', (value) => {
      for (const role of $scope.publishedRoles){
        $scope.roleCheckboxes.items[role] = value;
      }
    });

    $scope.deleteRole = () => {
      const rolesToKeep = [];
      for (const role of $scope.publishedRoles){
        if (!$scope.roleCheckboxes.items[role]) {
          rolesToKeep.push(role);
        }
      }
      $scope.publishedRoles = rolesToKeep;

      const roleKeys = Object.keys($scope.roleCheckboxes.items);
      for (let i = 0; i < roleKeys.length; i++) {
        if ($scope.roleCheckboxes.items[roleKeys[i]] === true) {
          delete $scope.roleCheckboxes.items[roleKeys[i]];
        }
      }
    };

    $scope.$watch('listSelectedRole', () => {
        if ($scope.listSelectedRole && $scope.listSelectedRole.name &&
          $scope.publishedRoles.findIndex(r => r === $scope.listSelectedRole.name) === -1
        ) {
          $scope.publishedRoles.push($scope.listSelectedRole.name);
        }
      },
      1
    );

    //////////////////////////////////////////
    //
    // Gestion des Groupes (3eme onglet)
    //
    /////////////////////////////////////////

    $scope.groups = []; //Contient la liste des Groupes

    /**
     *
     * Méthode de récupération des Groupes stockés dans le repository du portail.
     */
    GroupsFactory.get(true).then(
      (res) => {
        $scope.groups.splice(0);
        $scope.groups = res.data;
      },
      (reason) => {
        console.log('Get Groupes echec : ' + reason);
        require('toastr').error('Get Groupes echec :' + reason);
      }
    );

    $scope.groupCheckboxes = { checked: false, items: {} };

    // watch for check all checkbox
    $scope.$watch('groupCheckboxes.checked', (value) => {
      for (const group of $scope.publishedGroups){
        $scope.groupCheckboxes.items[group] = value;
      }
    });

    $scope.deleteGroup = () => {
      const groupsToKeep = [];
      for (const group of $scope.publishedGroups){
        if (!$scope.groupCheckboxes.items[group]) {
          groupsToKeep.push(group);
        }
      }
      $scope.publishedGroups = groupsToKeep;

      const groupKeys = Object.keys($scope.groupCheckboxes.items);
      for (let i = 0; i < groupKeys.length; i++) {
        if ($scope.groupCheckboxes.items[groupKeys[i]] === true) {
          delete $scope.groupCheckboxes.items[groupKeys[i]];
        }
      }
    };

    $scope.$watch('listSelectedGroup', () => {
        if ($scope.listSelectedGroup && $scope.listSelectedGroup.name &&
          $scope.publishedGroups.findIndex(g => g === $scope.listSelectedGroup.name) === -1) {
          $scope.publishedGroups.push($scope.listSelectedGroup.name);
        }
      },
      1
    );

    $scope.publishedEmail = {
      subject: editedParam.type + ' ' + editedParam.name,
      content: '',
    };
    /**
     * send Published Email
     * @param subject
     * @param content
     */
    $scope.sendPublishedEmail = (subject, content) => {
      const recipients = [];

      //users
      const userkeys = Object.keys($scope.userCheckboxes.items);
      for (let i = 0; i < userkeys.length; i++) {
        if ($scope.userCheckboxes.items[userkeys[i]] === true) {
          for (const user of $scope.users){
            if (user.login === userkeys[i]) {
              recipients.push(user);
            }
          }
        }
      }
      //roles
      const roleKeys = Object.keys($scope.roleCheckboxes.items);
      for (let i = 0; i < roleKeys.length; i++) {
        if ($scope.roleCheckboxes.items[roleKeys[i]] === true) {
          for (const user of $scope.users){
            for (let j = 0; j < user.roles.length; j++) {
              if (user.roles[j].name === roleKeys[i]) {
                recipients.push(user);
              }
            }
          }
        }
      }
      //groups
      const groupKeys = Object.keys($scope.groupCheckboxes.items);
      for (let i = 0; i < groupKeys.length; i++) {
        if ($scope.groupCheckboxes.items[groupKeys[i]] === true) {
          for (const user of $scope.users) {
            for (let j = 0; j < user.groups.length; j++) {
              if (user.groups[j].name === groupKeys[i]) {
                recipients.push(user);
              }
            }
          }
        }
      }
      const recipients_copy = [];
      const recipients_unique = [];
      for (let i = 0; i < recipients.length; i++) {
        let contains = false;
        for (let j = 0; j < recipients_copy.length; j++) {
          if (recipients_copy[j] === recipients[i].login) {
            contains = true;
          }
        }
        if (contains === false) {
          recipients_unique.push(recipients[i]);
          recipients_copy.push(recipients[i].login);
        }
      }

      for (let i = 0; i < recipients_unique.length; i++) {
        prepareEmail(recipients_unique[i], subject, content);
      }
    };

    /**
     * prepare Email
     * @param user
     * @param subject
     * @param content
     */
    const prepareEmail = (user, subject, content) => {
      const mailDesc = [];

      mailDesc.push({ name: 'mailTo', type: 'cst', value: [user.email] });
      mailDesc.push({ name: 'mailSubject', type: 'cst', value: subject });
      mailDesc.push({ name: 'mailContent', type: 'cst', value: content });

      gaDomUtils.showGlobalLoader();
      FunctionFactory.execute({ parameters: mailDesc }, 'sendMail', 'ja').then(
        () => {
          gaDomUtils.hideGlobalLoader();
          $scope.publishedEmail = {
            subject: editedParam.type + ' ' + editedParam.name,
            content: '',
          };
        },
        () => {
          gaDomUtils.hideGlobalLoader();
        }
      );
    };

    /**
     * display Published Email
     * @returns {boolean}
     */
    $scope.displayPublishedEmail = () => {
      let res = false;
      if ($rootScope.xgos.portal.sendMailCfg) {
        res = true;
      }
      return res;
    };

    $scope.renderNumEmail = () => {
      let num = 0;

      const userkeys = Object.keys($scope.userCheckboxes.items);
      for (let i = 0; i < userkeys.length; i++) {
        if ($scope.userCheckboxes.items[userkeys[i]] === true) {
          num++;
        }
      }
      //roles
      const roleKeys = Object.keys($scope.roleCheckboxes.items);
      for (let i = 0; i < roleKeys.length; i++) {
        if ($scope.roleCheckboxes.items[roleKeys[i]] === true) {
          num++;
        }
      }
      //groups
      const groupKeys = Object.keys($scope.groupCheckboxes.items);
      for (let i = 0; i < groupKeys.length; i++) {
        if ($scope.groupCheckboxes.items[groupKeys[i]] === true) {
          num++;
        }
      }

      return num;
    };

    /**
     * reset taOptions of toolbar
     * @type {*[]}
     */
    taOptions.toolbar = [
      [
        'h1',
        'h2',
        'h3',
        'h4',
        'h5',
        'h6',
        'bold',
        'italics',
        'underline',
        'strikeThrough',
        'ul',
        'ol',
        'insertLink',
      ],
    ];
  };
  publishController.$inject = [
    '$scope',
    'ParametersFactory',
    'UsersFactory',
    'GroupsFactory',
    'RolesFactory',
    '$filter',
    '$rootScope',
    'FunctionFactory',
    'gaDomUtils',
    'taOptions',
  ];
  return publishController;
});
