'use strict';
define(function() {
  var GcPagination = function() {
    return {
      templateUrl:
        'js/XG/modules/components/mobile_pagination/views/gc_pagination.html',
      restrict: 'AE',
      scope: true,

      link: function(scope, element, attrs, ctrl) {
        scope.selected = function() {
          var ipp, ip;
          if (scope.pagPages == undefined) scope.buildPageList();
          if (scope.pagPages == undefined) return;
          for (ipp = 0; ipp < scope.pagPages.length; ipp++) {
            if (scope.pagPages[ipp].pages == undefined) {
              if (scope.pagPages[ipp].index == scope.paginationObj.page) {
                scope.selectedPagpagesIndex = scope.pagPages[ipp].index;
                break;
              }
            } else {
              for (ip = 0; ip < scope.pagPages[ipp].pages.length; ip++) {
                if (
                  scope.pagPages[ipp].pages[ip].index ==
                  scope.paginationObj.page
                ) {
                  scope.selectedPagpagesIndex = scope.pagPages[ipp].index;
                  break;
                }
              }
            }
          }
        };

        scope.buildPageList = function() {
          var midStart, midEnd, midCnt, ip, ipp;

          if (scope.maxItems == undefined) scope.maxItems = 7;
          scope.pagPages = [];
          if (scope.paginationObj.pages == undefined) {
            //alert("Missing page list");
            return;
          }
          if (scope.paginationObj.pages.length == undefined) {
            alert('Page list is wrong');
            return;
          }
          if (scope.paginationObj.pages.length > scope.maxItems) {
            midCnt = scope.paginationObj.pages.length - scope.maxItems;
            midStart = Math.round(scope.maxItems / 2) - 1;
            midEnd = midStart + midCnt - 1;
          }
          for (ip = ipp = 0; ip < scope.paginationObj.pages.length; ip++) {
            if (ip >= midStart && ip <= midEnd) {
              if (ip == midStart) {
                scope.pagPages[midStart] = {
                  pages: [],
                  index: midStart,
                };
                ipp++;
              }
              scope.pagPages[midStart].pages.push({ index: ip });
            } else {
              scope.pagPages[ipp++] = { index: ip };
            }
          }
        };

        scope.init = function() {
          scope.$watch('paginationObj.curPage', scope.selected);
          scope.$watch('paginationObj.pages.length', scope.buildPageList);
          scope.maxItem = scope.paginationObj.maxItem;
        };

        scope.init();
      },
    };
  };

  GcPagination.$inject = [];
  return GcPagination;
});
