'use strict';
define(function() {
  /**
   * Replaces a true value with a check sign
   * and the false/undefined value with a cross sign
   * @returns input
   */
  var booleanToCheck = function($sce) {
    return function(input) {
      var trInput = input;
      if (input === true) {
        trInput =
          '<div class="text-success bg-success text-center">\u2713</div>';
      } else if (input === false || typeof input == 'undefined') {
        trInput = '<div class="text-center">\u2718</div>';
      }
      return $sce.trustAsHtml(trInput);
    };
  };

  booleanToCheck.$inject = ['$sce'];
  return booleanToCheck;
});
