var app = angular.module('docxfeeder', [
  'angularBootstrapNavTree',
  'pascalprecht.translate',
  'ngDialog',
]);

// Define the `PhoneListController` controller on the `phonecatApp` module
app.controller('feeder', [
  '$scope',
  '$http',
  '$timeout',
  'ngDialog',
  function mainCtrl($scope, $http, $timeout, ngDialog) {
    var checkNestedProperty = function(dotSeparatedString, object) {
      if (!object) object = false;
      return dotSeparatedString.split('.').reduce(function(obj, i) {
        return angular.isDefined(obj[i]) ? obj[i] : false;
      }, object);
    };

    var feederCfg = JSON.parse(localStorage.getItem('kisfeeder'));
    if (feederCfg == null) return;

    const url = new URL(window.location.href);
    let portalId = url.searchParams.get('portalId');
    if (!portalId) {
      portalId = localStorage.getItem('portal');
    }
    if (portalId == null) {
      return;
    }
    var token = localStorage.getItem('auth_token');
    if (token == null) return;

    var elements = JSON.parse(localStorage.getItem('kisElementFiliereFeeder'));
    var typeFormulaire = JSON.parse(localStorage.getItem('kisTypeFormulaire'));

    // anc only
    var listElementFilieres = [];

    $scope.feederMode = feederCfg.mode;
    var appname = feederCfg.appname;

    var apptype = 'anc';
    if (feederCfg.branches.length) {
      var elem;
      feederCfg.branches.forEach(function(branche, i) {
        if (branche.type == 'elements_filiere_templater') elem = i;
        if (branche.label == 'Instructions BAC') {
          apptype = 'bac';
        }
      });
    }
    if (apptype == 'anc') {
      try {
        listElementFilieres = JSON.parse(
          localStorage.getItem('kisFeederCfgAppli')
        ).properties.vidangesCfg.elements_filiere;
      } catch (error) {
        console.log(error);
      }
    }

    //Push checkbox attribut générique
    var attrGenerique = {
      label_court: 'Caractéristiques génériques',
      type: '',
    };

    for (var i in typeFormulaire) {
      if (typeFormulaire[i].type == 'FO0') typeFormulaire.splice(i, 1);
    }

    $scope.typeFormulaire = typeFormulaire;

    //Sort elementsFiliere by type
    $scope.tabType = [];
    for (var i in elements) {
      $scope.tabType.push(elements[i].type);
      elements[i].uid = elements[i].uid.slice(11, elements[i].uid.length);
    }
    $scope.elementsFiliere = elements;
    $scope.tabType = Array.from(new Set($scope.tabType));

    //Define all object
    for (var i in $scope.tabType) {
      switch ($scope.tabType[i]) {
        case 'kis_anc_element_filiere_type.1':
          $scope.tabType[i] = {
            type: $scope.tabType[i],
            alias: 'Prétraitement',
            name: 'pretraitement',
          };
          break;
        case 'kis_anc_element_filiere_type.2':
          $scope.tabType[i] = {
            type: $scope.tabType[i],
            alias: 'Traitement',
            name: 'traitement',
          };
          break;
        case 'kis_anc_element_filiere_type.3':
          $scope.tabType[i] = {
            type: $scope.tabType[i],
            alias: 'Filière agréées',
            name: 'filiere_agrees',
          };
          break;
        case 'kis_anc_element_filiere_type.4':
          $scope.tabType[i] = {
            type: $scope.tabType[i],
            alias: 'Autres',
            name: 'autres_elements',
          };
          break;
        default:
          $scope.tabType[i] = {
            type: $scope.tabType[i],
            alias: 'Type de filière inconnu',
            name: 'type_inconnu',
          };
      }
    }

    if ($scope.feederMode != 'discriminant') {
      $scope.tabType.splice(0, 0, {
        type: 'all_elements',
        alias: 'Tous les éléments',
        name: 'all_elements',
      });
    }

    $scope.config_signet = [
      {
        label: 'value',
        alias: 'Valeur',
      },
      {
        label: 'alias',
        alias: 'Question',
      },
      {
        label: 'all',
        alias: 'Question + valeur (1 signet)',
      },
      {
        label: 'allqa',
        alias: 'Question et valeur (2 signets)',
      },
    ];

    $scope.showBody = true;
    $scope.search = {};

    $scope.data = {};
    // add metadata
    if ($scope.feederMode == 'feeder') {
      feederCfg.branches.push({
        label: 'Meta-data',
        jsonurl: 'metadata.json',
      });

      new Clipboard('.copyKey');
    }

    $scope.search.template = false;
    $scope.canSearch = function(option, commentaire_element) {
      if (angular.isDefined(option) && option === 'fromTemplate')
        $scope.fromTemplate = true;
      else $scope.fromTemplate = false;
      $scope.search.enabled = {};
      $scope.search.enabled.attribute = false;
      if (angular.isDefined($scope.search.type.type) && option === 'type') {
        delete $scope.search.element;
        delete $scope.search.controle;
        delete $scope.search.config;
        $scope.search.template = false;
        if (angular.isDefined($scope.data)) $scope.data = {};
      }

      if (angular.isDefined($scope.search.type.type))
        $scope.search.enabled.element = true;
      if (
        $scope.search.type.type === 'all_elements' ||
        (angular.isDefined($scope.search.element) &&
          $scope.search.element.uid.length)
      )
        $scope.search.enabled.controle = true;
      if (
        angular.isDefined($scope.search.controle) &&
        $scope.search.controle.label_court.length
      )
        $scope.search.enabled.config = true;

      if (
        $scope.search.enabled.element &&
        angular.isDefined($scope.search.config) &&
        $scope.search.config.label
      )
        $scope.setListAttributes();
      if (
        $scope.search.type.type === 'all_elements' &&
        angular.isDefined($scope.search.config) &&
        $scope.search.config.label.length
      )
        $scope.setListAttributes();

      if ($scope.feederMode == 'discriminant' && option == 'controle')
        $scope.setListAttributes();

      if (
        angular.isDefined(commentaire_element) &&
        commentaire_element == 'element_filiere_commentaire'
      ) {
        $scope.loadingBranch = true;
        $scope.obligatoireDiscriminant = {
          obligatoire: {},
          discriminant: {},
          commentaires: {},
        };
        getObligatoireDiscriminant(
          apptype + 'FormCfg_' + $scope.search.controle.type
        ).then(function(res) {
          if (res.data != '') $scope.obligatoireDiscriminant = res.data;
          $scope.loadingBranch = false;
        });
      }
    };

    $scope.listeAttributes = [];
    $scope.setListAttributes = function(fromTemplate) {
      if (!$scope.fromTemplate) $scope.data = {};
      $scope.listeAttributes = [];
      $scope.search.enabled.attribute = true;

      if ($scope.feederMode != 'discriminant')
        $scope.listeAttributes.push({
          name: 'all_values',
          alias: 'Récupérer la liste complète',
        });
      else {
        $scope.search.generique = true;
      }

      var formName = $scope.search.controle.type.toLowerCase();
      var indexBool = 0;
      if (formName === '') {
        indexBool = -1;
      }

      if ($scope.search.type.type === 'all_elements') {
        $scope.data.selectedAttribute = $scope.listeAttributes[0];
      } else {
        $scope.elementsFiliere.forEach(function(elem) {
          if (
            elem.uid === $scope.search.element.uid &&
            elem.attributes.length
          ) {
            elem.attributes.forEach(function(attr) {
              if (
                (attr.name.indexOf('ctrl' + formName) == indexBool &&
                  attr.name.indexOf('caj_id') == -1) ||
                (angular.isDefined($scope.search.generique) &&
                  $scope.search.generique &&
                  attr.name.indexOf('ctrl') == -1 &&
                  attr.name.indexOf('caj_id') == -1)
              )
                if (
                  $scope.feederMode == 'discriminant' &&
                  attr.type == 'java.lang.String' &&
                  attr.size >= 500  &&
                  attr.name.indexOf('commentaire') >= 0 &&
                  (!attr.restrictions || attr.restrictions.length == 0)
                )
                  $scope.listeAttributes.push(attr);
                else if ($scope.feederMode != 'discriminant') {
                  $scope.listeAttributes.push(attr);
                }
            });
          }
        });
      }

      if (
        angular.isDefined($scope.data.selectedAttribute) &&
        $scope.search.type.type !== 'all_elements'
      )
        $scope.getValueFeeder();
      if (
        angular.isDefined($scope.data.selectedAttribute) &&
        $scope.data.selectedAttribute.name === 'all_values' &&
        $scope.search.type.type === 'all_elements'
      ) {
        getAllAttributesTemplate();
      }
    };

    var getAllAttributesTemplate = function() {
      $scope.keyToShow = [];
      var form = [];
      if (
        angular.isDefined($scope.search.generique) &&
        $scope.search.generique == true
      )
        form.push(''); // include caractéristiques generiques
      form.push($scope.search.controle);

      $scope.elementsFiliere.forEach(function(elem) {
        if (angular.isDefined($scope.search.template) && $scope.search.template)
          $scope.keyToShow.push({
            label: '#{ef-' + elem.uid + '-debut} \n\r',
            br: true,
          });

        elem.attributes.forEach(function(attr) {
          if (
            angular.isUndefined($scope.search.controle) ||
            !$scope.search.controle
          ) {
            if (attr.name.indexOf('caj_id') == -1) {
              if (
                angular.isDefined($scope.search.element.uid) &&
                $scope.search.element.uid === 'all'
              )
                keyToShow.push({
                  label: '#{ef-' + elem.uid + '-' + attr.name + '}',
                  br: false,
                }); //"-"+ attr.type+"-"+ attr.size+
              if (
                angular.isDefined($scope.search.element.uid) &&
                $scope.search.element.uid === 'value'
              )
                keyToShow.push({
                  label: '#{ef-' + elem.uid + '-' + attr.name + '-v}',
                  br: false,
                });
              if (
                angular.isDefined($scope.search.element.uid) &&
                $scope.search.element.uid === 'alias'
              )
                keyToShow.push({
                  label: '#{ef-' + elem.uid + '-' + attr.name + '-a}',
                  br: false,
                });
              if (
                angular.isDefined($scope.search.element.uid) &&
                $scope.search.element.uid === 'allqa'
              ) {
                keyToShow.push({
                  label: '#{ef-' + elem.uid + '-' + attr.name + '-a}',
                  br: false,
                });
                keyToShow.push({
                  label: '#{ef-' + elem.uid + '-' + attr.name + '-v}',
                  br: false,
                });
              }
            }
          } else if (angular.isDefined($scope.search.controle)) {
            var formName = $scope.search.controle.type.toLowerCase();
            var indexBool = 0;
            if (formName === '') {
              indexBool = -1;
            }

            if (
              (attr.name.indexOf('ctrl' + formName) == indexBool &&
                attr.name.indexOf('caj_id') == -1) ||
              (angular.isDefined($scope.search.generique) &&
                $scope.search.generique &&
                attr.name.indexOf('ctrl') == -1 &&
                attr.name.indexOf('caj_id') == -1)
            ) {
              if (
                angular.isDefined($scope.search.config) &&
                $scope.search.config.label === 'all'
              )
                $scope.keyToShow.push({
                  label: '#{ef-' + elem.uid + '-' + attr.name + '}',
                  br: false,
                });
              if (
                angular.isDefined($scope.search.config) &&
                $scope.search.config.label === 'value'
              )
                $scope.keyToShow.push({
                  label: '#{ef-' + elem.uid + '-' + attr.name + '-v}',
                  br: false,
                });
              if (
                angular.isDefined($scope.search.config) &&
                $scope.search.config.label === 'alias'
              )
                $scope.keyToShow.push({
                  label: '#{ef-' + elem.uid + '-' + attr.name + '-a}',
                  br: false,
                });
              if (
                angular.isDefined($scope.search.config) &&
                $scope.search.config.label === 'allqa'
              ) {
                $scope.keyToShow.push({
                  label: '#{ef-' + elem.uid + '-' + attr.name + '-a}',
                  br: false,
                });
                $scope.keyToShow.push({
                  label: '#{ef-' + elem.uid + '-' + attr.name + '-v}',
                  br: false,
                });
              }
            }
          }
        });

        if (angular.isDefined($scope.search.template) && $scope.search.template)
          $scope.keyToShow.push({
            label: '\n\r#{ef-' + elem.uid + '-fin}\n\r',
            br: true,
          });
      });
    };

    $scope.getValueFeeder = function() {
      if (
        angular.isDefined($scope.search.element) ||
        (angular.isDefined($scope.type_ef) &&
          $scope.search.type.type != 'all_elements')
      ) {
        $scope.keyToShow = [];

        if (
          angular.isDefined($scope.search.template) &&
          !$scope.search.template &&
          $scope.data.selectedAttribute.name != 'all_values'
        ) {
          if (
            angular.isDefined($scope.search.config) &&
            $scope.search.config.label === 'all'
          )
            $scope.keyToShow.push({
              label:
                '#{ef-' +
                $scope.search.element.uid +
                '-' +
                $scope.data.selectedAttribute.name +
                '}',
              br: false,
            });
          if (
            angular.isDefined($scope.search.config) &&
            $scope.search.config.label === 'value'
          )
            $scope.keyToShow.push({
              label:
                '#{ef-' +
                $scope.search.element.uid +
                '-' +
                $scope.data.selectedAttribute.name +
                '-v}',
              br: false,
            });
          if (
            angular.isDefined($scope.search.config) &&
            $scope.search.config.label === 'alias'
          )
            $scope.keyToShow.push({
              label:
                '#{ef-' +
                $scope.search.element.uid +
                '-' +
                $scope.data.selectedAttribute.name +
                '-a}',
              br: false,
            });
          if (
            angular.isDefined($scope.search.config) &&
            $scope.search.config.label === 'allqa'
          ) {
            $scope.keyToShow.push({
              label:
                '#{ef-' +
                $scope.search.element.uid +
                '-' +
                $scope.data.selectedAttribute.name +
                '-a}',
              br: false,
            });
            $scope.keyToShow.push({
              label:
                '#{ef-' +
                $scope.search.element.uid +
                '-' +
                $scope.data.selectedAttribute.name +
                '-v}',
              br: false,
            });
          }
        }

        if (
          angular.isDefined($scope.search.template) &&
          $scope.search.template &&
          $scope.data.selectedAttribute.name != 'all_values'
        ) {
          $scope.keyToShow.push({
            label: '#{ef-' + $scope.search.element.uid + '-debut}',
            br: true,
          });
          if (
            angular.isDefined($scope.search.config) &&
            $scope.search.config.label === 'all'
          )
            $scope.keyToShow.push({
              label:
                '#{ef-' +
                $scope.search.element.uid +
                '-' +
                $scope.data.selectedAttribute.name +
                '}',
              br: false,
            });
          if (
            angular.isDefined($scope.search.config) &&
            $scope.search.config.label === 'value'
          )
            $scope.keyToShow.push({
              label:
                '#{ef-' +
                $scope.search.element.uid +
                '-' +
                $scope.data.selectedAttribute.name +
                '-v}',
              br: false,
            });
          if (
            angular.isDefined($scope.search.config) &&
            $scope.search.config.label === 'alias'
          )
            $scope.keyToShow.push({
              label:
                '#{ef-' +
                $scope.search.element.uid +
                '-' +
                $scope.data.selectedAttribute.name +
                '-a}',
              br: false,
            });
          if (
            angular.isDefined($scope.search.config) &&
            $scope.search.config.label === 'allqa'
          ) {
            $scope.keyToShow.push({
              label:
                '#{ef-' +
                $scope.search.element.uid +
                '-' +
                $scope.data.selectedAttribute.name +
                '-a}',
              br: false,
            });
            $scope.keyToShow.push({
              label:
                '#{ef-' +
                $scope.search.element.uid +
                '-' +
                $scope.data.selectedAttribute.name +
                '-v}',
              br: false,
            });
          }
          $scope.keyToShow.push({
            label: '#{ef-' + $scope.search.element.uid + '-fin}',
            br: true,
          });
        }

        if (
          angular.isDefined($scope.data.selectedAttribute) &&
          $scope.data.selectedAttribute.name == 'all_values'
        ) {
          var listeDesAttributsCopie = angular.copy($scope.listeAttributes);
          if (listElementFilieres.includes($scope.search.element.name)) {
            listeDesAttributsCopie.push({
              alias: 'Nom du vidangeur',
              name: 'vidange_vidangeur',
              size: 500,
              type: 'java.lang.String',
            });

            listeDesAttributsCopie.push({
              alias: 'Fréquence',
              name: 'vidange_frequence',
              size: 500,
              type: 'java.lang.String',
            });

            listeDesAttributsCopie.push({
              alias: 'Volume de vidange',
              name: 'vidange_volume',
              size: 500,
              type: 'java.lang.String',
            });

            listeDesAttributsCopie.push({
              alias: 'Document de justificatif',
              name: 'vidange_doc_justif',
              size: 500,
              type: 'java.lang.String',
            });

            listeDesAttributsCopie.push({
              alias: 'Destination des Matieres',
              name: 'vidange_destination_matieres',
              size: 500,
              type: 'java.lang.String',
            });

            listeDesAttributsCopie.push({
              alias: 'Commentaire ',
              name: 'vidange_remarque',
              size: 500,
              type: 'java.lang.String',
            });

            listeDesAttributsCopie.push({
              alias: 'Vidange agriculteur',
              name: 'vidange_agriculteur',
              size: 500,
              type: 'java.lang.String',
            });

            listeDesAttributsCopie.push({
              alias: 'Vidange particulier',
              name: 'vidange_particulier',
              size: 500,
              type: 'java.lang.String',
            });

            listeDesAttributsCopie.push({
              alias: 'Vidange effectuee',
              name: 'vidange_effectuee',
              size: 500,
              type: 'java.lang.String',
            });

            listeDesAttributsCopie.push({
              alias: 'Vidange date',
              name: 'vidange_date',
              size: 500,
              type: 'java.lang.String',
            });
          }

          listeDesAttributsCopie.forEach(function(attr) {
            if (attr.name != 'all_values') {
              if (
                angular.isDefined($scope.search.config) &&
                $scope.search.config.label === 'all'
              )
                $scope.keyToShow.push({
                  label:
                    '#{ef-' + $scope.search.element.uid + '-' + attr.name + '}',
                  br: false,
                });
              if (
                angular.isDefined($scope.search.config) &&
                $scope.search.config.label === 'value'
              )
                $scope.keyToShow.push({
                  label:
                    '#{ef-' +
                    $scope.search.element.uid +
                    '-' +
                    attr.name +
                    '-v}',
                  br: false,
                });
              if (
                angular.isDefined($scope.search.config) &&
                $scope.search.config.label === 'alias'
              )
                $scope.keyToShow.push({
                  label:
                    '#{ef-' +
                    $scope.search.element.uid +
                    '-' +
                    attr.name +
                    '-a}',
                  br: false,
                });
              if (
                angular.isDefined($scope.search.config) &&
                $scope.search.config.label === 'allqa'
              ) {
                $scope.keyToShow.push({
                  label:
                    '#{ef-' +
                    $scope.search.element.uid +
                    '-' +
                    attr.name +
                    '-a}',
                  br: false,
                });
                $scope.keyToShow.push({
                  label:
                    '#{ef-' +
                    $scope.search.element.uid +
                    '-' +
                    attr.name +
                    '-v}',
                  br: false,
                });
              }
            }
          });

          if ($scope.search.template === true) {
            $scope.keyToShow.splice(0, 0, {
              label: '#{ef-' + $scope.search.element.uid + '-debut}',
              br: true,
            });
            $scope.keyToShow.push({
              label: '#{ef-' + $scope.search.element.uid + '-fin}',
              br: true,
            });
          }
        }
      } else if ($scope.search.type.type === 'all_elements') {
        $scope.keyToShow = getAllAttributesTemplate();
        $scope.data.selectedAttribute.name = 'all';
      }
    };

    var commentDialog, currentCommentKey, currentCommentType;

    $scope.addCommentDialog = function(key, type) {
      currentCommentKey = key;
      currentCommentType = type;

      $scope.newComment = { text: '' };
      if (angular.isDefined($scope.obligatoireDiscriminant[type][key].text)) {
        $scope.newComment.text = $scope.obligatoireDiscriminant[type][key].text;
      }

      commentDialog = ngDialog.open({
        template: 'addcomment.html',
        className:
          'ngdialog-theme-plain width1000 nopadding miniclose error_dialog',
        scope: $scope,
      });
    };

    $scope.saveComment = function() {
      $scope.obligatoireDiscriminant[currentCommentType][
        currentCommentKey
      ].text = $scope.newComment.text;
      commentDialog.close();
    };

    $scope.treectrl = {};
    $scope.treehandler = function(branch) {
      if ($scope.loadingBranch) return;

      if (!branch.children.length) {
        $scope.currentBranch = branch;
        $scope.loadingBranch = true;
        $scope.extraFields = branch.extraFields;

        $http
          .get(
            branch.jsonurl.indexOf('?') !== -1
              ? branch.jsonurl + '&nocas=1'
              : branch.jsonurl + '?nocas=1'
          )
          .then(function(res) {
            $scope.availableBranchData = [];
            var branchdata = res.data;

            if (
              $scope.currentBranch.type == 'DUB' ||
              $scope.currentBranch.type == 'DAU'
            ) {
            }

            // ignored elements need to be moved to their position
            for (var i in branchdata.parts) {
              var ignoreMoveTo = [];
              var sub = branchdata.parts[i];
              if (sub.dossier_extra_fields === true &&
                  angular.isDefined($scope.extraFields)) {
                $scope.extraFields.forEach(extraField => {
                  sub.data.push({
                    key: 'dossier.' + extraField.name,
                    description: extraField.alias,
                    type: getType(extraField.type)
                  });
                });
              }

              if (branchdata.parts[i].label === 'Grille de conformité') {
                console.log(branchdata.parts[i].label);
                sub.data.push(
                  {
                    description: 'Conclusion installation',
                    key: 'cdata.grille.installation.conc',
                    type: 'text',
                  },
                  {
                    description: 'Conclusion défaut de structure',
                    key: 'cdata.grille.defaut_structure.conc',
                    type: 'text',
                  },
                  {
                    description: 'Conclusion dysfonctionnement',
                    key: 'cdata.grille.dysfonctionnement.conc',
                    type: 'text',
                  },
                  {
                    description: 'Conclusion entretien usure',
                    key: 'cdata.grille.entretien_usure.conc',
                    type: 'text',
                  },
                  {
                    description: 'Avis général Kis',
                    key: 'cdata.grille.conclusion_kis',
                    type: 'text',
                  }
                );
              }

              for (var j in sub.data) {
                if (sub.data[j].type == 'ignored') {
                  sub.data[j].old_index = j;
                  ignoreMoveTo[sub.data[j].placement] = sub.data[j];
                } else {
                  // set new correct ignored part position
                  if (ignoreMoveTo[sub.data[j].key]) {
                    ignoreMoveTo[sub.data[j].key].new_index = j;
                  }
                }
              }

              // replace indexes
              if (Object.keys(ignoreMoveTo).length) {
                console.log(branchdata.parts[i]);
                for (var k in ignoreMoveTo) {
                  if (
                    ignoreMoveTo[k].placement !== 'cdata.avis_tech.surfaces'
                  ) {
                    branchdata.parts[i].data.splice(
                      ignoreMoveTo[k].old_index,
                      1
                    );
                    branchdata.parts[i].data.splice(
                      ignoreMoveTo[k].new_index,
                      0,
                      ignoreMoveTo[k]
                    );
                  } else {
                    var surfaceArray = {
                      description: 'Tableau de destinations et des surfaces',
                      key: 'kis_bac-tableau_destination_surface',
                      type: 'Tableau',
                    };
                    branchdata.parts[i].data.splice(
                      ignoreMoveTo[k].old_index,
                      1
                    );
                    branchdata.parts[i].data.splice(
                      ignoreMoveTo[k].new_index,
                      0,
                      surfaceArray
                    );
                  }
                }
              }
            }

            $scope.currentBranch.data = res.data;

            // we add a message to some items in order to inform the user that
            // he can use section markers in the templates in order to hide
            // entire blocks if the item has no value
            angular.forEach($scope.currentBranch.data.parts, function(part) {
              angular.forEach(part.data, function(item) {
                switch (item.key) {
                  case 'cdata.general.concepteur.nom':
                    item.info =
                      "Pour un affichage dynamique lors de l'impression, veuillez utiliser les signets de debut {#concepteur-debut} et fin {#concepteur-fin}";
                    break;
                  case 'cdata.general.installateur.nom':
                    item.info =
                      "Pour un affichage dynamique lors de l'impression, veuillez utiliser les signets de debut {#installateur-debut} et fin {#installateur-fin}";
                    break;
                  case 'cdata.general.bureau.nom':
                    item.info =
                      "Pour un affichage dynamique lors de l'impression, veuillez utiliser les signets de debut {#bureau-debut} et fin {#bureau-fin}";
                    break;
                  case 'cdata.info_generales.demandeur.nom':
                    item.info =
                      "Pour un affichage dynamique lors de l'impression, veuillez utiliser les signets de debut {#demandeur-debut} et fin {#demandeur-fin}";
                    break;
                }

                if (item.label === 'Branchement' || item.label === 'Boîte de branchement'
                  || item.label === "Analyse Eaux usées" || item.label === "Analyse Eaux pluviales"){
                  item.info = "Chaque $index doit être remplacé par le numéro souhaité (0,1,2) ";
                }
              });
            });

            // retrieve cfg
            if ($scope.feederMode == 'discriminant') {
              var isLoaded = false;
              if (
                angular.isDefined($scope.search) &&
                angular.isDefined($scope.search.controle) &&
                angular.isDefined($scope.search.controle.type) &&
                $scope.currentBranch.type == $scope.search.controle.type
              ) {
                isLoaded = Object.keys($scope.obligatoireDiscriminant).forEach(
                  function(obj) {
                    if (Object.keys(obj).length > 0) return true;
                  }
                );
              }
              if (!isLoaded) {
                getObligatoireDiscriminant(
                  apptype + 'FormCfg_' + $scope.currentBranch.type
                ).then(function(res) {
                  $scope.obligatoireDiscriminant = {
                    obligatoire: {},
                    discriminant: {},
                    commentaires: {},
                  };
                  if (res.data != '') $scope.obligatoireDiscriminant = res.data;
                  $scope.loadingBranch = false;
                });
              }
            } else {
              $scope.loadingBranch = false;
            }
          });
      }
      else {
        $scope.currentBranch = false;
      }
    };

    function getType(fieldType) {
      switch (fieldType) {
        case 'java.lang.Double':
        case 'java.lang.Integer': {
          return 'number';
        }
        case 'java.util.Date':
        case 'java.util.Timestamp': {
          return 'date';
        }
        case 'java.lang.Boolean': {
          return 'checkbox';
        }
        default: {
          return 'text';
        }
      }
    }

    // UGLY AF...
    $scope.shownotif = { idx: -1 };
    $scope.uglyNotif = function(txt) {
      $scope.shownotif.idx = 1;
      $scope.copiedString = txt;
      $timeout(function() {
        $scope.shownotif.idx = -1;
      }, 3000);
    };

    // permet de sauvegarder toutes les donnees accessibles pour la branche
    $scope.addToCopyList = function(label, tocopy) {
      $scope.availableBranchData.push({
        label: label,
        key: tocopy,
      });
    };
    // transforme la liste des donnees accessibles pour la branche en string utilisable directement dans un document
    $scope.getAvailableBranchDataAsText = function() {
      var txt = '';
      for (var o in $scope.availableBranchData) {
        txt +=
          $scope.availableBranchData[o].label +
          '\n' +
          $scope.availableBranchData[o].key +
          '\n\n';
      }

      return txt;
    };

    $scope.getElementToCopy = function(isElemAttr) {
      if (isElemAttr === true) {
        var txt = '';
        if ($scope.search.common === true)
          txt =
            'ef-' +
            $scope.type_ef.name +
            '-' +
            $scope.data.selectedAttribute.name;
        else
          $scope.keyToShow.forEach(function(l) {
            txt += l.label + '\n';
          });
      }
      if (txt.length < 100) $scope.uglyNotif(txt);
      else $scope.uglyNotif('\u2713');

      return txt;
    };

    /**
     * saveObligatoireDiscriminant
     * @returns {HttpPromise}
     */
    $scope.saveObligatoireDiscriminant = function() {
      var name;
      if (
        $scope.feederMode == 'discriminant' &&
        $scope.currentBranch.type == 'elements_filiere_commentaire'
      )
        name = apptype + 'FormCfg_' + $scope.search.controle.type;
      else name = apptype + 'FormCfg_' + $scope.currentBranch.type;

      var url =
          '/services/' +
          portalId +
          '/config/' +
          appname +
          '/add?f=json&type=main&name=' +
          name +
          '&nocas=1&token=' +
          encodeURIComponent(token),
        promise = $http.post(url, $scope.obligatoireDiscriminant);

      promise.then(function() {
        $scope.uglyNotif('Configuration Enregistrée');
      });

      return promise;
    };

    $scope.resetObligatoireDiscriminant = function() {
      var ans = confirm(
        'Etes-vous certain de vouloire réinitialiser la configuration ?'
      );
      if (ans) {
        var name = apptype + 'FormCfg_' + $scope.currentBranch.type;

        var url =
            '/services/' +
            portalId +
            '/config/' +
            appname +
            '/remove?f=json&type=main&name=' +
            name +
            '&nocas=1&token=' +
            encodeURIComponent(token),
          promise = $http.get(url);

        promise.then(function() {
          $scope.obligatoireDiscriminant = {
            obligatoire: {},
            discriminant: {},
            commentaires: {},
          };
        });

        return promise;
      }
    };

    /**
     * saveObligatoireDiscriminant
     * @returns {HttpPromise}
     */
    var getObligatoireDiscriminant = function(name) {
      var url =
        '/services/' +
        portalId +
        '/config/' +
        appname +
        '/get?f=json' +
        '&type=main&name=' +
        name +
        '&nocas=1&token=' +
        encodeURIComponent(token);
      var promise = $http.get(url);
      return promise;
    };

    /**
     * Supprime le cdata pour l'affichage
     * @return "string"
     */
    $scope.stripCDATA = function(item) {
      if (item.substring(0, 6) === 'cdata.') {
        var stripedData = item.substring(6, item.length);
        return stripedData;
      }
      return item;
    };

    $scope.closePanelDiag = function() {
      if (getCommentItemDialog){
        getCommentItem.close();
      }
      $timeout(function() {
        delete $scope.attribute;
        delete $scope.element;
      });
    };

    /**
     * Ouvre et récupère les commentaires de l'objet
     */
    $scope.hasValue = function(item) {
      var has = false;
      if ($scope.currentBranch.type == 'elements_filiere_commentaire') {
        if (
          checkNestedProperty(
            'commentaires.' + [$scope.search.element.name] + '.' + [item.name],
            $scope.obligatoireDiscriminant
          ) &&
          $scope.obligatoireDiscriminant.commentaires[
            $scope.search.element.name
          ][item.name].length > 0
        )
          has = true;
      } else if (angular.isDefined($scope.obligatoireDiscriminant)) {
        if (
          angular.isDefined(
            $scope.obligatoireDiscriminant.commentaires[item.key]
          ) &&
          $scope.obligatoireDiscriminant.commentaires[item.key].length > 0
        )
          has = true;
      }
      return has;
    };
    let getCommentItemDialog;
    /**
     * Ouvre et récupère les commentaires de l'objet
     */
    $scope.getCommentItem = function(item, element) {
      if (angular.isDefined(element)) {
        if (
          angular.isUndefined(
            $scope.obligatoireDiscriminant.commentaires[element.name]
          )
        )
          $scope.obligatoireDiscriminant.commentaires[element.name] = {};
        if (
          angular.isUndefined(
            $scope.obligatoireDiscriminant.commentaires[element.name][item.name]
          )
        )
          $scope.obligatoireDiscriminant.commentaires[element.name][
            item.name
          ] = [];

        $scope.currentCommentItem =
          $scope.obligatoireDiscriminant.commentaires[element.name][item.name];
        $scope.attribute = item;
        $scope.element = element;
        $scope.elementIsEdited = true;
      }
      else {
        $scope.currentCommentItem = item;
        $scope.elementIsEdited = false;
      }
      getCommentItemDialog = ngDialog.open({
        template: 'getvalues.html',
        className: 'ngdialog-theme-plain width800',
        scope: $scope,
      });
    };

    let valueDialog;
    /**
     * Ouvre une fênetre d'ajout de commentaire
     */
    $scope.addCommentItem = function() {
      $scope.newComment = '';
      valueDialog = ngDialog.open({
        template: 'addvalues.html',
        className: 'ngdialog-theme-plain width800',
        scope: $scope,
      });
    };

    /**
     * Pré enregistre le commentaire
     */
    $scope.preSaveCurrentCommentItem = function(newComment, key) {
      if ($scope.elementIsEdited) {
        delete $scope.currentCommentItem;
        $scope.obligatoireDiscriminant.commentaires[$scope.element.name][
          $scope.attribute.name
        ].push(newComment);
        $scope.currentCommentItem =
          $scope.obligatoireDiscriminant.commentaires[$scope.element.name][
            $scope.attribute.name
          ];
      } else {
        if (angular.isUndefined($scope.obligatoireDiscriminant)) {
          $scope.obligatoireDiscriminant = { commentaires: {} };
        }
        if (
          !angular.isDefined($scope.obligatoireDiscriminant.commentaires[key])
        ) {
          $scope.obligatoireDiscriminant.commentaires[key] = [];
          $scope.obligatoireDiscriminant.commentaires[key].push(newComment);
        } else {
          $scope.obligatoireDiscriminant.commentaires[key].push(newComment);
        }
      }
      if(valueDialog){
        valueDialog.close();
      }
    };

    /**
     * Supprime le commentaire ciblé
     */
    $scope.deleteCommentItem = function(index, key) {
      if ($scope.obligatoireDiscriminant.commentaires[key].length === 1) {
        delete $scope.obligatoireDiscriminant.commentaires[key];
      } else {
        $scope.obligatoireDiscriminant.commentaires[key].splice(index, 1);
      }
    };

    /**
     * Ouvre une fenêtre d'édition du commentaire
     */
    $scope.editCommentItem = function(item, index) {
      $scope.editedIndex = index;
      $scope.editedComment = item;

      valueDialog = ngDialog.open({
        template: 'editvalues.html',
        className: 'ngdialog-theme-plain',
        scope: $scope,
      });
    };

    /**
     * Pre-sauvegarder le commentaire édité
     */
    $scope.saveEditedComment = function(text, editedKey) {
      if ($scope.currentBranch.type == 'elements_filiere_commentaire')
        $scope.obligatoireDiscriminant.commentaires[$scope.element.name][
          $scope.attribute.name
        ][$scope.editedIndex] = text;
      else
        $scope.obligatoireDiscriminant.commentaires[editedKey][
          $scope.editedIndex
        ] = text;

      valueDialog.close();
    };

    $scope.tree = angular.copy(feederCfg.branches);

    $timeout(function() {
      $scope.treectrl.collapse_all();
    }, 0);
  }
]);
