'use strict';
define(function() {
  var userPicker = function(
    ngDialog,
    UsersFactory,
    $rootScope
  ) {
    return {
      templateUrl: 'js/XG/modules/common/views/directives/userPicker.html',
      scope: {
        res: '=',
        type: '=?', //checkbox pour partager url avec les utilisateurs
        titre: '=?',
        roles: '=?', // restreindre le choix aux roles spécifiés,
        disabled: '=?',
        initUser: '=?', // si login fourni, retourne l'utilisateur complet
        useragent: '=?',
        alternativeTitle: '=?',
      },
      restrict: 'EA',
      link: function(scope) {

        if (!scope.titre) {
          scope.titre = 'Choisir';
        }
        scope.select = {};

        var userSelectPickerDialog;
        scope.openDialogUsers = function() {
          scope.select = {};
          scope.select_users = {};
          $rootScope.$broadcast('userFromDialog', true);

          UsersFactory.getactiveuserslight().then(function(res) {
            var gusers = res.data;
            // tri si role specifié
            if (angular.isDefined(scope.roles)) {
              scope.users = gusers.filter(function(u) {
                return scope.roles.filter(function(n) {
                  return (
                    u.roles
                      .map(function(g) {
                        return g.name;
                      })
                      .indexOf(n) !== -1
                  );
                }).length;
              });
              console.log(scope.users);
            } else {
              scope.users = gusers;
            }
          });

          userSelectPickerDialog = ngDialog.open({
            template:
              'js/XG/modules/common/views/directives/user_picker_dialog.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        scope.selectUser = function() {
          scope.res = angular.copy(scope.select.user);
          userSelectPickerDialog.close();
        };

        scope.select_users = {};
        scope.partager = function() {
          var res = [];
          Object.keys(scope.select_users).forEach(function(key) {
            if (scope.select_users[key] == true) {
              scope.users.forEach(function(user) {
                if (user.login == key) {
                  res.push(user);
                }
              });
            }
          });
          scope.res = res;
          userSelectPickerDialog.close();
        };

        scope.render_select_users = function() {
          var value = false;
          Object.keys(scope.select_users).forEach(function(key) {
            if (scope.select_users[key] == true) {
              value = true;
            }
          });
          return value;
        };

        scope.unlinkUser = function() {
          for (var i in scope.res) {
            scope.res[i] = '';
          }
        };

        var initUser = function() {
          UsersFactory.getactiveuserslight().then(function(res) {
            res.data.forEach(function(u) {
              if (u.login === scope.initUser) scope.res = u;
            });
          });
        };

        if (angular.isDefined(scope.initUser)) initUser();
      },
    };
  };

  userPicker.$inject = [
    'ngDialog',
    'UsersFactory',
    '$rootScope',
  ];
  return userPicker;
});
