'use strict';
define(function() {
  /**
   * Permet d'uncheck un bouton radio
   * uncheckableRadio
   * @param $timeout
   * @returns {{restrict: string, require: string, link: link}}
   */
  var uncheckableRadio = function($timeout) {
    return {
      restrict: 'A',
      require: 'ngModel',
      link: function(scope, elt, attrs, ngModel) {
        var wasChecked;

        elt.bind('mouseup', function() {
          wasChecked = elt.prop('checked');
        });

        elt.bind('click', function() {
          // radio deja checked
          if (wasChecked) {
            $timeout(function() {
              elt.prop('checked', false);
              ngModel.$setViewValue(undefined);
            }, 0);
          }
        });
      },
    };
  };

  uncheckableRadio.$inject = ['$timeout'];
  return uncheckableRadio;
});
