'use strict';
define(function() {
  var positionFeature = function(
    ngDialog,
    $rootScope,
    FeatureTypeFactory,
    ogcFactory,
    gcWMS,
    PortalsFactory
  ) {
    return {
      templateUrl:
        'js/XG/modules/common/views/directives/position_feature.html',
      scope: {
        ftid: '=',
        fid: '=?',
        bbox: '=?',
        displayLayers: '=?', // array of fti to display
        positionImage: '=?',
        zoom: '=?', //
        displayFeaturesConfig: '=?', // used with features-config  directive
        tooltip: '=?', //used with ancBacMainReport
      },
      restrict: 'E',
      link: function(scope, element, attr) {
        var CenterOfGeom;
        var portalid = PortalsFactory.getPortalId(),
          map,
          dialogPositionFeature;

        // commentaire
        scope.openFeatureMap = function() {
          dialogPositionFeature = ngDialog.open({
            template:
              'js/XG/modules/common/views/directives/position_feature_dialog.html',
            className: 'ngdialog-theme-plain fullScreen nopadding',
            closeByDocument: false,
            showClose: true,
            scope: scope,
          });
        };

        //Listen After open ng-dialog
        $rootScope.$on('ngDialog.opened', function(e, $dialog) {
          if (
            angular.isUndefined(dialogPositionFeature) ||
            angular.isUndefined(dialogPositionFeature.id) ||
            dialogPositionFeature.id != $dialog[0].id
          ) {
            return false;
          }

          map = new ol.Map({
            layers: [
              new ol.layer.Tile({
                source: new ol.source.OSM(),
              }),
            ],
            target: 'map_position_feature',
            controls: ol.control.defaults({
              attributionOptions: {
                collapsible: false,
              },
            }),
            view: new ol.View({
              projection: 'EPSG:3857',
              center: [0, 0],
              minResolution: 0.03732276771737122,
              zoom: 10,
            }),
          });
          scope.currentMap = map;

          if (angular.isDefined(scope.displayLayers)) {
            scope.displayLayers.forEach(function(f) {
              var l = gcWMS.getOlLayerFromFeaturetypeInfo(f);
              map.addLayer(l);
            });
          }

          var cql_filter = '1=1';
          if (scope.fid.length == 0) {
            cql_filter = '1=2';
          } else if (scope.fid.length > 0) {
            cql_filter = "IN('" + scope.fid.join("','") + "')";
          }

          // afficher la feature et la zoomer
          var setExtent = function() {
            if (angular.isUndefined(scope.fid) || scope.fid.length == 0) {
              FeatureTypeFactory.getExtent(scope.ftid, 'EPSG:3857').then(
                function(res) {
                  map.getView().fit(res.data, map.getSize());
                  affichePositionImage();
                }
              );
            } else {
              //recuperer une feature par fid et ftid
              var promise = ogcFactory.getfeatures(
                'GetFeature',
                'WFS',
                '1.0.0',
                scope.ftid,
                'json',
                'EPSG:3857',
                cql_filter
              );
              promise.then(function(res) {
                //creer une nouvelle source pour cette feature
                var vectorSource = new ol.source.Vector({});
                var parser = new ol.format.GeoJSON();
                for (var i = 0; i < res.data.features.length; i++) {
                  vectorSource.addFeature(
                    parser.readFeature(res.data.features[i])
                  );
                }
                //RECUPERER L'EXTENT DE LA SOURCE
                map.getView().fit(vectorSource.getExtent(), map.getSize());
                affichePositionImage();
                if (scope.zoom) {
                  map.getView().setZoom(parseInt(scope.zoom));
                }
              });
            }
          };

          var affichePositionImage = function() {
            CenterOfGeom = map.getView().getCenter();
            var iconFeature = new ol.Feature({
              geometry: new ol.geom.Point(CenterOfGeom),
            });

            if (scope.positionImage) {
              var iconStyle = new ol.style.Style({
                image: new ol.style.Icon({
                  src: scope.positionImage,
                }),
              });
              iconFeature.setStyle(iconStyle);
            }

            var positionVectorLayer = new ol.layer.Vector({
              source: new ol.source.Vector({
                features: [iconFeature],
              }),
            });
            map.addLayer(positionVectorLayer);
          };

          //Si la bbox existe
          if (angular.isDefined(scope.bbox)) {
            map.getView().fit(scope.bbox, map.getSize());
            affichePositionImage();
          } else {
            //bbox n'eat pas existe
            setExtent();
          }

          //afficher la feature
          var afficherFeature = function() {
            FeatureTypeFactory.get().then(function(res) {
              // adapte aux modification de FeatureFactory.get (doit utiliser res et non plus res.data)
              for (var i = 0; i < res.length; i++) {
                if (res[i].uid === scope.ftid) {
                  map.addLayer(
                    new ol.layer.Tile({
                      source: new ol.source.TileWMS({
                        url:
                          '/services/' +
                          portalid +
                          '/geoserver/wms?token=' +
                          localStorage.auth_token,
                        params: {
                          LAYERS: portalid + ':' + res[i].name,
                          TILED: true,
                          CQL_FILTER: cql_filter,
                        },
                        serverType: 'geoserver',
                      }),
                    })
                  );
                }
              }
            });
          };
          afficherFeature();
        });
      },
    };
  };

  positionFeature.$inject = [
    'ngDialog',
    '$rootScope',
    'FeatureTypeFactory',
    'ogcFactory',
    'gcWMS',
    'PortalsFactory',
  ];
  return positionFeature;
});
