'use strict';
define(function() {
  var imageLibraryPicker = function(
    StyleFactory,
    ngDialog,
    gaDomUtils,
    $filter,
    $timeout
  ) {
    return {
      templateUrl:
        'js/XG/modules/common/views/directives/image_library_picker.html',
      scope: {
        imagePicked: '&?', // function called when an image is selected
        imageSelected: '=?', // already selected image
      },
      restrict: 'E',
      controller: [
        '$scope',
        function($scope) {
          $scope.imageTreeControl = {};
        },
      ],
      link: function(scope, element, attr) {
        /**
         * initial selection
         */
        if (scope.imageSelected) {
          var image = scope.imageSelected.split('/');
          scope.currentImg = image[image.length - 1];
        }

        scope.pickimages = [];
        scope.setImage = function(img) {
          // En session de suppression, la sélection d'une image coche la checkbox
          if (scope.isDeletingPortalImage) {
            if (!scope.portalImagesToDelete[img]) {
              scope.portalImagesToDelete[img] = true;
            } else {
              scope.portalImagesToDelete[img] = false;
            }
          } else {
            scope.currentImg = img; // used for css selected
            scope.imagePicked({
              data: {
                img: img,
                url: scope.pick.url,
              },
            });
          }
        };

        /**
         * Choosing an image folder
         * @param branch
         */
        scope.tree_handler = function(branch) {
          // display children images when parent is selected
          if (branch.mainfolder && !branch.images && branch.children) {
            branch.images = [];

            branch.children.forEach(function(sub) {
              if (sub.images) {
                sub.images.forEach(function(image) {
                  branch.images.push(sub.path + image);
                });
              }
            });
          }

          scope.pick = {
            images: branch.images,
            folder: branch.label,
            path: branch.path,
            url: branch.url,
            type: branch.type,
          };
        };

        /**
         * Retrieve images list
         */
        var refreshSymbolImages = function() {
          return StyleFactory.getsymbolsimages().then(function(res) {
            var folders = [];

            if (angular.isDefined(res.data.portal[0])) {
              res.data.portal[0].label = $filter('translate')(
                'model.styles.editor.symbolizers.common.portal_images'
              );
              folders.push(res.data.portal[0]);

              res.data.common[0].label = $filter('translate')(
                'model.styles.editor.symbolizers.common.common_images'
              );
              folders.push(res.data.common[0]);
            }

            scope.imgfolders = folders;

            $timeout(function() {
              if (scope.imageTreeControl.collapse_all != undefined) {
                scope.imageTreeControl.collapse_all();
                var communes = folders[1];
                scope.imageTreeControl.expand_branch(communes);
              }
            }, 0);

            /**
             * initial selection
             */
            if (scope.imageSelected) {
              var path = scope.imageSelected.split('/');
              var start = false;
              var new_path = [];
              for (var i = 0; i < path.length; i++) {
                if (start == true) {
                  new_path.push(path[i]);
                }
                if (path[i] == 'kis') {
                  start = true;
                }
              }
              scope.imgfolders.forEach(function(folder) {
                if (folder.children.length == 0 && new_path[0] != 'common') {
                  openBranch(folder);
                } else {
                  folder.children.forEach(function(child) {
                    if (new_path[2] == child.label) {
                      if (child.children.length == 0 || new_path.length == 4) {
                        openBranch(child);
                      } else {
                        child.children.forEach(function(c) {
                          if (new_path[3] == c.label) {
                            openBranch(c);
                          }
                        });
                      }
                    }
                  });
                }
              });
            }
          });
        };
        refreshSymbolImages();

        /**
         * open branch of tree
         * @param branch
         */
        var openBranch = function(branch) {
          $timeout(function() {
            scope.imageTreeControl.select_branch(branch);
          }, 0);
        };

        /** Upload File **/
        scope.uploadNewPortalImage = function(input) {

          // Ferme la session de suppression si elle était ouverte
          scope.stopPortalImagesDeletingSelection();

          scope.currentUploadFolder = scope.pick;

          // Méthode interne exécutée après vérifications: isFormatValid, imageNameAlreadyPresent, imageNameHasComma
          const processUpload = () => {
            gaDomUtils.showGlobalLoader();
            scope.staticFile = input.files[0];
            var fd = new FormData();
            fd.append('file', scope.staticFile);

            StyleFactory.uploadnewimage(fd, scope.currentUploadFolder.path).then(
                function(data) {
                  refreshSymbolImages().then(function() {
                    gaDomUtils.hideGlobalLoader();
                    scope.pick = false;
                  });
                },
                err => {
                  gaDomUtils.hideGlobalLoader();
                  scope.pick = false;
                  console.error(err.data);
                }
            );
          };
          // Méthode interne exécutée quand isFormatNotValid ou imageNameHasComma
          const alertImportError = (translationKey, additionalText) => {
            swal({
              title: $filter('translate')(
                  'model.styles.editor.symbolizers.common.' + translationKey + 'Title')
              + additionalText ? additionalText : '',
              text: $filter('translate')('model.styles.editor.symbolizers.common.' + translationKey + 'Text'),
              type: 'error',
              showCancelButton: false,
              confirmButtonColor: '#CCC',
              confirmButtonText: $filter('translate')('common.ok'),
              closeOnConfirm: true,
            });
          };

          const importingFileName = input.files[0].name;

          // Le fichier importé doit être un png ou un svg
          const isFormatNotValid = !importingFileName.endsWith('png') && !importingFileName.endsWith('svg');

          // L'import doit détecter si le fichier importé existe déjà parmis les images de portail disponibles
          const imageNameAlreadyPresent = scope.imgfolders.find(
              grp => grp.type === 'portal').images.some(
              img => img.toLowerCase() === importingFileName.toLowerCase());

          // Le nom du fichier ne doit pas contenir de virgule (la virgule est réservée en caractère séparateur pour la suppression)
          const imageNameHasComma = importingFileName.includes(',');

          if (isFormatNotValid) {
            alertImportError('badFormat', importingFileName);
            return;
          }
          if (imageNameHasComma) {
            alertImportError('badFileName', importingFileName);
            return;
          }
          if (imageNameAlreadyPresent) {
            scope.importingFileName = importingFileName;
            const confirm = ngDialog.openConfirm({
              template: 'js/XG/widgets/mapapp/style/views/modals/modal.uploadimage.confirm.html',
              className: 'ngdialog-theme-plain width600 nopadding miniclose',
              scope: scope,
            });
            confirm.then(
                (data) => {
                  if (data) {
                    processUpload();
                  }
                },
                () => {
                }
            ).finally(
                () => {
                  scope.importingFileName = null;
                }
            );
          } else {
            processUpload();
          }
        };

        /**
         * Au clic sur le bouton "Supprimer" de l'encart des images de portail.
         * Démarre une "session de suppression": les boutons d'action et les checkboxes apparaissent
         */
        scope.startPortalImagesDeletingSelection = () => {
          scope.portalImagesToDelete = {};  // Stockage des noms d'images de portail à supprimer
          scope.isDeletingPortalImage = true; // Affichage des boutons et checkboxes
        };

        /**
         * Au clic sur le bouton "Annuler" (croix) la session de suppression des images de portail.
         * Annule la "session de suppression": les boutons d'action et les checkboxes disparaissent
         */
        scope.stopPortalImagesDeletingSelection = () => {
          scope.portalImagesToDelete = {};
          scope.isDeletingPortalImage = false;
        };

        /**
         * Au clic sur le bouton de confirmation rouge "Supprimer" (poubelle).
         * Exécute la suppression des images, ferme la session de suppression
         * et rafraîchit la liste des images de portail
         */
        scope.portalImagesConfirmDelete = () => {
          const toDeleteFileNames = Object.entries(scope.portalImagesToDelete)
          .filter(([key, value]) => value === true)
          .map(([key, value]) => key);
          if (toDeleteFileNames.length > 0) {
            StyleFactory.deletePortalImageFiles(toDeleteFileNames.join(',')).then(
                res => {
                  if (res.data) {
                    // gestion des images non supprimées
                    if (res.data.hasOwnProperty('fails') && Array.isArray(res.data.fails)
                        && res.data.fails.length > 0) {
                      require('toastr').warning($filter('translate')('model.styles.editor.symbolizers.common.deleteNotComplete'));
                    }
                    // gestion des erreurs de lecture de fichier sld
                    if (res.data.hasOwnProperty('errors') && Array.isArray(res.data.errors)
                        && res.data.errors.length > 0) {
                      console.error('portalImagesConfirmDelete : ', res.data.errors.join(', '));
                    }
                    // gestion des images supprimées
                    if (res.data.hasOwnProperty('deleted') && Array.isArray(res.data.deleted)
                        && res.data.deleted.length > 0) {

                      // supprime les images du front
                      const portalGrp = scope.imgfolders.find(grp => grp.type === 'portal');
                      portalGrp.images = portalGrp.images.filter(img => !res.data.deleted.includes(img));
                      // Sélectionne le groupe des images du portail
                      scope.tree_handler(portalGrp);
                    }
                    scope.isDeletingPortalImage = false;
                  } else {
                    require('toastr').error($filter('translate')('model.styles.editor.symbolizers.common.serverError'));
                    scope.isDeletingPortalImage = false;
                  }
                },
                err => {
                  require('toastr').error($filter('translate')('model.styles.editor.symbolizers.common.serverError'));
                  console.error("portalImagesConfirmDelete error : ", err.data);
                  scope.isDeletingPortalImage = false;
                }
            );
          } else {
            scope.isDeletingPortalImage = false;
          }
        };
      },
    };
  };

  imageLibraryPicker.$inject = [
    'StyleFactory',
    'ngDialog',
    'gaDomUtils',
    '$filter',
    '$timeout'
  ];
  return imageLibraryPicker;
});
