'use strict';
define(function() {
  /**
   *
   */
  var executequery = function(
    QueryFactory,
    gaDomUtils,
    SelectManager,
    panelsManager,
    FeatureTypeFactory,
    AlertHpoFactory,
    $filter,
    ngDialog,
    DataStoreFactory,
    sldUtils,
    $timeout,
    $rootScope,
    extendedNgDialog,
    ngTableParams
  ) {
    return {
      templateUrl: 'js/XG/modules/common/views/directives/executeQuery.html',
      restrict: 'EA',
      scope: {
        fti: '=?',
        res: '=?',
      },
      link: function(scope) {
        scope.dbselector = {};
        scope.exect = {
          analysistool: 'allanalysis',
          result: [],
          geoj: {},
          requet: '',
          attributestouseindatatable: [],
          exportCSV: '',
        };

        $timeout(function() {
          scope.codeEditor = CodeMirror.fromTextArea(
            document.getElementById('code'),
            {
              mode: 'sql',
              indentWithTabs: true,
              smartIndent: true,
              lineNumbers: true,
              matchBrackets: true,
              autofocus: true,
              extraKeys: {
                'Ctrl-Space': 'autocomplete',
              },
              onChange: function() {
                scope.codeEditor.save();
              },
            }
          );
          scope.codeEditor.setSize('100%', '100%');
        }, 0);

        scope.saveCFG = function() {
          if (scope.codeEditor != undefined) {
            scope.codeEditor.setValue(scope.exect.requet);
            scope.codeEditor.on('change', function(cMirror) {
              scope.exect.requet = cMirror.getValue();
            });
          }
        };

        scope.loadDataStores = function() {
          DataStoreFactory.get().then(function(res) {
            if (res.data.length != 0) {
              scope.datasources = res.data;
              if (res.data.length == 1)
                scope.dbselector.choice = res.data[0].name;
              // else
              // scope.dbselector.choice = "";
            }
          });
        };
        scope.loadDataStores();
        scope.listFich = function() {
          scope.isroot = $rootScope.xgos.isroot;
          gaDomUtils.showGlobalLoader();
          var promise = QueryFactory.listFichSQL();
          promise.then(
            function(res) {
              scope.listTitreNomfile = res.data;
              scope.exect.requet = '';
              scope.saveCFG();
              if (Object.getOwnPropertyNames(res.data).length > 0) {
                scope.autocompleteglobalsearch = Object.keys(
                  scope.listTitreNomfile
                );
                scope.autocompleteglobalsearchinclude = [];
                res.data = Object.keys(res.data);
                var used;
                res.data.map(function(x) {
                  scope.obj = {
                    name: x,
                  };
                  if (used && used.indexOf(x) !== -1) scope.obj.selected = true;
                  scope.autocompleteglobalsearchinclude.push(scope.obj);
                });
              } else {
                scope.autocompleteglobalsearch = [];
                scope.autocompleteglobalsearchinclude = [];
              }
              gaDomUtils.hideGlobalLoader();
            },
            function(res) {
              scope.autocompleteglobalsearch = [];
              console.error(res);
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        scope.listFich();

        scope.exect.requet = null;

        scope.affichQuery = function(data, ds) {
          scope.ftisRequete = [];
          scope.operateurs = [];
          scope.exect = {};
          scope.feat = {};

          if (data != 'res.newValue') {
            data = scope.listTitreNomfile[data];
            scope.exect.exportCSV = data;
            gaDomUtils.showGlobalLoader();
            var promise = QueryFactory.afficherequet(data, ds);
            promise.then(
              function(res) {
                scope.exect.requet = res.data.requete;
                scope.exect.params = res.data.params;
                scope.exect.fieldsJson = res.data.fieldsJson;
                if (
                  scope.exect.params != undefined &&
                  scope.exect.params !== '' &&
                  scope.exect.params.length != 0
                ) {
                  for (var i in scope.exect.params) {
                    var tableName = scope.exect.params[i].table;
                    var parameName = scope.exect.params[i].attribut;
                    var operande = scope.exect.params[i].operande;
                    if (
                      !scope.ftisRequete[tableName] ||
                      tableName === 'kis_anc_dossier_controle_reponse'
                    ) {
                      if (tableName === 'kis_anc_dossier_controle_reponse') {
                        var fti = res.data.fakeFti;
                        for (var j in fti.attributes) {
                          if (fti.attributes[j].name === parameName) {
                            scope.exect.params[i].alias =
                              fti.attributes[j].alias;
                          }
                        }
                      } else {
                        var fti = FeatureTypeFactory.getFeatureByNameAndDatastore(
                          ds,
                          tableName
                        );
                      }
                      if (fti != false) {
                        scope.ftisRequete[tableName] = fti;
                        scope.operateurs[
                          tableName + parameName
                        ] = scope.listOperateursByAttributType(fti, parameName);
                        scope.saveCFG();
                        gaDomUtils.hideGlobalLoader();
                      } else {
                        AlertHpoFactory.alertConfirmCallback(
                          $filter('translate')('executQuery.alert.error'),
                          $filter('translate')(
                            'executQuery.alert.ftipasValide'
                          ),
                          'warning',
                          true,
                          'ok',
                          '#F50072',
                          false,
                          undefined,
                          undefined,
                          true,
                          false,
                          null
                        );
                        gaDomUtils.hideGlobalLoader();
                        scope.exect.params = '';
                        scope.exect.requet = '';
                        scope.saveCFG();
                        break;
                      }
                    } else {
                      scope.operateurs[
                        tableName + parameName
                      ] = scope.listOperateursByAttributType(
                        scope.ftisRequete[tableName],
                        parameName
                      );
                      scope.saveCFG();
                      gaDomUtils.hideGlobalLoader();
                    }
                  }
                } else {
                  AlertHpoFactory.alertConfirmCallback(
                    $filter('translate')('executQuery.alert.warning'),
                    $filter('translate')('executQuery.alert.paramvide'),
                    'warning',
                    true,
                    'ok',
                    '#F50072',
                    false,
                    undefined,
                    undefined,
                    true,
                    false,
                    null
                  );

                  scope.saveCFG();
                  gaDomUtils.hideGlobalLoader();
                }
              },
              function(res) {
                AlertHpoFactory.showErrorMessage(res);
                gaDomUtils.hideGlobalLoader();
              }
            );
          } else {
            scope.exect.requet = '';
            scope.saveCFG();
          }
        };

        scope.MAJFichSQL = function(nomFich, data) {
          var callback = function(confirmed) {
            if (confirmed) {
              gaDomUtils.showGlobalLoader();
              var promise = QueryFactory.MAJFichSQL(nomFich, data);
              promise.then(function(res) {
                AlertHpoFactory.getSimpleSuccess(
                  $filter('translate')('executQuery.alert.succes'),
                  $filter('translate')('executQuery.alert.valider'),
                  false
                );
                gaDomUtils.hideGlobalLoader();
              });
            }
          };
          AlertHpoFactory.alertConfirmCallback(
            $filter('translate')('executQuery.alert.warning'),
            $filter('translate')('executQuery.alert.mettreajour'),
            'warning',
            true,
            undefined,
            '#F50072',
            true,
            undefined,
            undefined,
            true,
            true,
            callback
          );
        };
        scope.queryname = undefined;
        scope.ngDialogPromise;
        scope.saveFichSQLHtml =
          'js/XG/modules/common/views/directives/saveFichSQL.html';

        scope.createFichSQL = function(query, ds) {
          if (query.trim() == '') {
            AlertHpoFactory.getSimpleFail(
              $filter('translate')('executQuery.alert.warning'),
              $filter('translate')('executQuery.alert.erreur'),
              true
            );
          } else {
            scope.ngDialogPromise = ngDialog.openConfirm({
              template: scope.saveFichSQLHtml,
              scope: scope,
              className: 'ngdialog-theme-plain width600 nopadding miniclose',
            });
            var callback = function(confirmed) {
              scope.createFichSQL(query, ds);
            };

            scope.ngDialogPromise.then(function(data) {
              if (
                scope.autocompleteglobalsearch != null &&
                scope.autocompleteglobalsearch.includes(data)
              ) {
                AlertHpoFactory.alertConfirmCallback(
                  $filter('translate')('executQuery.alert.error'),
                  $filter('translate')('executQuery.alert.existe'),
                  'warning',
                  true,
                  'ok',
                  '#F50072',
                  false,
                  undefined,
                  undefined,
                  true,
                  false,
                  callback
                );

                // require('toastr').error($filter('translate')('executQuery.alert.existe'));
              } else {
                gaDomUtils.showGlobalLoader();
                var promise = QueryFactory.createFichSQL(data, query);
                promise.then(
                  function(res) {
                    scope.listFich(ds);
                    AlertHpoFactory.getSimpleSuccess(
                      $filter('translate')('executQuery.alert.succes'),
                      $filter('translate')('executQuery.alert.valider'),
                      false
                    );
                    gaDomUtils.hideGlobalLoader();
                    scope.res.newValue = false;
                    scope.res.value = data;
                    scope.listTitreNomfile[data] = res.data;
                    scope.affichQuery(data, ds);
                  },
                  function(res) {
                    AlertHpoFactory.showErrorMessage(res);
                    gaDomUtils.hideGlobalLoader();
                  }
                );
              }
            });
          }
        };

        scope.$watch('res.value', function() {
          if (scope.res != undefined) {
            if (document.getElementsByName('newValue')['0'].selected) {
              scope.res.newValue = true;
            } else {
              scope.res.newValue = false;
            }
          }
        });

        scope.monresult = {};

        scope.test = false;
        scope.executeFich = function(data, ds) {
          var exect = angular.copy(scope.exect);
          gaDomUtils.showGlobalLoader();
          console.log(data);
          var promise = QueryFactory.executFichSQL(ds, exect);
          promise.then(
            function(res) {
              gaDomUtils.hideGlobalLoader();
              console.log(res.data != undefined);
              if (res.data != undefined) {
                var tmp = angular.copy(res.data);
                delete tmp.tablename;
                scope.exect.result = tmp;
                scope.fti = scope.exect.result.featureTypeInfo;
                scope.exect.attributestouseindatatable =
                  scope.exect.result.featureTypeInfo.attributes;
                SelectManager.addFeaturesFromGeojson(scope.exect.result);

                scope.feat = SelectManager.getFeatures();
                console.log(scope.exect.result);
                if ($rootScope.xgos && $rootScope.xgos.sector === 'map') {
                  scope.test = false;
                  if (scope.feat.totalFeatures > 0) {
                    scope.vopenTabPanels();
                    gaDomUtils.hideGlobalLoader();
                  }
                } else if (
                  $rootScope.xgos &&
                  $rootScope.xgos.sector === 'anc'
                ) {
                  console.log('OK !');

                  $rootScope.$broadcast('testTestResultTable', {
                    resultData: scope.exect,
                  });
                } else {
                  scope.test = true;
                }
              }
            },
            function(res) {
              AlertHpoFactory.showErrorMessage(res);
              gaDomUtils.hideGlobalLoader();
            }
          );
        };

        scope.show_selected = function() {
          var selector = document.getElementById('id_of_select');
          var value = selector[selector.selectedIndex].innerHTML;
          if (value === 'exists' || value === 'notexists') {
            $scope.buttonDisabled = false;
          } else {
            $scope.buttonDisabled = true;
          }
        };

        scope.layerdatatable = {};
        scope.vopenTabPanels = function() {
          scope.geoj = SelectManager.getFeaturesByftiType(scope.fti.name);
          scope.layerdatatable.height = 320;
          scope.closepanel();
          panelsManager.addPanel({
            id: 'selecttab',
            stickToRight: true,
            templateUrl:
              'js/XG/modules/common/views/directives/popexectDatatable.html',
            scope: scope,
            stickToBorder: true,
            visible: true,
            resizable: true,
          });
        };
        scope.closepanel = function() {
          panelsManager.removePanel('selecttab');
        };

        scope.opengraph = function() {
          console.log(scope.result);
          extendedNgDialog.open({
            template:
              'js/XG/widgets/mapapp/layerManager/views/charts/SelectedCharts.html',
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            draggable: true,
            title: $filter('translate')('layermanager.charts'),
          });
        };
        scope.getMap = function(aScope) {
          if (aScope == null) return undefined;
          if (aScope.map != undefined) return aScope.map;
          else return scope.getMap(aScope.$parent);
        };
        scope.map = scope.getMap(scope);

        scope.checkData = function(v) {
          var b = false;
          if (v instanceof Array) {
            if (b.length === 0) b = true;
          } else {
            if (Object.keys(v).length === 0) b = true;
          }
          return b;
        };
        scope.listOperateursByAttributType = function(fti, attributName) {
          var attributType = '';

          for (var ind = 0; ind < fti.attributes.length; ind++) {
            if (fti.attributes[ind].name == attributName) {
              attributType = fti.attributes[ind].type;

              if (attributType !== '') {
                switch (attributType) {
                  case 'text':
                    fti.attributes[ind].type = 'java.lang.String';
                    break;
                  case 'date':
                    fti.attributes[ind].type = 'java.sql.Timestamp';
                    break;
                  case 'number':
                    fti.attributes[ind].type = 'java.lang.Integer';
                    break;
                  case 'checkbox':
                  case 'radio':
                    fti.attributes[ind].type = 'java.lang.Boolean';
                    break;
                }
              }
            }
          }

          var operandsList = {
            Boolean: [
              {
                key: 'equals',
                label: 'equals',
              },
              {
                key: 'exists',
                label: 'exists',
              },
              {
                key: 'notexists',
                label: 'notexists',
              },
            ],

            Date: [
              {
                key: 'equals',
                label: 'equals',
              },
              {
                key: 'gt',
                label: 'gt;',
              },
              {
                key: 'gte',
                label: 'gte;',
              },
              {
                key: 'lt',
                label: 'lt;',
              },
              {
                key: 'lte',
                label: 'lte;',
              },
              {
                key: 'exists',
                label: 'exists',
              },
              {
                key: 'notexists',
                label: 'notexists',
              },
              {
                key: 'between',
                label: 'between',
              },
            ],

            Number: [
              {
                key: 'equals',
                label: 'equals',
              },
              {
                key: 'gt',
                label: 'gt;',
              },
              {
                key: 'gte',
                label: 'gte;',
              },
              {
                key: 'lt',
                label: 'lt;',
              },
              {
                key: 'lte',
                label: 'lte;',
              },
              {
                key: 'exists',
                label: 'exists',
              },
              {
                key: 'notexists',
                label: 'notexists',
              },
            ],

            String: [
              {
                key: 'startWith',
                label: 'startswith',
              },
              {
                key: 'endWith',
                label: 'endWith',
              },
              {
                key: 'regexp',
                label: 'regexp',
              },
              {
                key: 'inclus',
                label: 'inclus',
              },
              {
                key: 'equals',
                label: 'equals',
              },
              {
                key: 'notEquals',
                label: 'notEquals',
              },
              {
                key: 'exists',
                label: 'exists',
              },
              {
                key: 'notexists',
                label: 'notexists',
              },
            ],
          };

          var metaAttributType = '';

          if (attributType !== '') {
            switch (attributType) {
              case 'text':
              case 'java.lang.String':
              case 'java.lang.Character':
              case 'java.lang.CharSequence':
                metaAttributType = 'String';
                break;

              case 'number':
              case 'java.lang.Integer':
              case 'java.lang.Short':
              case 'java.lang.Double':
              case 'java.lang.Float':
              case 'java.math.BigDecimal':
              case 'java.lang.Long':
                metaAttributType = 'Number';
                break;

              case 'date':
              case 'java.sql.Timestamp':
              case 'java.lang.Timestamp':
              case 'java.sql.Date':
              case 'java.util.Date':
              case 'java.util.TimeZone':
                metaAttributType = 'Date';
                break;

              case 'checkbox':
              case 'radio':
              case 'java.lang.Boolean':
                metaAttributType = 'Boolean';
                break;
            }

            return operandsList[metaAttributType];
          }
        };
      },
    };
  };
  executequery.$inject = [
    'QueryFactory',
    'gaDomUtils',
    'SelectManager',
    'panelsManager',
    'FeatureTypeFactory',
    'AlertHpoFactory',
    '$filter',
    'ngDialog',
    'DataStoreFactory',
    'sldUtils',
    '$timeout',
    '$rootScope',
    'extendedNgDialog',
    'ngTableParams',
  ];
  return executequery;
});
