'use strict';
define(function() {
  /**
   *
   * @returns {{restrict: string, templateUrl: string}}
   */
  var arrayInput = function() {
    return {
      restrict: 'A',
      templateUrl: 'js/XG/modules/common/views/directives/arrayInput.html',
      scope: {
        res: '=',
      },
      link: function(scope) {
        scope.lines = angular.isArray(scope.res) ? scope.res : [''];

        /**
         * Add a line
         */
        scope.addLine = function() {
          var lastIndex = scope.lines.length - 1;
          var lastLine = scope.lines[lastIndex];

          if (lastLine) {
            scope.lines.push('');
          }
        };

        /**
         * Delete a line
         * @param index
         */
        scope.deleteLine = function(index) {
          scope.lines.splice(index, 1);
        };

        /**
         * Update res
         */
        scope.$watch(
          'lines',
          function(lines) {
            scope.res = lines;
          },
          1
        );
      },
    };
  };

  arrayInput.$inject = [];
  return arrayInput;
});
