'use strict';

define(function() {
  /*
   * CalendarInviteCtrl
   */
  var CalendarInviteCtrl = function(
    $scope,
    CalendarFactory,
    ngDialog,
    $rootScope
  ) {
    /**
     * refrsh
     */
    var refresh = function() {
      CalendarFactory.getinvitedevents().then(function(res) {
        $scope.invitedevents = res.data;
      });
    };
    refresh();

    /**
     * set Event User Status
     * @param event
     * @param type
     */
    $scope.setEventUserStatus = function(event, type) {
      CalendarFactory.seteventuserstatus('', event.id, type).then(function(
        res
      ) {
        console.log(res.data);
        refresh();
      });
    };

    var dialogEvent;

    $scope.edit = function(event) {
      $scope.currentEvent = event;
      dialogEvent = ngDialog.open({
        template:
          'js/XG/modules/common/views/directives/modal.calendar.event.html',
        className: 'ngdialog-theme-plain width1000 miniclose nopadding',
        closeByDocument: false,
        scope: $scope,
      });
    };

    $rootScope.$on('closeEventModal', function() {
      if (dialogEvent) dialogEvent.close();
    });
  };

  CalendarInviteCtrl.$inject = [
    '$scope',
    'CalendarFactory',
    'ngDialog',
    '$rootScope',
  ];
  return CalendarInviteCtrl;
});
