'use strict';

/**
 * @ngdoc overview
 * @name modules.authentication
 * @description
 * authentication module
 */
define([
  'angular',
  'modules/authentication/controllers/AuthCtrl',
  'modules/authentication/controllers/LogoutCtrl',
  'modules/authentication/controllers/InfoCtrl',
  'modules/authentication/services/AuthFactory',
], function(angular, AuthCtrl, LogoutCtrl, InfoCtrl, authFactory) {
  // Module
  var mod = angular.module('authentication', ['ngRoute']);

  // Services
  mod.factory('authFactory', authFactory);

  // Controllers
  mod.controller('AuthCtrl', AuthCtrl);
  mod.controller('LogoutCtrl', LogoutCtrl);
  mod.controller('InfoCtrl', InfoCtrl);

  // Configuration
  mod.config([
    '$routeProvider',
    function($routeProvider) {
      $routeProvider.when('/login/', {
        templateUrl: 'js/XG/modules/' + 'authentication/views/login.html',
        controller: AuthCtrl,
      });
      $routeProvider.when('/logout/', {
        templateUrl: 'js/XG/modules/' + 'authentication/views/logout.html',
        controller: LogoutCtrl,
      });
    },
  ]);

  return mod;
});
