'use strict';
/**
 * @ngdoc overview
 * @name modules.applications
 * @description
 * applications module
 */
define([
  'angular',

  'modules/applications/services/ApplicationFactory',
  'modules/applications/controllers/ApplicationCtrl',
  'modules/applications/controllers/QrCtrl',
], function(angular, ApplicationFactory, ApplicationCtrl, QrCtrl) {
  // Module
  var mod = angular.module('applications', []);

  // Services
  mod.factory('ApplicationFactory', ApplicationFactory);

  // Controllers
  mod.controller('ApplicationCtrl', ApplicationCtrl);
  mod.controller('QrCtrl', QrCtrl);
  // Configuration
  mod.config([
    '$routeProvider',
    function($routeProvider) {
      $routeProvider.when('/applications/', {
        templateUrl: 'js/XG/modules/' + 'applications/views/applications.html',
        controller: ApplicationCtrl,
      });
    },
  ]);
  return mod;
});
