/**
 *
 */
'use strict';
define(function() {
  /**
   * QrCtrl
   *
   * @param $scope
   * @param $window
   * @param $location
   * @param ApplicationFactory
   * @param RolesFactory
   * @constructor
   */
  var QrCtrl = function(
    $scope,
    $window,
    $location,
    ApplicationFactory,
    RolesFactory,
    ngDialog,
    gaUrlUtils,
    $rootScope,
    gclayers,
    PortalsFactory
  ) {
    /*
     * TODO: empecher de saisir deux applis avec le meme nom
     *
     */

    $scope.barecode = function(withoutngDialog) {
      var mobhost = $location.protocol() + '://' + $location.host();

      var appname = localStorage.getItem('app');
      if ($location.search().app) {
        appname = $location.search().app;
      }
      $scope.mobqrcode =
        '/services/' +
        PortalsFactory.getPortalId() +
        '/application/qrcode?name=' +
        appname +
        '&token=' +
        gaUrlUtils.encodeUriQuery(localStorage.getItem('auth_token')) +
        '&url=' +
        mobhost;
      if (!withoutngDialog)
        ngDialog.open({
          template: 'js/XG/widgets/mapapp/main/views/barecode.html',
          className: 'ngdialog-theme-plain width300 miniclose',

          closeByDocument: false,
          scope: $scope,
        });
    };

    /**
     * forceReloadDefaultMapConfig Positionne ici pour etre appele depuis
     * index.html devrait avoir son propre controller
     */
    $scope.forceReloadDefaultMapConfig = function() {
      $rootScope.$broadcast('forceReloadDefaultMapConfig');
      gclayers.getAnnotationLayer().setVisible(false);
    };
  };

  QrCtrl.$inject = [
    '$scope',
    '$window',
    '$location',
    'ApplicationFactory',
    'RolesFactory',
    'ngDialog',
    'gaUrlUtils',
    '$rootScope',
    'gclayers',
    'PortalsFactory'
  ];
  return QrCtrl;
});
