'use strict';

define(function () {
  var AssEditProcessServices = function (
    AdvancedEditionFactory,
    gclayers,
    FeatureTypeFactory,
    gcWFS,
    EditRulesFeatGeomFactory,
    extendedNgDialog,
    $translate,
    gaDomUtils,
    ogcFactory,
    ASSEditionFactory
  ) {
    let consumerScope;
    const GEOJSON_PARSER = new ol.format.GeoJSON();
    let wfsLayer = undefined;
    let style;
    let fti = undefined;
    let tool = {
      actionParent: 'ASS',
      actionType: 'longitudinalProfil',
      itemUID: '3b7abc6e-05a4-442c-bd14-0b719604eccb',
      style: 'elec_editing_elec-tool-04-bt-tron-move-png24',
      tooltip: 'Profil en long',
    }

    let longitudinalProfilFormTitle = 'Génération du profil en long';
    $translate('networkedit.sanitation.longitudinalProfilFormTitle').then(
      (res) => {
        longitudinalProfilFormTitle = res;
      }
    );


    /**
     * Pose une image sur le sommet et le milieu de chaque seguement
     * @param  {[type]} geometry [description]
     * @param  {[type]} styles   [description]
     * @return {[type]}          [description]
     */
    function typeGeometry(geometry, styles) {
      if (geometry.getLineString(0)) {
        geometry.getLineString(0).forEachSegment((start, end) => {
          const dx = end[0] - start[0];
          const dy = end[1] - start[1];
          const centre = [];
          centre[0] = start[0] + dx / 2;
          centre[1] = start[1] + dy / 2;

          const rotation = Math.atan2(dy, dx);
          // arrows
          styles.push(
            new ol.style.Style({
              geometry: new ol.geom.Point(end),
              image: new ol.style.Icon({
                src: 'img/common/arrow.png',
                anchor: [0.7, 0.5],
                // anchor: [0.75, 0.5],
                rotateWithView: true,
                rotation: -rotation,
              }),
            })
          );

          styles.push(
            new ol.style.Style({
              geometry: new ol.geom.Point(centre),
              image: new ol.style.Icon({
                src: 'img/common/arrow.png',
                anchor: [0.7, 0.5],
                // anchor: [0.75, 0.5],
                rotateWithView: true,
                rotation: -rotation,
              }),
            })
          );
        });
      }
    }

    /**
     * elle met en evidence le flux de canalisation ainsi la canalisation inversée
     * @param  {[type]} feature [description]
     * @return {[type]}         [description]
     */
    let styleFunction = (feature) => {
      let lineWidth = 2;
      if (featuresInversees.indexOf(feature.getId()) != -1) {
        lineWidth = 4;
        featuresInversees.splice(featuresInversees.indexOf(feature.getId()), 1);
      }
      const geometry = feature.getGeometry();
      const styles = [
        // linestring
        new ol.style.Style({
          stroke: new ol.style.Stroke({
            color: '#B22222',
            width: lineWidth,
          }),
        }),
      ];

      typeGeometry(geometry, styles);

      return styles;
    };

    // var styleFunctionInv = function(feature) {
    //       // var geometry = feature.getGeometry();
    //       var styles = [
    //         // linestring
    //         new ol.style.Style({
    //           image: new ol.style.Icon({
    //            src: 'img/common/Arrow-Down-Red.png',
    //            anchor: [0.0, 0.0]
    //                // rotateWithView: true
    //              }),
    //           stroke: new ol.style.Stroke({
    //             color: '#B22222',
    //             width: 2
    //           })

    //         })

    //         ];

    //      return styles;
    //    };

    function dessinerFlux(scope, tool) {
      if (gclayers.getOperationalLayer()) {
        const layers = gclayers.getOperationalLayer();

        const fti = FeatureTypeFactory.getFeatureByUid(scope.currentFti.uid);

        const layersToLoad = [];
        layersToLoad.push(fti);
        wfsLayer = gcWFS.getOlLayerFromFeaturetypeInfoArray(layersToLoad,scope.map);
        wfsLayer.setStyle(styleFunction);
        const map = scope.map;
        map.addLayer(wfsLayer);
        console.log(wfsLayer);
      }
    }

    function effacerFlux(scope, tool) {
      const map = scope.map;
      map.removeLayer(wfsLayer);
      console.log('supprimé!!!');
    }

    let featuresInversees = [];

    function inverser(scope, res, evt, consumerScope) {
      scope.isActive = true;
      const selectedFeatures = GEOJSON_PARSER.readFeatures(res.data);
      const layersToLoad = [];
      if (selectedFeatures.length > 0) {
        fti = {
          shareObject: '',
          editType: scope.editdescription.editType,
          feature: selectedFeatures[0],
          fti: scope.editdescription.fti,
          uid: scope.editdescription.fti.uid,
        };

        layersToLoad.push(fti);

        const feature = wfsLayer
          .getSource()
          .getFeatureById(fti.feature.getId());
        featuresInversees.push(feature.getId());
        const geom = feature.getGeometry();
        const geomInversee = EditRulesFeatGeomFactory.inverserLine(geom);
        feature.setGeometry(geomInversee);

        wfsLayer.setStyle(styleFunction);
        consumerScope.$broadcast('editProcessUpdated', {
          editprocessawait: true,
        });

        scope.editdescription.editType = 'update';
        scope.editdescription.editedfeature = scope.currentFeature = feature;
        scope.editdescription.fti = fti;
      }
    }

    function supprimer() {
      const feature = wfsLayer.getSource().getFeatureById(fti.feature.getId());
      const geom = feature.getGeometry();
      const geomInversee = EditRulesFeatGeomFactory.inverserLine(geom);
      feature.setGeometry(geomInversee);

      wfsLayer.setStyle(styleFunction);
    }

    function longitudinalProfil(scope) {

      scope.longProfilInput = {
        title: 'Profil en long',
        pc: 50,
        vertScale: 100,
        horizScale: 100,
        textSize: 0.005,
      };

      scope.onSelectNodeId = (position) => {
        gclayers.getselectSource().clear();

        console.log(position);
        console.log(scope.selectTool.res);
        if (scope.selectTool.res.features.length > 0) {
          const selectedFeatures = GEOJSON_PARSER.readFeatures(
            scope.selectTool.res
          );
          const selectedFeature = selectedFeatures[0];
          gclayers.getselectSource().addFeature(selectedFeature);

          const featProperties = selectedFeature.getProperties();
          const idValue = featProperties['id'];

          if (position == 'start') {
            scope.longProfilInput.startId = idValue;
          } else if (position == 'end') {
            scope.longProfilInput.endId = idValue;
          }
        }
      };
      openProfileBuilderForm(scope);
    }

    function openProfileBuilderForm(scope) {
      if (scope.longitudinalProfilFormPopup != undefined) {
        scope.longitudinalProfilFormPopup.close();
      }

      scope.longitudinalProfilFormPopup = extendedNgDialog.open({
        template:
          'js/XG/widgets/mapapp/longitudinalprofile/views/modal.form.html',
        className: 'ngdialog-theme-plain width600 nopadding miniclose',
        closeByDocument: false,
        scope: scope,
        draggable: {
          title: longitudinalProfilFormTitle,
        },
      });
    }

    function launchLongProfilBuild(scope) {
      gclayers.getselectSource().clear();
      const srid = scope.selectTool.map.getView().getProjection().getCode();
      const nodeUids = scope.selectTool.uids.join();
      const cql_filter = 'id = ' + scope.longProfilInput.startId;

      gaDomUtils.showGlobalLoader();

      const promise = ogcFactory.getfeatures(
        'GetFeature',
        'WFS',
        '1.0.0',
        nodeUids,
        'json',
        srid,
        cql_filter
      );
      promise
        .then((res) => {
          if (res.data.features.length != 1) {
            gaDomUtils.hideGlobalLoader();
            require('toastr').error('Noeud de départ non trouvé');
          }
          const selectedFeatures = GEOJSON_PARSER.readFeatures(res.data);
          const selectedFeature = selectedFeatures[0];
          const cql_filter2 = 'id = ' + scope.longProfilInput.endId;

          const promise2 = ogcFactory.getfeatures(
            'GetFeature',
            'WFS',
            '1.0.0',
            nodeUids,
            'json',
            srid,
            cql_filter2
          );
          promise2
            .then((res2) => {
              if (res2.data.features.length != 1) {
                gaDomUtils.hideGlobalLoader();
                require('toastr').error('Noeud de fin non trouvé');
              }
              const selectedFeatures2 = GEOJSON_PARSER.readFeatures(res2.data);
              const selectedFeature2 = selectedFeatures2[0];
              const featID1 = selectedFeature.getId();
              const featIdSplit1 = featID1.split('.');

              if (featIdSplit1.length != 2) {
                gaDomUtils.hideGlobalLoader();
                require('toastr').error('Erreur de syntaxe de l\'ID du noeud de départ');
              }
              const idStart = featIdSplit1[1];
              const layerName = featIdSplit1[0];
              const featID2 = selectedFeature2.getId();
              const featIdSplit2 = featID2.split('.');

              if (featIdSplit2.length != 2) {
                gaDomUtils.hideGlobalLoader();
                require('toastr').error(
                  "Erreur de syntaxe de l'ID du noeud d'arrivée'"
                );
              }
              const idEnd = featIdSplit2[1];

              const longitudinalProfilData = {
                findPathInput: {
                  start: {
                    featureId: idStart,
                    layerName: layerName,
                  },
                  end: {
                    featureId: idEnd,
                    layerName: layerName,
                  },
                },
                fileTile: scope.longProfilInput.title,
                pdc: scope.longProfilInput.pc,
                emitter: scope.longProfilInput.emitter,
                recipient: scope.longProfilInput.recipient,
                localisation: scope.longProfilInput.localisation,
                date: buildDate(scope.longProfilInput.date),
                formatIndex: scope.longProfilInput.format.index,
                verticalScale: scope.longProfilInput.vertScale,
                horizontalScale: scope.longProfilInput.horizScale,
                graduation: 'm',
                textSize: scope.longProfilInput.textSize,
                diameterUnit: scope.longProfilInput.diameterUnit,
                diameterDivider: scope.longProfilInput.diameterDivider,
              };

              //console.log(longitudinalProfilData);

              const promise3 = ASSEditionFactory.buildprofile(
                longitudinalProfilData,
                nodeUids
              );
              promise3
                .then((res3) => {
                  const fileName = res3.data.filename;
                  const portalId = res3.data.portalId;
                  if (fileName.startsWith('EXPORTEDPROFILE')) {
                    const downloadurl =
                      '/services/' +
                      portalId +
                      '/assedition/downloadexportedprofile?f=json' +
                      '&exportedProfileId=' +
                      fileName;
                    window.open(downloadurl);
                  }
                })
                .catch((error) => {
                  require('toastr').error(
                    'Impossible de télécharger le fichier <br>' + error.data
                  );
                })
                .finally(() => {
                  gaDomUtils.hideGlobalLoader();
                });
            })
            .catch((error) => {
              require('toastr').error(
                'Impossible de télécharger le fichier : ' + error
              );
            })
            .finally(() => {
              gaDomUtils.hideGlobalLoader();
            });
        })
        .catch((error) => {
          require('toastr').error(
            'Impossible de télécharger le fichier : ' + error
          );
        })
        .finally(() => {
          gaDomUtils.hideGlobalLoader();
        });
    }

    function buildDate(date) {
      let dd = date.getDate();
      let mm = date.getMonth() + 1;
      if (dd.toString().length == 1) {
        dd = '0' + dd;
      }
      if (mm.toString().length == 1) {
        mm = '0' + mm;
      }
      const yy = date.getFullYear();
      return dd+'/'+mm+'/'+yy
    }

    function init() {
      // To implement later, for loading network configs.
    }


    return {
      dessinerFlux: dessinerFlux,
      effacerFlux: effacerFlux,
      inverser: inverser,
      supprimer: supprimer,
      longitudinalProfil: longitudinalProfil,
      launchLongProfilBuild: launchLongProfilBuild,
    };
  };

  AssEditProcessServices.$inject = [
    'AdvancedEditionFactory',
    'gclayers',
    'FeatureTypeFactory',
    'gcWFS',
    'EditRulesFeatGeomFactory',
    'extendedNgDialog',
    '$translate',
    'gaDomUtils',
    'ogcFactory',
    'ASSEditionFactory',
  ];

  return AssEditProcessServices;
});
