'use strict';
define([
  'angular',

  'containers/directives/collabseMenuDirective',
  'containers/directives/widgetTooltip',
  'containers/directives/draggableDirective',
  'containers/services/gcPopup',
  'containers/directives/verticaltoolbardirective',
  'containers/directives/resizable',
  'containers/directives/resizableModal',
  'containers/directives/kisProcess',
  'containers/directives/kisCalendar',
  'containers/directives/kisCalendarFilters',
  'containers/directives/kisCalendarEvent',
  'containers/directives/kisCalendarRelation',
  'containers/directives/kisAlertBtn',
  'containers/directives/taskManager',
  'containers/services/panelsManager',
  'containers/services/ActionsManager',
  'containers/services/kisCalendarFactory',
  'containers/services/AssEditProcessServices',

  'angular-strap',
  'angular-strap.tpl',
  'angular-route',
  'toastr',
  'ol3js',
  'ng-table',
], function (
  angular,
  CollapseMenu,
  widgetTooltip,
  draggableDirective,
  gcPopup,
  verticaltoolbardirective,
  resizable,
  resizableModal,
  kisProcess,
  kisCalendar,
  kisCalendarFilters,
  kisCalendarEvent,
  kisCalendarRelation,
  kisAlertBtn,
  taskManager,
  panelsManager,
  ActionsManager,
  kisCalendarFactory,
  AssEditProcessServices
) {
  // generation du module
  var gccontainer = angular.module('gc_container', [
    'mgcrea.ngStrap',
    'ngRoute',
    'pascalprecht.translate',
    'model',
  ]);

  gccontainer.provider('panelsManager', panelsManager);
  gccontainer.directive('collapsemenu', CollapseMenu);
  gccontainer.directive('widgetTooltip', widgetTooltip);
  gccontainer.directive('gcPopup', draggableDirective);
  gccontainer.provider('gcPopup', gcPopup);
  gccontainer.directive('gcverticaltoolbar', verticaltoolbardirective);
  gccontainer.directive('resizable', resizable);
  gccontainer.directive('resizableModal', resizableModal);
  gccontainer.directive('kisProcess', kisProcess);
  gccontainer.directive('kisCalendar', kisCalendar);
  gccontainer.directive('kisCalendarFilters', kisCalendarFilters);
  gccontainer.directive('kisCalendarEvent', kisCalendarEvent);
  gccontainer.directive('kisCalendarRelation', kisCalendarRelation);
  gccontainer.directive('kisAlertBtn', kisAlertBtn);
  gccontainer.directive('taskManager', taskManager);
  gccontainer.factory('ActionsManager', ActionsManager);
  gccontainer.factory('kisCalendarFactory', kisCalendarFactory);
  gccontainer.factory('AssEditProcessServices', AssEditProcessServices);

  gccontainer.directive('nghtmlcompile', [
    '$compile',
    '$rootScope',
    'gaJsUtils',
    function ($compile, $rootScope, gaJsUtils) {
      return {
        restrict: 'A',

        link: function (scope, element, attrs) {
          if ($rootScope.loadedWidget == undefined)
            $rootScope.loadedWidget = [];
          let widgetUid;

          scope.$watch(attrs.nghtmlcompile, function (newValue, oldValue) {
            //-- Clef composée du nom du widget concaténé avec le nom de la configuration.
            widgetUid = newValue + '_' + scope.tool.config;
            if ($rootScope.loadedWidget[widgetUid] == undefined) {
              var templateScope = scope.$parent.$new();
              templateScope.map = scope.$parent.map;
              templateScope.ConfigName = scope.tool.config;
              templateScope.toolBarWidget = scope.tool;
              templateScope.panelsManager = scope.$parent.panelsManager;
              templateScope.mode = scope.$parent.mode;
              templateScope.contextMenu = gaJsUtils.getMenuOptions(scope);
              $rootScope.loadedWidget[widgetUid] = templateScope;
            }
            element.html('<div ' + newValue + '></div>');

            $compile(element.contents())($rootScope.loadedWidget[widgetUid]);
          });
          scope.$on('$destroy', function () {

            // KIS-3353: l’utilisateur doit pouvoir garder la popup du widget quand la catégorie se ferme
            // pour utiliser d’autres widgets en parallèle : geocatalog, localisation
            let activeWidgetName = null;
            const isPopupShown = document.querySelector('.ngdialog');
            if (isPopupShown) {
              const leftMapPanel = document.getElementById('map_aside');
              if (leftMapPanel) {
                const currentTool = leftMapPanel.querySelector('#tool.active');
                if (currentTool) {
                  activeWidgetName = currentTool.firstElementChild.id;
                }
              }
            }

            // KIS-3353: le widget actif n'est pas destroy si une popup est affichée
            if (widgetUid && scope.tool.name !== activeWidgetName) {
              $rootScope.loadedWidget[widgetUid].$destroy();
              delete $rootScope.loadedWidget[widgetUid];
            }
          });
        },
      };
    },
  ]);

  gccontainer.directive('popupbody', function () {
    return {
      restrict: 'A',
      link: function (scope, element, attrs) {},
      templateUrl: function (elem, attrs) {
        return attrs.popupbody || 'some/path/default.html';
      },
    };
  });

  gccontainer.directive('gaDraggable', [
    '$document',
    'gaBrowserSniffer',
    function ($document, gaBrowserSniffer) {
      return {
        restrict: 'A',
        scope: {
          dragPopup: '=?',
        },
        link: link,
      };

      function link(scope, element, attr) {
        var startX = 0,
          startY = 0,
          x = null,
          y = null;
        var eventKey = gaBrowserSniffer.events;
        var regex = /^(input|textarea|a|button)$/i;

        // Firefox doesn't like transition during drag
        element.addClass('ga-draggable');
        element.css({ position: 'absolute' });

        var dragZone = element.find(attr['gaDraggableZone']);

        if (!dragZone || dragZone.length == 0) {
          dragZone = element;
        }

        dragZone.addClass('ga-draggable-zone');

        dragZone.bind(eventKey.start, function (evt) {
          // If the class has disappeared that means draggable is not allow
          // temporarly.
          if (!dragZone.hasClass('ga-draggable-zone')) {
            return;
          }

          x = element.prop('offsetLeft');
          y = element.prop('offsetTop');

          let dragActive =
            element[0].getAttribute('drag-active') === 'true' ||
            element[0].getAttribute('drag-active') === null;

          if (dragActive) {
            startX = getMouseEventX(evt) - x;
            startY = getMouseEventY(evt) - y;
            $document.bind(eventKey.move, drag);
            $document.bind(eventKey.end, dragend);
          }
        });

        function drag(evt) {
          x = getMouseEventX(evt) - startX;
          y = getMouseEventY(evt) - startY;
          
          scope.dragPopup(element, x, y);

          // block default interaction
          if (!regex.test(evt.target.nodeName)) {
            evt.preventDefault();
          }
        }

        function dragend(evt) {
          $document.unbind(eventKey.move, drag);
          $document.unbind(eventKey.end, dragend);

          // block default interaction
          if (!regex.test(evt.target.nodeName)) {
            evt.preventDefault();
          }
        }

        /* Utils */

        // RE3: Get the X coordinate of a mouse or a touch event
        var getMouseEventX = function (event) {
          if (event.originalEvent) {
            event = event.originalEvent;
          }
          return angular.isNumber(event.clientX)
            ? event.clientX
            : event.touches[0].clientX;
        };

        // RE3: Get the Y coordinate of a mouse or touch event
        var getMouseEventY = function (event) {
          if (event.originalEvent) {
            event = event.originalEvent;
          }
          return angular.isNumber(event.clientY)
            ? event.clientY
            : event.touches[0].clientY;
        };
      }
    },
  ]);

  return gccontainer;
});
