'use strict';
define([], function() {
  var resizable = function($document, $rootScope) {
    return {
      restrict: 'EA',
      scope: {
        resizeOrigin: '@?',
        resizeOriginId: '@?',
      },
      link: function(scope, element, attrs) {
        var parent = angular.element(element).parent()[0];
        var baseY;
        var currentHeight;
        var heightToAdd;
        var newHeight;

        element.on('mousedown', function(event) {
          event.preventDefault();

          baseY = event.pageY;
          currentHeight = parent.offsetHeight;

          $document.on('mousemove', mousemove);
          $document.on('mouseup', mouseup);
        });

        function resizeY() {
          parent.style.height = newHeight + 'px';
          parent.style.minHeight = 'auto';
        }

        function mousemove(event) {
          // Handle vertical resizer
          var y = event.pageY;
          heightToAdd = baseY - y;
          newHeight = currentHeight + heightToAdd;
          /*console.log('----------------------------');
                        console.log('baseY:'+baseY);
                        console.log('y:'+y);
                        console.log('currentHeight:'+currentHeight);
                        console.log('heightToAdd:'+heightToAdd);
                        console.log('newHeight:'+newHeight);
                        console.log('----------------------------');*/
          resizeY();
        }

        function emitResize() {
          if (scope.resizeOrigin) {
            $rootScope.$broadcast('elementResized', {
              element: {
                type: scope.resizeOrigin,
                id: scope.resizeOriginId,
              },
              transformation: {
                y: heightToAdd,
              },
            });
          }
        }
        function mouseup(event) {
          emitResize();
          $document.unbind('mousemove', mousemove);
          $document.unbind('mouseup', mouseup);
        }

        $rootScope.$on('forceElementResize', function(event, args) {
          if (
            args.element.type == scope.resizeOrigin &&
            args.element.id == scope.resizeOriginId
          ) {
            newHeight = args.dimensions.y;
            heightToAdd = args.dimensions.y - parent.offsetHeight;
            resizeY();
            emitResize();
          }
        });
      },
    };
  };

  resizable.$inject = ['$document', '$rootScope'];
  return resizable;
});
