'use strict';
define(function() {
  var kisCalendarRelation = function(
    FeatureTypeFactory,
    ngDialog,
    QueryFactory,
    gclayers,
    $rootScope,
    $location,
    AncAppFactory,
    gaDomUtils
  ) {
    return {
      templateUrl: 'js/XG/containers/views/kis_calendarrelation.html',
      restrict: 'EA',
      scope: {
        res: '=',
        cannotModify: '=?',
        map: '=?',
      },
      link: function(scope, elt, attrs, ctrl) {
        /**
         * get all features
         */
        FeatureTypeFactory.get().then(function(res) {
          // adapte aux modification de FeatureFactory.get (doit utiliser res et non plus res.data)
          scope.featureslist = res;
        });

        var myDialog;
        scope.currentFeature = {};
        scope.selected = {};
        scope.currentIndex = false;
        /**
         * open dialog
         * @param relation
         * @param index
         */
        scope.openInfosDialog = function(relation, index) {
          scope.selected = {};
          scope.currentIndex = index;
          for (var i = 0; i < scope.featureslist.length; i++) {
            if (relation.properties.feature_uid == scope.featureslist[i].uid) {
              scope.currentFeature = scope.featureslist[i];
            }
          }
          myDialog = ngDialog.open({
            template:
              'js/XG/containers/views/modal.infos.kis_calendar_relation.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
          });
        };

        /**
         * save
         */
        scope.save = function() {
          for (var i = 0; i < scope.res.features.length; i++) {
            if (
              scope.currentFeature.uid ==
                scope.res.features[i].properties.feature_uid &&
              scope.currentIndex == i
            ) {
              scope.res.features[i].properties.feature_id =
                scope.selected.list[0].id;
            }
          }
          myDialog.close();
          scope.currentIndex = false;
        };

        /**
         * close Dialog
         */
        scope.close = function() {
          myDialog.close();
          scope.currentIndex = false;
        };

        /**
         * remove relation
         * @param index
         */
        scope.removeRelation = function(index) {
          var ans = confirm(
            'Êtes-vous certain de vouloir supprimer cette relation?'
          );
          if (ans) {
            scope.res.features.splice(index, 1);
          }
        };

        /**
         * add relation
         */
        scope.newRelation = function() {
          if (!scope.res || !scope.res.features) {
            scope.res.features = [];
          }
          scope.res.features.push({
            type: 'Feature',
            properties: {},
          });
        };

        /**
         * is Geographic
         * @param relation
         * @returns {boolean}
         */
        scope.isGeographic = function(relation) {
          var res = false;
          if (
            relation &&
            relation.properties &&
            relation.properties.feature_uid
          ) {
            var feature = FeatureTypeFactory.getFeatureByUid(
              relation.properties.feature_uid
            );
            if (
              feature &&
              feature.geographic &&
              relation.properties.feature_id
            ) {
              res = true;
            }
          }
          if (!scope.map) {
            res = false;
          }
          return res;
        };

        /**
         * position On Map
         * @param relation
         */
        scope.positionOnMap = function(relation) {
          QueryFactory.get(
            relation.properties.feature_uid,
            relation.properties.feature_id
          ).then(function(res) {
            console.log(res.data.features[0]);
            if (res.data.features[0].geometry) {
              var obj = res.data.features[0];
              var format = new ol.format.GeoJSON();
              var f = format.readFeature(obj);
              var extent = f.getGeometry().getExtent();
              scope.map.getView().fit(extent, scope.map.getSize());
              $rootScope.calendar.visible = false;
              gclayers.clearhighLightFeatures();
              gclayers.addhighLightFeature(f);
            } else {
              require('toastr').info('Position inconnue');
            }
          });
        };

        /**
         * display anc report
         * @param id
         * @returns {boolean}
         */
        scope.displayAncReport = function(id) {
          var res = false;
          if ($location.path().indexOf('/anc/') == 0 && id) {
            if (
              id.split('.')[0] == 'kis_anc_dossier' ||
              id.split('.')[0] == 'kis_anc_dossier_controle'
            ) {
              res = true;
            }
          }
          return res;
        };

        /**
         * edit report anc
         * @param uid
         * @param fid
         */
        //open_id
        scope.editReport = function(uid, fid) {
          $location.search('fid', fid);
          if ($location.path().indexOf('/anc/reports/') != 0) {
            $location.path('/anc/reports/');
          }
        };
      },
    };
  };

  kisCalendarRelation.$inject = [
    'FeatureTypeFactory',
    'ngDialog',
    'QueryFactory',
    'gclayers',
    '$rootScope',
    '$location',
    'AncAppFactory',
    'gaDomUtils',
  ];
  return kisCalendarRelation;
});
