'use strict';
define([], function() {
  var gcPopup = function() {
    return {
      restrict: 'A',
      templateUrl: 'js/XG/containers/views/popup.html',

      link: function(scope, element) {
        scope.pos = {
          top: 200,
          left: 200,
        };

        scope.dragActive = false;
        scope.pageX = 0;
        scope.pageY = 0;
        scope.X = 0;
        scope.Y = 0;

        scope.onMouseDown = function(evt) {
          scope.dragActive = true;
          //event.preventDefault();
          //document.onselectstart = function() { return false; };
          scope.Y = evt.pageY - scope.pos.top;
          scope.X = evt.pageX - scope.pos.left;
        };
        scope.onMouseMove = function(event) {
          if (scope.dragActive) {
            //console.log(scope);
            var t = event.pageY - scope.Y;
            var l = event.pageX - scope.X;
            scope.pos.top = t;
            scope.pos.left = l;
            scope.$app;
          }
        };
        scope.onMouseUp = function() {
          scope.dragActive = false;
        };
        scope.onMouseLeave = function(evt) {
          if (scope.dragActive) {
            var t = evt.pageY - scope.Y;
            var l = evt.pageX - scope.X;
            scope.pos.top = t;
            scope.pos.left = l;
          }
          scope.dragActive = false;
        };
        // Add close popup function
        scope.close = function() {
          console.log('close');
          scope.$destroy();
          scope = null;
          element.remove();
        };
        scope.getUniqueID = function() {
          var uniqueID = new Date();
          var myRandom = Math.floor(Math.random() * 1000);
          return uniqueID.getTime() + '' + myRandom;
        };
      },
    };
  };

  gcPopup.$inject = [];
  return gcPopup;
});
