/**
 *
 */
'use strict';
define(function() {
  var TypeProjetCtrl = function(
    $scope,
    TypeProjetFactory,
    ConfigFactory,
    QueryFactory,
    EditFactory,
    FeatureTypeFactory,
    ApplyProcedureFactory,
    gclayers,
    GlobalServices,
    GceSendMailServices,
    $timeout,
    $q,
    gaJsUtils
  ) {
    var ind1, ind2;

    $scope.getMap = function(aScope) {
      if (aScope == null) return undefined;
      if (aScope.map != undefined) return aScope.map;
      else return $scope.getMap(aScope.$parent);
    };

    //-- Get this scope ID in order to build unique HTML element identifier.
    $scope.thisId = $scope.$id;

    //-- Scope is ready when the factories have finished their job
    //-- so that the content compilation can be done.
    $scope.ready = false;
    $scope.objectToUpdateLoaded = true;
    $scope.relationsLoaded = false;

    //-- Factory giving access to object insertion, update
    //-- and to this "widget" configuration.
    $scope.descField = TypeProjetFactory.resources.descField;
    $scope.objectIdSav = $scope.objectId;
    $scope.lastAutomaticRefresh = 0;

    //-- Get map reference in order to be able to get its coordinate reference system.
    $scope.map = $scope.getMap($scope);

    //-- Actions may be disabled if required field are empty.
    //-- Concerned actions are create and update.
    $scope.infoFromChildren = {};
    $scope.infoFromChildren.existsRequiredValueWithNull = false;
    $scope.errorMessage = '';

    /**
     * TODO Comments
     */
    $scope.getObjUsingQueries = function() {
      var query, indFeatureType, where;

      if ($scope.indGetObjQuery >= $scope.config.exists_queries.length) {
        $scope.getObjUsingQueriesObjId = $scope.queryResult;
        $scope.queriesDone = true;
      } else {
        query = $scope.config.exists_queries[$scope.indGetObjQuery];
        for (
          indFeatureType = 0;
          indFeatureType < FeatureTypeFactory.resources.featuretypes.length;
          indFeatureType++
        )
          if (
            FeatureTypeFactory.resources.featuretypes[indFeatureType].name ==
            query.layerName
          )
            break;
        if (indFeatureType < FeatureTypeFactory.resources.featuretypes.length) {
          where = GlobalServices.getObjUsingQueriesBuildWhere(
            query.where,
            $scope.queryResult
          );
          $scope.queryResult = null;
          QueryFactory.data(
            FeatureTypeFactory.resources.featuretypes[indFeatureType].uid,
            where
          ).then(function(res) {
            if (res.data.features.length != 0) {
              if (query.result == 'id')
                $scope.queryResult = QueryFactory.getFeatureId(
                  res.data.features[0]
                );
              else
                $scope.queryResult =
                  res.data.features[0].properties[query.result];
            }
            $scope.indGetObjQuery++;
            $scope.getObjUsingQueries();
          });
        }
      }
    };

    $scope.tryToGetObjectWaitEnd = function() {
      if (!$scope.queriesDone) setTimeout($scope.tryToGetObjectWaitEnd, 200);
      else {
        if ($scope.getObjUsingQueriesObjId != null) {
          $scope.widgetState = 'update';
          $scope.objectId = $scope.getObjUsingQueriesObjId;
        } else {
          $scope.widgetState = 'insert';
        }
        $scope.loadWidgetStep2();
      }
    };

    $scope.tryToGetObjectUsingQueries = function() {
      $scope.getObjUsingQueriesObjId = null;
      $scope.queriesDone = false;
      $scope.indGetObjQuery = 0;
      $scope.getObjUsingQueries();
      setTimeout($scope.tryToGetObjectWaitEnd, 200);
    };

    $scope.getCfgUpdateMode = function() {
      if ($scope.config.updateMode == undefined) return 'inline';
      else return $scope.config.updateMode;
    };

    /**
     *     Called after table descriptor is gotten in order to continue
     *  this widget loading.
     */
    $scope.loadWidgetGotTableDescriptor = function(res) {
      $scope.descField = res;
      if ($scope.descField == null)
        alert(
          'Pas de description de table disponible pour [' +
            $scope.config.datastoreName +
            ':' +
            $scope.config.featureName +
            ']'
        );
      //console.log($scope.descField);
      if ($scope.widgetState == 'update' || $scope.widgetState == 'view') {
        var crs = $scope.map
          .getView()
          .getProjection()
          .getCode();
        //-- Widget state is update so look for the object to update ...
        QueryFactory.get(
          $scope.descField.uid,
          $scope.objectId,
          crs
        ).then(function(res) {
          if (res.data.features.length != 0) {
            $scope.theFeature = res.data.features[0];
            $scope.objectFields = res.data.features[0].properties;
            $scope.objectGeometry = res.data.features[0].geometry;
          }
          $scope.objectToUpdateLoaded = true;
          $scope.ready = $scope.objectToUpdateLoaded && $scope.relationsLoaded;
          //-- In case we want the user to validate the modification
          //-- when he decides to do it add an update command/
          //-- If we are not in this case, the modifications will be saved
          //-- after a modification is done in any input field.
          if ($scope.getCfgUpdateMode() == 'global') $scope.updateMode = true;
        });
      }
      if ($scope.descField == null) $scope.descField = {};
      if ($scope.descField.relations == null) $scope.descField.relations = [];
      for (ind2 = 0; ind2 < $scope.descField.relations.length; ind2++) {
        var ftinforel = FeatureTypeFactory.getFeatureTypeDesc(
          $scope.config.datastoreName,
          $scope.descField.relations[ind2].componentEnd
        );
        $scope.descField.relations[ind2].componentEndDescField = ftinforel;
      }
      $scope.relationsLoaded = true;

      $scope.ready = $scope.objectToUpdateLoaded;
    };

    /**
     *
     */
    $scope.loadWidgetStep2 = function() {
      $scope.objectToUpdateLoaded =
        $scope.widgetState != 'update' && $scope.widgetState != 'view';

      if ($scope.widgetState == 'insert') {
        $scope.objectFields = {};
        $scope.insertMode = true;
      }
      /////////////////////////////////////////////////////////////////
      FeatureTypeFactory.getFeatureTypeDescAsPromise(
        $scope.config.datastoreName,
        $scope.config.featureName
      ).then(function(res) {
        if (res == null)
          gaJsUtils.errorMessage(
            'Composant non trouvé: [' +
              $scope.config.datastoreName +
              '.' +
              $scope.config.featureName,
            ']'
          );
        else $scope.loadWidgetGotTableDescriptor(res);
      });
    };

    $scope.moduleIsNotAvailable = function() {
      $scope.ready = true;
      $scope.available = false;
      if ($scope.config.availability.when_not_available.type == 'message') {
        $scope.errorMessage =
          $scope.config.availability.when_not_available.message;
      }
    };

    $scope.defineDefaultConfig = function(featureName) {
      if (featureName.indexOf('.') == -1) return;
      var cfg = ($scope.config = {});
      if ($scope.stateFromParent != 'view') cfg.state = 'insert';
      else cfg.state = 'view';
      cfg.updateMode = 'inline';
      cfg.contentType = 'panelContainer';
      var tfn = featureName.split('.');
      cfg.datastoreName = tfn[0];
      cfg.featureName = tfn[1];
      var tableDesc = FeatureTypeFactory.getFeatureTypeDesc(tfn[0], tfn[1]);
      GlobalServices.defineDefaultConfigManageRelations(
        cfg,
        tfn[0],
        tfn[1],
        tableDesc
      );
    };

    /**
     *        Get configuration, description of tables/layers
     *    and eventually database object from server
     *    while this is not done the widget construction is waiting.
     *    When it is done  << $scope.ready >> is set to true
     *    and the compilation starts.
     */
    $scope.loadWidgetStep1 = function() {
      if (TypeProjetFactory.resources.config == null) {
        //-- Ask for configuration.
        ConfigFactory.get('creation_projet', $scope.ConfigName).then(function(
          res
        ) {
          //                        console.log(res);
          //-- Strange but we getting out of ConfigFactory.get $scope.objectId becomes undefined !!!!!
          if ($scope.objectId == undefined)
            $scope.objectId = $scope.objectIdSav;
          if ($scope.configFromParentDirective != undefined)
            $scope.config = $scope.configFromParentDirective;
          else if (
            $scope.config == undefined ||
            $scope.config.setFromParent != 'true'
          )
            if (res.data == undefined || res.data == '')
              $scope.defineDefaultConfig($scope.ConfigName);
            else $scope.config = res.data;

          if (
            $scope.config == null ||
            ($scope.config.datastoreName == null &&
              $scope.config.progDatastorename == null)
          ) {
            alert('Configuration du widget incorrecte !');
          } else {
            if ($scope.config.objectId != undefined) {
              $scope.parentId = {};
              $scope.parentId.fieldName = $scope.config.objectId;
              $scope.parentId.fieldValue = $scope.objectIdSav;
            }
            var p = TypeProjetFactory.isAvailable($scope.config.availability);
            p.then(function(res) {
              if (!res) $scope.moduleIsNotAvailable();
              else {
                $scope.available = true;
                if ($scope.config.state == 'insert_if_not_exists')
                  $scope.tryToGetObjectUsingQueries();
                else {
                  $scope.widgetState = $scope.config.state;
                  $scope.loadWidgetStep2();
                }
              }
            });
          }
        });
      }
    };

    $scope.update = function() {
      setTimeout(function() {
        if (!$scope.ready) $scope.update();
        else {
          var elt = document.getElementById(
            'typeprojetdirective_' + $scope.thisId
          );
          var str = '';
          if (!$scope.available) {
            //                                str += '<span ng-bind="errorMessage" class="typeprojmess" ng-show="errorMessage.length!=0"></span>';
            str +=
              '<span class="typeprojmess" ng-show="errorMessage.length!=0">' +
              $scope.errorMessage +
              '</span>';
          } else {
            str +=
              '<span ng-bind="errorMessage" class="typeprojmess" ng-show="errorMessage.length!=0"></span>';
            str +=
              '<div tabcontainerdirective ng-if="config.contentType==' +
              "'tabContainer'" +
              '">';
            str += '</div>';
            str +=
              '<div stepcontainerdirective ng-if="config.contentType==' +
              "'stepContainer'" +
              '">';
            str += '</div>';
            str +=
              '<div FormFieldPanelDirective ng-if="config.contentType==' +
              "'panelContainer'" +
              '">';
            str += '</div>';
            str +=
              '<div FormFieldPanelDirective ng-if="config.contentType==undefined">';
            str += '</div>';
            str +=
              '<button ng-show="insertMode" ng-click="insertObject()" ng-disabled="infoFromChildren.existsRequiredValueWithNull">Créer</button>';
            str +=
              '<button ng-show="$scope.widgetState==' +
              "'" +
              'insert' +
              "'" +
              ' && updateMode" ng-click="backToInsertMode()"><img src="img/common/24px-Go-previous.png" ></img></button>';
            str +=
              '<button ng-show="updateMode && getCfgUpdateMode()==' +
              "'" +
              'global' +
              "'" +
              '" ng-click="updateObject()" ng-disabled="infoFromChildren.existsRequiredValueWithNull">Modifier</button>';
            str +=
              '<button ng-click="backToCreateMode()"  ng-if="config.state==' +
              "'" +
              'insert' +
              "'" +
              '" ng-show="updateMode" id="backbtn_' +
              $scope.$id +
              '"><img src="img/common/24px-Go-previous.png" ></img></button>';
            str +=
              '<button ng-click="saveConfig()" ng-if="mode==\'config\'" ><span class="glyphicon glyphicon-floppy-disk" ></span></img></button>';
          }
          var cmp = $scope.compile(str)($scope);
          angular.element(elt).append(cmp);
        }
      }, 250);
    };

    /*
        $scope.loadWidgetTimeout = function ()
        {
            if ($scope.loadWidgetTryCount===undefined)
                $scope.loadWidgetTryCount = 0;
            //-- After 5 minutes inrease timeout delay
            if ($scope.loadWidgetTryCount>600)
                $timeout($scope.loadWidget,5000);
            else if ($scope.loadWidgetTryCount>240)
               {
                $scope.loadWidgetTryCount++;
                $timeout($scope.loadWidget,1500);
               }
            else
               {
                $scope.loadWidgetTryCount++;
                $timeout($scope.loadWidget,500);
               }
        };


        $scope.loadWidget = function ()
        {
            $scope.eltTypeProjet = document.getElementById("typeprojetdirective_"+$scope.$id);
            if ($scope.eltTypeProjet==undefined)
               {
                   $scope.loadWidgetTimeout();
               }
            else if ($scope.eltTypeProjet.getBoundingClientRect().width!=0)
                GlobalServices.initialize().then(
                    function (res)
                    {
                        $scope.loadWidgetStep1();
                        $scope.update();
                    }
                );
            else
                $scope.loadWidgetTimeout();
        };

        $scope.loadWidget();
*/

    $scope.$on('openTools_typeprojetdirective', function(event, data) {
      var cfgName = data.config;
      if (cfgName == undefined || cfgName.trim == undefined)
        cfgName = data.configName;
      if ($scope.ConfigName == cfgName && $scope.ready == false) {
        GlobalServices.initialize().then(function(res) {
          $scope.loadWidgetStep1();
          $scope.update();
        });
      }
    });

    /**
     *       The user has activated the back command.
     *    This command is visibles when in update mode.
     *    Activating it make the "widget" go back to insert mode
     *    for creating a new object.
     */
    $scope.backToInsertMode = function() {
      $scope.objectId = null;
      $scope.insertMode = true;
      $scope.updateMode = false;
    };

    $scope.getRelatedTables = function(fields) {
      var ind,
        fn,
        tn,
        indPt,
        indTable,
        tables = [];

      for (fn in fields) {
        //-- get table name from related field name.
        indPt = fn.indexOf('.');
        if (indPt != -1) tn = fn.substr(0, indPt);
        //-- Look for table name in the list of tables in relation.
        for (indTable = 0; indTable < tables.length; indTable++)
          if (tables[indTable] == tn) break;
        //-- Table name not found in the list so we add it.
        if (tn != undefined && indTable == tables.length) tables.push(tn);
      }
      return tables;
    };

    $scope.insertInto = function(
      fieldsForMoreRelation,
      tableName,
      fieldsForInserting,
      parentObj,
      parentObjectId,
      objectFields,
      defer,
      sendResolve
    ) {
      var fn,
        rel,
        newObj = {};
      var descField = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.config.datastoreName,
        tableName
      );
      for (var ind = 0; ind < descField.attributes.length; ind++) {
        fn = descField.attributes[ind].name;
        if (fn == 'id') continue;
        for (var ind2 = 0; ind2 < $scope.descField.relations.length; ind2++) {
          rel = $scope.descField.relations[ind2];
          if (
            rel.fieldEnd == fn &&
            $scope.descField.name == rel.componentStart &&
            tableName == rel.componentEnd
          ) {
            //-- The field is a relation
            newObj[fn] = parentObjectId;
            break;
          }
        }
        if (ind2 == $scope.descField.relations.length)
          //-- The field is not a relation, it's a simple attribute
          newObj[fn] = GlobalServices.getValueForDB(
            descField,
            fn,
            objectFields[fn],
            -1
          );
      }

      //-- Build GeoJSON object describing the object we want  to insert
      var features;
      features = {};
      features.type = 'FeatureCollection';
      features.features = [];
      features.features[0] = {};
      features.features[0].type = 'Feature';
      features.features[0].properties = newObj;
      if ($scope.objectFields['__geom__'] !== undefined && descField.geographic)
        features.features[0].geometry = $scope.objectFields['__geom__'];
      else features.features[0].geometry = {};

      //-- Insert the object into the database.
      EditFactory.add(descField.uid, features).then(function(res) {
        var objectId, indPt;
        if (res.data.errors.length != 0)
          gaJsUtils.errorMessage(
            'Echec de création !',
            'Table concernée: ' + descField.alias
          );
        else {
          //-- Refresh the map
          gclayers.refreshlayerByid(descField.uid, $scope.map);
          var created = res.data.create[0];
          if (created.id != undefined) {
            indPt = created.id.indexOf('.');
            objectId = created.id.substr(indPt + 1);
            $scope[tableName + '_id'] = created.id;
          }

          //-- Object has been created so we switch into update mode of this object.
          if (objectId != null) {
            $scope.insertRelatedObjects(
              fieldsForMoreRelation,
              newObj,
              objectId
            );
          }
          if (fieldsForMoreRelation.length == 0)
            $scope.$broadcast('gotObjectId', {
              objectId: $scope.objectId,
              layerName: $scope.config.featureName,
            });
          if (defer != undefined && sendResolve) defer.resolve('');
        }
      });
    };

    $scope.insertRelatedObjects = function(
      objectFields,
      parentObj,
      parentObjectId
    ) {
      var tableFn;
      var indPt,
        indTable,
        fieldsForMoreRelation = [],
        fieldsForInserting = [];
      var tables = $scope.getRelatedTables(objectFields);
      var newObjFields = {};
      var defer = $q.defer();

      for (indTable = 0; indTable < tables.length; indTable++) {
        for (var property in objectFields) {
          indPt = property.indexOf('.');
          if (property.substr(0, indPt) == tables[indTable]) {
            tableFn = property.substr(indPt + 1);
            newObjFields[tableFn] = objectFields[property];
            indPt = tableFn.indexOf('.');
            if (indPt != -1) fieldsForMoreRelation.push(tableFn);
            else fieldsForInserting.push(tableFn);
          }
        }
        $scope.insertInto(
          fieldsForMoreRelation,
          tables[indTable],
          fieldsForInserting,
          parentObj,
          parentObjectId,
          newObjFields,
          defer,
          indTable == tables.length - 1
        );
      }
      if (tables.length == 0)
        $timeout(function() {
          defer.resolve('');
        }, 200);
      return defer.promise;
    };

    $scope.manageActions = function(eventType) {
      var defer = $q.defer();
      var executingActions = false;

      if ($scope.config.events != undefined) {
        for (var ind = 0; ind < $scope.config.events.length; ind++) {
          if ($scope.config.events[ind].type == eventType) {
            $scope.execActionsInd = -1;
            $scope.actionsToExecute = angular.copy(
              $scope.config.events[ind].actions
            );
            $scope.execActionsNewValue = undefined;
            $scope.executeActions({ defer: defer });
            executingActions = true;
          }
        }
      }
      if (!executingActions) defer.resolve('');

      return defer.promise;
    };

    /**
     *      Method called on button click event in order to create an object
     *  in the database. When creation is done the idget switches to update mode.
     *  The back command let the user go back to the insert mode.
     */
    $scope.insertObject = function() {
      var ind, ind2;
      var newObj, fn, rel;
      var features;
      var crs = $scope.map
        .getView()
        .getProjection()
        .getCode();

      newObj = {};
      features = GlobalServices.initEditFeatures();
      $scope.manageActions('beforeCreate').then(function() {
        //-- Build a clean object with only physical fields (no relation).
        for (ind = 0; ind < $scope.descField.attributes.length; ind++) {
          fn = $scope.descField.attributes[ind].name;
          if (fn == 'id') continue;

          if (!$scope.manageRelation(fn, newObj))
            //-- The field is not a relation, it's a simple attribute
            newObj[fn] = GlobalServices.getValueForDB(
              $scope.descField,
              fn,
              $scope.objectFields[fn],
              -1
            );
        }
        //-- If a field value must be set from parent then add it here.
        //-- Typically this is the case for a parnet identifier which allows to establish the relation with this new object.
        if ($scope.parentId != undefined)
          newObj[$scope.parentId.fieldName] = $scope.parentId.fieldValue;
        //-- If a geometry field exists we get it (else we get undefined ... but it's OK')
        var theGeometry = $scope.objectFields['__geom__'];
        var crs = $scope.map
          .getView()
          .getProjection()
          .getCode();

        //-- Insert the object into the database.
        TypeProjetFactory.addObject(
          $scope.descField.uid,
          newObj,
          $scope.config.featureName,
          theGeometry,
          crs
        ).then(function() {
          $scope.objectId = TypeProjetFactory.resources.objectId;
          //-- Object has been created so we switch into update mode of this object.
          if ($scope.objectId != null) {
            $scope.theFeature = TypeProjetFactory.resources.addedFeature;
            if (Array.isArray($scope.theFeature)) {
              $scope.theFeature = JSON.parse($scope.theFeature[0].json);
              if (theGeometry != undefined) {
                if ($scope.theFeature.geometry == undefined)
                  $scope.theFeature.geometry = {};
                $scope.theFeature.geometry.coordinates =
                  theGeometry.coordinates;
              }
            }
            $scope.insertMode = false;
            $scope.updateMode = true;
            $scope
              .insertRelatedObjects(
                $scope.objectFields,
                newObj,
                $scope.objectId
              )
              .then(function(data) {
                $scope.$broadcast('gotObjectId', {
                  objectId: $scope.objectId,
                  layerName: $scope.config.featureName,
                });
                $scope.refreshMap();
                $scope.manageActions('onCreate');
              });
          }
        });
      });
    };

    $scope.updateOf = function(
      fieldsForMoreRelation,
      tableName,
      fieldsForInserting,
      parentObj,
      parentObjectId,
      objectFields
    ) {
      var fn,
        rel,
        newObj = {};
      var descField = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.config.datastoreName,
        tableName
      );
      for (var ind = 0; ind < descField.attributes.length; ind++) {
        fn = descField.attributes[ind].name;
        if (fn == 'id') continue;
        for (var ind2 = 0; ind2 < $scope.descField.relations.length; ind2++) {
          rel = $scope.descField.relations[ind2];
          if (rel.fieldEnd == fn) {
            //-- The field is a relation
            newObj[fn] = parentObjectId;
            break;
          }
        }
        if (ind2 == $scope.descField.relations.length)
          //-- The field is not a relation, it's a simple attribute
          newObj[fn] = GlobalServices.getValueForDB(
            descField,
            fn,
            objectFields[fn],
            -1
          );
      }

      //-- Build GeoJSON object describing the object we want  to update
      var features;
      features = {};
      features.type = 'FeatureCollection';
      features.features = [];
      features.features[0] = {};
      features.features[0].id = $scope[tableName + '_id'];
      features.features[0].type = 'feature';
      features.features[0].properties = newObj;
      features.features[0].geometry = {};

      //-- Insert the object into the database.
      EditFactory.update(descField.uid, features).then(function(res) {
        var objectId, indPt;
        var created = res.data.create[0];
        if (created != undefined && created.id != undefined) {
          indPt = created.id.indexOf('.');
          objectId = created.id.substr(indPt + 1);
        }

        //-- Object has been created so we switch into update mode of this object.
        if (objectId != undefined) {
          $scope.insertRelatedObjects(fieldsForMoreRelation, newObj, objectId);
        }
      });
    };

    $scope.updateRelatedObjects = function(
      objectFields,
      parentProperties,
      parentObjectId,
      params
    ) {
      var tableFn;
      var indPt,
        indTable,
        fieldsForMoreRelation = [],
        fieldsForUpdating = [];
      var tables, obj;
      if (params != undefined) {
        obj = {};
        obj[params.modifiedField] = '';
        tables = $scope.getRelatedTables(obj);
      } else tables = $scope.getRelatedTables(objectFields);
      var newObjFields = {};
      for (indTable = 0; indTable < tables.length; indTable++) {
        for (var property in objectFields) {
          indPt = property.indexOf('.');
          if (property.substr(0, indPt) == tables[indTable]) {
            tableFn = property.substr(indPt + 1);
            newObjFields[tableFn] = objectFields[property];
            indPt = tableFn.indexOf('.');
            if (indPt != -1) fieldsForMoreRelation.push(tableFn);
            else fieldsForUpdating.push(tableFn);
          }
        }
        $scope.updateOf(
          fieldsForMoreRelation,
          tables[indTable],
          fieldsForUpdating,
          parentProperties,
          parentObjectId,
          newObjFields
        );
      }
    };

    /**
     *     The field (attachment field) ask to be informed if an object
     *  is ebing edited and so will need its id and layer name.
     */
    $scope.$on('getObjectIdIfStateIsUpdate', function(event, data) {
      var elt;

      $scope.$broadcast('gotObjectId', {
        objectId: $scope.objectId,
        layerName: $scope.config.featureName,
      });
    });

    $scope.$on('gotRecordIdOfRelatedField', function(event, id) {
      //-- Store related object id in order to be ready for updating it.
      var indPt, idStr;
      if (id.trim != undefined) idStr = id;
      else idStr = id.id;
      indPt = idStr.indexOf('.');
      if (indPt == -1)
        gaJsUtils.errorMessage('Widget: id fourni incorrect !', '');
      else $scope[idStr.substr(0, indPt) + '_id'] = idStr;
    });

    $scope.updateObject = function() {
      var ab = 0;
      //-- Send message to modules indicating them
      //-- they have to update the inputs into the database.
      //-- At the moment this code is written the concerned module is the relationformfield
      //-- which have to update the related objects.
      $scope.$broadcast('updateAsked', {});

      $scope.updateTheObject();
    };

    /**
     *       Retrieve layer from OpenLayer map.
     */
    $scope.getLayer = function() {
      var layers = gclayers.getOperationalLayer();
      if ($scope.theLayer != undefined) return;
      for (var ind = 0; ind < layers.length; ind++)
        if (
          $scope.config.datastoreName == layers[ind].fti.storeName &&
          $scope.descField.name == layers[ind].fti.name
        )
          $scope.theLayer = layers[ind];
    };

    /**
     *     Refresh map layer by modifying the URL.
     *  "params" is the URL param list.
     */
    $scope.refreshMap = function() {
      $scope.getLayer();
      if ($scope.theLayer != undefined) {
        /*
                var params = $scope.theLayer.getSource().getParams();
                params.t = new Date().getMilliseconds();
                $scope.theLayer.getSource().updateParams(params);
                */
        //-- Refresh the map
        gclayers.refreshlayerByid($scope.theLayer.fti.uid, $scope.map);
      }
    };

    $scope.manageRelation = function(fn, newObj) {
      var ind2, rel;

      for (ind2 = 0; ind2 < $scope.descField.relations.length; ind2++) {
        rel = $scope.descField.relations[ind2];
        //-- Field name probably looks like id_xxxxx
        if (rel.fieldEnd == fn) {
          //-- The field is a relation so read the value from relation input field
          newObj[fn] = $scope.objectFields[rel.name];
          if (newObj[fn] === undefined && $scope.objectFields[fn] != undefined)
            newObj[fn] = $scope.objectFields[fn];
          if (newObj[fn] == '') newObj[fn] = null;
          break;
        }
      }
      return ind2 < $scope.descField.relations.length;
    };

    $scope.sameUpdateThanPrevious = function(senddata) {
      var now = new Date();
      var senddataAsStr;

      now = now.getTime();
      senddataAsStr = JSON.stringify(senddata);
      if (
        $scope.previoudUpdDate != undefined &&
        now - $scope.previoudUpdDate < 5000
      ) {
        if (senddataAsStr == $scope.previousSendataAsStr) {
          $scope.previoudUpdDate = now;
          return true;
        }
      }
      $scope.previousSendataAsStr = angular.copy(senddataAsStr);
      $scope.previoudUpdDate = now;
      return false;
    };

    /**
     *       Update the object with information stored on the fields.
     */
    $scope.updateTheObject = function(params) {
      var propertyName, fieldIndex, pointIndex;
      var senddata, idValue, ind;

      if ($scope.objectId === undefined) return;
      $scope.manageActions('beforeUpdate').then(function() {
        var crs = $scope.map
          .getView()
          .getProjection()
          .getCode();
        //-- Build GeoJSON object describing the object we want  to insert
        senddata = GlobalServices.initEditFeatures();
        pointIndex = ('' + $scope.objectId).indexOf('.');
        if (pointIndex != -1) senddata.features[0].id = $scope.objectId;
        else
          senddata.features[0].id =
            $scope.descField.name + '.' + $scope.objectId;

        //-- Get input values (set from input fields)
        for (
          ind = 0;
          ind < $scope.descField.attributes.length;
          ind++ //          for (propertyName in $scope.objectFields)
        ) {
          propertyName = $scope.descField.attributes[ind].name;
          fieldIndex = GlobalServices.getAttributeIndex(
            $scope.descField,
            propertyName
          );
          if (fieldIndex != -1) {
            if (
              !$scope.manageRelation(
                propertyName,
                senddata.features[0].properties
              )
            )
              senddata.features[0].properties[
                propertyName
              ] = GlobalServices.getValueForDB(
                $scope.descField,
                propertyName,
                $scope.objectFields[propertyName],
                fieldIndex
              );
          }
        }
        if (
          $scope.objectFields['__geom__'] !== undefined &&
          $scope.objectFields['__geom__'] != ''
        )
          senddata.features[0].geometry = $scope.objectFields['__geom__'];
        else {
          if ($scope.objectGeometry != undefined)
            senddata.features[0].geometry = $scope.objectGeometry;
          else senddata.features[0].geometry = {};
        }

        //-- Compléter pour ne pas perdre la valeur des champs non affichés.
        for (propertyName in $scope.objectFields) {
          fieldIndex = GlobalServices.getAttributeIndex(
            $scope.descField,
            propertyName
          );
          if (
            fieldIndex != -1 &&
            propertyName != '__geom__' &&
            propertyName.indexOf('.') == -1 &&
            senddata.features[0].properties[propertyName] === undefined
          )
            senddata.features[0].properties[propertyName] =
              $scope.objectFields[propertyName];
        }

        //-- If a field value must be set from parent then add it here.
        //-- Typically this is the case for a parnet identifier which allows to establish the relation with this new object.
        if ($scope.parentId != undefined)
          senddata.features[0].properties[$scope.parentId.fieldName] =
            $scope.parentId.fieldValue;

        if ($scope.sameUpdateThanPrevious(senddata)) return;
        EditFactory.update($scope.descField.uid, senddata, crs).then(function(
          res
        ) {
          var errorMsg;

          if (res.statusText != 'OK' || res.config.data.features.length == 0) {
            //console.log("Echec de mise à jour de ["+$scope.descField.name+"]");
            var errorMsg = '<h4>Erreur</h4> ';
            errorMsg +=
              '<br/><h4>Details</h4>  Echec de mise à jour de [' +
              $scope.descField.name +
              ']';
            require('toastr').error(errorMsg);
          } else {
            //-- On refait un update aprés exécution des actions.
            //-- Dans ce acs on ne rappelle pas les actions, sinon,
            //-- c'est le serpent qui se mord la queue.
            if (
              $scope.updateAgainAfterActions == undefined ||
              !$scope.updateAgainAfterActions
            ) {
              $scope.manageActions('afterUpdate');
              $scope.refreshMap();
            }
          }
        });

        if (
          params == undefined ||
          params.modifiedField == undefined ||
          params.modifiedField.indexOf('.') != -1
        )
          $scope.updateRelatedObjects(
            $scope.objectFields,
            senddata.features[0].properties,
            $scope.objectId,
            params
          );
      });
    };

    /**
     *
     */
    $scope.setErrMess = function(message) {
      $scope.errorMessage = message;
      //console.log("Message:"+message);
    };

    /**
     * TODO commenter
     */
    $scope.backToCreateMode = function() {
      $scope.objectId = null;
      $scope.insertMode = true;
      $scope.updateMode = false;
      $scope.$broadcast('gotObjectId', {
        objectId: $scope.objectId,
        layerName: $scope.config.featureName,
      });
    };

    /**
     *       When a value has been changed depending on mode we update the object.
     *   If the update mode is "global" then we wait the user to click on the update command.
     *   If the update mode is not "global" (default is "inline") then we automatically
     *   update the object when a value has been changed.
     */
    $scope.valueChangedFunction = true;
    $scope.valueChanged = function(params) {
      if (
        ($scope.widgetState == 'update' || $scope.updateMode) &&
        $scope.getCfgUpdateMode() != 'global'
      )
        if ($scope.actionsToExecute == undefined)
          $scope.updateTheObject(params);
      //-- Else the call to updateTheMethod will be called after the execution of the last action.
      if ($scope.infoFromChildren.existsRequiredValueWithNull)
        $scope.setErrMess('Champ obligatoire non renseigné !');
      else $scope.setErrMess('');
    };

    $scope.getValueForKeyWord = function(value) {
      //-- Can we get the value because it is a generic key word ?
      var params = { objectId: $scope.objectId, extraValues: $scope };
      var res = GlobalServices.getValueForKeyWord(value, params);
      if (res.done) return res.newValue;

      //-- Query key word result is replaced by previous query result value.
      if (value == '!result!') return $scope.execActionQueryResult;

      //-- Query key word result is replaced by previous query result value.
      if (value == '!result_count!') {
        if ($scope.execActionQueryResult == undefined) return 0;
        else if ($scope.execActionQueryResult.pop == undefined) return 1;
        else return $scope.execActionQueryResult.length;
      }

      return value;
    };

    $scope.getStringListFromArray = function(theArray, theSep) {
      var values = '';
      for (var ind = 0; ind < theArray.length; ind++) {
        if (values != '') values += ',';
        values += theSep + theArray[ind] + theSep;
      }
      return values;
    };

    $scope.getValueFromStoredVariable = function(varname) {
      var sep = '',
        value;

      if ($scope[varname].type == 'java.lang.String') sep = "'";
      if ($scope[varname].value == undefined) value = undefined;
      else if ($scope[varname].value.push != undefined)
        value = $scope.getStringListFromArray($scope[varname].value, sep);
      else value = sep + $scope[varname].value + sep;
      return value;
    };

    /**
     *     Replace a date in the format JJ/MM/AAAA (DD/MM/YYYY)
     *  into a query date inside the where clause itself.
     */
    $scope.setWhereDateValue = function(where, ind) {
      //-- get only the DATE part which is something like DATE(01/01/1970)
      var subWhere = where.substr(ind + 1);
      var indExcl = subWhere.indexOf('!');
      subWhere = subWhere.substr(0, indExcl);

      //-- Extract the day number
      var indSlash = subWhere.indexOf('/');
      var day = subWhere.substr(5, indSlash - 5);

      //-- Extract the month number
      var month = subWhere.substr(indSlash + 1);
      var indSlash = month.indexOf('/');
      month = month.substr(0, indSlash);

      //-- Extract the year
      indSlash = subWhere.lastIndexOf('/');
      var year = subWhere.substr(indSlash + 1, 4);

      //-- Format the date for the query
      var theDate = '' + year + '-' + month + '-' + day + 'T12:00:00+00:00';

      //-- Return updated where clause
      return where.substr(0, ind) + theDate + where.substr(ind + indExcl + 2);
    };

    $scope.execActionBuildWhere = function(where) {
      var whereRes, reg, ind, value;

      //-- Query key word CURRENT_YEAR replaced by current full year value such as 2015.
      reg = new RegExp('!CURRENT_YEAR!', 'g');
      whereRes = where.replace(reg, '' + gaJsUtils.getCurrentYear());

      //-- !DATE(dd/mm/yyyy)!  which may first have been !DATE(dd/mm/!CURRENT_YEAR!)!
      ind = whereRes.indexOf('!DATE');
      while (ind != -1) {
        whereRes = $scope.setWhereDateValue(whereRes, ind);
        ind = whereRes.indexOf('!DATE');
      }

      //-- Query key word result is replaced by previous query result value.
      reg = new RegExp('!result!', 'g');
      whereRes = whereRes.replace(reg, $scope.execActionQueryResult);

      //-- Query key word results is replaced by previous query result values between parenthesis.
      if (whereRes.indexOf('!results!') != -1) {
        var sep = '';
        reg = new RegExp('!results!', 'g');
        if ($scope.execActionQueryResultType == 'java.lang.String') sep = "'";
        value = $scope.getStringListFromArray(
          $scope.execActionQueryResult,
          sep
        );
        whereRes = whereRes.replace(reg, '(' + value + ')');
      }

      //-- Query key word !variable! is followed by ".!nom_variable!"
      //-- so get that value stored in the scope whether it is a single value or an array
      //-- and replace the key string "!variable!.!ma_variable!" by this value.
      ind = whereRes.indexOf('!variable!');
      if (ind != -1) {
        var ind1 = whereRes.indexOf('!', ind + 11);
        var ind2 = whereRes.indexOf('!', ind1 + 1);
        var varname = whereRes.substr(ind1 + 1, ind2 - ind1 - 1);

        reg = new RegExp('!variable!.!' + varname + '!', 'g');
        whereRes = whereRes.replace(
          reg,
          '(' + $scope.getValueFromStoredVariable(varname) + ')'
        );
      }

      //-- Query key word results is replaced by previous query result values between parenthesis.
      reg = new RegExp('!new_value!', 'g');
      whereRes = whereRes.replace(reg, $scope.execActionsNewValue);

      //-- Query key word THIS_OBJECT_ID is replaced by the id of the object managed in this widget.
      reg = new RegExp('!THIS_OBJECT_ID!', 'g');
      if ($scope.objectId != undefined)
        whereRes = whereRes.replace(reg, $scope.objectId);
      else whereRes = whereRes.replace(reg, '-1');

      //-- Query key word THIS_OBJECT_FIELD_VALUE_fieldname is replaced by the field value.
      ind = whereRes.indexOf('!THIS_OBJECT_FIELD_VALUE_');
      if (ind != -1) {
        var ind2 = whereRes.indexOf('!', ind + 1);
        value = whereRes.substr(ind + 25, ind2 - ind - 25);
        value = $scope.objectFields[value];
        whereRes = whereRes.substr(0, ind) + value + whereRes.substr(ind2 + 1);
      }

      ind = whereRes.indexOf('!PARENT_ID!');
      if (ind != -1) {
        //-- Query key word PARENT_ID refers to the main object which is a parent
        //-- related to the object field which is being modifiedField.
        //-- Example: Modifiying the field "resilie" of table day_marche_resiliation
        //--          -> PARENT_ID is the ID of the marche.
        if ($scope.parentId != undefined) {
          reg = new RegExp('!PARENT_ID!', 'g');
          whereRes = whereRes.replace(reg, $scope.parentId.fieldValue);
        }
      }

      //-- Query key word NULL is replaced by the null value.
      reg = new RegExp('!NULL!', 'g');
      whereRes = whereRes.replace(reg, 'null');

      return whereRes;
    };

    $scope.execActionGetValueFromQuery = function(action, params) {
      var tableDesc, where;

      tableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        action.storeName,
        action.featureType
      );
      where = $scope.execActionBuildWhere(action.where);
      console.log(
        'GetValueFromQuery: table=' + tableDesc.name + ' ; where =' + where
      );
      QueryFactory.data(tableDesc.uid, where).then(function(res) {
        $scope.execActionQueryResult = null;
        console.log(
          'GetValueFromQuery: (table=' +
            tableDesc.name +
            ' ; where =' +
            where +
            ')  res.data.features.length=' +
            res.data.features.length
        );
        if (res.data.features.length != 0)
          if (action.resultField == 'id') {
            $scope.execActionQueryResultType = 'java.lang.Integer';
            $scope.execActionQueryResult = QueryFactory.getFeatureId(
              res.data.features[0]
            );
          } else {
            $scope.execActionQueryResult =
              res.data.features[0].properties[action.resultField];
            $scope.execActionQueryResultType =
              tableDesc.attributes[action.resultField].type;
          }
        //-- When action query is done execute next action that will probably
        //-- use the result and more precisely the field value we got.
        $scope.executeActions(params);
      });
    };

    $scope.execActionGetValuesFromQuery = function(action, params) {
      var tableDesc, where;

      tableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        action.storeName,
        action.featureType
      );
      where = $scope.execActionBuildWhere(action.where);
      console.log(
        'GetValuesFromQuery: table=' +
          tableDesc.name +
          ' ; where =' +
          where +
          ''
      );
      QueryFactory.data(tableDesc.uid, where).then(function(res) {
        var ind, len;
        $scope.execActionQueryResult = null;
        len = res.data.features.length;
        console.log(
          'GetValuesFromQuery: (table=' +
            tableDesc.name +
            ' ; where =' +
            where +
            ')  res.data.features.length=' +
            len
        );
        $scope.execActionQueryResult = [];
        for (ind = 0; ind < len; ind++) {
          if (action.resultField == 'id')
            $scope.execActionQueryResult.push(
              QueryFactory.getFeatureId(res.data.features[ind])
            );
          else
            $scope.execActionQueryResult.push(
              res.data.features[ind].properties[action.resultField]
            );
        }
        if (action.resultField == 'id')
          $scope.execActionQueryResultType = 'java.lang.Integer';
        else {
          for (ind = 0; ind < tableDesc.attributes.length; ind++)
            if (tableDesc.attributes[ind].name == action.resultField) {
              $scope.execActionQueryResultType = tableDesc.attributes[ind].type;
              break;
            }
        }

        //-- When action query is done execute next action that will probably
        //-- use the result and more precisely the field value we got.
        $scope.executeActions(params);
      });
    };

    /**
         *      In case the configuration parameter "delRelatedObjects" is defined
         *  in the "DelObjectInDb" action, this method call the "deleteWhere"
         *  method in order to remove related objects.
         *  It works for 1-1 or 1-N relations where the child table
         *  has a field containing the value of the parent identifier.
         *  This child field name is configured in the "idField" parameter.
         *  Example of configuration:
         *   "delRelatedObjects":
                    [
                     {"featureType":"day_marcche_etape_procedure", "idField":"id_marche"}
                    ]
              }
         */
    $scope.delRelatedObjects = function(action, id) {
      var relTable, delRelAction;

      if (action.delRelatedObjects != undefined)
        for (
          var indRel = 0;
          indRel < action.delRelatedObjects.length;
          indRel++
        ) {
          delRelAction = action.delRelatedObjects[indRel];
          relTable = FeatureTypeFactory.getFeatureTypeDesc(
            action.storeName,
            delRelAction.featureType
          );
          EditFactory.deleteWhere(
            relTable.uid,
            delRelAction.idField + '=' + id
          );
        }
    };

    /**
     *     This action add an object as described in the field
     *  trigger list of actions.
     */
    $scope.execActionDelObjInDb = function(action, params) {
      var tableDesc, where;

      tableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        action.storeName,
        action.featureType
      );
      where = $scope.execActionBuildWhere(action.where);
      QueryFactory.data(tableDesc.uid, where).then(function(res) {
        var id,
          idList = '';

        for (var ind = 0; ind < res.data.features.length; ind++) {
          if (idList != '') idList += ',';
          id = QueryFactory.getFeatureId(res.data.features[ind]);
          idList += id;
          $scope.delRelatedObjects(action, id);
        }
        EditFactory.remove(tableDesc.uid, idList).then(function() {
          //-- When remove action is done execute next action
          $scope.executeActions(params);
        });
      });
    };

    $scope.getIdListFromActionDesc = function(action) {
      if (action.ids.indexOf('!actionResults!.') == 0) {
        var featIds =
          $scope.actionResults[action.ids.substr(17, action.ids.length - 18)];
        if (featIds != undefined) return featIds.join();
      }
      return undefined;
    };

    /**
     *     This action delete objects as described from an id list or building the idlist from the action description.
     */
    $scope.execActionDelObjInDbByIds = function(
      action,
      params,
      pTableDesc,
      pIdList
    ) {
      var tableDesc, where;

      var id,
        idList = '';

      tableDesc = pTableDesc;
      if (tableDesc == undefined)
        tableDesc = FeatureTypeFactory.getFeatureTypeDesc(
          action.storeName,
          action.featureType
        );
      idList = pIdList;
      if (idList == undefined) idList = $scope.getIdListFromActionDesc(action);
      if (idList == undefined) $scope.executeActions(params);
      else
        EditFactory.remove(tableDesc.uid, idList).then(function() {
          //-- When remove action is done execute next action
          $scope.executeActions(params);
        });
    };

    /**
     *      Extract id from object looking like the following description:
     *
     *         create: Object
     *           day_marche.17: "SimpleFeatureImpl:day_marche=[SimpleFeatureImpl.Attribute: date_signature<date_signature id=fid-10f5afde_14bca1ccfb2_-7f7a>=null,
     *                           ...
     *                           SimpleFeatureImpl.Attribute: id_projet<id_projet id=fid-10f5afde_14bca1ccfb2_-7f7a>=32]"
     */
    $scope.getIdFromCreateRes = function(createRet, tableName) {
      var idPrefix = tableName + '.';
      if (createRet.id.substr(0, idPrefix.length) == idPrefix)
        return createRet.id.substr(idPrefix.length);
    };

    $scope.prepareActionresults = function(action, res) {
      /*
       *
       *  res content extract example (when creation is OK):
       *      Object
       *        config: Object
       *          data: Object
       *            create: Object
       *              day_marche.17: "SimpleFeatureImpl:day_marche=[SimpleFeatureImpl.Attribute: date_signature<date_signature id=fid-10f5afde_14bca1ccfb2_-7f7a>=null,
       *                              ...
       *                              SimpleFeatureImpl.Attribute: id_projet<id_projet id=fid-10f5afde_14bca1ccfb2_-7f7a>=32]"
       */
      if (action.storeResults != undefined) {
        if ($scope.actionResults == undefined) $scope.actionResults = {};
        if (action.storeResults.value == 'id') {
          $scope.actionResults[action.storeResults.property] = [];
          for (var indRes = 0; indRes < res.data.create.length; indRes++)
            $scope.actionResults[action.storeResults.property].push(
              $scope.getIdFromCreateRes(
                res.data.create[indRes],
                action.featureType
              )
            );
        }
      }
    };

    /**
     *     This action add an object as described in the field
     *  trigger list of actions.
     */
    $scope.execActionAddObjInDb = function(action, params) {
      var tableDesc,
        prop = {},
        fv;

      tableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        action.storeName,
        action.featureType
      );

      //-- Build GeoJSON object describing the object we want  to insert
      var features = {};
      features.type = 'FeatureCollection';
      features.features = [];
      features.features[0] = {};
      features.features[0].type = 'feature';

      for (var ind = 0; ind < action.fields.length; ind++) {
        switch (action.fields[ind].valueType) {
          case 'lastQueryResult':
            fv = $scope.execActionQueryResult;
            break;
          case 'thisObjectId':
            fv = $scope.objectId;
            break;
          case 'constant':
            fv = action.fields[ind].fieldValue;
            break;
          case 'thisObjectProperty':
            if ($scope.objectFields[action.fields[ind].fieldName] != undefined)
              fv = $scope.objectFields[action.fields[ind].fieldName];
            break;
        }
        prop[action.fields[ind].name] = fv;
      }
      features.features[0].properties = prop;

      features.features[0].geometry = {};

      EditFactory.add(tableDesc.uid, features).then(function(res) {
        $scope.prepareActionresults(action, res);
        //-- Prevent children a possibly related object has been created
        $scope.$broadcast('maybeChildCreatedAfterInsertingMainObject', {});
        //-- When add action is done execute next action
        $scope.executeActions(params);
      });
    };

    /**
     *     This action add an object as described in the field
     *  trigger list of actions.
     */
    $scope.execActionAddObjectsInDb = function(action, params) {
      var tableDesc,
        prop = {};

      tableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        action.storeName,
        action.featureType
      );

      $scope.addObjects_ObjCount = $scope.execActionQueryResult.length;

      //-- Build GeoJSON object describing the object we want  to insert
      var fv,
        features = {};
      features.type = 'FeatureCollection';
      features.features = [];

      for (var indRes = 0; indRes < $scope.addObjects_ObjCount; indRes++) {
        features.features[indRes] = {};
        features.features[indRes].type = 'feature';
        for (var ind = 0; ind < action.fields.length; ind++) {
          switch (action.fields[ind].valueType) {
            case 'lastQueryResult':
              fv = $scope.execActionQueryResult[indRes];
              break;
            case 'thisObjectId':
              fv = $scope.objectId;
              break;
            case 'constant':
              fv = action.fieldValue;
              break;
            case 'thisObjectProperty':
              if (
                $scope.objectFields[action.fields[ind].fieldName] != undefined
              )
                fv = $scope.objectFields[action.fields[ind].fieldName];
              break;
          }
          prop[action.fields[ind].name] = fv;
        }
        features.features[indRes].properties = angular.copy(prop);

        features.features[indRes].geometry = {};
      }

      EditFactory.add(tableDesc.uid, features).then(function(res) {
        /*
         *
         *  res content extract example (when creation is OK):
         *      Object
         *        config: Object
         *          data: Object
         *            create: Object
         *              day_marche.17: "SimpleFeatureImpl:day_marche=[SimpleFeatureImpl.Attribute: date_signature<date_signature id=fid-10f5afde_14bca1ccfb2_-7f7a>=null,
         *                              ...
         *                              SimpleFeatureImpl.Attribute: id_projet<id_projet id=fid-10f5afde_14bca1ccfb2_-7f7a>=32]"
         */
        if (action.storeResult != undefined) {
          if ($scope.actionResults == undefined) $scope.actionResults = {};
          if (action.storeResult.value == 'id')
            $scope.actionResults[
              action.storeResult.property
            ] = $scope.getIdFromCreateRes(
              res.data.create[0],
              action.featureType
            );
        }
        //-- When add action is done execute next action
        $scope.executeActions(params);
      });
    };

    $scope.buildIdList = function(action) {
      var ids = '',
        reg;

      if (action.ids == '!lastQueryResult!')
        ids = $scope.execActionQueryResult.toString();
      else if (action.ids.indexOf('!variable!') == 0) {
        //-- Ids have been stored in variable indexed by following key word example:
        //-- !variable!.!idEtape!
        var ind2 = action.ids.indexOf('!', 12);
        var varname = action.ids.substr(12, ind2 - 12);
        ids = $scope.getValueFromStoredVariable(varname);
      } else ids = action.ids;

      if (ids.indexOf('!PARENT_ID!') == 0) {
        //-- Query key word PARENT_ID refers to the main object which is a parent
        //-- related to the object field which is being modifiedField.
        //-- Example: Modifiying the field "resilie" of table day_marche_resiliation
        //--          -> PARENT_ID is the ID of the marche.
        if ($scope.execActionsParentId != undefined) {
          reg = new RegExp('!PARENT_ID!', 'g');
          ids = ids.replace(reg, $scope.execActionsParentId);
        }
      }

      return ids;
    };
    /**
     *     This action update objects as described in the field
     *  trigger list of actions.
     */
    $scope.execActionUpdateOneFieldByIds = function(action, params) {
      var tableDesc,
        prop = {},
        fv,
        ids,
        indField,
        fieldType;

      tableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        action.storeName,
        action.featureType
      );

      ids = $scope.buildIdList(action);

      for (indField = 0; indField < action.fields.length; indField++) {
        fieldType = action.fields[indField].type.toLowerCase();
        EditFactory.updatebyid(
          tableDesc.uid,
          ids,
          action.fields[indField].name,
          fieldType,
          action.fields[indField].value
        ).then(function(res) {
          if (indField == action.fields.length)
            //-- When update action is done execute next action
            $scope.executeActions(params);
        });
      }
    };

    $scope.execActionSetFieldValue = function(action, params) {
      if (action.valueType == 'constant')
        $scope.objectFields[action.fieldName] = action.fieldValue;
      else if (action.valueType == 'expression')
        $scope.objectFields[action.fieldName] = $scope.getValueForKeyWord(
          action.fieldValue
        );
      else if (action.valueType == 'resultOfPreviousQuery')
        $scope.objectFields[action.fieldName] = $scope.execActionQueryResult;
      if (action.broadcastValueToUserInterface)
        $scope.$broadcast('fieldValueModifiedOnMainWidget', {
          fieldName: action.fieldName,
          fieldValue: $scope.objectFields[action.fieldName],
        });
      //-- When set value action is done execute next action
      $scope.executeActions(params);
    };

    /**
     *      The action consists in creating the steps of the procedure
     *  for the project or one table relating to the project.
     *  An example of table relating to the project is the "marche"
     *  for a "projet" project of Yamoussoukro.
     */
    $scope.execActionApplyProcSteps = function(action, params) {
      var newConfig;

      if (
        action.projectIdFieldOfType == '__none__' ||
        ($scope.objectFields[action.projectIdFieldOfType] != undefined &&
          $scope.objectFields[action.projectIdFieldOfType] != null)
      ) {
        var config = {},
          projectIds = [],
          indId;
        config.storeName = action.storeName;
        config.projectTableName = action.projectTableName;
        config.stepTableName = action.stepTableName;
        config.predefStepTableName = action.predefStepTableName;
        config.predefStepIdFieldOfType = action.predefStepIdFieldOfType;
        if (action.projectIdFieldOfType != '__none__')
          config.predefStepTypeId =
            $scope.objectFields[action.projectIdFieldOfType];
        else config.predefStepTypeId = '__none__';
        config.projectIdFieldOfStepTable = action.projectIdFieldOfStepTable;
        config.projectIdFieldOfType = action.projectIdFieldOfType;

        //-- Current main object id is used to build the relation between
        //-- project and its steps unless "projectValueOfIdFieldOfStepTableFromStoredResult"
        //-- tell us to use another value (means that we are creating the steps
        //-- of another table than the project one)
        if (
          action.projectValueOfIdFieldOfStepTableFromStoredResult !=
            undefined &&
          action.projectValueOfIdFieldOfStepTableFromStoredResult != ''
        )
          projectIds.push(
            $scope.actionResults[
              action.projectValueOfIdFieldOfStepTableFromStoredResult
            ]
          );
        else if (
          action.projectValueOfIdFieldOfStepTableFromStoredResults !=
            undefined &&
          action.projectValueOfIdFieldOfStepTableFromStoredResults != ''
        ) {
          projectIds = $scope.actionResults[config.projectIdFieldOfStepTable];
        } else if (
          action.projectValueOfIdFieldOfStepTableFromQueryResult === 'true' &&
          $scope.execActionQueryResult != undefined
        ) {
          for (indId = 0; indId < $scope.execActionQueryResult.length; indId++)
            projectIds.push($scope.execActionQueryResult[indId]);
        } else projectIds.push($scope.objectId);

        $scope.applyProcSteps_ProjectIdCount = projectIds.length;
        $scope.applyProcSteps_ProjectIdDone = 0;
        for (var ind = 0; ind < $scope.applyProcSteps_ProjectIdCount; ind++) {
          newConfig = angular.copy(config);
          newConfig.projectId = projectIds[ind];
          ApplyProcedureFactory.apply(newConfig).then(function() {
            //-- One more project ID has been treated
            $scope.applyProcSteps_ProjectIdDone++;
            //-- If the count of project ids to treat is reached, we can execute next action.
            if (
              $scope.applyProcSteps_ProjectIdDone ==
              $scope.applyProcSteps_ProjectIdCount
            )
              $scope.executeActions(params);
          });
        }
      } else $scope.executeActions(params);
    };

    /**
     *      The action consists in creating the steps of the procedure
     *  for the project or one table relating to the project.
     *  An example of table relating to the project is the "marche"
     *  for a "projet" project of Yamoussoukro.
     */
    $scope.execActionDeleteProcSteps = function(action, params) {
      var newConfig;

      if (
        action.projectIdFieldOfType == '__none__' ||
        ($scope.objectFields[action.projectIdFieldOfType] != undefined &&
          $scope.objectFields[action.projectIdFieldOfType] != null)
      ) {
        //-- STEPS
        //-- Get procedure record
        //-- Delete each record from specific table
        //-- Delete procedure record
        var config = {},
          projectIds = [],
          indId;
        config.storeName = action.storeName;
        config.projectTableName = action.projectTableName;
        config.stepTableName = action.stepTableName;
        config.predefStepTableName = action.predefStepTableName;
        config.predefStepIdFieldOfType = action.predefStepIdFieldOfType;
        if (action.projectIdFieldOfType != '__none__')
          config.predefStepTypeId =
            $scope.objectFields[action.projectIdFieldOfType];
        else config.predefStepTypeId = '__none__';
        config.projectIdFieldOfStepTable = action.projectIdFieldOfStepTable;
        config.projectIdFieldOfType = action.projectIdFieldOfType;

        //-- Current main object id is used to build the relation between
        //-- project and its steps unless "projectValueOfIdFieldOfStepTableFromStoredResult"
        //-- tell us to use another value (means that we are creating the steps
        //-- of another table than the project one)
        if (
          action.projectValueOfIdFieldOfStepTableFromStoredResult !=
            undefined &&
          action.projectValueOfIdFieldOfStepTableFromStoredResult != ''
        )
          projectIds.push(
            $scope.actionResults[
              action.projectValueOfIdFieldOfStepTableFromStoredResult
            ]
          );
        else if (
          action.projectValueOfIdFieldOfStepTableFromStoredResults !=
            undefined &&
          action.projectValueOfIdFieldOfStepTableFromStoredResults != ''
        ) {
          projectIds = $scope.actionResults[config.projectIdFieldOfStepTable];
        } else if (
          action.projectValueOfIdFieldOfStepTableFromQueryResult === 'true' &&
          $scope.execActionQueryResult != undefined
        ) {
          for (indId = 0; indId < $scope.execActionQueryResult.length; indId++)
            projectIds.push($scope.execActionQueryResult[indId]);
        } else projectIds.push($scope.objectId);

        $scope.applyProcSteps_ProjectIdCount = projectIds.length;
        $scope.applyProcSteps_ProjectIdDone = 0;
        for (var ind = 0; ind < $scope.applyProcSteps_ProjectIdCount; ind++) {
          newConfig = angular.copy(config);
          newConfig.projectId = projectIds[ind];
          ApplyProcedureFactory.deleteProcedure(newConfig).then(function() {
            //-- One more project ID has been treated
            $scope.applyProcSteps_ProjectIdDone++;
            //-- If the count of project ids to treat is reached, we can execute next action.
            if (
              $scope.applyProcSteps_ProjectIdDone ==
              $scope.applyProcSteps_ProjectIdCount
            )
              $scope.executeActions(params);
          });
        }
      } else $scope.executeActions(params);
    };

    $scope.execActionUpdateWhere = function(action, params) {
      var ft = FeatureTypeFactory.getFeatureTypeDesc(
        action.storeName,
        action.featureType
      );
      var where = $scope.execActionBuildWhere(action.where);
      EditFactory.updateWhere(ft.uid, where, action.formulas).then(function() {
        $scope.executeActions(params);
      });
    };

    $scope.sendMail = function(action, params) {
      GceSendMailServices.init(action.fieldName, action.storeName, $scope).then(
        function(res) {
          if (res.status == 'ok') {
            GceSendMailServices.sendMail(res.ctxId).then(function(res) {
              if (res.status == 'ok') {
                $scope.objectFields[action.fieldName] = res.mailContent;
                $scope.$broadcast('mailSentFromWidget', {
                  fieldName: action.fieldName,
                  mailContent: res.mailContent,
                });
              }
              $scope.executeActions(params);
            });
          }
        }
      );
    };

    $scope.computeFromPreviousResult = function(action, params) {
      var ind, res;

      switch (action.operation) {
        case 'sum':
          res = 0;
          for (ind = 0; ind < $scope.execActionQueryResult.length; ind++)
            res += $scope.execActionQueryResult[ind];
          break;
      }

      $scope[action.storeIntoVariable] = res;

      $scope.executeActions(params);
    };

    $scope.evaluateLogicalExpression = function(action, params) {
      var evalParams, ind;

      evalParams = {};
      evalParams.extraValues = $scope;
      evalParams.objectFields = $scope.objectFields;
      action.logicalCondition.operation = $scope.execActionBuildWhere(
        action.logicalCondition.operation
      );
      if (
        GlobalServices.evaluateSimpleExpression(
          action.logicalCondition,
          evalParams
        )
      ) {
        if (action.whenTrue != undefined) {
          for (ind = 0; ind < action.whenTrue.actions.length; ind++)
            $scope.actionsToExecute.splice(
              $scope.execActionsInd + 1 + ind,
              0,
              action.whenTrue.actions[ind]
            );
        }
      } else {
        if (action.whenFalse != undefined) {
          for (ind = 0; ind < action.whenFalse.actions.length; ind++)
            $scope.actionsToExecute.splice(
              $scope.execActionsInd + 1 + ind,
              0,
              action.whenFalse.actions[ind]
            );
        }
      }
      $scope.executeActions(params);
    };

    $scope.executeAction = function(action, params) {
      console.log('executeAction: action.type=' + action.type);
      switch (action.type) {
        case 'SetFieldValue':
          $scope.execActionSetFieldValue(action, params);
          break;
        case 'GetValueFromQuery':
          $scope.execActionGetValueFromQuery(action, params);
          break;
        case 'GetValuesFromQuery':
          $scope.execActionGetValuesFromQuery(action, params);
          break;
        case 'AddObjectInDb':
          $scope.execActionAddObjInDb(action, params);
          break;
        case 'DelObjectInDb':
          $scope.execActionDelObjInDb(action, params);
          break;
        case 'DelObjectInDbByIds':
          $scope.execActionDelObjInDbByIds(action, params);
          break;
        case 'ApplyProcedureSteps':
          $scope.execActionApplyProcSteps(action, params);
          break;
        case 'DeleteProcedureSteps':
          $scope.execActionDeleteProcSteps(action, params);
          break;
        case 'UpdateOneFieldByIds':
          $scope.execActionUpdateOneFieldByIds(action, params);
          break;
        case 'ExecuteUpdateWhere':
          $scope.execActionUpdateWhere(action, params);
          break;
        case 'ComputeFromPreviousResult':
          $scope.computeFromPreviousResult(action, params);
          break;
        case 'Logical':
          $scope.evaluateLogicalExpression(action, params);
          break;
        case 'ErrorMessage':
          gaJsUtils.errorMessage(action.message);
          $scope.executeActions(params);
          break;
        case 'StoreCurrentValue':
          $scope[action.variableName] = {};
          if (action.variableValue == '!result!')
            $scope[action.variableName].value = $scope.execActionQueryResult;
          else if (action.variableValue == '!results!')
            $scope[action.variableName].value = $scope.execActionQueryResult;
          $scope[action.variableName].type = $scope.execActionQueryResultType;
          $scope.executeActions(params);
          break;
        case 'SendMail':
          $scope.sendMail(action);
          break;
      }
    };

    $scope.actionConditionIsOk = function(action) {
      var val1, val2;

      val1 = $scope.getValueForKeyWord(action.condition.litteral);
      val2 = $scope.getValueForKeyWord(action.condition.value);

      switch (action.condition.operator) {
        case '=':
          return (val1 = val2);
        case '<>':
          return val1 != val2;
        case '>':
          return val1 > val2;
        case '>=':
          return val1 >= val2;
        case '<':
          return val1 < val2;
        case '<=':
          return val1 <= val2;
      }
    };

    /**
     *     It's possible from configuration to add behaviors
     *  on value change for the form fields.
     *  So when it is the case, this function execute the actions
     *  associated to this field modification.
     *  This actions are described on the field configuration.
     *
     *  Possible action types are:
     *  - SetFieldValue
     *  - GetValueFromQuery
     *  - GetValuesFromQuery
     *  - AddObjectInDb
     *  - DelObjectInDb
     *  - ApplyProcedureSteps
     *  - ExecuteUpdateWhere
     *  - StoreCurrentValue
     */
    $scope.executeActions = function(params) {
      var action;

      if ($scope.actionsToExecute == undefined) return;
      //-- Index of next action
      $scope.execActionsInd++;
      if ($scope.execActionsInd >= $scope.actionsToExecute.length) {
        //-- After actions the object may have been modified, so we update it.
        //-- Anyway, the value changed method won't be called from form field panel
        //-- when actions have to be executed.
        if (!$scope.insertMode) {
          $scope.updateAgainAfterActions = true;
          $scope.updateTheObject();
          $scope.updateAgainAfterActions = false;
        }
        $scope.actionsToExecute = undefined;
        if (params != undefined && params.defer != undefined)
          params.defer.resolve('');
        return;
      }

      //-- Get action
      action = $scope.actionsToExecute[$scope.execActionsInd];

      //-- If there is a condition to execute the action controle it.
      //-- If the condition is OK then execute the action else skip to the next one.
      if (action.condition != undefined && !$scope.actionConditionIsOk(action))
        $scope.executeActions(params);
      else $scope.executeAction(action, params);
    };

    /**
     *     The field (attachment field) ask to be informed if an object
     *  is being edited and so will need its id and layer name.
     */
    $scope.$on('thereIsAnActionToTriggerAfterChange', function(event, params) {
      $scope.execActionsInd = -1;
      $scope.actionsToExecute = params.actions;
      $scope.execActionsNewValue = params.newValue;
      $scope.execActionsParentId = params.parentId;
      $scope.executeActions();
    });

    $scope.saveConfig = function() {
      var theConfig = $scope.config;
      if (
        $scope.$$childHead != null &&
        $scope.$$childHead.panelFields != undefined
      ) {
        theConfig.panelFields = [];
        for (var iFld = 0; iFld < $scope.$$childHead.panelFields.length; iFld++)
          theConfig.panelFields.push({
            field: $scope.$$childHead.panelFields[iFld].field,
          });
      }
      ConfigFactory.add(theConfig, 'creation_projet', $scope.ConfigName);
    };
  };

  TypeProjetCtrl.$inject = [
    '$scope',
    'TypeProjetFactory',
    'ConfigFactory',
    'QueryFactory',
    'EditFactory',
    'FeatureTypeFactory',
    'ApplyProcedureFactory',
    'gclayers',
    'GlobalServices',
    'GceSendMailServices',
    '$timeout',
    '$q',
    'gaJsUtils',
  ];
  return TypeProjetCtrl;
});
