/**
 *
 *        Send mail object
 *
 *
 */
'use strict';
g2cSendMailOb = {
  mailFieldName: '',
  datastoreName: '',
  featureTypeFactory: {},
  queryFactory: {},

  /**
   *    Get the mail description from the database table named "g2cenvoimail".
   *  To get the description of the mail we want to send from this field,
   *  we make a query on its name. The mail name is the second part of this field name.
   *  This field name is like "g2cenvoimail_mailname".
   */
  getMailDescriptionFromDB: function() {
    //-- Get mail name.
    var mailName = this.mailFieldName.substr(13);
    //-- Get the description of the table named "g2cenvoimail"
    //-- which contains the description of the mails.
    var fti = this.featureTypeFactory.getFeatureTypeDesc(
      this.datastoreName,
      'g2cenvoimail'
    );
    //-- Filter to obtain only the information of the mail concerned by this field.
    var where = "nom='" + mailName + "'";

    this.queryFactory.data(fti.uid, where).then(function(res) {
      if (res.data.features.length != 0) {
        //-- We got the mail description, so load it in the scope.
        this.mailDesc = res.data.features[0];
        this.buildMailRecipientList();
        this.buildMailContent();
      }
    });
  },

  /**
   *     Html of the send mail confirmation dialog box.
   */
  getSendConfirmHtml: function(envoiOuRenvoi) {
    var dialogContent;
    if (envoiOuRenvoi == 'envoi')
      dialogContent = "<div>Confirmez vous l'envoi du mail ?</div>";
    else dialogContent = '<div>Confirmez vous le renvoi du mail ?</div>';
    dialogContent += '<div>';
    dialogContent += "  <button ng-click='sendMailOk()'>Oui</button>";
    dialogContent += "  <button ng-click='sendmailAbort()'>Non</button>";
    dialogContent += '</div>';

    return dialogContent;
  },

  /**
   *    Store directly in a scope property the boolean value
   *  indicating if a mail has already been sent for this field.
   */
  setMailAlreadySent: function() {
    //----------- recuperer valeur depuis base de données ?
    this.mailAlreadySent =
      this.objectField.value != undefined && this.objectField.value != '';
  },

  /**
   *    Recursive function that look for a field in the widget.
   * The field we are looking for is identified by its name.
   * So this field is a table field that must be present in the widget.
   */
  getFieldValueFromParent: function(fieldName, theScope) {
    //-- If previous scope has no parent, or
    //-  max depth is reached no value found, so return empty string.
    if (theScope == undefined) return '';
    if (this.depthForFieldRecursiveSearch++ > 6) return '';

    //-- Look if a child contains the field.
    //-- If so return its value.
    for (var cs = theScope.$$childHead; cs; cs = cs.$$nextSibling) {
      if (cs.theField01 != undefined)
        if (cs.theField01.objectField.name == fieldName)
          return cs.theField01.objectField.value;
    }

    //-- No field found in this scope, so try to find it
    //-- in the parent scope of "theScope".
    return this.getFieldValueFromParent(fieldName, theScope.$parent);
  },

  /**
   *     Look for a field in the widget and return its current value when it is found.
   */
  getFieldValue: function(fieldName) {
    //-- This directive is in a formfield or a ffl2 (form field level 2).
    //-- So the parent containing the fields of same levels
    //-- is the scope which is the parent of the parent of this directive's scope.
    //-- But anyway make a recursive search in case this module is used differently.
    //--
    $scope.depthForFieldRecursiveSearch = 0;
    return $scope.getFieldValueFromParent(fieldName, $scope.$parent);
  },

  /**
   *    When mail has not been sent at all, the content gotten from
   * the mail description is calculated. The need of calculation is du to
   * the possible presence of expression in the body of the mail.
   * The expressions that can be evaluated are:
   * - !CURRENT_YEAR!:      Année courante / Current year
   * - !CURRENT_YEAR+N!:    Année courante + valeur de l'entier N / Current year plus integer value of N
   * - !FIELD!.!fieldname!  Valeur du champ nommé fieldname pourvu qu'il soit dans le widget /
   *                        Value of the field named "fieldname" provided that it's present in the widget.
   */
  calculateMailContent: function() {
    var ind1,
      ind2,
      keyWord,
      value,
      reg,
      loopCnt = 0;

    //-- Replace all CURRENT_YEAR expression by its value.
    ind1 = this.mailContent.indexOf('!CURRENT_YEAR');
    while (ind1 != -1 && ++loopCnt != 100) {
      ind2 = this.mailContent.indexOf('!', ind1 + 1);
      keyWord = this.mailContent.substr(ind1, ind2 - ind1 + 1);
      reg = keyWord;
      if (keyWord.substr(13, 1) != '!')
        keyWord =
          keyWord.substr(0, 13) + '!' + keyWord.substr(13, keyWord.length - 14);
      value = GlobalServices.getValueForKeyWord(keyWord);
      this.mailContent = this.mailContent.replace(reg, '' + value.newValue);

      ind1 = this.mailContent.indexOf('!CURRENT_YEAR');
    }

    //-- Replace all FIELD expression by its value.
    loopCnt = 0;
    ind1 = this.mailContent.indexOf('!FIELD!');
    while (ind1 != -1 && ++loopCnt != 100) {
      ind2 = this.mailContent.indexOf('!', ind1 + 9);
      keyWord = this.mailContent.substr(ind1, ind2 - ind1 + 1);
      value = this.getFieldValue(
        this.mailContent.substr(ind1 + 9, ind2 - ind1 - 9)
      );
      if (value.getMonth != undefined) value = value.toLocaleDateString();
      else value = '' + value;
      reg = new RegExp(keyWord, 'g');
      this.mailContent = this.mailContent.replace(reg, value);

      ind1 = this.mailContent.indexOf('!FIELD!');
    }

    //-- Replace all remaining !xxx! expression by its value.
    ind1 = this.mailContent.indexOf('!');
    while (ind1 != -1 && ++loopCnt != 100) {
      ind2 = this.mailContent.indexOf('!', ind1 + 1);
      keyWord = this.mailContent.substr(ind1, ind2 - ind1 + 1);
      value = GlobalServices.getValueForKeyWord(keyWord);
      if (value.newValue.toLocaleString != undefined)
        value.newValue = value.newValue.toLocaleString();
      this.mailContent = this.mailContent.replace(keyWord, '' + value.newValue);

      ind1 = this.mailContent.indexOf('!');
    }
  },

  /**
   *     When a mail has already been sent we do not change its content.
   *  When a mail has never been sent, we get the default content from
   *  the mail description and then calculate it in order to evaluate
   *  the contained expressions.
   */
  buildMailContent: function() {
    this.setMailAlreadySent();
    if (this.mailAlreadySent) this.mailContent = this.objectFieldValue;
    else {
      this.mailContent = this.mailDesc.properties['contenu'];
      this.calculateMailContent();
    }
  },

  /**
   *    Get the mail of each user stored in the recipient list
   * of the mail description.
   */
  buildMailRecipientList: function() {
    var userUids, uid;

    this.recipients = [];
    if (this.mailDesc.properties['recipients'] != null) {
      //-- Recipient list is stored as an array of user UID
      //-- without string delimiter (example: [a01,b02,f99]).
      //-- From the we build a javascript array.
      userUids = this.mailDesc.properties['recipients'];
      userUids = userUids.replace(/\[/g, '');
      userUids = userUids.replace(/\]/g, '');
      userUids = userUids.split(',');

      UsersFactory.get().then(function(res) {
        var ind1, ind2;
        //-- Go through user list and get email of user making part of the recipient list.
        for (ind1 = 0; ind1 < userUids.length; ind1++) {
          uid = userUids[ind1].trim();
          for (ind2 = 0; ind2 < res.data.length; ind2++)
            if (uid == res.data[ind2].uid) {
              this.recipients.push(res.data[ind2].email);
              break;
            }
        }
      });
    }
  },

  getMailRecipients: function() {
    return this.recipients;
  },

  getMailSubject: function() {
    return $scope.mailDesc.properties['subject'];
  },

  /**
   *     Return mail content which is different depending on if it is a first
   *  mail sending or a new sending of the same mail.
   *
   *  $scope.mailContent contains the full description of the mail
   *                     as it is stored in the database when already sent.
   *                     When already sent the mail content contains
   *                     the number of times it has been sent,
   *                     and the dates of the sendings and the recipients.
   *  $scope.getMailContent only returns the message body of the mail.
   */
  getMailContent: function() {
    var ind = this.mailContent.indexOf('Corps du message:');
    if (ind == -1) return this.mailContent;
    else return this.mailContent.substr(ind + 18);
  },

  sendmailAbort: function() {
    ngDialog.closeAll('');
  },

  /**
   *     Once sent the mail is stored so that it become the field value.
   *  At first sending, the value is a text containing the adte and time of the sending
   *  then the mails of the recipients, and finally the message text.
   *  If the mail is sent again, we add the sending count at the begining as well as
   *  the date andtime and the list of mails address of this new sending.
   *  The mail list may change for a new sending because between the two sending
   *  the administrator may have benn changing the recipient list in the mail description.
   */
  storeMail: function() {
    var ind,
      nb,
      mailToStore = '';
    var recipients = this.getMailRecipients();
    var today = new Date();

    if (this.mailAlreadySent) {
      ind = this.mailContent.indexOf("Nombre d'envois:");
      if (ind == -1) nb = 2;
      else nb = parseInt(this.mailContent.substr(ind + 16)) + 1;
      mailToStore = "Nombre d'envois:" + nb + '\n\n\n';
      mailToStore += '---------------\n';
      mailToStore +=
        "Date et heure de l'envoi no " +
        nb +
        ':\n' +
        today.getDate() +
        '/' +
        (1 + today.getMonth()) +
        '/' +
        today.getFullYear() +
        ' à ';
      mailToStore += today.getHours() + 'H' + today.getMinutes();
      mailToStore += '\n\nMail envoyé à:\n';
      mailToStore += recipients.join(' , ');
      mailToStore += '\n---------------';
      mailToStore += '\n\n\n' + this.mailContent;
    } else {
      mailToStore +=
        "Date et heure d'envoi du mail:\n" +
        today.getDate() +
        '/' +
        today.getMonth() +
        '/' +
        today.getFullYear() +
        ' à ';
      mailToStore += today.getHours() + 'H' + today.getMinutes();
      mailToStore += '\n\nMail envoyé à:\n';
      mailToStore += recipients.join(' , ');
      mailToStore += '\n\nCorps du message:\n';
      mailToStore += this.mailContent;
    }

    this.mailContent = this.objectFieldValue = mailToStore;
    $scope.valueChanged();
  },

  /**
   *    Function called when the user has confirmed the sending of the mail.
   */
  sendMailOk: function() {
    var mailDesc = [];
    this.sendingMail = true;
    mailDesc.push({
      name: 'mailTo',
      type: 'cst',
      value: this.getMailRecipients(),
    });
    mailDesc.push({
      name: 'mailSubject',
      type: 'cst',
      value: this.getMailSubject(),
    });
    mailDesc.push({
      name: 'mailContent',
      type: 'cst',
      value: this.getMailContent(),
    });
    FunctionFactory.execute({ parameters: mailDesc }, 'sendMail', 'ja').then(
      function(res) {
        //-- If mail correctly sent then store it so that we'll have
        //-- the trace of the sent mail.
        if (res.data === 'true') {
          this.storeMail();
          this.setMailAlreadySent();
          gaJsUtils.successMessage('Mail envoyé');
        } else gaJsUtils.errorMessage("Echec à l'envoi du mail !", '');
        this.sendingMail = false;
      }
    );
    ngDialog.closeAll('');
  },

  /********************************************
   *
   *
   *    Actions triggered on user commands.
   *
   */

  sendMail: function() {
    ngDialog.open({
      template: this.getSendConfirmHtml('envoi'),
      plain: true,
      scope: this,
    });
  },

  sendMailAgain: function() {
    ngDialog.open({
      template: this.getSendConfirmHtml('renvoi'),
      plain: true,
      scope: this,
    });
  },

  /**
   *     Open a widget in order to show the mail which is gonna be sent.
   *  Recipient list and subject are also displayed.
   */
  openMailContent: function() {
    var template;
    var childScope = $scope.$new(false, $scope);

    if (this.mailAlreadySent)
      template =
        "<textarea ng-model='mailContent' readonly ng-change='valueChanged()' style='width:500px;height:450px;'></textarea>";
    else {
      this.recipientsAsString = this.recipients.join(' , ');
      template = '<table>';
      template += '  <tr><td>Destinataires</td></tr>';
      template += '  <tr><td>';
      template +=
        "      <textarea readonly ng-model='recipientsAsString' style='width:500px;height:60px;'></textarea>";
      template += '  </td></tr>';
      template += '  <tr><td>';
      template += '  </td></tr>';
      template += '  <tr><td>Sujet</td></tr>';
      template += '  <tr><td>';
      template +=
        "      <input ng-model='mailDesc.properties[\"subject\"]' disabled style='width:500px;'>";
      template += '  </td></tr>';
      template += '  <tr><td>Corps du message</td></tr>';
      template += '  <tr><td>';
      template +=
        "      <textarea ng-model='mailContent' style='width:500px;height:350px;'></textarea>";
      template += '  </td></tr>';
      template += '</table>';
    }
    ngDialog.open({
      template: template,
      plain: true,
      scope: childScope,
      className: 'ngdialog-theme-plain width800',
    });
  },

  /*******************************************
   *
   *
   *     Initialization of the scope
   *
   */
  init: function(
    mailFieldName,
    datastoreName,
    FeatureTypeFactory,
    QueryFactory
  ) {
    this.sendingMail = this.mailAlreadySent = false;
    this.mailFieldName = mailFieldName;
    this.datastoreName = datastoreName;
    this.featureTypeFactory = FeatureTypeFactory;
    this.queryFactory = QueryFactory;
    this.getMailDescriptionFromDB();
  },
};
