'use strict';
define(function() {
  var UnitsFactory = function($http, $q, ConfigFactory, UnitFactory) {
    var resources = {
      units: null,
      ufUnits: null,
    };

    /**
     *        Best practice is to call this function first at a high level
     *    so that the description of the units be loaded and ready as soon as possible
     *    in order to be accessible for the fields.
     */
    function getUnitsFromAppConfig(deferred, unitName) {
      ConfigFactory.get('main', 'units').then(function(res) {
        resources.units = res.data;
        UnitFactory.get().then(function(res) {
          resources.ufUnits = res;
          deferred.resolve(getUnitDescriptionFromRes(unitName, res));
        });
      });
    }

    function getUnitDescriptionFromRes(unitName) {
      var ind;
      for (ind = 0; ind < resources.ufUnits.length; ind++)
        if (resources.ufUnits[ind].unit == unitName)
          return resources.ufUnits[ind];
      for (ind = 0; ind < resources.units.length; ind++)
        if (resources.units[ind].unit == unitName) return resources.units[ind];
    }

    function getUnitDescription(unitName) {
      var deferred = $q.defer();
      if (resources.units == null) getUnitsFromAppConfig(deferred, unitName);
      else deferred.resolve(getUnitDescriptionFromRes(unitName));
      return deferred.promise;
    }

    return {
      UnitsFactory: UnitsFactory,
      getUnitDescription: getUnitDescription,
      getUnitsFromAppConfig: getUnitsFromAppConfig,
    };
  };
  UnitsFactory.$inject = ['$http', '$q', 'ConfigFactory', 'UnitFactory'];
  return UnitsFactory;
});
