/**
 *
 */
'use strict';
define(function() {
  var TableSelectAndUpdateCtrl = function(
    $scope,
    $timeout,
    TableSelectAndUpdateFactory,
    QueryFactory,
    ConfigFactory,
    FeatureTypeFactory,
    EditFactory,
    ngTableParams,
    GlobalServices
  ) {
    /**
	 *     In this module the configuration must contain the following elements:
	 *     
	 *     - data store name
	 *     - feature type name
	 *
	 *     In this module the configuration may contain the following elements:
	 *     
	 *     - useDescription :  select = only selection
	 *                         select_add = selection and add
	 *                         all = selection, add, modify delete
	 *                         DEFAULT = select

	 *     - foot navigator : true/false to indicate if the list is displayed 
	 *                        on many pages in the google search manner 
	 *                        with a limited number of item on one page.
	 *                        DEFAULT = TRUE
	 *                        
	 *     - max item per page: see previous parameter description
	 *     					  DEFAULT = 5
	 *     
	 *     - fields : list of field in the order when not all 
	 *                fields have to be shown in the table.
	 *     
	 *     - excluded fields : list of fields not to be displayed.
	 *     
	 *     - selection type :  "single" or "multiple" the latter is the default
	 *                         it says if we can select one value or many values.
	 *     
	 */

    $scope.attributes = [];
    $scope.objects = [];
    $scope.allObjects = $scope.filteredObjects = [];
    $scope.checkedObjects = [];
    $scope.thisId = $scope.$id;
    $scope.showAddBtn = $scope.showUpdateBtn = $scope.showDeleteBtn = $scope.showSelectBtn = true;
    $scope.textFilter = {};
    $scope.textFilter.properties = {};
    $scope.loaded = false;
    $scope.filterHasBeenChangedOne = $scope.filterHasBeenChangedTwo = false;
    $scope.justAddedObjectIds = [];

    $scope.txtStyle = { color: '#000000' };

    /**
     *       When there are few attributes we can make the larger.
     */
    $scope.defineWidthDependingOnAttCount = function() {
      var width = 400;
      if ($scope.attributes.length < 3) {
        width = 600 / $scope.attributes.length;
        $scope.txtStyle = {
          color: '#000000',
          width: '' + width + 'px',
          'max-width': '' + width + 'px',
        };
      }
    };

    $scope.alert = function(message) {
      //console.log("Echec de mise à jour de ["+$scope.descField.name+"]");
      var errorMsg = '<h4>Erreur</h4> ';
      errorMsg += '<br/><h4>Details</h4>' + message;
      require('toastr').error(errorMsg);
    };

    $scope.filterChanged1 = function() {
      if ($scope.filterHasBeenChangedTwo) {
        $scope.filterHasBeenChangedTwo = false;
        $timeout($scope.filterChanged1, 500);
      } else {
        $scope.filterHasBeenChangedOne = $scope.filterHasBeenChangedTwo = false;
        $scope.getFilter();
      }
    };

    $scope.filterChanged = function() {
      if ($scope.filterHasBeenChangedOne) $scope.filterHasBeenChangedTwo = true;
      else {
        $scope.filterHasBeenChangedOne = true;
        $timeout($scope.filterChanged1, 500);
      }
    };

    $scope.getFilter = function() {
      var ind = 1,
        theFilter = {};
      $scope.filteredObjects = $scope.allObjects;
      for (var prop in $scope.textFilter.properties) {
        if ($scope.textFilter.properties[prop] != '') {
          theFilter['properties'] = {};
          theFilter['properties'][prop] = $scope.textFilter.properties[prop];
          $scope.filteredObjects = TableSelectAndUpdateFactory.filterFeatureList(
            $scope.filteredObjects,
            theFilter
          );
        }
      }
      $scope.currentPage = 0;
      $scope.lastPageNumber = Math.floor(
        ($scope.filteredObjects.length - 1) / $scope.itemsByPage
      );
      $scope.pageChanged();
    };

    $scope.initUnit = function(att) {
      var unitName, unitDesc;
      if (att.unit == undefined || att.unit.type == undefined)
        att.fieldHasUnit = false;
      else {
        att.fieldHasUnit = true;
        unitName = att.unit.type;
        att.currentUnitFactor = {};
        att.numericValue = {};
        //-- Initial value (in case there is one)
        //att.numericValue.value = $scope.theField01.objectField.value;
        UnitsFactory.getUnitDescription(unitName).then(function(res) {
          att.unitDesc = res;
          if (att.unitDesc != undefined && att.unitDesc.multiple.length != 0) {
            //$scope.$watch("currentUnitFactor.value",$scope.unitChanged);
            //-- Next watch is useful once because theField01.objectField.value
            //-- changes out of this directive only when the query from parent (relation form field)
            //-- get the value after this directive be created.
            //$scope.$watch("theField01.objectField.value",$scope.objectValueChanged);
            for (var ind = 0; ind < att.unitDesc.multiple.length; ind++)
              if (att.unitDesc.multiple[ind].factor == att.unit.defaultFactor) {
                att.dbUnit = att.unitDesc.multiple[ind].symbol;
                att.currentUnitFactor.value = att.unitDesc.multiple[ind];
                break;
              }
          }
        });
      }
    };

    /**
     *     Add attribute description to the list of attribute to display and manage
     *  in this table component.
     *  The attributes are copied, so that an eventual modification of the alias
     *  does not affect the shared feature type description.
     */
    $scope.addAttribute = function(ftDesc, indAtt) {
      var att, ind, val, restr, prop;

      //-- Instanciate new attribute and set basic information.
      att = {};
      (att.name = ftDesc.attributes[indAtt].name),
        (att.alias = ftDesc.attributes[indAtt].alias);
      att.type = ftDesc.attributes[indAtt].type;
      att.fieldTypeIsDomain = false;
      $scope.textFilter.properties[att.name] = '';
      $scope.initUnit(ftDesc.attributes[indAtt]);
      /*
         if (att.name=='prenom')
         $scope.textFilter.properties2[att.name]="";
		 */
      //-- If there is a list of value restriction on this attribute
      //-- store it on the attribute in order to be able to feed angularks with it.
      restr = ftDesc.attributes[indAtt].restrictions;
      for (ind = 0; ind < restr.length; ind++) {
        if (restr[ind].type == 'Domain') {
          att.fieldTypeIsDomain = true;
          att.listOfValues = [];
          for (var prop in restr[ind].listofValues) {
            val = {};
            val.code = prop;
            val.value = restr[ind].listofValues[prop];
            att.listOfValues.push(val);
          }
        }
      }

      //-- Is the field an attachment field
      var fieldType = att.type.toLowerCase();
      att.fieldTypeIsMultipleAttachments =
        fieldType.indexOf('g2c.attachments') != -1;
      if (!att.fieldTypeIsMultipleAttachments)
        att.fieldTypeIsSingleAttachment =
          fieldType.indexOf('g2c.attachment') != -1;
      //-- Other field types
      att.fieldTypeIsBoolean = fieldType.indexOf('.boolean') != -1;
      att.fieldTypeIsDate = fieldType.indexOf('.date') != -1;
      att.fieldTypeIsString = fieldType.indexOf('.string') != -1;

      //-- Add the attribute description into the list of attributes to manage.
      $scope.attributes.push(att);
    };

    $scope.loadAttributes = function() {
      var ind, ind2;

      if ($scope.config.fields == undefined)
        for (ind = 0; ind < $scope.tableDesc.attributes.length; ind++)
          $scope.addAttribute($scope.tableDesc, ind);
      else
        for (ind = 0; ind < $scope.config.fields.length; ind++)
          for (ind2 = 0; ind2 < $scope.tableDesc.attributes.length; ind2++)
            if (
              $scope.config.fields[ind].field ==
              $scope.tableDesc.attributes[ind2].name
            )
              $scope.addAttribute($scope.tableDesc, ind2);
    };

    /**     Callled after con,figuration check, this function
     *  list the record of the table.
     */
    $scope.loadWidget = function() {
      $scope.tableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.config.datastoreName,
        $scope.config.featureName
      );
      $scope.loadAttributes();
      QueryFactory.data($scope.tableDesc.uid, '').then(function(res) {
        var ind, indAtt;

        if ($scope.objects.length != 0)
          $scope.objects.splice(0, $scope.objects.length);
        $scope.currentPage = 0;
        $scope.lastPageNumber = Math.floor(
          (res.data.features.length - 1) / $scope.itemsByPage
        );
        for (ind = 0; ind < res.data.features.length; ind++) {
          $scope.allObjects.push(res.data.features[ind]);
          if (ind <= $scope.itemsByPage)
            $scope.objects.push(res.data.features[ind]);
        }
        $scope.defineWidthDependingOnAttCount();
        $scope.loaded = true;
      });
    };

    $scope.defineCommandVisibiity = function() {
      switch ($scope.config.useDescription) {
        case 'select':
          $scope.showAddBtn = $scope.showUpdateBtn = $scope.showDeleteBtn = false;
          $scope.showSelectBtn = true;
          break;
        case 'select_add':
          $scope.showUpdateBtn = $scope.showDeleteBtn = false;
          $scope.showAddBtn = $scope.showSelectBtn = true;
          break;
        case 'all':
          $scope.showUpdateBtn = $scope.showDeleteBtn = $scope.showAddBtn = $scope.showSelectBtn = true;
          break;
      }
    };

    $scope.checkConfiguration = function() {
      if ($scope.ConfigName == undefined)
        if (
          $scope.$parent.$parent.theField01 != undefined &&
          $scope.$parent.$parent.theField01.featureName != undefined
        )
          $scope.ConfigName =
            'config_chercher_' +
            $scope.$parent.$parent.theField01.objectField.name;
      if ($scope.ConfigName == undefined)
        $scope.alert('Pas de fichier de configuration fourni !');
      else
        ConfigFactory.get('chercher_modifier', $scope.ConfigName).then(function(
          res
        ) {
          if ($scope.ConfigName.length === undefined)
            //-- <<<< Configuration is contained in the ConfigName . >>>>
            $scope.config = $scope.ConfigName;
          //-- <<<< Configuration has been gotten. >>>>
          else $scope.config = res.data;
          if ($scope.config.datastoreName == undefined)
            $scope.alert('Pas de datastore fourni dans la configuration !');
          else if ($scope.config.featureName == undefined)
            $scope.alert('Pas de table/couche fourni dans la configuration !');
          else {
            //-- Set default values when necessary
            //-- This one can also be set in the parent component.
            if ($scope.selectionType != undefined)
              $scope.config.selectionType = $scope.selectionType;
            if ($scope.config.selectionType == undefined)
              $scope.config.selectionType = 'multiple';
            if ($scope.config.useDescription == undefined)
              $scope.config.useDescription = 'select';
            if ($scope.config.useDescription == undefined)
              $scope.config.footNavigator = true;
            if ($scope.config.maxItemPerPage == undefined)
              $scope.itemsByPage = 5;
            else $scope.itemsByPage = $scope.config.maxItemPerPage;

            $scope.defineCommandVisibiity();
            $scope.loadWidget();
          }
        });
    };

    $scope.checkConfiguration();

    /**     Date values are really messy. Here we convert String value
     *   gotten from service to a Date object to feed correctly the date component.
     *
     */
    $scope.setDate = function(obj, attName) {
      var strDate, dDate, ms;

      //-- If trim function exists the field value is a String
      if (
        obj.properties[attName] != null &&
        obj.properties[attName].trim != undefined
      ) {
        //-- Actually the date is a string ...
        //-- Betting the date has the expected JAVA GEoJSson format
        //-- convert it into a Date (format example: 2015-02-03T23:00:00.000+0000)
        strDate = obj.properties[attName];
        dDate = new Date();
        dDate.setFullYear(strDate.substr(0, 4));
        dDate.setMonth(strDate.substr(5, 2) - 1);
        dDate.setDate(strDate.substr(8, 2));
        dDate.setHours(strDate.substr(11, 2));
        dDate.setMinutes(strDate.substr(14, 2));
        dDate.setSeconds(strDate.substr(17, 2));
        //----- TODO Modify server side after better DATE managemen
        //-- Date returned is day-1 23H00 so we add 2 hours
        //-- (one should be enough ...) to display correct date.
        //-- In the DB the displayed date is OK.
        //-- When date will be better managed we'll get rid of this.
        ms = dDate.getTime() + 7200000; //  = 60 secondes x 1000 x 60 minutes x 2 heures
        dDate.setTime(ms);
        obj.properties[attName] = dDate;
      }
    };

    /**
     * TODO commenter
     */
    $scope.buildObjectList = function() {
      var rel, ftDesc, where;

      //-- Get objects TODO match a filter ????.
      //where = rel.fieldEnd+"="+$scope.mainObjectId;
      QueryFactory.data($scope.tableDesc.uid, '').then(function(res) {
        var ind, indAtt;

        if ($scope.allObjects.length != 0)
          $scope.allObjects.splice(0, $scope.objects.length);
        $scope.lastPageNumber = Math.floor(
          (res.data.features.length - 1) / $scope.itemsByPage
        );
        for (ind = 0; ind < res.data.features.length; ind++) {
          $scope.allObjects.push(res.data.features[ind]);
          //-- Set date values as a date class instanciation
          for (indAtt = 0; indAtt < $scope.attributes.length; indAtt++)
            if ($scope.attributes[indAtt].fieldTypeIsString)
              $scope.setDate(
                $scope.allObjects[$scope.allObjects.length - 1],
                $scope.attributes[indAtt]
              );
        }
        $scope.filteredObjects = $scope.allObjects;
        $scope.pageChanged();
      });
    };

    /**
     *     Extract readable value of the given attribute from given object
     *  in order to display
     */
    $scope.getValueFor = function(object, attribute) {
      var retValue = object.properties[attribute.name];

      if (attribute.listOfValues != undefined) {
        for (var ind1 = 0; ind1 < attribute.listOfValues.length; ind1++) {
          for (var ind2 = 0; ind2 < attribute.listOfValues.length; ind2++) {
            if (retValue == attribute.listOfValues[ind2].code)
              return attribute.listOfValues[ind2].value;
          }
        }
      }
      return retValue;
    };

    $scope.getCurrentValuesAsProperties = function(ftDesc) {
      var prop = {},
        ind;

      for (ind = 0; ind < $scope.attributes.length; ind++)
        if ($scope.attributes[ind].value != undefined)
          //               prop[ ftDesc.attributes[ind].name ] = $scope.attributes[ ind ].value;
          prop[ftDesc.attributes[ind].name] = GlobalServices.getValueForDB(
            ftDesc,
            ftDesc.attributes[ind].name,
            $scope.attributes[ind].value
          );
        else prop[ftDesc.attributes[ind].name] = null;

      //prop[ $scope.getRelation().fieldEnd ] = $scope.mainObjectId;

      return prop;
    };

    /**
     *     Function triggered on add new record command activation.
     *  The function create a new empty record that will be updated
     *  when the user will change value in the input fields.
     */
    $scope.addNewRecord = function() {
      var features;

      //-- Build GeoJSON object describing the object we want  to insert
      features = {};
      features.type = 'FeatureCollection';
      features.features = [];
      features.features[0] = {};
      features.features[0].type = 'feature';
      features.features[0].properties = $scope.getCurrentValuesAsProperties(
        $scope.tableDesc
      );
      features.features[0].geometry = {};

      EditFactory.add($scope.tableDesc.uid, features).then(function(res) {
        var errorMsg = '';

        if (res.statusText != 'OK' || res.data.errors.ERROR != undefined) {
          //console.log("Echec de mise à jour de ["+$scope.descField.name+"]");
          var errorMsg = '<h4>Erreur</h4> ';
          errorMsg +=
            "<br/><h4>Details</h4>  Echec de l'ajout d'un objet en base !";
          errorMsg += '<br/>' + res.data.errors.ERROR;
          require('toastr').error(errorMsg);
        } else {
          $scope.justAddedObjectIds.push(
            QueryFactory.getFeatureId(res.data.create[0])
          );
          $scope.buildObjectList();
        }
      });
    };

    /**
     *     Function triggered on update record command activation.
     *  The function update the record.
     *
     */
    $scope.updateRecord = function(obj) {
      var features;

      //-- Build GeoJSON object describing the object we want  to insert
      features = {};
      features.type = 'FeatureCollection';
      features.features = [];
      features.features.push(obj);
      features.features[0].geometry = {};

      EditFactory.update($scope.tableDesc.uid, features).then(function(res) {
        var errorMsg;

        if (res.statusText != 'OK' || res.data.errors.ERROR != undefined) {
          //console.log("Echec de mise à jour de ["+$scope.descField.name+"]");
          var errorMsg = '<h4>Erreur</h4> ';
          errorMsg +=
            "<br/><h4>Details</h4>  Echec de l'ajout d'un objet en base !";
          errorMsg += '<br/>' + res.data.errors.ERROR;
          require('toastr').error(errorMsg);
        } else $scope.buildObjectList();
      });
    };

    /**
     *     Function triggered on delete record command activation.
     *  The function delete the selected records.
     *
     */
    $scope.deleteRecords = function() {
      var idsToDelete = '';
      for (var ind = 0; ind < $scope.checkedObjects.length; ind++) {
        idsToDelete += $scope.checkedObjects[ind] + ',';
      }
      idsToDelete += idsToDelete.slice(idsToDelete.length - 1);

      EditFactory.remove($scope.tableDesc.uid, idsToDelete).then(function(res) {
        var errorMsg;

        if (res.statusText != 'OK' || res.data.errors.ERROR != undefined) {
          //console.log("Echec de mise à jour de ["+$scope.descField.name+"]");
          var errorMsg = '<h4>Erreur</h4> ';
          errorMsg +=
            "<br/><h4>Details</h4>  Echec de l'ajout d'un objet en base !";
          errorMsg += '<br/>' + res.data.errors.ERROR;
          require('toastr').error(errorMsg);
        } else $scope.buildObjectList();
      });
    };

    $scope.selectRecords = function(close) {
      $scope.tableSelectAction = 'select';
      if ($scope.tableSelectSelectionDone != undefined) {
        //-- If selection type is single the selected object is given as a parameter
        //-- If selection type is multiple the identifiers
        //-- of the selected objects are given as a list parameter
        if ($scope.config.selectionType == 'single')
          $scope.tableSelectSelectionDone($scope.selectedObject);
        else $scope.tableSelectSelectionDone($scope.checkedObjects);
      }
      if (close) $scope.meAsNgDialog.closeAll();
    };

    /**
     *     Modify value so that it can be inserted into the database field.
     *  What is managed until now is the date format.
     */
    $scope.getValueForDb = function(obj, att) {
      var fieldType = att.type.toLowerCase();
      var value = obj.properties[att.name];

      if (!fieldType.indexOf('.string') != -1 && value == '') return null;

      if (fieldType.indexOf('.date') != -1) {
        if (value == undefined) return null;

        return (
          '' +
          value.getFullYear() +
          '-' +
          (1 + value.getMonth()) +
          '-' +
          value.getDate() +
          'T12:00:00.000+0000'
        );
        //return "2016-01-02T12:00:00.000+0000";
      }

      if (value == undefined) return null;
      return value;
    };

    /**
     *     As we cannot directly send the object to the update service,
     *  because there is a discrepancy with the date format,
     *  we use this function to build the object property list
     *  where the values (the date values) are correctly set.
     */
    $scope.getPropertiesFromObject = function(indObj, ftDesc) {
      var indAtt,
        prop = {};

      for (indAtt = 0; indAtt < ftDesc.attributes.length; indAtt++)
        prop[ftDesc.attributes[indAtt].name] = $scope.getValueForDb(
          $scope.objects[indObj],
          ftDesc.attributes[indAtt]
        );

      return prop;
    };

    $scope.$parent.valueChangedFunction = true;
    $scope.valueChanged = function(modifiedObject) {
      //-- A value has changed so we update the object.
      //-- The modified values are directly them which
      //-- are in the $scope.objects list so we don't have much to do,
      //-- only send it to the update service.
      var ftDesc, features, ind;

      ftDesc = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.config.datastoreName,
        $scope.config.featureName
      );

      //-- Build GeoJSON object describing the object we want to update
      for (ind = 0; ind < $scope.objects.length; ind++)
        if ($scope.objects[ind].id == modifiedObject.id) break;
      features = {};
      features.type = 'FeatureCollection';
      features.features = [];
      features.features[0] = {};
      features.features[0].id = modifiedObject.id;
      features.features[0].type = 'feature';
      features.features[0].properties = $scope.getPropertiesFromObject(
        ind,
        ftDesc
      );
      features.features[0].geometry = {};

      //-- Call update service
      EditFactory.update(ftDesc.uid, features).then(function(res) {
        var errorMsg;

        if (res.statusText != 'OK' || res.data.errors.ERROR != undefined) {
          //console.log("Echec de mise à jour de ["+$scope.descField.name+"]");
          var errorMsg = '<h4>Erreur</h4> ';
          errorMsg +=
            "<br/><h4>Details</h4>  Echec de la modification d'un objet en base !";
          errorMsg += '<br/>' + res.data.errors.ERROR;
          require('toastr').error(errorMsg);
        } else $scope.buildObjectList();
      });
    };

    $scope.nextPage = function() {
      $scope.currentPage++;
      $scope.pageChanged();
    };

    $scope.removeTableRows = function() {
      /*
	 var ind;
	 var elt = document.getElementById('table_'+$scope.$id);
	 for (ind=elt.rows.length-2;ind>1;ind--)
		  elt.deleteRow(ind);
		  */
    };

    $scope.pageChanged = function() {
      var ind = $scope.currentPage * $scope.itemsByPage;
      var indMax = ind + $scope.itemsByPage;

      $scope.objects.splice(0, $scope.objects.length);
      $scope.removeTableRows();
      for (; ind < $scope.filteredObjects.length && ind < indMax; ind++)
        $scope.objects.push($scope.filteredObjects[ind]);
    };

    $scope.previousPage = function() {
      $scope.currentPage--;
      $scope.pageChanged();
    };

    $scope.firstPage = function() {
      $scope.currentPage = 0;
      $scope.pageChanged();
    };

    $scope.lastPage = function() {
      $scope.currentPage = Math.floor(
        ($scope.filteredObjects.length - 1) / $scope.itemsByPage
      );
      $scope.pageChanged();
    };

    $scope.checkObj = function(obj) {
      var ind;

      if ($scope.config.selectionType == 'single')
        $scope.checkedObjects.splice(0, $scope.checkedObjects.length);
      for (ind = 0; ind < $scope.checkedObjects.length; ind++)
        if ($scope.checkedObjects[ind] == obj.id) {
          //-- Object is already in the list so it's just been unchecked
          $scope.checkedObjects.splice(ind, 1);
          break;
        }
      if (ind == $scope.checkedObjects.length) {
        if ($scope.selectionType == 'single') $scope.selectedObject = obj;
        $scope.checkedObjects.push(obj.id);
      }
    };

    $scope.getObjIsChecked = function(obj) {
      var ind;

      for (ind = 0; ind < $scope.checkedObjects.length; ind++)
        if ($scope.checkedObjects[ind] == obj.id) {
          return true;
        }
      return '';
    };

    $scope.getIsEnabledForAttachmentField = function(objectId) {
      return (
        $scope.showUpdateBtn ||
        $scope.justAddedObjectIds.indexOf(objectId) != -1
      );
    };
  };

  TableSelectAndUpdateCtrl.$inject = [
    '$scope',
    '$timeout',
    'TableSelectAndUpdateFactory',
    'QueryFactory',
    'ConfigFactory',
    'FeatureTypeFactory',
    'EditFactory',
    'ngTableParams',
    'GlobalServices',
  ];
  return TableSelectAndUpdateCtrl;
});
