'use strict';
define(function() {
  /**
   * Class : StepContainerFactory
   * Factory WebServices
   */
  var StepContainerFactory = function($http, FeatureTypeFactory, QueryFactory) {
    var resources = {
      steps: null,
      specifiTablesDescField: [],
      relObjects: [],
      relIds: [],
    };

    function getSteps(tableUid, whereClause) {
      //var promise = $http.get('/services/{portalid}/query/'+tableUid+'/data?where='+whereClause+'&fid='+tableUid);
      var promise = QueryFactory.data(
        tableUid,
        whereClause,
        undefined,
        undefined,
        undefined,
        undefined
      );
      promise.then(function(res) {
        resources.steps = res.data;
      });
      return promise;
    }

    /**
     * Function: add
     */
    function addObject(fid, senddata, featureType, roQueryIndex) {
      var features;

      //-- Build GeoJSON object describing the object we want  to insert
      features = {};
      features.type = 'FeatureCollection';
      features.features = [];
      features.features[0] = {};
      features.features[0].type = 'feature';
      features.features[0].properties = senddata;
      features.features[0].geometry = {};

      //-- Do the insert
      var promise = $http.post(
        '/services/{portalid}/edit/' + fid + '/add?f=json',
        features
      );
      promise.then(function(res) {
        var indPt, ind;
        //- If the service returns OK (which does not mean the creation is OK)
        if (res.status == 200) {
          if (
            res.data.errors.ERROR != undefined &&
            res.data.errors.ERROR.trim != undefined &&
            res.data.errors.ERROR.length != 0
          )
            alert('Création impossible : ' + res.data.errors.ERROR);
          else {
            var created = res.data.create[0];
            if (created.id != undefined) {
              indPt = created.id.indexOf('.');
              ind = resources.relIds.length;
              resources.relIds[ind] = {};
              resources.relIds[ind].featureType = created.id.substr(0, indPt);
              resources.relIds[ind].id = created.id.substr(indPt + 1);
              resources.relIds[ind].roQueryIndex = roQueryIndex;
            }
          }
        }
      });
      return promise;
    }

    return {
      StepContainerFactory: StepContainerFactory,
      getSteps: getSteps,
      addObject: addObject,
      resources: resources,
    };
  };

  StepContainerFactory.$inject = [
    '$http',
    'FeatureTypeFactory',
    'QueryFactory',
  ];
  return StepContainerFactory;
});
