/**
 *
 */
'use strict';
define(function() {
  var StepContainerCtrl = function(
    $scope,
    StepContainerFactory,
    QueryFactory,
    GlobalServices,
    EditFactory,
    FeatureTypeFactory,
    $q,
    gaJsUtils
  ) {
    var conf;
    var container;

    //-- Get this scope ID in order to build unique HTML element identifier.
    $scope.thisId = $scope.$id;

    if ($scope.$parent.stepContainer) container = $scope.$parent;
    else {
      container = $scope.$parent.tab;
      if (container == null) container = $scope.$parent;
    }

    $scope.container = container;
    if (container.stepDescField != undefined)
      container.fieldDesc = container.stepDescField;
    else if (container.fieldDesc == undefined)
      container.fieldDesc = container.descField;
    var fieldDescAtt = container.fieldDesc.attributes;
    var fieldDescRelations = container.fieldDesc.relations;
    var objectFields = container.objectFields;
    $scope.objectId = container.objectId;
    $scope.ready = false;
    if (container.inlineConfigs == null) container.inlineConfigs = [];
    if (container.stepConfig != undefined) conf = container.stepConfig;
    else if (container.contentType != undefined) conf = container;
    else conf = container.config;
    if (container.inlineInput == null) container.inlineInput = true;
    $scope.conf = conf;

    var ind;
    for (ind = 0; ind < fieldDescAtt.length; ind++) {
      fieldDescAtt[ind].fieldTypeIsNumber =
        fieldDescAtt[ind].type.indexOf('.Integer') != -1 ||
        fieldDescAtt[ind].type.indexOf('.Long') != -1 ||
        fieldDescAtt[ind].type.indexOf('.Double') != -1 ||
        fieldDescAtt[ind].type.indexOf('.Float') != -1;
      fieldDescAtt[ind].fieldTypeIsDate =
        fieldDescAtt[ind].type.indexOf('.Date') != -1;
      fieldDescAtt[ind].fieldTypeIsString =
        fieldDescAtt[ind].type.indexOf('.String') != -1;
      fieldDescAtt[ind].fieldTypeIsDomain =
        fieldDescAtt[ind].type.indexOf('domain') != -1;
      if (fieldDescAtt[ind].alias == null)
        fieldDescAtt[ind].alias = fieldDescAtt[ind].name;
    }

    /**
     *       In case a property "disableStepFieldsWhen" is defined in the step configuration,
     *    calculate the test which decides if the fields are enabled or not.
     *    This is useful to forbid an update access to steps which are too old,
     *    and that are to be used in view mode only.
     *    For example a budget which is two years old has not to be modified.
     */
    $scope.checkIfFieldsAreDisabled = function(conf) {
      $scope.stepFieldsEnabled = true;
      if (conf.disableStepFieldsWhen != undefined) {
        var params = { objectFields: objectFields, objectId: $scope.objectId };
        $scope.stepFieldsEnabled = !GlobalServices.evaluateSimpleExpression(
          conf.disableStepFieldsWhen,
          params
        );
      } else if (conf.disableStepFieldsAlways != undefined) {
        $scope.stepFieldsEnabled =
          conf.disableStepFieldsAlways.toLowerCase() != 'true';
      }
    };

    /**
     *  IndIc : Inline Configuration Index
     */
    $scope.storeInlineConfigForStep = function(ind2, indIc, desc, pf, ind4) {
      //-- No specific configuration encountered so build it !
      $scope.steps[ind2].fieldDesc.inlineConfig[indIc] = {};
      $scope.steps[ind2].fieldDesc.inlineConfig[indIc].featureName = desc.name;
      $scope.steps[ind2].fieldDesc.inlineConfig[indIc].datastoreName =
        pf.datastoreName;
      $scope.steps[ind2].fieldDesc.inlineConfig[indIc].contentType =
        'panelContainer';
      $scope.steps[ind2].fieldDesc.inlineConfig[indIc].excludedFields = [
        $scope.stepTableListDescField.relations[ind4].fieldEnd,
      ];
      $scope.steps[ind2].fieldDesc.inlineConfig[indIc].scopeId = $scope.$id;
      $scope.steps[ind2].fieldDesc.inlineInput = container.inlineInput;
    };

    /**
     *
     */
    $scope.setStep = function(ind2, ind4, desc, feat, stepsConf) {
      var indIc, ind5, pf, conf;

      pf = {};
      pf.field = $scope.stepTableListDescField.relations[ind4].name;
      pf.relation = $scope.stepTableListDescField.relations[ind4];
      $scope.steps[ind2].containerMode = $scope.container.mode;
      $scope.steps[ind2].mode = $scope.container.mode;
      $scope.steps[ind2].fieldDesc.relations[
        ind4
      ].componentEndDescField = pf.relation.componentEndDescField = desc;
      pf.datastoreName = $scope.stepTableListDescField.storeName;
      pf.objectId = QueryFactory.getFeatureId(feat);
      $scope.steps[ind2].excludedFields = [];
      indIc = $scope.steps[ind2].fieldDesc.inlineConfig.length;
      //-- Check if there is a specific configuration for this feature type from server configuration.
      if (stepsConf.inlineConfigs == undefined) stepsConf.inlineConfigs = [];
      for (ind5 = 0; ind5 < stepsConf.inlineConfigs.length; ind5++) {
        conf = stepsConf.inlineConfigs[ind5];
        if (conf.featureName == desc.name) {
          if (conf.when == undefined) {
            $scope.steps[ind2].fieldDesc.inlineConfig[indIc] = conf;
            break;
          } else if (
            conf.when.conditionField != undefined &&
            feat.properties[conf.when.conditionField] ==
              conf.when.conditionValue
          ) {
            //-- Exemple de configuration supplémentaire
            //--   "when": {
            //--            "conditionValue": "day_projet_etape_finale",
            //-             "conditionField": "table_specifique"
            //--           }
            $scope.steps[ind2].fieldDesc.inlineConfig[indIc] = conf;
            break;
          }
        }
      }

      if (ind5 == stepsConf.inlineConfigs.length) {
        //-- No specific inline config from configuration file
        //-- so we have to create one in order the step be correctly displayed.
        $scope.storeInlineConfigForStep(ind2, indIc, desc, pf, ind4);
      } else {
        if (stepsConf.inlineConfigs[ind5].inlineInput != undefined)
          $scope.steps[ind2].fieldDesc.inlineInput =
            stepsConf.inlineConfigs[ind5].inlineInput;
      }
      $scope.steps[ind2].fieldDesc.inlineConfig[indIc].fieldsEnabled =
        $scope.stepFieldsEnabled;
      $scope.steps[ind2].panelFields.push(pf);

      var container = $scope.container;
      if (container.config != undefined) {
        if ($scope.steps[ind2].config == undefined)
          $scope.steps[ind2].config = {};
        if (container.config.reportFields != undefined)
          $scope.steps[ind2].config.reportFields =
            container.config.reportFields;
        if (container.config.controls != undefined)
          $scope.steps[ind2].config.controls = container.config.controls;
      }
      if ($scope.conf.fieldActions != undefined) {
        if ($scope.steps[ind2].config == undefined)
          $scope.steps[ind2].config = {};
        $scope.steps[ind2].config.fieldActions = $scope.conf.fieldActions;
      }
      if ($scope.conf.controls != undefined) {
        if ($scope.steps[ind2].config == undefined)
          $scope.steps[ind2].config = {};
        $scope.steps[ind2].config.controls = $scope.conf.controls;
      }
    };

    $scope.getStepExcludedFieldList = function(ind2) {
      //-- Prepare list of fields not do use.
      //-- This list is used to check the fields from main step object.
      var thisExcludedFieldList;
      if (
        container.inlineConfigs != undefined &&
        ind2 < container.inlineConfigs.length
      )
        thisExcludedFieldList = container.inlineConfigs[ind2].excludedFields;
      if (thisExcludedFieldList == undefined) thisExcludedFieldList = [];
      return thisExcludedFieldList;
    };

    $scope.automaticStepsLoad = function() {
      //-- -1- Get related table children
      //-- -2- Build the content of each step
      var where, res;
      $scope.getStepTableListUID();
      where = $scope.stepTableListIdField + '=' + $scope.objectId;
      StepContainerFactory.getSteps($scope.stepTableListUid, where).then(
        function() {
          var ind1, feat, indIc;
          $scope.steps = [];

          if (conf.stepsOrderingField != null) {
            //-- IF A SORT FIELD IS GIVEN
            //-- Sort the steps on ordering field.
            StepContainerFactory.resources.steps.features.sort(function(a, b) {
              if (a.properties[conf.stepsOrderingField] == null) return -1;
              if (b.properties[conf.stepsOrderingField] == null) return 1;
              if (
                a.properties[conf.stepsOrderingField] >
                b.properties[conf.stepsOrderingField]
              )
                return 1;
              if (
                a.properties[conf.stepsOrderingField] <
                b.properties[conf.stepsOrderingField]
              )
                return -1;
              // a doit etre egale a b
              return 0;
            });
          }

          $scope.stepFeatures = angular.copy(
            StepContainerFactory.resources.steps.features
          );
          $scope.specifiTablesDescField = [];
          for (
            ind1 = 0;
            ind1 < StepContainerFactory.resources.steps.features.length;
            ind1++
          ) {
            feat = StepContainerFactory.resources.steps.features[ind1];
            $scope.steps[ind1] = {};
            $scope.steps[ind1].index = ind1;
            $scope.steps[ind1].title =
              feat.properties[conf.stepsTitleFieldFromListTable];
            $scope.steps[ind1].excludedFields =
              conf.stepsExcludedFieldsFromListTable;
            $scope.steps[ind1].objectFields = feat.properties;

            //-- cloner $scope.stepTableListDescField;
            $scope.steps[ind1].fieldDesc = angular.copy(
              $scope.stepTableListDescField
            );
            $scope.steps[ind1].fieldDesc.inlineInput = conf.inlineInput;
            $scope.steps[ind1].fieldDesc.inlineConfig = [];

            if (
              conf.stepsUseSpecificTable == 'true' &&
              feat.properties[conf.stepsSpecificTableNameField] != null
            ) {
              //-- Get joined record(s)
              //-- If relation is 1-1 and joined record does not exist then create it
              //-- else display it (means set the object fields).
              res = FeatureTypeFactory.getFeatureTypeDesc(
                container.fieldDesc.storeName,
                feat.properties[conf.stepsSpecificTableNameField]
              );
              if (res == null)
                alert(
                  'Il manque la description de la table [' +
                    feat.properties[conf.stepsSpecificTableNameField] +
                    '] de la base [' +
                    container.fieldDesc.storeName +
                    ']'
                );
              else $scope.specifiTablesDescField.push(res);
            }
          }

          var ind2, ind3, ind4, feat, desc;
          if (
            $scope.specifiTablesDescField.length ==
            StepContainerFactory.resources.steps.features.length
          ) {
            for (
              ind2 = 0;
              ind2 < StepContainerFactory.resources.steps.features.length;
              ind2++
            ) {
              //-- Prepare list of fields not do use.
              //-- This list is used to check the fields from main step object.
              var thisExcludedFieldList = $scope.getStepExcludedFieldList(ind2);

              for (
                ind3 = 0;
                ind3 < $scope.specifiTablesDescField.length;
                ind3++
              ) {
                desc = $scope.specifiTablesDescField[ind3];
                if ($scope.steps[ind2].panelFields == null) {
                  $scope.steps[ind2].panelFields = [];
                  //-- In case there are fields to display from main step object
                  //-- we add them to the list now.
                  if (container.panelFields != undefined)
                    for (
                      var indPf = 0;
                      indPf < container.panelFields.length;
                      indPf++
                    )
                      //-- If the field is excluded don't load it into this step panel.
                      if (
                        thisExcludedFieldList.indexOf(
                          container.panelFields[indPf].field
                        ) == -1
                      )
                        $scope.steps[ind2].panelFields.push(
                          angular.copy(container.panelFields[indPf])
                        );
                }
                feat = StepContainerFactory.resources.steps.features[ind2];
                $scope.steps[ind2].mandatory =
                  feat.properties.etape_obligatoire;
                if (
                  desc.name == feat.properties[conf.stepsSpecificTableNameField]
                ) {
                  //$scope.steps[ind2].fieldDesc = desc;
                  for (
                    ind4 = 0;
                    ind4 < $scope.stepTableListDescField.relations.length;
                    ind4++
                  )
                    if (
                      $scope.stepTableListDescField.relations[ind4]
                        .componentEnd == desc.name
                    ) {
                      $scope.setStep(ind2, ind4, desc, feat, conf);
                      break;
                    }
                  break;
                }
              }
            }
            //$scope.fieldsReady = true;
            $scope.checkFields_1_1();
          }
        }
      );
    };

    /**
     *       Return the unique identifier of the layer/table
     *    which name is given as a parameter.
     */
    $scope.getSpecificTableUid = function(relComponentEnd) {
      var ind, specTables;

      specTables = $scope.specifiTablesDescField;
      for (ind = 0; ind < specTables.length; ind++) {
        if (specTables[ind].name == relComponentEnd) {
          return specTables[ind].uid;
        }
      }
    };

    /**
     *      Build an empty record for a given table or layer.
     *   This useful to create a related record which is going
     *   to receive information from "RelationFormField".
     */
    $scope.getNullRecordFor = function(relComponentEnd, relFieldEnd, feat) {
      var ind,
        ind2,
        specTables,
        senddata = {};

      specTables = $scope.specifiTablesDescField;
      for (ind = 0; ind < specTables.length; ind++) {
        if (specTables[ind].name == relComponentEnd) {
          for (ind2 = 0; ind2 < specTables[ind].attributes.length; ind2++) {
            senddata[specTables[ind].attributes[ind2].name] = null;
          }
          senddata[relFieldEnd] = QueryFactory.getFeatureId(feat);
          return senddata;
        }
      }
    };

    $scope.getRelation = function(relObject) {};

    /**
     *       In case of a 1 to 1 relation the related object is needed.
     *    This method add it when it still does not exist.
     */
    $scope.addObjectWhenMissing = function() {
      var rel;
      var query = $scope.relatedObjQueries[$scope.roQueryIndex];
      var deferred = $q.defer();

      //-- Relation is not a 1-1 relation
      if (query == undefined) deferred.resolve('');

      //-- No related object, so create one.
      if (query.relFeatures.length == 0) {
        $scope.objectToCreateCnt++;
        rel = query.relation;
        var properties = $scope.getNullRecordFor(
          rel.componentEnd,
          rel.fieldEnd,
          query.feat
        );
        StepContainerFactory.addObject(
          query.specTableUid,
          properties,
          rel.componentEnd,
          $scope.roQueryIndex
        ).then(function(res) {
          //-- Parent fields may be needed for an update (such case is the percentage of teh step for one project)
          if ($scope.steps[$scope.roQueryIndex].objectFields != undefined)
            $scope.steps[$scope.roQueryIndex].parentObjectFields =
              $scope.steps[$scope.roQueryIndex].objectFields;
          var created = res.data.create[0];
          if (created.id != undefined) {
            var indPt = created.id.indexOf('.');
            //                              resources.relIds[ind] = {};

            $scope.steps[$scope.roQueryIndex].objectFields = properties;
            $scope.steps[$scope.roQueryIndex].objectId = created.id.substr(
              indPt + 1
            );
            $scope.steps[
              $scope.roQueryIndex
            ].featureName = QueryFactory.getFeatureName(created);
          }

          deferred.resolve('');
        });
      } else {
        //-- Parent fields may be needed for an update (such case is the percentage of the step for one project)
        if ($scope.steps[$scope.roQueryIndex].objectFields != undefined)
          $scope.steps[$scope.roQueryIndex].parentObjectFields =
            $scope.steps[$scope.roQueryIndex].objectFields;
        $scope.steps[$scope.roQueryIndex].objectFields =
          query.relFeatures[0].properties;
        $scope.steps[$scope.roQueryIndex].objectId = QueryFactory.getFeatureId(
          query.relFeatures[0]
        );
        $scope.steps[
          $scope.roQueryIndex
        ].featureName = QueryFactory.getFeatureName(query.relFeatures[0]);
        deferred.resolve('');
      }
      return deferred.promise;
    };

    $scope.setSpecificTablesCreatedTrue = function(query) {
      var stepRecord = query.feat;

      if (stepRecord.properties['specific_tables_created'] !== undefined) {
        //-- Build GeoJSON object describing the object we want  to insert
        var senddata = GlobalServices.initEditFeatures();

        senddata.features[0].id = stepRecord.id;
        senddata.features[0].properties = stepRecord.properties;
        senddata.features[0].properties['specific_tables_created'] = true;
        EditFactory.update($scope.stepTableListUid, senddata).then(function(
          res
        ) {
          var errorMsg;

          if (res.statusText != 'OK' || res.config.data.features.length == 0) {
            //console.log("Echec de mise à jour de ["+$scope.descField.name+"]");
            var errorMsg = '<h4>Erreur</h4> ';
            errorMsg +=
              '<br/><h4>Details</h4>  Echec de mise à jour de la table des étapes !';
            require('toastr').error(errorMsg);
          }
        });
      }
    };

    $scope.manageMandatoryStep = function() {
      if ($scope.container.mode == 'readonly')
        $scope.steps[$scope.roQueryIndex].mode = $scope.container.mode;
      else {
        var i1, i2, feats;
        feats = $scope.relatedObjQueries[$scope.roQueryIndex].relFeatures;
        $scope.steps[$scope.roQueryIndex].allValuesAreNull = true;
        for (
          i1 = 0;
          i1 < feats.length &&
          $scope.steps[$scope.roQueryIndex].allValuesAreNull;
          i1++
        )
          for (var prop in feats[i1].properties)
            if (
              prop != 'id_etape' &&
              feats[i1].properties[prop] != null &&
              feats[i1].properties[prop] != ''
            ) {
              $scope.steps[$scope.roQueryIndex].allValuesAreNull = false;
              break;
            }
      }
    };

    /**
     *       For each step of the procedure get the related object.
     */
    $scope.getStepRelatedObject = function() {
      var query = $scope.relatedObjQueries[$scope.roQueryIndex];
      if (query == undefined) {
        if (++$scope.roQueryIndex < $scope.relatedObjQueries.length)
          $scope.getStepRelatedObject();
        return;
      }
      //-- Get step related object
      QueryFactory.data(query.specTableUid, query.where).then(function(res) {
        $scope.relatedObjQueries[$scope.roQueryIndex].relFeatures =
          res.data.features;
        $scope.addObjectWhenMissing().then(function(res) {
          $scope.manageMandatoryStep();
          //-- Previous query done, now we execute the next one
          if (++$scope.roQueryIndex < $scope.relatedObjQueries.length) {
            $scope.getStepRelatedObject();
            //-- If it exists set the specific_tables_created attribute to TRUE
            $scope.setSpecificTablesCreatedTrue(
              $scope.relatedObjQueries[$scope.roQueryIndex]
            );
          }
          //-- Last related object query has been treated, may be the insertion
          //-- of the related object (if one) is not totally finished
          //-- but it is not so critical.
          else $scope.ready = true;
        });
      });
    };

    $scope.checkFields_1_1 = function() {
      //-- Check fields which relation cardinality is 1-1
      //-- are in relation with something. If not then we create an empty record.
      var query, where, rel, ind1, ind2, ind4, feat, relObjects;

      $scope.rel_1_1_cnt = 0;
      $scope.objectToCreateCnt = 0;
      $scope.relatedObjQueries = [];
      for (
        ind1 = 0;
        ind1 < StepContainerFactory.resources.steps.features.length;
        ind1++
      ) {
        //-- This field is one to one relation so check if the related object and
        //-- create it in case it does not exist.
        for (
          ind4 = 0;
          ind4 < $scope.stepTableListDescField.relations.length;
          ind4++
        ) {
          rel = $scope.stepTableListDescField.relations[ind4];
          if (
            rel.componentEnd ==
            StepContainerFactory.resources.steps.features[ind1].properties[
              conf.stepsSpecificTableNameField
            ]
          ) {
            if (rel.occurence != '1-1')
              $scope.relatedObjQueries.push(undefined);
            else {
              $scope.rel_1_1_cnt++;
              query = {};
              query.feat = StepContainerFactory.resources.steps.features[ind1];
              query.where =
                rel.fieldEnd + '=' + QueryFactory.getFeatureId(query.feat);
              query.specTableUid = $scope.getSpecificTableUid(rel.componentEnd);
              query.relation = rel;
              $scope.relatedObjQueries.push(query);
              //			    				  break;
            }
          }
        }
      }
      //-- No 1 to 1 relation so we are ready
      if ($scope.rel_1_1_cnt == 0) $scope.ready = true;
      else if ($scope.relatedObjQueries.length != 0) {
        $scope.roQueryIndex = 0;
        $scope.getStepRelatedObject();
      }
    };

    $scope.staticStepsLoad = function() {
      var steps;
      if (container.steps != null) steps = container.steps;
      else steps = $scope.steps;
      for (ind = 0; ind < steps.length; ind++) {
        steps[ind].objectFields = objectFields;
        steps[ind].fieldDesc = container.fieldDesc;
      }

      $scope.steps = steps;
      $scope.objectFields = objectFields;
      $scope.fieldDesc = container.fieldDesc;
    };

    $scope.getStepTableListUID = function() {
      // Look for relation used to generate step list.
      // When found store the table information (already loaded from main component).
      var ind1;
      if (conf.stepsListTable == null)
        alert('Propri�t� de configuration absente: [stepsListTable]');
      for (ind1 = 0; ind1 < fieldDescRelations.length; ind1++) {
        if (fieldDescRelations[ind1].componentEnd == conf.stepsListTable) {
          $scope.stepTableDesc = fieldDescRelations[ind1].componentEndDescField;
          $scope.stepTableListUid =
            fieldDescRelations[ind1].componentEndDescField.uid;
          $scope.stepTableListDescField =
            fieldDescRelations[ind1].componentEndDescField;
          $scope.stepTableListIdField = fieldDescRelations[ind1].fieldEnd;
          break;
        }
      }
    };

    if (
      conf.stepsConfig == null &&
      (conf.steps != null || $scope.steps != null)
    )
      conf.stepsConfig = 'static';
    else conf.stepsConfig = 'automatic';
    $scope.stepsConfig = conf.stepsConfig;

    $scope.checkIfFieldsAreDisabled(conf);
    if ($scope.objectId != undefined) {
      if (conf.stepsConfig == 'automatic') $scope.automaticStepsLoad();
      else $scope.staticStepsLoad();
    }

    $scope.$on('gotRelatedObjects', function(event, data) {
      if ($scope.objectId == undefined) {
        //-- In case called from relation thru ffpl2 objecId was undefined
        //-- else the step records' parent is known.
        //-- The parent has been retrieved in relation form field so we can build the step sontent
        $scope.objectId = QueryFactory.getFeatureId(data.objects.features[0]);
        if (conf.stepsConfig == 'automatic') $scope.automaticStepsLoad();
        else $scope.staticStepsLoad();
      }
    });

    //initiate an array to hold all active tabs
    $scope.activeTabs = [];

    //check if the tab is active
    $scope.isOpenTab = function(tab) {
      //check if this tab is already in the activeTabs array
      if ($scope.activeTabs.indexOf(tab) > -1) {
        //if so, return true
        return true;
      } else {
        //if not, return false
        return false;
      }
    };

    //function to 'open' a tab
    $scope.openTab = function(tab) {
      var ind;
      //check if tab is already opened
      if ($scope.isOpenTab(tab)) {
        $scope.activeTabs.splice($scope.activeTabs.indexOf(tab), 1);
      } else {
        for (ind = 0; ind < $scope.activeTabs.length; ind++)
          if ($scope.isOpenTab($scope.activeTabs[ind])) {
            $scope.activeTabs.splice(ind, 1);
            //-- No more than one tab opened at a time
            break;
          }
        //if it's not opened, add it!
        $scope.activeTabs.push(tab);
      }
    };

    $scope.updateTheStep = function(ind1, theStep) {
      var propertyName, fieldIndex;
      var senddata, idValue;

      //-- Build GeoJSON object describing the object we want  to insert
      senddata = GlobalServices.initEditFeatures();

      //-- Get input values (set from input fields)
      for (propertyName in $scope.stepFeatures[ind1].properties) {
        fieldIndex = GlobalServices.getAttributeIndex(
          $scope.stepTableDesc,
          propertyName
        );
        if (fieldIndex != -1)
          senddata.features[0].properties[
            propertyName
          ] = GlobalServices.getValueForDB(
            $scope.stepTableDesc,
            propertyName,
            theStep.parentObjectFields[propertyName],
            fieldIndex
          );
      }
      senddata.features[0].id = $scope.stepFeatures[ind1].id;

      EditFactory.update($scope.stepTableListUid, senddata).then(function(res) {
        var errorMsg;

        if (res.statusText != 'OK' || res.config.data.features.length == 0) {
          //console.log("Echec de mise à jour de ["+$scope.descField.name+"]");
          gaJsUtils.errorMessage(
            'Echec de mise à jour de [' + $scope.descField.name + ']'
          );
        }
      });
    };

    $scope.setTheStepParam = function(theStep, params) {
      if (params.allValuesAreNull != undefined)
        $scope.steps[theStep.index].allValuesAreNull = params.allValuesAreNull;
      if (
        theStep.containerMode != 'readonly' &&
        !params.allValuesAreNull &&
        theStep.mandatory == 1
      ) {
        if (theStep.index + 1 < $scope.steps.length)
          $scope.steps[theStep.index + 1].mode = 'write';
      }
    };

    var fn;
    var ind1;
    var ind2;
    var ind3;
    var panelFields;
    $scope.valueChangedFunction = true;
    $scope.valueChanged = function(params) {
      if ($scope.objectFields != undefined)
        for (ind1 = 0; ind1 < $scope.steps.length; ind1++) {
          panelFields = $scope.steps[ind1].panelFields;

          for (ind2 = 0; ind2 < panelFields.length; ind2++) {
            if (panelFields[ind2].field != null) {
              fn = panelFields[ind2].field;
              $scope.objectFields[fn] = $scope.steps[ind1].objectFields[fn];
            } else {
              for (
                ind3 = 0;
                ind3 < panelFields[ind2].group.fieldOrder.length;
                ind3++
              ) {
                fn = panelFields[ind2].group.fieldOrder[ind3];
                $scope.objectFields[fn] = $scope.steps[ind1].objectFields[fn];
              }
            }
          }
        }
      else if (params.theStep != undefined)
        for (ind1 = 0; ind1 < $scope.steps.length; ind1++) {
          if ($scope.steps[ind1] == params.theStep) {
            $scope.updateTheStep(ind1, params.theStep);
            return;
          }
        }
      /*
       		 var mess = "Scope:\n";
       		 for (ind1=0;ind1<$scope.fieldDesc.attributes.length;ind1++)
       			  mess += "  - "+$scope.fieldDesc.attributes[ind1].name+" : "+$scope.objectFields[ $scope.fieldDesc.attributes[ind1].name ]+"\n";
       		 alert(mess);
*/
      if (
        $scope.$parent != null &&
        $scope.$parent.valueChangedFunction === true
      ) {
        $scope.$parent.valueChanged();
      }
    };
  };

  StepContainerCtrl.$inject = [
    '$scope',
    'StepContainerFactory',
    'QueryFactory',
    'GlobalServices',
    'EditFactory',
    'FeatureTypeFactory',
    '$q',
    'gaJsUtils',
  ];
  return StepContainerCtrl;
});
