/**
 *
 */
'use strict';
define(function() {
  var FormFieldPanelCtrl_l2 = function($scope) {
    var fieldDesc, fieldValue;
    var objectFields, specialFields;
    var fieldOrder;
    var panelFields;
    var relations;
    var relMainFields;
    var ind0 = 0;
    var ind1;
    var ind2 = 0;
    var ind3;
    var fn;
    var indFD;
    var fieldList = [];
    var fieldGroups = [];
    var panel;

    if ($scope.$parent.panel != undefined) panel = $scope.$parent.panel;
    else if ($scope.$parent.tab != undefined) panel = $scope.$parent.tab;
    else if ($scope.theStep != undefined) panel = $scope.theStep;
    else if ($scope.$parent.theStep != undefined)
      panel = $scope.$parent.theStep;

    if (panel != null) {
      fieldDesc = panel.fieldDesc;
      objectFields = panel.objectFields;
      fieldOrder = panel.fieldOrder;
      panelFields = panel.panelFields;
      relMainFields = panel.tableMainFields;
      specialFields = panel.specialFields;
    } else {
      if ($scope.$parent != null) {
        fieldDesc = $scope.$parent.descField;
        objectFields = $scope.$parent.objectFields;
        fieldOrder = $scope.$parent.config.fieldOrder;
        panelFields = $scope.$parent.config.panelFields;
        panelFields = $scope.$parent.config.specialFields;
        relMainFields = $scope.$parent.config.tableMainFields;
      }
    }
    relations = fieldDesc.relations;
    fieldDesc = fieldDesc.attributes;
    if (relations == null) relations = [];
    if (specialFields == null) specialFields = [];

    // No panel field list defined so we use all the field of the table description.
    if (panelFields == null) {
      panelFields = [];
      for (ind2 = 0; ind2 < fieldDesc.length; ind2++) {
        panelFields[ind2] = {};
        panelFields[ind2].field = fieldDesc[ind2].name;
      }
      // Add relations (at the end by default)
      for (ind1 = 0; ind1 < relations.length; ind1++) {
        panelFields[ind2] = {};
        panelFields[ind2++].field = relations[ind1].name;
      }
    }

    // No field ordering defined so we build it from panel field list.
    if (fieldOrder == null) {
      fieldOrder = [];
      for (ind2 = 0; ind2 < panelFields.length; ind2++)
        fieldOrder[ind2] = panelFields[ind2].field;
    }

    for (ind1 = 0; ind1 < fieldOrder.length; ind1++) {
      for (ind2 = 0; ind2 < panelFields.length; ind2++) {
        //            			 if (panelFields[ind1].field!=null && panelFields[ind1].field==fieldOrder[ind1])
        // Simple field
        if (panelFields[ind2].field == fieldOrder[ind1]) {
          fieldList[ind0] = panelFields[ind2];
          for (indFD = 0; indFD < fieldDesc.length; indFD++) {
            if (fieldDesc[indFD].name == fieldOrder[ind1]) {
              fieldList[ind0].fieldDesc = fieldDesc[indFD];
              break;
            }
          }
          if (indFD == fieldDesc.length)
            for (indFD = 0; indFD < relations.length; indFD++) {
              if (relations[indFD].name == fieldOrder[ind1]) {
                fieldList[ind0].relation = relations[indFD];
                fieldList[ind0].fieldDesc = {};
                fieldList[ind0].fieldDesc.fieldTypeIsRelation = true;
                for (ind3 = 0; ind3 < relMainFields.length; ind3++)
                  if (
                    relMainFields[ind3].table == relations[indFD].componentEnd
                  )
                    fieldList[ind0].relatedObjectField =
                      relMainFields[ind3].fields[0];
                if (panelFields[ind2].lineNumber == null)
                  fieldList[ind0].lineNumber = 3;
                else fieldList[ind0].lineNumber = panelFields[ind2].lineNumber;

                // Store relation start field value in order to be able
                // to get objects already in relation with this one.
                fieldList[ind0].objectId =
                  objectFields[relations[indFD].fieldStart];
                break;
              }
            }

          if (
            specialFields != null &&
            specialFields[fieldOrder[ind1]] != null
          ) {
            if (specialFields[fieldOrder[ind1]].rows != null)
              fieldList[ind0].rows = specialFields[fieldOrder[ind1]].rows;
            if (specialFields[fieldOrder[ind1]].type != null)
              if (specialFields[fieldOrder[ind1]].type == 'comment') {
                if (fieldList[ind0].fieldDesc != null) {
                  fieldList[ind0].fieldDesc.fieldTypeIsComment = true;
                  fieldList[ind0].fieldDesc.fieldTypeIsString = false;
                }
              }
          }
          if (objectFields[fieldOrder[ind1]] == null) fieldValue = '';
          else fieldValue = objectFields[fieldOrder[ind1]];
          fieldList[ind0++].objectField = {
            name: fieldOrder[ind1],
            value: fieldValue,
          };
          break;
        }
      }
    }

    ind0 = 0;
    for (ind1 = 0; ind1 < panelFields.length; ind1++) {
      if (panelFields[ind1].group != null) {
        fieldGroups[ind0] = panelFields[ind1];
        fieldGroups[ind0].fieldDesc = fieldDesc;
        fieldGroups[ind0].fieldOrder = panelFields[ind1].group.fieldOrder;
        fieldGroups[ind0].title = panelFields[ind1].group.title;
        fieldGroups[ind0++].objectFields = objectFields;
      }
    }

    $scope.fieldList = fieldList;
    $scope.fieldGroups = fieldGroups;

    // When a value has been changed we get all values from lower components
    $scope.valueChangedFunction = true;
    $scope.valueChanged = function() {
      for (ind0 = 0; ind0 < $scope.fieldList.length; ind0++) {
        objectFields[$scope.fieldList[ind0].objectField.name] =
          $scope.fieldList[ind0].objectField.value;
      }
      for (ind0 = 0; ind0 < fieldGroups.length; ind0++) {
        for (
          ind1 = 0;
          ind1 < $scope.fieldGroups[ind0].fieldOrder.length;
          ind1++
        ) {
          fn = $scope.fieldGroups[ind0].fieldOrder[ind1];
          objectFields[fn] = $scope.fieldGroups[ind0].objectFields[fn];
        }
      }
      if ($scope.$parent.valueChangedFunction === true) {
        $scope.$parent.valueChanged();
      }
    };
  };

  FormFieldPanelCtrl_l2.$inject = ['$scope'];
  return FormFieldPanelCtrl_l2;
});
