/**
 *
 */
'use strict';
define(function() {
  var FormFieldCtrl = function(
    $scope,
    $timeout,
    $datepicker,
    QueryFactory,
    ngDialog,
    UnitsFactory,
    ConfigFactory,
    FeatureTypeFactory,
    SelectManager,
    UsersFactory,
    GlobalServices,
    gaJsUtils
  ) {
    //-- Description of the field (type, length)
    //-- Example:
    //--          {
    //--           "name": "nom",
    //--           "alias": "nom",
    //--           "type": "java.lang.String",
    //--           "isNillable": false,
    //--           "size": 500,
    //--           "restrictions": []
    //--          }

    var fieldDesc, ind03, fieldType;

    $scope.prepareStoredAsField = function() {
      if ($scope.theField01.valueStoredAs != undefined) {
        //$scope.theField01.objectField = GlobalServices.getStoredValueObj($scope.theField01.valueStoredAs.name);
        GlobalServices.getStoredValueObj(
          $scope.theField01.valueStoredAs.name
        ).then(function(res) {
          $scope.theField01.objectField = res;
          GlobalServices.gotStoredValue($scope.theField01.valueStoredAs.name);
        });
        if ($scope.theField01.fieldDesc == undefined)
          $scope.theField01.fieldDesc = {};
        $scope.theField01.fieldDesc.type = $scope.theField01.valueStoredAs.type;
        if ($scope.theField01.fieldDesc.alias == undefined)
          $scope.theField01.fieldDesc.alias = $scope.theField01.alias;
        if ($scope.theField01.fieldDesc.alias == undefined)
          $scope.theField01.fieldDesc.alias = $scope.theField01.field;
        $scope.theField01.fieldDesc.unit = $scope.theField01.valueStoredAs.unit;
      }

      if ($scope.theField01.storeAs != undefined)
        GlobalServices.storeValueObj(
          $scope.theField01.storeAs,
          $scope.theField01.objectField
        );
    };

    /**
     *       Check if the field is a mandatory one.
     *    If so check if the value is null or not.
     *    If the value is null and the field is mandatory then
     *    set the flag named "$scope.theField01.requiredValueIsNull" to true,
     *    else set it to false.
     */
    $scope.manageRequiredField = function(callValueChangedWhenValueNeeded) {
      if (
        $scope.theField01.panelUse != 'search' &&
        $scope.widgetState != 'view' &&
        (($scope.theField01.required != undefined &&
          $scope.theField01.required == 'true') ||
          $scope.theField01.fieldDesc.isNillable === false)
      ) {
        $scope.requiredValueIsNull =
          $scope.theField01.objectField.value == null ||
          (isNaN($scope.theField01.objectField.value) &&
            $scope.theField01.fieldDesc.fieldTypeIsNumber) ||
          $scope.theField01.objectField.value == '';
        $scope.theField01.requiredValueIsNull = $scope.requiredValueIsNull;
        //-- At initialization time thie method is not called from value changed,
        //-- so the parent cannot be informed that there is a mandatory field without value.
        //-- That's why we have to call it in such a case,
        //-- and the parameter named "callValueChangedWhenValueNeeded" is used for it.
        if (callValueChangedWhenValueNeeded) $scope.valueChanged();
      } else $scope.requiredValueIsNull = false;
    };

    $scope.configureDatePicker = function() {
      $scope.datepickerOptions = {
        format: 'yyyy-mm-dd',
        language: 'fr',
        autoclose: true,
        weekStart: 0,
      };
    };

    $scope.prepareFieldDesc = function() {
      if ($scope.theField01.fieldDesc != undefined) {
        var dep = $scope.theField01.fieldDesc.visibilityDependsOn;
        if (dep == undefined || dep.defaultVisibility == undefined)
          $scope.visible = true;
        else $scope.visible = dep.defaultVisibility == 'true';
      }
    };

    $scope.initializeScope = function() {
      $scope.unitList = [];
      $scope.thisId = $scope.$id;
      $scope.lastChangeTime = 0;
      $scope.enabled = true;
      $scope.labelMinWidth = '200px';
      if ($scope.theField01.mode == undefined) $scope.theField01.mode = 'write';
      if (
        $scope.theField01.inlineConfig !== undefined &&
        $scope.theField01.inlineConfig.fieldsEnabled !== undefined &&
        !$scope.theField01.inlineConfig.fieldsEnabled
      )
        $scope.theField01.mode = 'readonly';

      if ($scope.theField01.fieldDesc == null) $scope.theField01.fieldDesc = {};
      if ($scope.theField01.fieldDesc.relation == null) {
        $scope.theField01.fieldDesc.relation = {};
        $scope.theField01.fieldDesc.relation.callForm = true;
      }
      if (
        $scope.theField01.objectId == undefined &&
        $scope.$parent.objectId != undefined
      )
        $scope.theField01.objectId = $scope.$parent.objectId;
      if ($scope.theField01.config != undefined) {
        $scope.theField01.contentType = $scope.theField01.config.contentType;
        if ($scope.theField01.contentType == 'fftable4updl2')
          $scope.mainObjectId = $scope.theField01.objectId;
      }
      $scope.initUnit();
      $scope.configureDatePicker();
      $scope.manageRequiredField(true);
      //-- In case the field is a "more input" field there is no objectField property.
      if ($scope.theField01.objectField != undefined)
        $scope.lastOkValue = $scope.theField01.objectField.value;
    };

    /**
     *       Extract id value from id string which looks like
     *    "featuretypename.X" where X is the identifier value.
     */
    $scope.getFeatureId = function(feature) {
      var indPt;

      indPt = feature.id.indexOf('.');
      if (indPt == -1) return parseInt(feature.id);
      else return parseInt(feature.id.substr(indPt + 1));
    };

    $scope.getMainFieldForTable = function() {
      if ($scope.theField01.relatedObjectField != null)
        return $scope.theField01.relatedObjectField.field;
      else
        gaJsUtils.errorMessage(
          'Pas de champ configuré pour afficher dans la liste [' +
            $scope.theField01.field +
            ']) !'
        );
      return null;
    };

    $scope.getMainFieldsForTable = function() {
      if ($scope.theField01.relatedObjectFields != undefined)
        return $scope.theField01.relatedObjectFields;
      else
        gaJsUtils.errorMessage(
          'Pas de champs configurés pour afficher dans la liste (champ concerné: [' +
            $scope.theField01.field +
            ']) !'
        );
      return null;
    };

    $scope.addValueToSelect = function(code, value, group_value) {
      var item = {};

      item.code = code;
      item.value = value;
      item.group_value = group_value;
      $scope.theField01.fieldDesc.listOfValues.push(item);
    };

    $scope.selectFirstItem = function() {
      /*
           var elt = document.getElementById("select_"+$scope.thisId);
           
           if (elt.selectedIndex == -1)
              {
               elt.selectedIndex = 0;
               setTimeout( $scope.selectFirstItem,200);
              }
           else
           */
      $scope.valueChanged();
    };

    $scope.refreshValueList = function(loading) {
      var ind01, feat, mainFields, value, grp_value, fd;
      var defaultValueExists = false;

      $scope.theField01.fieldDesc.listOfValues.splice(
        0,
        $scope.theField01.fieldDesc.listOfValues.length
      );
      mainFields = $scope.getMainFieldsForTable();
      if ($scope.theField01.panelUse == 'search')
        $scope.addValueToSelect('', '-- Aucun --');
      for (ind01 = 0; ind01 < $scope.relatedObjects.features.length; ind01++) {
        feat = $scope.relatedObjects.features[ind01];

        if (mainFields != null) {
          value = '';
          for (var iField = 0; iField < mainFields.length; iField++)
            value += feat.properties[mainFields[iField].field] + ' ';
        }
        //-- Il y a eut un cas avec marche approbation où une liste vide existe !
        else if (ind01 < $scope.theField01.fieldDesc.listOfValues.length)
          value = $scope.theField01.fieldDesc.listOfValues[ind01].code;
        else value = '';

        if ($scope.theField01.fieldDesc.groupSelect == undefined)
          $scope.addValueToSelect($scope.getFeatureId(feat), value);
        else {
          fd = $scope.theField01.fieldDesc;
          grp_value = feat.properties[fd.groupSelect.group_field];
          if (
            fd.groupSelect.group_matching != undefined &&
            fd.groupSelect.group_matching[grp_value] != undefined
          )
            grp_value = fd.groupSelect.group_matching[grp_value];
          else if (fd.groupSelect.group_matching['_null_'] != undefined)
            grp_value = fd.groupSelect.group_matching['_null_'];
          $scope.addValueToSelect($scope.getFeatureId(feat), value, grp_value);
        }

        if (
          $scope.theField01.fieldDesc.listOfValues[ind01].value ==
          $scope.theField01.objectField.value
        )
          defaultValueExists = true;
      }
      //-- objectField may be defined if the field is called
      //-- from a widget with update state.
      if (
        !defaultValueExists &&
        $scope.relatedObjects.features.length != 0 &&
        $scope.theField01.objectField.value == ''
      ) {
        $scope.theField01.objectField.value =
          $scope.theField01.fieldDesc.listOfValues[0].code;
        $scope.dependencyIdForChildren =
          $scope.theField01.fieldDesc.listOfValues[0].code;
        $scope.valueChanged();
      } else {
        $scope.savedValue = $scope.theField01.objectField.value;
        $scope.theField01.objectField.value = '';
        var len = $scope.theField01.fieldDesc.listOfValues.length;
        for (ind01 = 0; ind01 < len; ind01++)
          if (
            $scope.theField01.fieldDesc.listOfValues[ind01].code ==
            $scope.savedValue
          ) {
            if ($scope.theField01.fieldDesc.listOfValues.length != 0) {
              $scope.theField01.objectField.value =
                $scope.theField01.fieldDesc.listOfValues[ind01].code;
              $scope.selectFirstItem();
            }
            break;
          }
        //-- No matching object found so select the first one
        if (ind01 == len && len != 0) {
          $scope.theField01.objectField.value =
            $scope.theField01.fieldDesc.listOfValues[0].code;
          $scope.selectFirstItem();
        }
      }
    };

    /**
     *       Build list of values for dropdown list in case values come from a table.
     *   If this field depends on another one there is a where clause to build
     *   which restrict the list to those in relation with the main field
     *   (ie the parent of the relation).
     */
    $scope.loadListOfValuesFromTable = function(loading) {
      if ($scope.theField01.relation == undefined) return;
      //-- Get all table records and set the value list used by the select.
      //-- If ID is provided then get related objects
      $scope.theField01.tableDesc = FeatureTypeFactory.getFeatureTypeDesc(
        $scope.theField01.datastoreName,
        $scope.theField01.relation.componentStart
      );
      var where = '';
      if (
        $scope.parentId != null &&
        $scope.parentId != '' &&
        $scope.theField01.fieldDesc.dependsOn != undefined
      )
        where =
          $scope.theField01.fieldDesc.dependsOn.id_enfant +
          '=' +
          $scope.parentId;
      QueryFactory.data($scope.theField01.tableDesc.uid, where).then(function(
        res
      ) {
        //alert(res);
        $scope.relatedObjects = res.data;
        $scope.refreshValueList(loading);
      });

      //FormFieldFactory.getRelatedObjects($scope.theField01.tableDesc.uid,where);

      /* FormFieldFactory.getRelatedObjects($scope.theField01.tableDesc.uid,where);
            //
       	var featureTypeUid = FormFieldFactory.tablesgetfinfo($scope.theField01.datastoreName,$scope.theField01.relation.componentStart).then
        	(
        		function()
        		{
        			$scope.theField01.tableDesc = FormFieldFactory.resources.tableDescription;
          		    //var where = $scope.theField01.relation.fieldEnd+"="+$scope.theField01.objectId;
        			//FormFieldFactory.getRelatedObjects($scope.theField01.tableDesc.uid,where).then
        			var where="";
        			if ($scope.parentId!=null && $scope.parentId!="")
        				where = $scope.theField01.fieldDesc.dependsOn.id_enfant+"="+$scope.parentId;
        			FormFieldFactory.getRelatedObjects($scope.theField01.tableDesc.uid,where).then
        			  (
       				   function()
        			   {
        				   	$scope.relatedObjects = $scope.resources.objects;
        				   	$scope.refreshValueList();
        	 		   }
        			  );
        		}
        	);
*/
    };

    /**
     *     Reset the field name in order it is correctly set when update to database is done.
     *  Now we set it to be the id field name which should look like id_xxx.
     *  This function is called when there is a relation with a selection form.
     *  In this case the property name of the object objectField has been
     *  set with the name of the relation.
     */
    $scope.setIdFieldNameForRelationWithForm = function() {
      var prefix = '',
        ptInd;

      //-- In case the field is on a related table, we have to keep the prefix
      //-- (which is the related table name).
      ptInd = $scope.theField01.objectField.name.indexOf('.');
      if (ptInd != -1)
        prefix = $scope.theField01.objectField.name.substr(0, ptInd + 1);

      if (
        $scope.theField01.relation.componentEnd == $scope.theField01.featureName
      )
        $scope.theField01.objectField.name =
          prefix + $scope.theField01.relation.fieldEnd;
      else
        $scope.theField01.objectField.name =
          prefix + $scope.theField01.relation.fieldStart;
    };

    $scope.getThisObjectIdFieldNameForRelationWithForm = function() {
      if (
        $scope.theField01.relation.componentEnd == $scope.theField01.featureName
      )
        return $scope.theField01.relation.fieldStart;
      else return $scope.theField01.relation.fieldEnd;
    };

    /**
     * TODO : commenter
     */
    $scope.setDate = function(ind) {
      var strDate, dDate, ms;

      if (
        $scope.theField01.objectField.value != null &&
        $scope.theField01.objectField.value != '' &&
        $scope.theField01.objectField.value.trim != undefined
      ) {
        //-- Actually the date is a string ...
        strDate = $scope.theField01.objectField.value;
        $scope.theField01.objectField.value = strDate.substr(0, 10);
      } else {
        //--yyyyyyyyy a enlever TODO dDate = new Date();
        //-- $scope.theField01.objectField.value = dDate;
        $scope.theField01.objectField.value = null;
      }
    };

    /**
     *     Called only when object value changed and field is a unit field.
     */
    $scope.objectValueChanged = function() {
      if (!$scope.objectValuieChangedBecauseOfUnitSelection)
        $scope.numericValue.value = $scope.theField01.objectField.value;
      $scope.objectValuieChangedBecauseOfUnitSelection = false;
    };

    $scope.unitChanged = function() {
      if ($scope.currentUnitFactor.value != undefined) {
        $scope.theField01.objectField.value =
          $scope.numericValue.value * $scope.currentUnitFactor.value.factor;
        $scope.objectValuieChangedBecauseOfUnitSelection = true;
      }
    };

    $scope.initUnit = function() {
      var unitName, unitDesc;
      var fd = $scope.theField01.fieldDesc;
      if (fd.unit == undefined || fd.unit.type == undefined)
        $scope.fieldHasUnit = false;
      else {
        $scope.fieldHasUnit = true;
        unitName = fd.unit.type;
        $scope.currentUnitFactor = {};
        $scope.numericValue = {};
        //-- Initial value (in case there is one)
        $scope.numericValue.value = $scope.theField01.objectField.value;
        UnitsFactory.getUnitDescription(unitName).then(function(res) {
          $scope.unitDesc = res;
          if (
            $scope.unitDesc != undefined &&
            $scope.unitDesc.multiple.length != 0
          ) {
            $scope.$watch('currentUnitFactor.value', $scope.unitChanged);
            //-- Next watch is useful once because theField01.objectField.value
            //-- changes out of this directive only when the query from parent (relation form field)
            //-- get the value after this directive be created.
            $scope.$watch(
              'theField01.objectField.value',
              $scope.objectValueChanged
            );
            for (var ind = 0; ind < $scope.unitDesc.multiple.length; ind++)
              if (
                $scope.unitDesc.multiple[ind].factor == fd.unit.defaultFactor
              ) {
                $scope.dbUnit = $scope.unitDesc.multiple[ind].symbol;
                $scope.currentUnitFactor.value = $scope.unitDesc.multiple[ind];
                break;
              }
          }
        });
      }
    };

    $scope.setDomainForField = function(fieldDesc, restriction) {
      $scope.fieldTypeIsDomain = true;
      fieldDesc.listOfValues = [];
      for (var prop in restriction.listofValues) {
        ind03 = $scope.theField01.fieldDesc.listOfValues.length;
        fieldDesc.listOfValues[ind03] = {};
        fieldDesc.listOfValues[ind03].code = prop;
        fieldDesc.listOfValues[ind03].value = restriction.listofValues[prop];
      }
    };

    /**
          *  Une configuration d'interval peut être utilisée.

          *  -1- Pour dire qu'on n'utilise pas de champ spécial
          *      (cas où interval défini dans description du champ
          *       mais où on veut le gérer sans champ spécial)
          *      {
          *       intervalDesc: {
          *        "useIntervalField": false
          *       }
          *      } 

          *  -2- Pour décrire un interval (comme description du champ)
          *      {
          *       intervalDesc: {
          *        "useIntervalField": true,
          *        "min": 1,
          *        "max": 10,
          *        "mininclus": true,
          *        "maxinclus": true
          *       }
          *      } 
          * 
          */
    $scope.setIntervalForField = function(fieldDesc, restriction) {
      $scope.fieldHasInterval = true;
      fieldDesc.minval = restriction.interval.min;
      fieldDesc.maxval = restriction.interval.max;
      fieldDesc.minvalincluded = restriction.mininclus;
      fieldDesc.maxvalincluded = restriction.maxinclus;
      if (
        $scope.theField01.config != undefined &&
        $scope.theField01.config.intervalDesc != undefined
      )
        $scope.fieldTypeIsInterval =
          $scope.theField01.config.intervalDesc.useIntervalField;
      else $scope.fieldTypeIsInterval = true;
    };

    $scope.prepareFieldAsListOfValue = function(fieldDesc) {
      var ind01, restr;

      if (fieldDesc.restrictions == undefined) return;
      //-- Field is restricted to a list of values or yyyyyyy ?
      for (ind01 = 0; ind01 < fieldDesc.restrictions.length; ind01++) {
        restr = fieldDesc.restrictions[ind01];
        if (restr.type == 'Domain') {
          $scope.setDomainForField(fieldDesc, restr);
        } else if (restr.type == 'Interval') {
          $scope.setIntervalForField(fieldDesc, restr);
        }
      }
      if (
        $scope.theField01.config != undefined &&
        $scope.theField01.config.intervalDesc != undefined &&
        $scope.theField01.config.intervalDesc.useIntervalField
      ) {
        $scope.fieldTypeIsInterval = true;
        $scope.fieldTypeIsDate = $scope.fieldTypeIsNumber = $scope.fieldTypeIsString = $scope.fieldTypeIsComment = $scope.fieldTypeIsBoolean = false;
      }
    };

    $scope.defineFieldType = function(fieldDesc) {
      if (fieldDesc.type != undefined) {
        $scope.theField01.fieldDesc.fieldTypeIsNumber =
          fieldDesc.type.indexOf('.Integer') != -1 ||
          fieldDesc.type.indexOf('.Long') != -1 ||
          fieldDesc.type.indexOf('.Double') != -1 ||
          fieldDesc.type.indexOf('.Float') != -1;
        $scope.theField01.fieldDesc.fieldTypeIsBoolean =
          fieldDesc.type.indexOf('.Boolean') != -1;
        $scope.theField01.fieldDesc.fieldTypeIsDate =
          fieldDesc.type.indexOf('.Date') != -1;

        if (
          $scope.theField01.fieldDesc.name != undefined &&
          $scope.theField01.fieldDesc.name.substr(0, 13) == 'g2cenvoimail_'
        ) {
          $scope.theField01.fieldDesc.fieldTypeIsSendMail = true;
        } else {
          $scope.theField01.fieldDesc.fieldTypeIsString =
            fieldDesc.type.indexOf('.String') != -1;
          if (
            $scope.theField01.fieldDesc.fieldTypeIsString &&
            (fieldDesc.size == 0 || fieldDesc.size > 500)
          ) {
            $scope.theField01.fieldDesc.fieldTypeIsString = false;
            $scope.theField01.fieldDesc.fieldTypeIsComment = true;
          } else $scope.maxLength = fieldDesc.size;
        }
      }

      if (fieldDesc.fieldTypeIsBoolean) {
        //-- Do we have to set a default value to the chackbox
        if (
          $scope.theField01.objectField === null ||
          $scope.theField01.objectField.value === null ||
          $scope.theField01.objectField.value === ''
        ) {
          if ($scope.theField01.objectField == undefined)
            $scope.theField01.objectField = {};
          $scope.theField01.objectField.name = fieldDesc.name;
          //-- Radio button: no default value
          $scope.theField01.objectField.strValue = '';
          $scope.theField01.objectField.value = null;
        } else if (fieldDesc.buttons == undefined) {
          if ($scope.theField01.objectField.value)
            $scope.theField01.objectField.strValue = '1';
          else $scope.theField01.objectField.strValue = '0';
        }
      }

      if ($scope.theField01.fieldDesc.fieldTypeIsDate) $scope.setDate();

      if (fieldDesc.type != undefined) {
        fieldType = fieldDesc.type.toLowerCase();
        $scope.theField01.fieldDesc.fieldTypeIsMultipleAttachments =
          fieldType.indexOf('g2c.attachments') != -1;
        if (!$scope.theField01.fieldDesc.fieldTypeIsMultipleAttachments)
          $scope.theField01.fieldDesc.fieldTypeIsSingleAttachment =
            fieldType.indexOf('g2c.attachment') != -1;
      }

      if ($scope.theField01.config != undefined) {
        if ($scope.theField01.config.type == 'report') {
          $scope.theField01.fieldDesc.fieldTypeIsReport = true;
          //-- When the field is a report the attachment possibility will be managed in the report field
          $scope.theField01.config.withAttachment =
            $scope.theField01.fieldDesc.fieldTypeIsSingleAttachment;
          $scope.theField01.fieldDesc.fieldTypeIsMultipleAttachments = $scope.theField01.fieldDesc.fieldTypeIsSingleAttachment = $scope.theField01.fieldDesc.fieldTypeIsString = false;
          if (
            $scope.theField01.config.fieldAlias != undefined &&
            $scope.theField01.config.fieldAlias != ''
          )
            $scope.theField01.fieldDesc.alias =
              $scope.theField01.config.fieldAlias;
        }
      }
    };

    /**
     *     Called when broadcast from formFieldPanel
     *  when field value has been read.
     */
    $scope.$on('gotFieldValue', function(event, data) {
      //-- Until now there is something to do only when the field is a relation field ...
      $scope.manageRelationField($scope.theField01.fieldDesc);
      if ($scope.theField01.field.indexOf('.') != -1) {
        //-- Case of a field reached thru a relation
        if (data.objectField != undefined)
          $scope.theField01.objectField.value = data.objectField.value;
      }
    });

    /**
     *        Look for the value to display in the text to display in the case
     *    of a field where the value is selected from a form ans so from
     *    another table.
     */
    $scope.setSelectWithFormValueToDisplay = function() {
      //-- If no value set then do not look for readable value.
      if ($scope.theField01.objectField.value == undefined) return;

      ConfigFactory.get('chercher_modifier', $scope.theField01.configName).then(
        function(res) {
          //-- <<<< Configuration has been gotten. >>>>
          var config = res.data;
          //-- If the property "configName" is not a String it is the configuration.
          if (
            $scope.theField01.configName === undefined ||
            $scope.theField01.configName.length === undefined
          )
            config = $scope.theField01.configName;
          if (config == undefined || config == '')
            gaJsUtils.errorMessage(
              'Configuration [' +
                $scope.theField01.configName +
                '] non trouvée pour le champ [' +
                $scope.theField01.field +
                '] !'
            );
          else if (config.datastoreName == undefined)
            gaJsUtils.errorMessage(
              'Pas de datastore fourni dans la configuration !'
            );
          else if (config.featureName == undefined)
            gaJsUtils.errorMessage(
              'Pas de table/couche fourni dans la configuration !'
            );
          else {
            var tableDesc;
            tableDesc = FeatureTypeFactory.getFeatureTypeDesc(
              config.datastoreName,
              config.featureName
            );

            if (tableDesc.geographic)
              $scope.theField01.fieldDesc.relatedTableIsGeographic = true;

            var fieldName = $scope.getThisObjectIdFieldNameForRelationWithForm();
            if ($scope.theField01.objectField.value != '')
              if (fieldName == 'id') {
                QueryFactory.get(
                  tableDesc.uid,
                  $scope.theField01.objectField.value
                ).then(function(res) {
                  //-- Get (and so display) the property value to show.
                  $scope.tableSelectSelectionDone(res.data.features[0], false);
                });
              } else
                QueryFactory.data(
                  tableDesc.uid,
                  +'=' + $scope.theField01.objectField.value
                ).then(function(res) {
                  //-- Get (and so display) the property value to show.
                  $scope.tableSelectSelectionDone(res.data.features[0], false);
                });
          }
        }
      );
    };

    $scope.prepareStoredAsField();
    $scope.initializeScope();

    var dep = $scope.theField01.fieldDesc.dependencies;
    if (dep != null) {
      for (var ind = 0; ind < dep.length; ind++) {
        if (dep[ind].dependsOn != null) {
          $scope.theField01.fieldDesc.dependsOn = dep[ind];
        }
      }
    }

    //-- TheField01 is the field to manage in this module instance.
    if ($scope.theField01 == null)
      $scope.theField01 = $scope.__proto__.theField01;
    if ($scope.theField01.objectField == null)
      $scope.theField01.objectField = {};
    if (
      $scope.theField01.defaultValue != undefined &&
      ($scope.theField01.objectField.value == null ||
        $scope.theField01.objectField.value == '')
    ) {
      var val = GlobalServices.getValueForKeyWord(
        $scope.theField01.defaultValue
      );
      if (!val.done) val = $scope.theField01.defaultValue;
      else val = val.newValue;
      $scope.theField01.objectField.value = val;
    }

    fieldDesc = $scope.theField01.fieldDesc;
    if (fieldDesc != null) $scope.theField01.fieldDesc.listOfValues = [];

    $scope.manageRelationField = function(fieldDesc) {
      if (fieldDesc.fieldTypeIsRelation) {
        if ($scope.theField01.fieldDesc.alias == undefined)
          $scope.theField01.fieldDesc.alias = $scope.theField01.field;
        if (
          $scope.theField01.relation.occurence == '1-N' &&
          $scope.theField01.relation.componentEnd ==
            $scope.theField01.featureName
        ) {
          //-- Unless setting specifically says don't display a list of value
          //-- in that case a list of the value read from the table will be displayed.
          if (fieldDesc.selectWithForm === true) {
            fieldDesc.fieldTypeIsRelationWithForm = true;
            $scope.setIdFieldNameForRelationWithForm();
            $scope.setSelectWithFormValueToDisplay();
          } else {
            fieldDesc.fieldTypeIsRelationWithForm = false;
            fieldDesc.fieldTypeIsRelationListOfValue = true;
            $scope.loadListOfValuesFromTable(true);
          }
        }
      } else {
        //-- Prepare information in order to manage different field types.
        /* TODO  enlver normalemnt ici  fieldDesc.fieldTypeIsRelation est FAUX  donc test tooujours FAUX ......
            if (fieldDesc.fieldTypeIsRelation && $scope.theField01.fieldDesc.alias==undefined)
                $scope.theField01.fieldDesc.alias = $scope.theField01.field;
            else if (fieldDesc.type!=undefined)
                */
        $scope.defineFieldType(fieldDesc);

        $scope.prepareFieldAsListOfValue($scope.theField01.fieldDesc);

        $scope.manageRequiredField(true);
      }
    };

    /**
     *     Transform the value from something like
     *  "[00,01,02,03]"  to  an array of string like ["00","01","02","03"].
     */
    $scope.setDomainValueFromString = function() {
      var v = $scope.theField01.objectField.value;

      if (v == undefined || v == '') return;

      v = v.replace(/\[/g, '');
      v = v.replace(/\]/g, '');
      v = v.split(',');
      $scope.theField01.objectField.value = [];
      for (var ind = 0; ind < v.length; ind++)
        $scope.theField01.objectField.value.push(('' + v[ind]).trim());
    };

    /**
     *    Manage field described with domain in the configuration file.
     * Until today only type service returnin object list is managed
     * thru this setting.
     */
    $scope.manageDomainField = function() {
      var lv, codeField, value, valFields;

      $scope.domainSize = 1;
      $scope.domainSelectionMode = 'single';
      if ($scope.theField01.domain != undefined) {
        $scope.setDomainValueFromString();
        $scope.fieldTypeIsDomain = true;
        if ($scope.theField01.domain.size != undefined)
          $scope.domainSize = $scope.theField01.domain.size;
        if ($scope.theField01.domain.selectionMode != undefined)
          $scope.domainSelectionMode = $scope.theField01.domain.selectionMode;
        lv = $scope.theField01.fieldDesc.listOfValues = [];
        codeField = $scope.theField01.domain.idField;
        valFields = $scope.theField01.domain.mainFields;
        //                $scope.$eval($scope.theField01.domain.service).then (
        eval($scope.theField01.domain.service).then(function(res) {
          for (var ind = 0; ind < res.data.length; ind++) {
            value = '';
            for (var ind1 = 0; ind1 < valFields.length; ind1++) {
              if (value != '') value += ' ';
              value += res.data[ind][valFields[ind1]];
            }
            lv.push({ code: res.data[ind][codeField], value: value });
          }
        });
      }
    };

    $scope.manageFieldValueDependingOnType = function() {
      if (
        $scope.theField01.fieldDesc.type != undefined &&
        $scope.theField01.fieldDesc.type.toLowerCase().indexOf('.boolean') != -1
      ) {
        if (
          $scope.theField01.objectField.strValue === '1' ||
          $scope.theField01.objectField.strValue === 'true'
        )
          $scope.theField01.objectField.value = true;
        else if (
          $scope.theField01.objectField.strValue === '0' ||
          $scope.theField01.objectField.strValue === 'false'
        )
          $scope.theField01.objectField.value = false;
        else $scope.theField01.objectField.value = null;
      }
    };

    $scope.manageRelationField(fieldDesc);
    $scope.manageDomainField();
    //-- No alias on the field description nor in the configuration so use database field name.
    if (fieldDesc.alias == undefined)
      $scope.theField01.fieldDesc.alias = fieldDesc.name;
    if (
      fieldDesc.alias != undefined &&
      $scope.theField01.fieldDesc.alias.substr(0, 1) == '!'
    ) {
      var res = GlobalServices.getValueForKeyWord(
        $scope.theField01.fieldDesc.alias
      );
      if (res.done) $scope.theField01.fieldDesc.alias = res.newValue;
    }

    $scope.valueChangedTo = function() {
      $scope.timingoutInput = false;
      $scope.manageRequiredField(false);
      $scope.valueChanged();
    };

    /**
     *      Management of fields depending on this one according to
     *   a change of value. This dependency is a relational one
     *   not a logical one.
     */
    $scope.emitToDependents = function(dep) {
      for (var ind = 0; ind < dep.length; ind++) {
        if (dep[ind].dependent != null) {
          var data = {};
          data.childTableName = dep[ind].dependent;
          if ($scope.dependencyIdForChildren != null)
            data.parentId = $scope.dependencyIdForChildren;
          else data.parentId = $scope.theField01.objectField.value;
          $scope.$emit('dependencyParentChangedTriggered', data);
          $scope.dependencyIdForChildren = null;
        }
      }
    };

    /**
     *      Management of fields depending on this one according to
     *   a change of value. This dependency is a logical one
     *   not a relational one.
     */
    $scope.manageDependentFields = function() {
      var data, ind, dep;

      dep = $scope.theField01.fieldDesc.dependentFields;
      if (dep == undefined) dep = $scope.theField01.fieldDesc.dependencies;
      if (dep != undefined) {
        for (ind = 0; ind < dep.length; ind++) {
          data = {};
          data.target = dep[ind];
          data.source = $scope.theField01.fieldDesc.name;
          data.value = $scope.theField01.objectField.value;
          $scope.$emit('logicalDependencyParentChangedTriggered', data);
        }
      }
    };

    $scope.dpValueChanged = function() {
      var ind = 0;
      var elt = document.getElementById('dp_' + $scope.thisId);
    };

    $scope.manageMinMax = function() {
      $scope.minmaxOK = true;
      if ($scope.fieldHasInterval) {
        if ($scope.theField01.fieldDesc.minvalincluded)
          $scope.minmaxOK =
            $scope.theField01.objectField.value >=
            $scope.theField01.fieldDesc.minval;
        else
          $scope.minmaxOK =
            $scope.theField01.objectField.value >
            $scope.theField01.fieldDesc.minval;
        if ($scope.minmaxOK) {
          if ($scope.theField01.fieldDesc.maxvalincluded)
            $scope.minmaxOK =
              $scope.theField01.objectField.value <=
              $scope.theField01.fieldDesc.maxval;
          else
            $scope.minmaxOK =
              $scope.theField01.objectField.value <
              $scope.theField01.fieldDesc.maxval;
        }

        if ($scope.minmaxOK)
          $scope.lastOkValue = $scope.theField01.objectField.value;
        else if ($scope.lastOkValue != undefined) {
          $scope.theField01.objectField.value = $scope.lastOkValue;
        }
      }
    };

    $scope.executeFieldActions = function() {
      //-- If actions are configure on the field send them to the main parent
      //-- (widget typeprojet) in order to execute them.
      if ($scope.theField01.fieldDesc.fieldActions != undefined) {
        var actions = $scope.theField01.fieldDesc.fieldActions;
        for (var indAction = 0; indAction < actions.length; indAction++) {
          if (
            actions[indAction].when == undefined ||
            actions[indAction].when == 'change' ||
            $scope.theField01.objectField.value == actions[indAction].when ||
            (actions[indAction].when == 'not empty' &&
              $scope.theField01.objectField.value != null &&
              $scope.theField01.objectField.value != '') ||
            (actions[indAction].when == 'empty' &&
              $scope.theField01.objectField.value == null) ||
            $scope.theField01.objectField.value == ''
          )
            $scope.$emit('thereIsAnActionToTriggerAfterChange', {
              actions: actions[indAction].actions,
              newValue: $scope.theField01.objectField.value,
            });
        }
      }
    };

    /**
     *     This function is called when the value the user may input has changed
     *  in order to dispatch it to the parent cope and then maybe
     *  to the parent of the parent scope.
     */
    $scope.valueChanged = function() {
      //-- If text input is in process wait for a typing pause
      //-- to take the input value into account.
      //-- We do this by waiting no change occurs in the form field
      //-- during half a minute.
      if (
        $scope.theField01.fieldDesc.fieldTypeIsString ||
        $scope.theField01.fieldDesc.fieldTypeIsNumber
      ) {
        //-- Characters are being input
        var now = new Date(),
          nowMs;
        nowMs = now.getTime();
        if ($scope.lastChangeTime == 0 || nowMs - $scope.lastChangeTime < 750) {
          //-- Less than 500 milliseconds between two characters
          //-- so wait for another.
          $scope.lastChangeTime = nowMs;
          if (!$scope.timingoutInput) {
            $scope.timingoutInput = true;
            $timeout($scope.valueChangedTo, 1000);
          }
          return;
        }
        //-- When no other character is input and the delay is > 500 ms
        //-- we continue the treatment.
        $scope.lastChangeTime = nowMs;
      }

      if ($scope.fieldHasUnit)
        //-- Only to update the value that will be stored
        $scope.unitChanged();

      $scope.manageMinMax();
      $scope.manageFieldValueDependingOnType();
      //-- If $scope.requiredValueIsNull has been set to TRUE by manageMinMax
      //-- don't check if the field is mandatory, the variable requiredValueIsNull
      //-- could be set to FALSE and min-max test be bypassed.
      if (!$scope.minmaxOK) $scope.requiredValueIsNull = true;
      else $scope.manageRequiredField(false);
      $scope.executeFieldActions();

      if ($scope.$parent.valueChangedFunction === true) {
        $scope.$parent.valueChanged({ modifiedField: $scope.theField01.field });
      }
      var dep = $scope.theField01.fieldDesc.dependencies;
      if (dep != null) $scope.emitToDependents(dep);

      $scope.manageDependentFields();
      $scope.lastChangeTime = 0;
    };

    /**
     *     Called when broadcast from main container says the parent object
     *  has been created in the DataBase.
     *  As a parameter the object id of the new object is received.
     *  Setting the objectId value will enable input field,
     *  for example if the field is a file attachment field.
     */
    $scope.$on('gotObjectId', function(event, data) {
      //-- Test added because this is the case concerned by this id.
      if (data.fromRelationFormField)
        $scope.theField01.objectId = data.objectId;

      //-- EMPTY FIELD (after creation)
      //-- If we don't want to empty the fields after creation
      //-- the following lines should be removed or part of a condition
      //-- depending on the configuration of the widget.
      if (data.objectId == null) {
        $scope.emptyField();
        $scope.valueChanged();
        if (!$scope.emptyFieldHasSetAValue)
          $scope.theField01.objectField.value = $scope.getInheritedValue(
            $scope.theField01.objectField.name
          );
      }
    });

    /**
     *     We are notified that an object with dependent field have been modified by the user.
     *  So we check that this field is dependent of the modified field.
     *  If so then change the content.
     *  This is used with select elements, for example when a list of
     *  cities depends on the selected region.
     */
    $scope.$on('dependencyParentChangedDispatched', function(event, data) {
      if (
        ($scope.theField01.relation != undefined &&
          data.childTableName == $scope.theField01.relation.componentStart) ||
        ($scope.theField01.relation == undefined &&
          $scope.theField01.panelUse == 'search')
      ) {
        $scope.parentId = data.parentId;
        $scope.loadListOfValuesFromTable(false);
      }
    });

    /**
     *     We are notified that an object with dependent field have been modified by the user.
     *  So we check that this field is dependent of the modified field.
     *  If so then change the input field description according to the new value.
     *  This allows to disable a field depending on the value of another one
     */
    $scope.$on('logicalDependencyParentChangedDispatched', function(
      event,
      data
    ) {
      var dep;
      if (data.target == $scope.theField01.fieldDesc.name) {
        dep = $scope.theField01.fieldDesc.enabledDependsOn;
        if (dep != undefined && dep.field == data.source)
          if (dep.equals == '!NULL!')
            $scope.enabled = data.value == null || data.value == '';
          else $scope.enabled = data.value == dep.equals;

        dep = $scope.theField01.fieldDesc.visibilityDependsOn;
        if (dep != undefined && dep.field == data.source)
          if (dep.equals == '!NULL!')
            $scope.visible = data.value == null || data.value == '';
          else {
            if (dep.equals != undefined)
              $scope.visible = data.value == dep.equals;
            else if (dep.in != undefined)
              $scope.visible = dep.in.indexOf("'" + data.value + "'") != -1;
          }
      }
    });

    $scope.tableSelectSelectionDone = function(object, newValue) {
      var val;
      //-- Single selection so the selected object is received as a parameter
      $scope.theField01.objectField.value = QueryFactory.getFeatureId(object);

      var fields = $scope.getMainFieldsForTable();
      $scope.theField01.objectField.valueToDisplay = '';
      if (fields.length == 0)
        $scope.theField01.objectField.valueToDisplay += QueryFactory.getFeatureId(
          object
        );
      else
        for (var ind = 0; ind < fields.length; ind++)
          if (fields[ind].field == 'id')
            $scope.theField01.objectField.valueToDisplay +=
              QueryFactory.getFeatureId(object) + ' ';
          else {
            val = object.properties[fields[ind].field];
            if (val != undefined)
              $scope.theField01.objectField.valueToDisplay += val + ' ';
          }

      //-- Give to the parents the information that a value has been modified.
      if (newValue == undefined || newValue == true) $scope.valueChanged();
    };

    $scope.openForm = function() {
      var template;
      var childScope = $scope.$new(true, $scope);
      childScope.ConfigName = $scope.theField01.configName;
      childScope.tableSelectSelectionDone = $scope.tableSelectSelectionDone;
      childScope.selectionType = 'single';
      childScope.meAsNgDialog = ngDialog;
      template =
        "<div TableSelectAndUpdateDirective style='width:100%;overflow-x:scroll;'></div>";
      ngDialog.open({
        template: template,
        plain: true,
        scope: childScope,
        className: 'ngdialog-theme-plain width800',
      });
    };

    $scope.openCommentInput = function() {
      var template;
      var childScope = $scope.$new(false, $scope);
      if ($scope.theField01.mode == 'readonly')
        template =
          "<textarea ng-model='theField01.objectField.value' readonly ng-change='valueChanged()' style='width:500px;height:450px;'><textarea>";
      else
        template =
          "<textarea ng-model='theField01.objectField.value' ng-change='valueChanged()' style='width:500px;height:450px;'><textarea>";
      ngDialog.open({
        template: template,
        plain: true,
        scope: childScope,
        className: 'ngdialog-theme-plain width800',
      });
    };

    $scope.emptyField = function() {
      $scope.emptyFieldHasSetAValue = false;
      if ($scope.theField01.objectField.name == '__geom__')
        $scope.theField01.objectField.value.coordinates == null;
      else {
        if ($scope.theField01.fieldDesc.fieldTypeIsNumber) {
          $scope.theField01.objectField.value = undefined;
          if ($scope.numericValue != undefined)
            $scope.numericValue.value = undefined;
        } else if ($scope.theField01.fieldDesc.fieldTypeIsRelationListOfValue) {
          var fieldDesc = $scope.theField01.fieldDesc;
          if (fieldDesc.dependencies != undefined) {
            for (var iDep = 0; iDep < fieldDesc.dependencies.length; iDep++) {
              if (fieldDesc.dependencies[iDep].dependsOn != undefined)
                //-- There is a dependency with a parent object so don't reset this listOfValues
                return;
            }
            //-- If this line is reached, it means that there is at least a child depending on this object
            //-- and no parent dependency, so we select this list first item
            if (
              fieldDesc.listOfValues != undefined &&
              fieldDesc.listOfValues.length != 0
            ) {
              $scope.theField01.objectField.value =
                fieldDesc.listOfValues[0].code;
              $scope.emptyFieldHasSetAValue = true;
            } else $scope.theField01.objectField.value = '';
          }
        } else $scope.theField01.objectField.value = '';
        if ($scope.theField01.objectField.valueToDisplay !== undefined)
          $scope.theField01.objectField.valueToDisplay = '';
        if ($scope.theField01.fieldDesc.fieldTypeIsRelation)
          $scope.theField01.objectId = null;
      }
      if ($scope.theField01.panelUse != 'search') $scope.valueChanged();
    };

    $scope.getSelectedMapObject = function() {
      var relatedTable;

      //-- Get related feature name
      if (
        $scope.theField01.relation.componentStart ==
        $scope.theField01.featureName
      )
        relatedTable = $scope.theField01.relation.componentEnd;
      else relatedTable = $scope.theField01.relation.componentStart;

      //-- Get first selected object which belongs to the related feature
      var features = SelectManager.getfeatures();
      for (var ind = 0; ind < features.features.length; ind++)
        if (
          QueryFactory.getFeatureName(features.features[ind]) == relatedTable
        ) {
          //-- Build the relation between the main object and the selected one.
          $scope.tableSelectSelectionDone(features.features[ind]);
          break;
        }
    };

    $timeout($scope.manageDependentFields, 500);
    $scope.prepareFieldDesc();

    /**
     *     When field is used in the search panel, we have to give
     *  the choice of the operator in order to be able to choose between
     *  before date, after date between dates.
     */
    $scope.dateOperators = [];
    $scope.dateOperators[0] = { text: 'Le', operator: '=' };
    $scope.dateOperators[1] = { text: 'Avant', operator: '<' };
    $scope.dateOperators[2] = { text: 'Aprés', operator: '>' };
    $scope.dateOperators[3] = { text: 'Entre', operator: 'BETWEEN' };
    $scope.theField01.objectField.operator = '=';
    $scope.dateOperatorIsbetween = false;
  };

  FormFieldCtrl.$inject = [
    '$scope',
    '$timeout',
    '$datepicker',
    'QueryFactory',
    'ngDialog',
    'UnitsFactory',
    'ConfigFactory',
    'FeatureTypeFactory',
    'SelectManager',
    'UsersFactory',
    'GlobalServices',
    'gaJsUtils',
  ];
  return FormFieldCtrl;
});
