/**
 *
 */
'use strict';
define(function() {
  var fftablel2Ctrl = function($scope, FeatureAttachmentFactory, QueryFactory) {
    $scope.attributes = [];
    $scope.objects = [];

    /**
     *       Extract id value from id string which looks like
     *    "featuretypename.X" where X is the identifier value.
     */
    $scope.getLayerName = function(feature) {
      var indPt;

      indPt = feature.id.indexOf('.');
      if (indPt == -1) return feature.id;
      else return feature.id.substr(0, indPt);
    };

    $scope.buildList = function() {
      var data;

      data = $scope.receivedData;
      if (data.objects != undefined && data.objects.features.length != 0) {
        $scope.layerName = $scope.getLayerName(data.objects.features[0]);
        if ($scope.layerName == $scope.theField01.relation.componentEnd)
          for (var ind1 = 0; ind1 < data.objects.features.length; ind1++)
            $scope.objects.push(data.objects.features[ind1]);
      }
    };

    $scope.$on('gotRelatedObjects', function(event, data) {
      $scope.receivedData = data;
      if ($scope.attributes == undefined || $scope.attributes.length == 0)
        //-- Table description should have been received before
        //-- but it's not the case so ask for it to a parent (RelationFormField for example).
        $scope.$emit('askForRelatedTableDesc', '');
      $scope.buildList();
    });

    $scope.$on('gotTableDesc', function(event, data) {
      var name;

      if (data.tableDesc.name == $scope.theField01.relation.componentEnd) {
        //-- Go through each field of the table
        for (var ind1 = 0; ind1 < data.tableDesc.attributes.length; ind1++) {
          //-- If the field name is not in the list of the ecluded fields
          //-- then put the alias in the header list.
          //-- This header list is displayed by angular in fftablel2.html.
          name = data.tableDesc.attributes[ind1].name;
          if (
            data.config.excludedFields == undefined ||
            data.config.excludedFields.indexOf(name) == -1
          ) {
            $scope.attributes.push(data.tableDesc.attributes[ind1]);
          }
        }
      }
    });

    $scope.getValueFor = function(object, attribute) {
      var retValue = object.properties[attribute.name];
      var restr;

      if (attribute.restrictions.length != 0) {
        for (var ind1 = 0; ind1 < attribute.restrictions.length; ind1++) {
          restr = attribute.restrictions[ind1];
          if (restr.type == 'Domain') {
            for (var propertyName in restr.listofValues) {
              if (retValue == propertyName)
                return restr.listofValues[propertyName];
            }
          }
        }
      }
      return retValue;
    };

    /**
     *       The user clicked on the download file button, so we ask the server
     *    to give us a URL for downloading, then we onpen this link in a new window..
     */
    $scope.download = function(object, attribute) {
      var fileName = object.properties[attribute.name];
      var id = QueryFactory.getFeatureId(object);
      FeatureAttachmentFactory.getdownloadurl(
        fileName,
        $scope.layerName,
        id
      ).then(function(res) {
        window.open(res.data);
      });
    };
  };

  fftablel2Ctrl.$inject = [
    '$scope',
    'FeatureAttachmentFactory',
    'QueryFactory',
  ];
  return fftablel2Ctrl;
});
