/**
 *
 */
'use strict';
define(function() {
  var ffl2AttachmentCtrl = function(
    $scope,
    ffl2AttachmentFactory,
    QueryFactory,
    ngDialog,
    FeatureAttachmentFactory,
    $timeout
  ) {
    $scope.filenames = [];
    $scope.selected_filename = {};
    $scope.singleFileSelectorId = 'ffl2attonefileinput_' + $scope.$id;
    $scope.multipleFileSelectorId = 'ffl2attmanyfilesinput_' + $scope.$id;
    $scope.lockUi = false;
    $scope.cmdAddId = 'cmdAdd_' + $scope.$id;

    $scope.dialogContent =
      '<div>Confirmez vous la suppresion de [!!1!!] ?</div>';
    $scope.dialogContent += '<div>';
    $scope.dialogContent +=
      "  <button ng-click='removeAttachedFile()'>Oui</button>";
    $scope.dialogContent +=
      "  <button ng-click='cancelRemoveAttachedFile()'>Non</button>";
    $scope.dialogContent += '</div>';

    $scope.callRefreshListFromMain = 0;

    $scope.enableCmdAddTryCount = 0;

    $scope.theFeature = {};

    /**
     *     Set the filename or filenames into the correct attribute
     *  for later update. The attribute to set depends on the container
     *  of this directive. If it's a standard component (FieldForm or ffl2)
     *  the value to read or modify is $scope.theField01.objectField.value.
     *  If the container is the component named fftable4updl2 then
     *  the value to read or modify is $scope.obj.properties[ $scope.att.name ].
     */
    $scope.setObjectValue = function(value) {
      //-- Standard case from FormField
      if (
        $scope.theField01 != undefined &&
        $scope.theField01.objectField != undefined
      )
        $scope.theField01.objectField.value = value;
      //-- Case for fftable4updl2
      if ($scope.obj != undefined && $scope.att != undefined)
        $scope.obj.properties[$scope.att.name] = value;
    };

    /**
     *      When many files may be attached to an object,
     *  this method let us remove one of the files from the attribute
     *  listing the file names.
     */
    $scope.removeObjectValue = function(value) {
      var ind, reg, val;

      val = $scope.getObjectValue();
      ind = val.indexOf(value);
      if (ind != -1) {
        var newVal = $scope.theField01.objectField.value.substr(0, ind);
        newVal += $scope.theField01.objectField.value.substr(
          ind + value.length + 1
        );
        $scope.theField01.objectField.value = newVal;
        reg = new RegExp(';;', 'g');
        val = val.replace(reg, ';');
      }
      //-- Standard case from FormField
      $scope.setObjectValue(val);
    };

    /**
     *     Set the filename or filenames into the correct attribute
     *  for later update. The attribute to set depends on the container
     *  of this directive. If it's a standard component (FieldForm or ffl2)
     *  the value to read or modify is $scope.theField01.objectField.value.
     *  If the container is the component named fftable4updl2 then
     *  the value to read or modify is $scope.obj.properties[ $scope.att.name ].
     */
    $scope.concatObjectValue = function(value) {
      //-- Standard case from FormField
      if ($scope.theField01.objectField != undefined)
        $scope.theField01.objectField.value += value;
      //-- Case for fftable4updl2
      if ($scope.obj != undefined && $scope.att != undefined)
        $scope.obj.properties[$scope.att.name] += value;
    };

    /**
     *     Get the filename or filenames from the correct attribute.
     *  The attribute to get depends on the container
     *  of this directive. If it's a standard component (FieldForm or ffl2)
     *  the value to read or modify is $scope.theField01.objectField.value.
     *  If the container is the component named fftable4updl2 then
     *  the value to read is $scope.obj.properties[ $scope.att.name ].
     */
    $scope.getObjectValue = function() {
      //-- Standard case from FormField
      if (
        $scope.theField01 != undefined &&
        $scope.theField01.objectField != undefined &&
        $scope.theField01.objectField.value != undefined &&
        $scope.theField01.objectField.value != ''
      )
        return $scope.theField01.objectField.value;
      //-- Case for fftable4updl2
      if ($scope.obj != undefined && $scope.att != undefined)
        return $scope.obj.properties[$scope.att.name];
    };

    /**
     *       try to enable the add command.
     *       If the element cannot be gotten, it's beacuse the module is not ready.
     *       So we use the javascript timeout to wait it is ready.
     *       When ready, the command is enabled.
     */
    $scope.enableCmdAdd = function() {
      //-- No add button when mode is readonly
      if (
        $scope.theField01 != undefined &&
        $scope.theField01.mode == 'readonly'
      ) {
        $scope.refreshFileList();
        return;
      }
      var elt = document.getElementById($scope.cmdAddId);
      if (elt == null) {
        if ($scope.enableCmdAddTryCount++ <= 480)
          setTimeout($scope.enableCmdAdd, 250);
        else $scope.enableCmdAddTryCount = 0;
      } else {
        $scope.enableCmdAddTryCount = 0;
        if ($scope.getIsEnabledForAttachmentField != undefined)
          elt.disabled = !$scope.getIsEnabledForAttachmentField(
            $scope.theFeature.objectId
          );
        else elt.disabled = false;
        console.log(
          'enableCmdAdd.SCOPE ID: ' +
            $scope.$id +
            ' appel $scope.refreshFileList()'
        );
        $scope.refreshFileList();
      }
    };

    $scope.takeObjectintoAccount = function(feature) {
      $scope.theFeature.layerName = QueryFactory.getFeatureName(feature);
      $scope.theFeature.objectId = QueryFactory.getFeatureId(feature);
      $scope.refreshFileList();
      if ($scope.theFeature.objectId != null) $scope.enableCmdAdd();
    };

    $scope.$on('gotRelatedObjects', function(event, data) {
      //-- As this component is used in the main object description
      //-- as well as in a related object description,
      //-- this event has to be taken into account only if the attachment field
      //-- concerns a related object and not the main object.
      if ($scope.parentType == 'level2') {
        $scope.takeObjectintoAccount(data.objects.features[0]);
      } else if (
        $scope.parentType == 'main' &&
        data.updatedFromPanel != undefined &&
        data.fieldName == $scope.theField01.fieldDesc.name
      ) {
        $scope.setObjectValue(
          data.feature.properties[$scope.theField01.fieldDesc.name]
        );
        $scope.takeObjectintoAccount(data.feature);
      }
    });

    /**
     *     Called when broadcast from main container says the parent object
     *  has been created in the DataBase.
     *  As a parameter the object id of the new object is received.
     *  Setting the objectId value will enable input field,
     *  for example if the field is a file attachment field.
     */
    $scope.$on('gotObjectId', function(event, data) {
      //-- As this component is used in the main object description
      //-- as well as in a related object description,
      //-- this event has to be taken into account only if the attachment field
      //-- concerns the main object and not a related object.
      if ($scope.parentType == 'main') {
        $scope.theFeature.layerName = data.layerName;
        $scope.theFeature.objectId = data.objectId;
        if ($scope.theFeature.objectId != null) $scope.enableCmdAdd();
        //-- EMPTY FIELD after creation and action is back to create modes
        else $scope.filenames.splice(0, $scope.filenames.length);
      }
    });

    /**
     *       The user clicked on the download file button, so we ask the server
     *    to give us a URL for downloading, then we onpen this link in a new window..
     */
    $scope.download = function() {
      var fn = '' + $scope.selected_filename.name;
      ffl2AttachmentFactory
        .getdownloadurl(
          fn,
          $scope.theFeature.layerName,
          $scope.attachmentObjectId
        )
        .then(function() {
          window.open(escape(ffl2AttachmentFactory.resources.downloadurl));
        });
    };

    $scope.removeAttachedFile = function() {
      FeatureAttachmentFactory.remove(
        $scope.nameOfFileToRemove,
        $scope.theFeature.layerName,
        $scope.attachmentObjectId
      ).then(function() {
        if ($scope.cardinality == 'n')
          $scope.removeObjectValue($scope.nameOfFileToRemove);
        else $scope.setObjectValue('');
        console.log(
          'removeAttachedFile.SCOPE ID: ' +
            $scope.$id +
            ' appel $scope.refreshFileList()'
        );
        $scope.refreshFileList();
        $scope.valueChanged();
      });

      ngDialog.closeAll();
    };

    $scope.cancelRemoveAttachedFile = function() {
      ngDialog.closeAll();
    };

    /**
     *       The user clicked on the add file button, so we activate the
     *    selection file dialog.
     *    When the files are selected the callback $scope.fileSelected is called.
     */
    $scope.addFile = function() {
      //-- Choose the file selector depending on the authorized
      //-- file quantity in only one we'll use the single file selector
      //-- if n files  can be choosen then use the multiple file selector.
      if ($scope.theFeature.objectId == null) return;
      if ($scope.cardinality == '1')
        $scope.fileSelectorId = $scope.singleFileSelectorId;
      else $scope.fileSelectorId = $scope.multipleFileSelectorId;
      var elt = document.getElementById($scope.fileSelectorId);
      //-- Dans le cas de la tarnsmission y a un truc sur le scope et les methodes de ce scope
      //-- ne ont pas dans celui de l'input, d'où ce tour de passe passe.
      var eltInput = document.getElementById($scope.singleFileSelectorId);
      if (eltInput != undefined) {
        var inputScope = angular.element(eltInput).scope();
        if (inputScope != undefined && inputScope.fileSelected == undefined)
          inputScope.fileSelected = $scope.fileSelected;
      }
      elt.click();
    };

    /**
     *       The user clicked on the remove file button,
     *   so we first ask him to confirm the operation
     *   then depending on the answer we remove the attached file.
     */
    $scope.removeFile = function() {
      if ($scope.theFeature.objectId == null || $scope.filenames.length == 0)
        return;
      if ($scope.cardinality == '1')
        //-- When a signle file is attached, it's not necessary
        //-- that the user select it in order to remove it
        $scope.nameOfFileToRemove = $scope.filenames[0].name;
      else {
        $scope.nameOfFileToRemove = $scope.selected_filename.name;
        //-- Should not occur but who knows !
        if (
          $scope.nameOfFileToRemove == undefined ||
          $scope.nameOfFileToRemove == ''
        )
          return;
      }

      var reg = new RegExp('!!1!!', 'g');
      var template = $scope.dialogContent.replace(
        reg,
        $scope.nameOfFileToRemove
      );
      ngDialog.open({ template: template, plain: true, scope: $scope });
    };

    /**
     *       Get file attachment list from server and display it.
     */
    $scope.refreshFileListUseResult = function() {
      var ind, fn, storedNames;

      //-- Empty file list
      $scope.filenames.splice(0, $scope.filenames.length);
      //-- Build new file list
      if ($scope.getObjectValue() == null) $scope.setObjectValue('');
      storedNames = ';' + $scope.getObjectValue() + ';';
      //console.log("--refreshFileList.SCOPE ID: "+$scope.$id);
      //console.log("--refreshFileList.ffl2AttachmentFactory.resources.fileList.length: "+ffl2AttachmentFactory.resources.fileList.length);
      for (
        ind = 0;
        ind < ffl2AttachmentFactory.resources.fileList.length;
        ind++
      ) {
        fn = ffl2AttachmentFactory.resources.fileList[ind];
        //-- If the file is associated with this field then add it into the list.
        if (storedNames.indexOf(';' + fn + ';') != -1) {
          $scope.filenames.push({ name: fn });
          console.log('--refreshFileList: ajout à liste: fn=' + fn);
        }
      }
      //    					if ($scope.lineNumber==1 && $scope.filenames.length!=0)
      if ($scope.filenames.length != 0) {
        $scope.selected_filename.name = $scope.filenames[0].name;
      }
    };

    /**
     *       Get file attachment list from server and display it.
     */
    $scope.refreshFileList = function() {
      $scope.attachmentObjectId = $scope.theFeature.objectId;
      ffl2AttachmentFactory
        .list($scope.theFeature.layerName, $scope.theFeature.objectId)
        .then(function() {
          if (
            ffl2AttachmentFactory.resources.fileList != null &&
            ffl2AttachmentFactory.resources.fileList.length != 0
          ) {
            $scope.refreshFileListUseResult();
          } else {
            $scope.attachmentObjectId =
              $scope.theFeature.layerName + '.' + $scope.theFeature.objectId;
            ffl2AttachmentFactory
              .list($scope.theFeature.layerName, $scope.attachmentObjectId)
              .then(function() {
                if (
                  ffl2AttachmentFactory.resources.fileList != null &&
                  ffl2AttachmentFactory.resources.fileList.length != 0
                ) {
                  $scope.refreshFileListUseResult();
                } else {
                }
              });
          }
        });
    };

    /**
     *       Upload a file on the server.
     *    If the file size is too large, then many requests
     *    will be done to send the file by pieces.
     */
    $scope.uploadFile = function(content, filename) {
      var encodedcontent, fn, senddata;

      if (!window.btoa)
        window.btoa = function(str) {
          return $scope.Base64.encode(str);
        };

      encodedcontent = window.btoa(content);
      if (encodedcontent.length > 500000) {
        if ($scope.currentpart == -1) {
          $scope.partcount = 1 + Math.floor(encodedcontent.length / 500000);
          $scope.currentpart = 1;
        } else $scope.currentpart++;
        fn = '' + $scope.currentpart + '_' + filename;
      } else {
        $scope.currentpart = $scope.partcount = -1;
        fn = filename;
      }

      senddata =
        'base64:' +
        encodedcontent.substr(($scope.currentpart - 1) * 500000, 500000);

      ffl2AttachmentFactory
        .add(
          senddata,
          fn,
          '' + $scope.partcount,
          $scope.theFeature.layerName,
          $scope.theFeature.objectId
        )
        .then(function() {
          if ($scope.currentpart < $scope.partcount)
            $scope.uploadFile(content, filename);
          else {
            //-- Add file name in the list and in the field value
            $scope.filenames.push({ name: filename });
            if ($scope.cardinality == 'n') {
              if ($scope.getObjectValue() != '') $scope.concatObjectValue(';');
              $scope.concatObjectValue(filename);
            } else $scope.setObjectValue(filename);
            //-- Try to load next file, may be there is not, then it won't do anything :))
            $scope.indexOfFileToUpload++;
            $scope.getAndUploadFile();
          }
        });
    };

    $scope.getAndUploadFile = function() {
      var file;
      var start = 0;
      var stop;
      var reader = new FileReader();
      var content, lu, ind;

      ind = $scope.indexOfFileToUpload;
      if (ind < $scope.fileSelector.files.length) {
        $scope.lockUi = true;
        file = $scope.fileSelector.files[ind];
        stop = file.size - 1;
        // If we use onloadend, we need to check the readyState.
        lu = false;
        reader.onloadend = function(evt) {
          if (!lu && evt.target.readyState == FileReader.DONE) {
            // DONE == 2
            lu = true;
            content = evt.target.result;
            $scope.uploadFile(content, file.name);
          }
        };
        var blob = file.slice(start, stop + 1);
        $scope.currentpart = -1;
        reader.readAsBinaryString(blob);
      } else {
        console.log('getAndUploadFile.SCOPE ID: ' + $scope.$id);
        $scope.refreshFileList();
        $scope.lockUi = false;
        $scope.valueChanged();
      }
    };

    /**
     *       Method called when a file has been selected by the user.
     *    Depending on the configuration many files may be selected.
     */
    $scope.fileSelected = function() {
      var fileNames = '',
        ind01,
        file;
      //--  If only one file can be associated and there is already one
      //--  attached to this object then we remove it,
      //--  so that it will be replaced by the newly selected one.
      if ($scope.cardinality == '1' && $scope.filenames.length != 0) {
        for (ind01 = 0; ind01 < $scope.filenames.length; ind01++) {
          if (fileNames != '') fileNames += ';';
          file = $scope.filenames[ind01];
          fileNames += file.name;
        }
        ffl2AttachmentFactory.removeFiles(
          fileNames,
          $scope.theFeature.layerName,
          $scope.theFeature.objectId
        );
        ffl2AttachmentFactory.removeFiles(
          fileNames,
          $scope.theFeature.layerName,
          $scope.theFeature.layerName + '.' + $scope.theFeature.objectId
        );
        $scope.setObjectValue('');
      }
      //-- Get File Selector HTML DOM element in order to be able to get selected files
      $scope.fileSelector = document.getElementById($scope.fileSelectorId);
      $scope.indexOfFileToUpload = 0;
      $scope.getAndUploadFile();
    };

    $scope.valueChanged = function() {
      if ($scope.$parent.valueChangedFunction === true) {
        if (
          $scope.theField01 != undefined &&
          $scope.theField01.objectField != undefined
        )
          $scope.$parent.valueChanged({
            fieldName: $scope.theField01.objectField.name,
          });
        if ($scope.obj != undefined && $scope.att != undefined)
          $scope.$parent.valueChanged($scope.obj);
      }
    };

    /****************************************************************************
     *
     *  Base64 encode / decode
     *  http://www.webtoolkit.info/
     *
     */

    $scope.Base64 = {
      // private property
      _keyStr:
        'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=',

      // public method for encoding
      encode: function(input) {
        var output = '';
        var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
        var i = 0;

        input = Base64._utf8_encode(input);

        while (i < input.length) {
          chr1 = input.charCodeAt(i++);
          chr2 = input.charCodeAt(i++);
          chr3 = input.charCodeAt(i++);

          enc1 = chr1 >> 2;
          enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
          enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
          enc4 = chr3 & 63;

          if (isNaN(chr2)) {
            enc3 = enc4 = 64;
          } else if (isNaN(chr3)) {
            enc4 = 64;
          }

          output =
            output +
            this._keyStr.charAt(enc1) +
            this._keyStr.charAt(enc2) +
            this._keyStr.charAt(enc3) +
            this._keyStr.charAt(enc4);
        }

        return output;
      },

      // public method for decoding
      decode: function(input) {
        var output = '';
        var chr1, chr2, chr3;
        var enc1, enc2, enc3, enc4;
        var i = 0;

        input = input.replace(/[^A-Za-z0-9\+\/\=]/g, '');

        while (i < input.length) {
          enc1 = this._keyStr.indexOf(input.charAt(i++));
          enc2 = this._keyStr.indexOf(input.charAt(i++));
          enc3 = this._keyStr.indexOf(input.charAt(i++));
          enc4 = this._keyStr.indexOf(input.charAt(i++));

          chr1 = (enc1 << 2) | (enc2 >> 4);
          chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
          chr3 = ((enc3 & 3) << 6) | enc4;

          output = output + String.fromCharCode(chr1);

          if (enc3 != 64) {
            output = output + String.fromCharCode(chr2);
          }
          if (enc4 != 64) {
            output = output + String.fromCharCode(chr3);
          }
        }

        output = Base64._utf8_decode(output);

        return output;
      },

      // private method for UTF-8 encoding
      _utf8_encode: function(string) {
        string = string.replace(/\r\n/g, '\n');
        var utftext = '';

        for (var n = 0; n < string.length; n++) {
          var c = string.charCodeAt(n);

          if (c < 128) {
            utftext += String.fromCharCode(c);
          } else if (c > 127 && c < 2048) {
            utftext += String.fromCharCode((c >> 6) | 192);
            utftext += String.fromCharCode((c & 63) | 128);
          } else {
            utftext += String.fromCharCode((c >> 12) | 224);
            utftext += String.fromCharCode(((c >> 6) & 63) | 128);
            utftext += String.fromCharCode((c & 63) | 128);
          }
        }

        return utftext;
      },

      // private method for UTF-8 decoding
      _utf8_decode: function(utftext) {
        var string = '';
        var i = 0;
        var c, c1, c2, c3;

        c = c1 = c2 = 0;
        while (i < utftext.length) {
          c = utftext.charCodeAt(i);

          if (c < 128) {
            string += String.fromCharCode(c);
            i++;
          } else if (c > 191 && c < 224) {
            c2 = utftext.charCodeAt(i + 1);
            string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
            i += 2;
          } else {
            c2 = utftext.charCodeAt(i + 1);
            c3 = utftext.charCodeAt(i + 2);
            string += String.fromCharCode(
              ((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63)
            );
            i += 3;
          }
        }

        return string;
      },
    };

    /****************************************************************************
     *  Base64 encode / decode
     *  END
     ****************************************************************************
     */

    /*
     * If the widget is activated with an existing object (to update) try to load attached files.
     */
    if ($scope.theFeature.objectId != undefined) {
      if ($scope.theField01 != undefined) {
        if (
          $scope.theFeature.layerName == undefined &&
          $scope.theField01.config != undefined &&
          $scope.theField01.config.featureName != undefined
        ) {
          $scope.theFeature.layerName = $scope.theField01.config.featureName;
          //                    console.log("ffl2attach.SCOPE ID: "+$scope.$id+" appel $scope.refreshFileList()");
          //                    $scope.refreshFileList();
        }
      }
    }
  };

  ffl2AttachmentCtrl.$inject = [
    '$scope',
    'ffl2AttachmentFactory',
    'QueryFactory',
    'ngDialog',
    'FeatureAttachmentFactory',
    '$timeout',
  ];
  return ffl2AttachmentCtrl;
});
