'use strict';
define(function() {
  var gcelement = function(
    extendedNgDialog,
    FeatureTypeFactory,
    ngDialog,
    QueryFactory,
    ConfigFactory,
    $filter,
    AepInerventionFactory
  ) {
    return {
      templateUrl: 'js/XG/biz/aepInterventions/views/aepinterventions.html',

      restrict: 'A',

      link: function(scope) {
        FeatureTypeFactory.get().then(function() {
          scope.ftis = {};
          if (!scope.configuration) scope.configuration = {};
          if (scope.ftis['anomalie'] == undefined)
            scope.configuration.anomalie = scope.ftis[
              'anomalie'
            ] = FeatureTypeFactory.getFeatureByUid(
              '55ca34fa-6804-44dd-b4f7-21446413dfa2'
            );

          if (scope.ftis['emetteur'] == undefined)
            scope.configuration.emetteur = scope.ftis[
              'emetteur'
            ] = FeatureTypeFactory.getFeatureByUid(
              'c8b02420-dd65-42d5-a764-37691ad9871b'
            );
        });

        //ELEMENTS CONFIGURATION DU WIDGET AEP_INTERVENTION
        /**
         * [verifyObj permet de vérifier si un objet existe ou pas dans le tableau]
         * @param  {[type]} tab        [description]
         * @param  {[type]} currentobj [description]
         * @return {[type]}            [description]
         */
        scope.verifyObj = function(tab, currentobj) {
          for (var k = 0; k < tab.length; k++) {
            if (currentobj === tab[k]) {
              return true;
            }
          }
          return false;
        };

        scope.fonts = [];
        scope.fontsUid = [];
        scope.addFont = function() {
          if (
            scope.fonts.length > 0 &&
            scope.verifyObj(scope.fontsUid, scope.config.selectedFont.uid)
          ) {
            require('toastr').error(
              'Cette objet est déja dans la liste, veuillez choisir un autre'
            );
          } else {
            scope.fonts.push({
              uid: scope.config.selectedFont.uid,
              name: scope.config.selectedFont.name,
            });
            scope.fontsUid.push(scope.config.selectedFont.uid);
          }
        };

        scope.robs = [];
        scope.robsUid = [];
        scope.addRob = function() {
          if (
            scope.robs.length > 0 &&
            scope.verifyObj(scope.robsUid, scope.config.selectedRob.uid)
          ) {
            require('toastr').error(
              'Cette objet est déja dans la liste, veuillez choisir un autre'
            );
          } else {
            scope.robs.push({
              uid: scope.config.selectedRob.uid,
              name: scope.config.selectedRob.name,
            });
            scope.robsUid.push(scope.config.selectedRob.uid);
          }
        };

        scope.cans = [];
        scope.addCan = function() {
          scope.cans.push({
            uid: scope.config.selectedCan.uid,
            name: scope.config.selectedCan.name,
          });
        };
        scope.branchs = [];
        scope.addBranch = function() {
          scope.branchs.push({
            uid: scope.config.selectedBr.uid,
            name: scope.config.selectedBr.name,
          });
        };
        scope.compts = [];
        scope.addCompt = function() {
          scope.compts.push({
            uid: scope.config.selectedCt.uid,
            name: scope.config.selectedCt.name,
          });
        };
        scope.geocodeGoogle = function() {
          scope.config.geocodeType = 'GOOGLE';
        };
        scope.geocodeOSM = function() {
          scope.config.geocodeType = 'OSM';
        };
        scope.geocodeKISGEOCODAGE = function() {
          scope.config.geocodeType = 'KISGEOCODAGE';
        };

        scope.deleteObj = function(tab, index) {
          tab.splice(index, 1);
        };
        scope.geocode = {};

        /**
         *    Fonctions de sauvegarde et de récupèration de la configuration
         * [openConfig ouvre la configuration du widget AEP_Intervention]
         * @return {[type]} [description]
         */
        scope.openConfig = function() {
          scope.config = {};

          scope.getConfig(true);
        };

        scope.openCfgPopup = function() {
          ngDialog.openConfirm({
            template:
              'js/XG/biz/aepInterventions/views/modals/configuration.html',
            className: 'ngdialog-theme-plain width800 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            draggable: {
              title: 'Configuration',
            },
          });
        };

        /**
         * Récupèration de la configuration.
         * @returns {undefined}
         */
        scope.getConfig = function(openCfgPopup) {
          ConfigFactory.get('widgets', scope.ConfigName).then(
            function(res) {
              if (res.data !== '' && res.status === 200) {
                scope.configuration = res.data;
                scope.fonts = scope.configuration.fonts;
                scope.robs = scope.configuration.robs;
                scope.cans = scope.configuration.cana;
                scope.branchs = scope.configuration.branch;
                scope.compts = scope.configuration.compt;
                scope.geocodeType = scope.configuration.geocodeType;
                scope.geocode = scope.configuration.geocode;
                scope.geocodeType = scope.configuration.geocodeType;
                scope.geocode = scope.configuration.geocode;
              }
              if (openCfgPopup === true) scope.openCfgPopup();
              if (scope.ftis == undefined) scope.ftis = {};
              if (
                scope.configuration.anomalie &&
                scope.configuration.anomalie.uid
              )
                scope.ftis['anomalie'] = scope.configuration.anomalie;
              else scope.configuration.anomalie = scope.ftis['anomalie'];
              if (
                scope.configuration.emetteur &&
                scope.configuration.emetteur.uid
              )
                scope.ftis['emetteur'] = scope.configuration.emetteur;
              else scope.configuration.emetteur = scope.ftis['emetteur'];
              console.info('Configuration de bizeditwidget chargée.');
            },
            function(reason) {
              console.error(
                'Configuration de bizeditwidget non chargée: ' + reason
              );
            }
          );
        };
        scope.getConfig();
        /**
         * Sauve dans le fichier de configuration,
         *  la configuration presente dans le scope courant.
         * @returns {undefined}
         */
        scope.saveconfig = function() {
          if (scope.configuration == undefined) {
            scope.configuration = {};
          }
          if (scope.config.geocodeType == undefined) {
            if (
              scope.configuration.geocodeType &&
              scope.configuration.geocodeType != ''
            ) {
              scope.config.geocodeType = scope.configuration.geocodeType;
            } else {
              scope.config.geocodeType = '';
            }
          }

          if (scope.config.geocoderCfg == undefined) {
            scope.config.geocoderCfg = {};
          }
          if (scope.config.geocoderCfg.value == undefined) {
            scope.config.geocoderCfg.value = '';
          }
          if (!scope.configuration == undefined) scope.configuration = {};
          scope.configuration.fonts = scope.fonts;
          scope.configuration.robs = scope.robs;
          scope.configuration.cana = scope.cans;
          scope.configuration.branch = scope.branchs;
          scope.configuration.compt = scope.compts;
          scope.configuration.geocodeType = scope.config.geocodeType;
          scope.configuration.geocode = scope.config.geocoderCfg.value;

          console.log(scope.configuration);
          ConfigFactory.add(
            scope.configuration,
            'widgets',
            scope.ConfigName
          ).then(
            function(res) {
              console.log(res.config.data);
              require('toastr').success(res.data);
            },
            function(reason) {
              require('toastr').error(reason);
            }
          );
        };
        scope.rem = false;
        scope.$on('closeNgDialogAno', function(event) {
          scope.rem = true;
          if (scope.anoDossier) {
            scope.anoDossier.close();
          }
          if (scope.newDossier) {
            scope.newDossier.close();
          }
        });
        /**
         * [saveModifications sauvegarde de toutes les modifications avant de fermer le formulaire Ano/intervention]
         * @return {[type]} [description]
         */
        scope.saveModifications = function() {
          scope.$broadcast('getAepIntervention');
        };
        /**
         * [desactivateDraw desactive l'outil de dessin lorsqu'on ferme le formulaire
         * @return {[type]} [description]
         */
        scope.desactivateDraw = function() {
          scope.$broadcast('desactiveDrawAno');
        };

        scope.tab = [];
        /**
         * [openDossier ouvre le dossier de l'anomalie]
         * @return {[type]} [description]
         */
        scope.openDossier = function(ano) {
          // si ouverture de dossier d'une anomalie existante
          if (ano) {
            QueryFactory.relation(
              scope.ftis['anomalie'].uid,
              'Ano_Emetteur',
              ano.id,
              ''
            ).then(function() {
              scope.currentAnomalie = ano;

              scope.anoDossier = extendedNgDialog.open({
                template:
                  'js/XG/biz/aepInterventions/views/modals/modalDossier.html',
                className: 'ngdialog-theme-plain width800 nopadding miniclose',
                closeByDocument: false,
                scope: scope,
                title: scope.currentAnomalie.id,
                draggable: true,
                preCloseCallback: function() {
                  //sauvegarde de toutes les modifications avant de fermer le formulaire Ano/intervention
                  if (!scope.rem) {
                    var ans = confirm(
                      $filter('translate')('aepintervention.saveModifs')
                    );
                    if (ans) {
                      scope.saveModifications();
                    } else {
                      scope.desactivateDraw();
                    }
                  }
                },
              });
            });
          }
          // si ouverture de dossier d'une nouvelle anomalie
          else {
            QueryFactory.data(
              scope.ftis['anomalie'].uid,
              '1=1',
              undefined,
              undefined,
              undefined,
              undefined
            ).then(function() {
              AepInerventionFactory.addIncrement().then(function(resInc) {
                var numbauto = resInc.data;
                function pad(n) {
                  return n < 10 ? '0' + n : n;
                }
                var d = new Date();
                var dd = pad(d.getDate());
                var mm = pad(d.getMonth() + 1);
                var yy = d.getFullYear();
                scope.refAuto = 'A' + yy + mm + dd + '_' + numbauto.toString();
                scope.dateAuto =
                  yy + '-' + mm + '-' + dd + 'T01:00:00.000+0100';

                scope.currentAnomalie = null;
                scope.currentEmetteur = null;
                scope.newDossier = extendedNgDialog.open({
                  template:
                    'js/XG/biz/aepInterventions/views/modals/modalDossier.html',
                  className:
                    'ngdialog-theme-plain width800 nopadding miniclose',
                  closeByDocument: false,
                  scope: scope,
                  title: $filter('translate')('aepintervention.newFolder'),
                  draggable: true,
                  preCloseCallback: function() {
                    //sauvegarde de toutes les modifications avant de fermer le formulaire Ano/intervention
                    if (!scope.rem) {
                      var ans = confirm(
                        $filter('translate')('aepintervention.saveModifs')
                      );
                      if (ans) {
                        scope.saveModifications();
                      } else {
                        scope.desactivateDraw();
                      }
                    }
                  },
                });
              });
            });
          }
        };

        /**
         * [openAnosEnCours ouvre la liste des anomalies en cours (etat='Intervention à faire')]
         * @return {[type]} [description]
         */
        scope.openAnosEnCours = function() {
          scope.anomalieFti = scope.ftis['anomalie'];
          scope.selectedanomalie = { data: [] };
          scope.dossierEncours = "etat='Intervention à faire'";

          QueryFactory.data(
            scope.anomalieFti.uid,
            scope.dossierEncours,
            scope.map
              .getView()
              .getProjection()
              .getCode(),
            '',
            '',
            ''
          ).then(
            function(res) {
              scope.featr = res.data;
            },
            function() {}
          );

          scope.panelsManager.removePanel('AnoEnCours');

          scope.panelsManager.addPanel({
            id: 'AnoEnCours',
            stickToRight: true,
            templateUrl:
              'js/XG/biz/aepInterventions/views/modals/anomaliesEnCours.html',
            scope: scope,
            visible: true,
            stickToBorder: true,
            resizable: true,
          });
        };
        scope.closePanelAnoEnCours = function() {
          scope.panelsManager.removePanel('AnoEnCours');
        };

        /**
         * [openInterArchives ouvre la liste des anomalies en cours (etat='Dossier clos')]
         * @return {[type]} [description]
         */
        scope.openInterArchives = function() {
          scope.anomalieFti = scope.ftis['anomalie'];
          scope.selectedanomalie = { data: [] };
          scope.dossierArchives = "etat='Dossier clos'";

          scope.panelsManager.removePanel('AnoArchives');

          scope.panelsManager.addPanel({
            id: 'AnoArchives',
            stickToRight: true,
            templateUrl:
              'js/XG/biz/aepInterventions/views/modals/interventionsArchives.html',
            scope: scope,
            visible: true,
            stickToBorder: true,
            resizable: true,
          });
        };
        scope.closePanelAnoArchives = function() {
          scope.panelsManager.removePanel('AnoArchives');
        };

        /**
         * [openInterArchives ouvre la liste des anomalies en cours (etat='Dossier clos')]
         * @return {[type]} [description]
         */
        scope.openInterdejafait = function() {
          scope.anomalieFti = scope.ftis['anomalie'];
          scope.selectedanomalie = { data: [] };
          scope.dossierDejaFaites = "etat='Intervention déjà faite'";

          scope.panelsManager.removePanel('AnoFaites');

          scope.panelsManager.addPanel({
            id: 'AnoFaites',
            stickToRight: true,
            templateUrl:
              'js/XG/biz/aepInterventions/views/modals/interventionsdejafaites.html',
            scope: scope,
            visible: true,
            stickToBorder: true,
            resizable: true,
          });
        };
        scope.closePanelAnoFaites = function() {
          scope.panelsManager.removePanel('AnoFaites');
        };

        scope.datatableDossiersCrud = {
          update: { func: scope.openDossier },
        };

        //GESTION DES CHART DIAGRAMME
        scope.vopenPie = function() {
          if (scope.chartpopover) scope.chartpopover.close();
          scope.chartpopover = extendedNgDialog.open({
            template:
              'js/XG/biz/aepInterventions/views/anomalies/SelectedCharts.html',
            className: 'ngdialog-theme-plain width1000 nopadding miniclose',
            closeByDocument: false,
            scope: scope,
            title: 'Charts',
            draggable: true,
          });
        };

        scope.$on('opendosseraep', function(evt, args) {
          scope.openDossier(args);
        });
      },
    };
  };

  gcelement.$inject = [
    'extendedNgDialog',
    'FeatureTypeFactory',
    'ngDialog',
    'QueryFactory',
    'ConfigFactory',
    '$filter',
    'AepInerventionFactory',
  ];
  return gcelement;
});
