var app = angular.module('conception', ['mgcrea.ngStrap']);

app.controller('controle', [
  '$scope',
  '$http',
  '$location',
  function mainCtrl($scope, $http, $location) {
    $scope.formClient = true;
    $scope.cdata = {};

    var portalid, app;

    /**
     * get portal adn appname
     */
    if ($location.absUrl().split('?')[1]) {
      $location
        .absUrl()
        .split('?')[1]
        .split('&')
        .forEach(function(param) {
          var value = param.split('=')[1];
          if (param.indexOf('portal=') == 0) {
            portalid = value;
          } else if (param.indexOf('app=') == 0) {
            app = value;
          }
        });
    }

    $scope.spanc = {};
    if (portalid && app) {
      var promise = $http.get(
        '/services/' + portalid + '/ancapp/' + app + '/getconfig?f=json'
      );
      promise.then(function(res) {
        if (res.data.infosSpanc) {
          $scope.spanc = res.data.infosSpanc;
        }
        if (!$scope.spanc.logo) {
          $scope.spanc.logo = '../../img/patrimonio.png';
        }
      });
    }

    /**
     * check form is complete
     * @returns {boolean}
     */
    $scope.incompleteForm = function() {
      var num = 0;
      [
        'civilite',
        'nom',
        'prenom',
        'adresse_num_rue',
        'adresse_rue',
        'adresse_ville',
        'adresse_cp',
        'email',
      ].forEach(function(key) {
        if (
          $scope.cdata.info_generales &&
          $scope.cdata.info_generales.proprietaire
        ) {
          if (
            !$scope.cdata.info_generales.proprietaire[key] ||
            $scope.cdata.info_generales.proprietaire[key] == ''
          ) {
            num++;
          }
        } else {
          num++;
        }
      });

      if (num === 0) {
        return false;
      } else {
        return true;
      }
    };

    /**
     * add controle detail externe
     * @returns {boolean}
     */
    $scope.save = function() {
      if (!portalid || !app) {
        alert('Une information obligatoire est manquante dans url');
        return false;
      }
      var ans = confirm(
        'Êtes-vous sur de vouloir enregistrer ces informations ?'
      );
      if (ans) {
        $scope.form_open = 'fin';
        console.log($scope.cdata);
        var promise = $http.post(
          '/services/' +
            portalid +
            '/ancapp/' +
            app +
            '/addControleDetailByClient?f=json',
          $scope.cdata
        );
        promise.then(function(res) {
          $scope.cdata = {};
        });
      }
    };

    $scope.validateEmail = function(email) {
      var res = true;
      if (email && email != '') {
        var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        res = re.test(email);
      }
      return res;
    };
  },
]);
